VERSION 2.00
Begin Form AlarmForm 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Alarm Clock"
   Height          =   1200
   Icon            =   ALARM.FRX:0000
   Left            =   1170
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   ScaleHeight     =   795
   ScaleWidth      =   3030
   Top             =   1260
   Width           =   3150
   Begin Timer Timer1 
      Interval        =   500
      Left            =   2640
      Top             =   120
   End
   Begin Label lblTime 
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   13.5
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   495
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   2415
   End
End
Option Explicit
Dim AlarmTime
Const MINIMIZED = 1

Sub Form_Click ()
    AlarmTime = InputBox("Enter alarm time", "VB Alarm", AlarmTime)
    If AlarmTime = "" Then Exit Sub
    If Not IsDate(AlarmTime) Then
        MsgBox "The time you entered was not valid."
    Else                                ' String returned from InputBox is a valid time
        AlarmTime = CVDate(AlarmTime)   ' so store as a date/time value in AlarmTime.
    End If
End Sub

Sub Form_Load ()
    AlarmTime = ""
End Sub

Sub Form_Resize ()
    If WindowState = MINIMIZED Then     ' If form is minimized
        SetCaptionTime                  ' display time in caption.
    Else
        Caption = "Alarm Clock"
    End If
End Sub

Sub SetCaptionTime ()
    Caption = Format(Time, "Medium Time")   ' Display time using medium time format.
End Sub

Sub Timer1_Timer ()
Static AlarmSounded As Integer
    If lblTime.Caption <> CStr(Time) Then
        ' It's now a different second than the one displayed.
        If Time >= AlarmTime And Not AlarmSounded Then
            Beep
            MsgBox "Alarm at " & Time
            AlarmSounded = True
        ElseIf Time < AlarmTime Then
            AlarmSounded = False
        End If
        If WindowState = MINIMIZED Then
            'If minimized then update form Caption every minute
            If Minute(CVDate(Caption)) <> Minute(Time) Then SetCaptionTime
        Else
            'Else update label Caption every second
            lblTime.Caption = Time
        End If
    End If
End Sub

