VERSION 2.00
Begin Form frmEditor 
   Caption         =   "Text Editor: Untitled"
   ClientHeight    =   4020
   ClientLeft      =   960
   ClientTop       =   2190
   ClientWidth     =   7200
   ClipControls    =   0   'False
   FontBold        =   0   'False
   FontItalic      =   0   'False
   FontName        =   "MS Sans Serif"
   FontSize        =   8.25
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   4710
   Left            =   900
   LinkTopic       =   "Form2"
   ScaleHeight     =   3753.867
   ScaleMode       =   0  'User
   ScaleWidth      =   7200
   Top             =   1560
   Width           =   7320
   Begin CommonDialog CMDialog1 
      CancelError     =   -1  'True
      Left            =   0
      Top             =   0
   End
   Begin TextBox txtEdit 
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   4289
      Left            =   -30
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   0
      Top             =   -30
      Width           =   7215
   End
   Begin Menu mnuFile 
      Caption         =   "&File"
      Begin Menu mnuFileItem 
         Caption         =   "&New"
         Index           =   0
      End
      Begin Menu mnuFileItem 
         Caption         =   "&Open..."
         Index           =   1
      End
      Begin Menu mnuFileItem 
         Caption         =   "Save &As..."
         Index           =   2
      End
      Begin Menu mnuFileItem 
         Caption         =   "&Close"
         Enabled         =   0   'False
         Index           =   3
      End
      Begin Menu mnuFileItem 
         Caption         =   "-"
         Index           =   4
      End
      Begin Menu mnuFileItem 
         Caption         =   "E&xit"
         Index           =   5
      End
      Begin Menu mnuFileArray 
         Caption         =   "-"
         Index           =   0
         Visible         =   0   'False
      End
   End
   Begin Menu mnuEdit 
      Caption         =   "&Edit"
      Begin Menu mnuEditItem 
         Caption         =   "Cu&t"
         Index           =   0
         Shortcut        =   ^X
      End
      Begin Menu mnuEditItem 
         Caption         =   "C&opy"
         Index           =   1
         Shortcut        =   ^C
      End
      Begin Menu mnuEditItem 
         Caption         =   "&Paste"
         Index           =   2
         Shortcut        =   ^V
      End
   End
   Begin Menu mnuSettings 
      Caption         =   "&Settings"
      Begin Menu mnuSettingsItem 
         Caption         =   "&Colors"
         Index           =   0
         Begin Menu mnuColorsItem 
            Caption         =   "&BackColor"
            Index           =   0
            Begin Menu mnuBackColorItem 
               Caption         =   "&Red"
               Index           =   0
            End
            Begin Menu mnuBackColorItem 
               Caption         =   "&Green"
               Index           =   1
            End
            Begin Menu mnuBackColorItem 
               Caption         =   "&Blue"
               Index           =   2
            End
         End
         Begin Menu mnuColorsItem 
            Caption         =   "&ForeColor"
            Index           =   1
            Begin Menu mnuForeColorItem 
               Caption         =   "&Red"
               Index           =   0
            End
            Begin Menu mnuForeColorItem 
               Caption         =   "&Green"
               Index           =   1
            End
            Begin Menu mnuForeColorItem 
               Caption         =   "&Blue"
               Index           =   2
               Begin Menu mnuBlueItem 
                  Caption         =   "&Light Blue"
                  Index           =   0
               End
               Begin Menu mnuBlueItem 
                  Caption         =   "&Dark Blue"
                  Index           =   1
                  Begin Menu mnuDarkBlueItem 
                     Caption         =   "&Sea Blue"
                     Index           =   0
                  End
                  Begin Menu mnuDarkBlueItem 
                     Caption         =   "&Midnight Blue"
                     Index           =   1
                  End
               End
            End
         End
      End
      Begin Menu mnuSettingsItem 
         Caption         =   "&Font Sizes"
         Index           =   1
         Begin Menu mnuFontSizesItem 
            Caption         =   "12"
            Checked         =   -1  'True
            Index           =   0
         End
         Begin Menu mnuFontSizesItem 
            Caption         =   "24"
            Index           =   1
         End
      End
   End
   Begin Menu mnuAbout 
      Caption         =   "&About..."
   End
End

Sub Form_Load ()
    ' Change working directory to the directory
    ' where the application was executed.
    ChDir app.Path
    ChDrive app.Path
    
    ' position the text box
    txtEdit.Move 0, 0

' The form is horizontally and vertically centered when loaded.
    Top = Screen.Height / 2 - Height / 2
    Left = Screen.Width / 2 - Width / 2
End Sub

Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)
' The general procedure DoUnLoadPreCheck handles the possible unload options
' for all three forms in this sample application.
    DoUnLoadPreCheck UnloadMode
End Sub

Sub Form_Resize ()
    txtEdit.Width = Scalewidth
    txtEdit.Height = Scaleheight
End Sub

Sub mnuAbout_Click ()
' All the CaptionTextn string variables below are concatenated together with the appropriate
' line feed characters to display text in the About dialog.
    CaptionText1 = "This Text Editor sample application illustrates the various menu features available using Visual Basic, including..."
    CaptionText2 = "...submenus, separator bars, access keys, shortcut keys, modal and modeless dialog boxes,"
    CaptionText3 = " MsgBox, showing and hiding forms, disabling controls, invisible controls, check marks,"
    CaptionText4 = " control arrays, and adding and removing menu controls at run time..."
    CaptionText5 = "...and much, much, more!"
    frmAbout!lblAbout.Caption = CaptionText1 & Chr$(10) & Chr$(10) & CaptionText2 & CaptionText3 & CaptionText4 & Chr$(10) & Chr$(10) & CaptionText5
' The Show method with style = 1 is used here to display the dialog as modal. Unloading the
' dialog is handled in the forms cmdOK_Click event procedure.
    frmAbout.Show 1
End Sub

Sub mnuBackColorItem_Click (Index As Integer)
    Select Case Index
	Case 0    ' Set BackColor to Red
	    txtEdit.BackColor = RGB(255, 0, 0)
	Case 1    ' Set BackColor to Green
	    txtEdit.BackColor = RGB(0, 255, 0)
	Case 2    ' Set BackColor to Blue
	    txtEdit.BackColor = RGB(0, 0, 255)
    End Select
End Sub

Sub mnuBlueItem_Click (Index As Integer)
' If Light Blue was selected then set the Forecolor to light
' blue otherwise do nothing.
    If Index = 0 Then
       txtEdit.ForeColor = RGB(0, 150, 255)
    End If
End Sub

Sub mnuDarkBlueItem_Click (Index As Integer)
    Select Case Index
    Case 0              ' Set ForeColor to Sea Blue
	txtEdit.ForeColor = RGB(0, 50, 175)
    Case 1              ' Set ForeColor to Midnight Blue
	txtEdit.ForeColor = RGB(0, 0, 255)
    End Select
End Sub

Sub mnuEdit_Click ()
    ' Disable Cut and Copy if no text selected.
    mnuEditItem(0).Enabled = (txtEdit.SelLength > 0)
    mnuEditItem(1).Enabled = (txtEdit.SelLength > 0)
End Sub

Sub mnuEditItem_Click (Index As Integer)
    Select Case Index
	Case 0 ' If Index = 0, user chose "Cut"
	    Clipboard.Clear
	    Clipboard.SetText txtEdit.SelText ' Copy selected text to Clipboard.
	    txtEdit.SelText = "" ' Clear selected text from the document.
	Case 1 ' If Index = 1, user chose "Copy"
	    Clipboard.Clear
	    Clipboard.SetText txtEdit.SelText ' Copy selected text to Clipboard.
	Case 2 ' If Index = 2, user chose "Paste"
	    txtEdit.SelText = Clipboard.GetText() ' Paste Clipboard text (if any) into document.
    End Select
End Sub

Sub mnuFileArray_Click (Index As Integer)
' Open the selected file.
    If Index >= 0 Then
	OpenFile (mnuFileArray(Index).Caption)
    End If
End Sub

Sub mnuFileItem_Click (Index As Integer)
	
' CancelError is True
On Error GoTo errhandler

Select Case Index   ' Check index value of selected menu item.
    Case 0  ' If index = 0, the user chose "New"
	txtEdit.Text = ""       ' Clear text box
	Filename = "Untitled"   ' Set the title bar caption to "Text Editor: Untitled"
	frmEditor.Caption = "Text Editor: " & Filename
    Case 1  ' If index = 1, the user chose "Open..."
	' Set filters
	CMDialog1.Filter = "All Files (*.*)|*.*|Text Files (*.txt)|*.txt|Batch Files (*.bat)|*.bat"
	' Specify default filter
	CMDialog1.FilterIndex = 2
	' display the File Open dialog
	CMDialog1.Action = 1
	Filename = CMDialog1.Filename
	OpenFile (Filename)
    Case 2  ' If index = 2, the user chose "Save As..."
	' Set filters
	CMDialog1.Filter = "All Files (*.*)|*.*|Text Files (*.txt)|*.txt|Batch Files (*.bat)|*.bat"
	' Specify default filter
	CMDialog1.FilterIndex = 2
	' display the File Open dialog
	CMDialog1.Action = 2
	Filename = CMDialog1.Filename
	CloseFile (Filename)
    Case 3  ' If index = 3, the user chose "Close"
	txtEdit.Text = ""                             ' Clear text box
	frmEditor.Caption = "Text Editor: Untitled"   ' Refresh caption of form
	mnuFileItem(3).Enabled = False                ' Disable this menu item.
	CloseFile (Filename)                          ' Close the current file.
    Case 4  ' This menu item is a separator bar, no code needs to be written here
	    ' because it cannot be selected and therefore cannot receive a Click event.
    Case 5  ' If index = 5, the user chose "Exit"
	End  ' End this application and return to the Windows operating system.
End Select
errhandler:
' user pressed cancel button
    Exit Sub
End Sub

Sub mnuFontSizesItem_Click (Index As Integer)
Select Case Index ' Perform action based on Index property value of menu control
    Case 0 ' If Index = 0 then user chose font size 12
	txtEdit.FontSize = 12   ' Set FontSize property of text box to 12
	mnuFontSizesItem(0).Checked = True ' Display check mark next to 12
	mnuFontSizesItem(1).Checked = False' Remove check mark next to 24
    Case 1
	txtEdit.FontSize = 24   ' Set FontSize property of text box to 24
	mnuFontSizesItem(0).Checked = False' Remove check mark next to 12
	mnuFontSizesItem(1).Checked = True ' Display check mark next to 24
End Select
End Sub

Sub mnuForeColorItem_Click (Index As Integer)
Select Case Index
    Case 0 ' Set ForeColor to Red
	    txtEdit.ForeColor = RGB(255, 0, 0)
    Case 1 ' Set ForeColor to Green
	    txtEdit.ForeColor = RGB(0, 255, 0)
    Case 2 ' No code for this case because submenu is automatically displayed on Case 2.
End Select
End Sub

