VERSION 2.00
Begin Form frmDrag 
   Caption         =   "Drag Drop"
   ClientHeight    =   2670
   ClientLeft      =   1500
   ClientTop       =   2040
   ClientWidth     =   6405
   ClipControls    =   0   'False
   Height          =   3075
   Left            =   1440
   LinkTopic       =   "Form2"
   MDIChild        =   -1  'True
   ScaleHeight     =   2670
   ScaleWidth      =   6405
   Top             =   1695
   Width           =   6525
   Begin DriveListBox Drive1 
      DragIcon        =   DRAG.FRX:0000
      Height          =   315
      Left            =   120
      TabIndex        =   2
      Top             =   120
      Width           =   1935
   End
   Begin FileListBox File1 
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "System"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   2190
      Left            =   2280
      Pattern         =   "*.txt;*.bmp;*.exe;*.hlp"
      TabIndex        =   1
      Top             =   120
      Width           =   2055
   End
   Begin DirListBox Dir1 
      DragIcon        =   DRAG.FRX:0302
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "System"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1920
      Left            =   120
      TabIndex        =   0
      Top             =   600
      Width           =   1935
   End
   Begin Image Image1 
      BorderStyle     =   1  'Fixed Single
      Height          =   2415
      Left            =   4560
      Stretch         =   -1  'True
      Top             =   120
      Width           =   1725
   End
End

Sub Dir1_Change ()
    file1.Path = Dir1.Path
End Sub

Sub Drive1_Change ()
    Dir1.Path = Drive1.Drive
End Sub

Sub File1_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    file1.DragIcon = Drive1.DragIcon
    file1.Drag
End Sub

Sub Form_Load ()
    frmDrag.Width = 6525
    frmDrag.Height = 3075
End Sub

Sub Image1_DragDrop (Source As Control, X As Single, Y As Single)
    ' Get last three letters of the dragged filename
    temp = Right$(file1.FileName, 3)
    ' If dragged file is in the root, append filename.
    If Mid(file1.Path, Len(file1.Path)) = "\" Then
      dropfile = file1.Path & file1.FileName
    ' If dragged file is not in root, append "\" and filename.
    Else
      dropfile = file1.Path & "\" & file1.FileName
    End If
      
    image1.Picture = LoadPicture("")
    Select Case temp
    Case "txt"
        X = Shell("Notepad " + dropfile, 1)
    Case "bmp", "wmf", "rle", "ico"
        image1.Picture = LoadPicture(dropfile)
    Case "exe"
        X = Shell(dropfile, 1)
    Case "hlp"
        X = Shell("WinHelp " + dropfile, 1)
    Case Else
        nl = Chr$(10) + Chr$(13)
        msg = "Try one of these file types:"
        msg = nl + msg + nl + nl + "     .txt, .bmp, .exe, .hlp"
        MsgBox msg
    End Select
End Sub

Sub Image1_DragOver (Source As Control, X As Single, Y As Single, State As Integer)
    Select Case State
    Case 0
        ' Display a new icon when the source
        ' enters the drop area.
        file1.DragIcon = Dir1.DragIcon
    Case 1
        ' Display the original DragIcon when the source
        ' leaves the drop area.
        file1.DragIcon = Drive1.DragIcon
    End Select

' Note that Dir1.DragIcon and Drive1.DragIcon have been
' set at design time. This allows you to load the "Enter
' and "Leave" icons for File1 at runtime without requiring
' that the user has those icons are on disc.

End Sub

