VERSION 2.00
Begin Form GestFrm 
   BackColor       =   &H00FFFFFF&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Custom Gesture Actions"
   ControlBox      =   0   'False
   Height          =   7095
   Left            =   270
   LinkMode        =   1  'Source
   LinkTopic       =   "Form2"
   ScaleHeight     =   6690
   ScaleWidth      =   9045
   Top             =   30
   Width           =   9165
   Begin PictureBox Picture1 
      BackColor       =   &H00C0C0C0&
      Height          =   975
      Left            =   120
      ScaleHeight     =   945
      ScaleWidth      =   8745
      TabIndex        =   3
      TabStop         =   0   'False
      Top             =   120
      Width           =   8775
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "The RcResult event can be used to invoke custom gesture functions.  For example, in the multiline HEdit below, a 'b' with a circle around it causes the text to turn bold.  An 'i' with a circle will toggle the Italic property of the control."
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H00000000&
         Height          =   855
         Index           =   3
         Left            =   360
         TabIndex        =   4
         Top             =   120
         Width           =   8175
      End
   End
   Begin VHedit HEdit1 
      BackColor       =   &H00FFFFFF&
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   13.5
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00000000&
      Height          =   1095
      InflateBottom   =   270
      InflateLeft     =   270
      InflateRight    =   270
      InflateTop      =   270
      Left            =   120
      ScrollBars      =   2  'Vertical
      TabIndex        =   5
      TabStop         =   0   'False
      Text            =   "This HEdit has several custom gestures including circled-b, circled-i and the copy gesture that looks like an alpha."
      Top             =   1200
      Version         =   268435458
      Width           =   8775
   End
   Begin PictureBox Picture2 
      BackColor       =   &H00C0C0C0&
      Height          =   615
      Index           =   0
      Left            =   120
      ScaleHeight     =   585
      ScaleWidth      =   8745
      TabIndex        =   1
      TabStop         =   0   'False
      Top             =   2400
      Width           =   8775
      Begin Label Label1 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Standard Gestures can also be used.  If the copy gesture is issued, the contents of the HEdit will be copied to the label below."
         ForeColor       =   &H00000000&
         Height          =   495
         Index           =   1
         Left            =   720
         TabIndex        =   2
         Top             =   60
         Width           =   7575
      End
   End
   Begin PictureBox Picture2 
      BackColor       =   &H00C0C0C0&
      Height          =   615
      Index           =   1
      Left            =   120
      ScaleHeight     =   585
      ScaleWidth      =   8745
      TabIndex        =   7
      TabStop         =   0   'False
      Top             =   3720
      Width           =   8775
      Begin Label Label1 
         BackColor       =   &H00C0C0C0&
         Caption         =   "We can also modify the correction gesture and supply a custom correction box.  This is very useful in places where space is limited."
         ForeColor       =   &H00000000&
         Height          =   495
         Index           =   4
         Left            =   720
         TabIndex        =   8
         Top             =   60
         Width           =   7575
      End
   End
   Begin PictureBox Picture3 
      BackColor       =   &H00C0C0C0&
      Height          =   1515
      Left            =   120
      ScaleHeight     =   1485
      ScaleWidth      =   8745
      TabIndex        =   9
      Top             =   4500
      Width           =   8775
      Begin VHedit HEditArr 
         BackColor       =   &H00FFFFFF&
         ForeColor       =   &H00000000&
         Height          =   315
         Index           =   0
         InflateBottom   =   270
         InflateLeft     =   270
         InflateRight    =   270
         InflateTop      =   270
         Left            =   120
         TabIndex        =   13
         TabStop         =   0   'False
         Top             =   240
         Version         =   268435458
         Width           =   2775
      End
      Begin VHedit HEditArr 
         BackColor       =   &H00FFFFFF&
         ForeColor       =   &H00000000&
         Height          =   315
         Index           =   1
         InflateBottom   =   270
         InflateLeft     =   270
         InflateRight    =   270
         InflateTop      =   270
         Left            =   2880
         TabIndex        =   14
         TabStop         =   0   'False
         Top             =   240
         Version         =   268435458
         Width           =   3615
      End
      Begin VHedit HEditArr 
         BackColor       =   &H00FFFFFF&
         ForeColor       =   &H00000000&
         Height          =   315
         Index           =   2
         InflateBottom   =   270
         InflateLeft     =   270
         InflateRight    =   270
         InflateTop      =   270
         Left            =   6480
         TabIndex        =   15
         TabStop         =   0   'False
         Top             =   240
         Version         =   268435458
         Width           =   1935
      End
      Begin VHedit HEditArr 
         BackColor       =   &H00FFFFFF&
         ForeColor       =   &H00000000&
         Height          =   315
         Index           =   3
         InflateBottom   =   270
         InflateLeft     =   270
         InflateRight    =   270
         InflateTop      =   270
         Left            =   120
         TabIndex        =   16
         TabStop         =   0   'False
         Top             =   540
         Version         =   268435458
         Width           =   2775
      End
      Begin VHedit HEditArr 
         BackColor       =   &H00FFFFFF&
         ForeColor       =   &H00000000&
         Height          =   315
         Index           =   4
         InflateBottom   =   270
         InflateLeft     =   270
         InflateRight    =   270
         InflateTop      =   270
         Left            =   2880
         TabIndex        =   17
         TabStop         =   0   'False
         Top             =   540
         Version         =   268435458
         Width           =   3615
      End
      Begin VHedit HEditArr 
         BackColor       =   &H00FFFFFF&
         ForeColor       =   &H00000000&
         Height          =   315
         Index           =   5
         InflateBottom   =   270
         InflateLeft     =   270
         InflateRight    =   270
         InflateTop      =   270
         Left            =   6480
         TabIndex        =   18
         TabStop         =   0   'False
         Top             =   540
         Version         =   268435458
         Width           =   1935
      End
      Begin VHedit HEditArr 
         BackColor       =   &H00FFFFFF&
         ForeColor       =   &H00000000&
         Height          =   315
         Index           =   6
         InflateBottom   =   270
         InflateLeft     =   270
         InflateRight    =   270
         InflateTop      =   270
         Left            =   120
         TabIndex        =   19
         TabStop         =   0   'False
         Top             =   840
         Version         =   268435458
         Width           =   2775
      End
      Begin VHedit HEditArr 
         BackColor       =   &H00FFFFFF&
         ForeColor       =   &H00000000&
         Height          =   315
         Index           =   7
         InflateBottom   =   270
         InflateLeft     =   270
         InflateRight    =   270
         InflateTop      =   270
         Left            =   2880
         TabIndex        =   20
         TabStop         =   0   'False
         Top             =   840
         Version         =   268435458
         Width           =   3615
      End
      Begin VHedit HEditArr 
         BackColor       =   &H00FFFFFF&
         ForeColor       =   &H00000000&
         Height          =   315
         Index           =   8
         InflateBottom   =   270
         InflateLeft     =   270
         InflateRight    =   270
         InflateTop      =   270
         Left            =   6480
         TabIndex        =   21
         TabStop         =   0   'False
         Top             =   840
         Version         =   268435458
         Width           =   1935
      End
      Begin Label Label2 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Name"
         ForeColor       =   &H00000000&
         Height          =   195
         Index           =   0
         Left            =   960
         TabIndex        =   10
         Top             =   0
         Width           =   1095
      End
      Begin Label Label2 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Address"
         ForeColor       =   &H00000000&
         Height          =   195
         Index           =   1
         Left            =   3960
         TabIndex        =   11
         Top             =   0
         Width           =   1095
      End
      Begin Label Label2 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Phone"
         ForeColor       =   &H00000000&
         Height          =   195
         Index           =   2
         Left            =   6780
         TabIndex        =   12
         Top             =   0
         Width           =   1095
      End
      Begin Label Label1 
         BackColor       =   &H00C0C0C0&
         Caption         =   "To correct, make a checkmark on the entry."
         ForeColor       =   &H00000000&
         Height          =   315
         Index           =   5
         Left            =   2460
         TabIndex        =   22
         Top             =   1200
         Width           =   4215
      End
   End
   Begin CommandButton Command1 
      Caption         =   "Return To Main Menu"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   435
      Left            =   120
      TabIndex        =   0
      Top             =   6120
      Width           =   8775
   End
   Begin Label Label 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      ForeColor       =   &H00000000&
      Height          =   495
      Left            =   1020
      TabIndex        =   6
      Top             =   3120
      Width           =   7035
   End
End

Sub Command1_Click ()
    MainFrm.Show
    GestFrm.Hide
End Sub

Sub Form_Load ()
    Label.Caption = ""
    HEditArr(0).Text = "John F. Dow"
    HEditArr(1).Text = "123 Nowhere Ave."
    HEditArr(2).Text = "(206) 555-1234"
    HEditArr(3).Text = "John Q. Public"
    HEditArr(4).Text = "4567 There Way"
    HEditArr(5).Text = "(321) 555-3456"
    HEditArr(6).Text = "Jane Smith"
    HEditArr(7).Text = "78 Back Over Ave."
    HEditArr(8).Text = "(519) 555-3311"
End Sub

Sub HEdit1_RcResult (RcResult As Long)
    Dim VBrc As RcResult    'VB Copy of the RcResult Structure
    Dim SyeTable() As SYE   'VB Copy of Symbol Element Array

    Rem --- Make a copy of the RCResult Structure
    CPointerToVBType ByVal RcResult, VBrc, 80

    Rem --- Get the number of symbols in the graph
    NumOfSymbols% = VBrc.SYGraph.cSye
    lpSye& = VBrc.SYGraph.lpSye

    Rem --- Allocate enough space for all the symbols and copy them in
    ReDim SyeTable(NumOfSymbols%)
    CPointerToVBType ByVal lpSye&, SyeTable(0), NumOfSymbols% * 12

    Rem --- If there is only one symbol then check if it is a gesture
    If (NumOfSymbols% = 1) Then
        Syv& = SyeTable(0).Syv      'Get the symbol value
        SyvType& = Syv& \ &H10000   'and calculate its type by looking at the HiWord
    
        Rem --- If it is a gesture, check if it is one that we change.
        If (SyvType& = SYVHI_GESTURE) Then
            
            Rem --- If a circled-B then change the font and modify the RCResult
            If (Syv& = (SYV_CIRCLELOA + Asc("b") - Asc("a"))) Then
                Hedit1.FontBold = Not Hedit1.FontBold
                VBrc.wREsultsType = VBrc.wREsultsType Or RCRT_ALREADYPROCESSED

            Rem --- If a circled-I then change the font and modify the RCResult
            ElseIf (Syv& = (SYV_CIRCLELOA + Asc("i") - Asc("a"))) Then
                Hedit1.FontItalic = Not Hedit1.FontItalic
                VBrc.wREsultsType = VBrc.wREsultsType Or RCRT_ALREADYPROCESSED
             
            Rem --- If a copy ("alpha") gesture, then copy then text and modify the RCResult
            ElseIf (Syv& = (SYV_COPY)) Then
                Label.Caption = Hedit1.Text
                VBrc.wREsultsType = VBrc.wREsultsType Or RCRT_ALREADYPROCESSED
            End If
        End If
    
        Rem --- Copy the Possibly modified RCResult back
        VBTypeToCPointer VBrc, ByVal RcResult, 80
    End If

End Sub

Sub HEditArr_GotFocus (Index As Integer)
    Command1.SetFocus
End Sub

Sub HEditArr_RcResult (Index As Integer, RcResult As Long)
    Dim VBrc As RcResult    'VB Copy of the RcResult Structure
    Dim SyeTable() As SYE   'VB Copy of Symbol Element Array

    Rem --- Make a copy of the RCResult Structure
    CPointerToVBType ByVal RcResult, VBrc, 80

    Rem --- Get the number of symbols in the graph
    NumOfSymbols% = VBrc.SYGraph.cSye
    lpSye& = VBrc.SYGraph.lpSye

    Rem --- If there is only one symbol then check if it is a gesture
    If (NumOfSymbols% = 1) Then

        Rem --- Allocate enough space for all the symbols and copy them in
        ReDim SyeTable(NumOfSymbols%)
        CPointerToVBType ByVal lpSye&, SyeTable(0), NumOfSymbols% * 12

        
        Syv& = SyeTable(0).Syv      'Get the symbol value
        SyvType& = Syv& \ &H10000   'and calculate it's type by looking at the HiWord
    
        Rem --- If it is a gesture, check if it is one that we change.
        If (SyvType& = SYVHI_GESTURE) Then
            
            Rem --- If a correct gesture then call correct system
            If (Syv& = (SYV_CORRECT)) Then
                Rem --- Disable current Form
                GestFrm.Enabled = False
                For i% = 0 To 8
                    HEditArr(i%).BackColor = &HC0C0C0
                Next i%

                GestFrm.BackColor = &HC0C0C0

                Rem --- Load Editing form and fill data in
                Load EditSubForm
                first% = (Index \ 3) * 3
                EditSubForm.BName.Text = HEditArr(first%).Text
                EditSubForm.BAddr.Text = HEditArr(first% + 1).Text
                EditSubForm.BPhone(0).Text = Mid$(HEditArr(first% + 2).Text, 2, 3)
                EditSubForm.BPhone(1).Text = Mid$(HEditArr(first% + 2).Text, 7, 3)
                EditSubForm.BPhone(2).Text = Mid$(HEditArr(first% + 2).Text, 11, 4)
                EditSubForm.ElemNum.Caption = Str$(first%)

                Rem --- Show Editing Form
                EditSubForm.Show
            End If
        End If
    
    End If

    Rem --- Ignore Everything
    VBrc.wREsultsType = VBrc.wREsultsType Or RCRT_ALREADYPROCESSED
    VBTypeToCPointer VBrc, ByVal RcResult, 80

End Sub

