VERSION 2.00
Begin Form RcFrm 
   BackColor       =   &H00FFFFFF&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "RcResult Demonstration"
   ControlBox      =   0   'False
   Height          =   6690
   Left            =   225
   LinkMode        =   1  'Source
   LinkTopic       =   "Form1"
   ScaleHeight     =   419
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   604
   Top             =   105
   Width           =   9180
   Begin PictureBox Picture1 
      BackColor       =   &H00C0C0C0&
      Height          =   1035
      Index           =   0
      Left            =   120
      ScaleHeight     =   1005
      ScaleWidth      =   8745
      TabIndex        =   1
      TabStop         =   0   'False
      Top             =   120
      Width           =   8775
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "The RcResult event occurs when a BEdit or HEdit control attempts to recognize the ink.  The event can be used as a trigger to create a 'locking' signature field.  Once the user stops inking, the field will be locked and no changes can be made."
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H00000000&
         Height          =   795
         Index           =   0
         Left            =   240
         TabIndex        =   2
         Top             =   120
         Width           =   8355
      End
   End
   Begin VHedit SigField 
      BackColor       =   &H00FFFFFF&
      DelayRecog      =   -1  'True
      Height          =   855
      InflateBottom   =   18
      InflateLeft     =   18
      InflateRight    =   18
      InflateTop      =   18
      Left            =   480
      TabIndex        =   3
      TabStop         =   0   'False
      Top             =   1560
      Version         =   268435458
      Width           =   6135
   End
   Begin CommandButton ResetButton 
      Caption         =   "Reset Signature"
      Height          =   855
      Left            =   6840
      TabIndex        =   0
      Top             =   1560
      Width           =   1755
   End
   Begin PictureBox Picture1 
      BackColor       =   &H00C0C0C0&
      Height          =   855
      Index           =   1
      Left            =   120
      ScaleHeight     =   825
      ScaleWidth      =   8745
      TabIndex        =   7
      TabStop         =   0   'False
      Top             =   2640
      Width           =   8775
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "The RcResult event can be used to obtain a great deal of information about the recognition process.  When a word is evaluated only the most likely candidate is displayed, but with some manipulation all the possible results can be seen."
         ForeColor       =   &H00000000&
         Height          =   615
         Index           =   1
         Left            =   540
         TabIndex        =   8
         Top             =   120
         Width           =   7755
      End
   End
   Begin VHedit HEdit 
      BackColor       =   &H00FFFFFF&
      ForeColor       =   &H00000000&
      Height          =   435
      InflateBottom   =   18
      InflateLeft     =   18
      InflateRight    =   18
      InflateTop      =   18
      Left            =   2040
      TabIndex        =   9
      TabStop         =   0   'False
      Top             =   3660
      Version         =   268435458
      Width           =   2535
   End
   Begin ListBox ListOfOptions 
      BackColor       =   &H00FFFFFF&
      ForeColor       =   &H00000000&
      Height          =   810
      Left            =   2040
      TabIndex        =   6
      TabStop         =   0   'False
      Top             =   4680
      Width           =   6855
   End
   Begin CommandButton Command1 
      Caption         =   "Return to Main Menu"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   495
      Left            =   120
      TabIndex        =   4
      Top             =   5640
      Width           =   8775
   End
   Begin Label Label2 
      BackColor       =   &H00FFFFFF&
      Caption         =   "Locking Signature Field"
      ForeColor       =   &H00000000&
      Height          =   255
      Index           =   0
      Left            =   2040
      TabIndex        =   5
      Top             =   1320
      Width           =   2175
   End
   Begin Label Label2 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00FFFFFF&
      Caption         =   "Write a Word Here:"
      ForeColor       =   &H00000000&
      Height          =   255
      Index           =   1
      Left            =   180
      TabIndex        =   10
      Top             =   3780
      Width           =   1755
   End
   Begin Label Label2 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00FFFFFF&
      Caption         =   "Symbol Graph:"
      ForeColor       =   &H00000000&
      Height          =   255
      Index           =   3
      Left            =   480
      TabIndex        =   13
      Top             =   4260
      Width           =   1455
   End
   Begin Label GraphWnd 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Arial"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00000000&
      Height          =   375
      Left            =   2040
      TabIndex        =   12
      Top             =   4200
      Width           =   6855
   End
   Begin Label Label2 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00FFFFFF&
      Caption         =   "Possible interpretations will appear here:"
      ForeColor       =   &H00000000&
      Height          =   675
      Index           =   2
      Left            =   480
      TabIndex        =   11
      Top             =   4740
      Width           =   1455
   End
End
Option Base 1

Sub AddToGraph (Syv&, SyvType&)
    Select Case SyvType&
        Case SYVHI_ANSI             'If an ANSI Symbol, add it to the graph
            GraphWnd.Caption = GraphWnd.Caption + Chr$((Syv& And &HFF)) + " "
        Case SYVHI_SPECIAL          'If the symbol is a Meta Symbol, replace it with a visible character
            Select Case Syv&
                Case SYV_UNKNOWN
                    GraphWnd.Caption = GraphWnd.Caption + "? "
                Case SYV_BEGINOR
                    GraphWnd.Caption = GraphWnd.Caption + "{ "
                Case SYV_ENDOR
                    GraphWnd.Caption = GraphWnd.Caption + "} "
                Case SYV_OR
                    GraphWnd.Caption = GraphWnd.Caption + "| "
            End Select
        Case SYVHI_GESTURE          'If the symbol is a gesture, print the gesture name
            Select Case Syv&
                Case SYV_CLEAR
                    GraphWnd.Caption = " -- CLEAR Gesture"
                Case SYV_EXTENDSELECT
                    GraphWnd.Caption = " -- EXTEND SELECT Gesture"
                Case SYV_UNDO
                    GraphWnd.Caption = " -- UNDO Gesture"
                Case SYV_COPY
                    GraphWnd.Caption = " -- COPY Gesture"
                Case SYV_PASTE
                    GraphWnd.Caption = " -- PASTE Gesture"
                Case SYV_CLEARWORD
                    GraphWnd.Caption = " -- CLEAR WORD Gesture"
                Case SYV_USER
                    GraphWnd.Caption = " -- USER Gesture"
                Case SYV_BACKSPACE
                    GraphWnd.Caption = " -- BACKSPACE Gesture"
                Case SYV_TAB
                    GraphWnd.Caption = " -- TAB Gesture"
                Case SYV_RETURN
                    GraphWnd.Caption = " -- RETURN Gesture"
                Case SYV_SPACE
                    GraphWnd.Caption = " -- SPACE Gesture"
                Case SYV_CIRCLEUPA To SYV_CIRCLEUPZ
                    GraphWnd.Caption = " -- Circle " + Chr$(Syv& - SYV_CIRCLEUPA + Asc("A")) + " Gesture"
                Case SYV_CIRCLELOA To SYV_CIRCLELOZ
                    GraphWnd.Caption = " -- Circle " + Chr$(Syv& - SYV_CIRCLELOA + Asc("a")) + " Gesture"
            End Select
    End Select


End Sub

Sub Command1_Click ()
    MainFrm.Show
    RcFrm.Hide
End Sub

Sub Form_Load ()
    SigField.EraseInk = True
    SigField.Enabled = True
    ResetButton.Enabled = False
End Sub

Sub HEdit_RcResult (RcResult As Long)
    Rem --- This example prints out the symbol graph and a list
    Rem --- Of all the possible purmutations of the graph

    Dim VBRC As RcResult      'RCRESULT Structure
    Dim SyeTable() As SYE     'Table of Symbol Elements
    Dim LenArr() As Integer   'Length Array used in Determing all posiblile entries
    Const SizeOfArr = 200
    ReDim LenArr(SizeOfArr)

    Rem --- Set Mouse pointer to HourGlass
    Screen.MousePointer = 11

    Rem --- Get a copy of the RcResult Structure
    CPointerToVBType ByVal RcResult, VBRC, 80

    Rem --- Determine the number of symbols in the graph and get their address
    NumOfSymbols% = VBRC.SYGraph.cSye
    lpSye& = VBRC.SYGraph.lpSye

    Rem -- Allocate space for the graph and make a copy of it
    ReDim SyeTable(NumOfSymbols%)
    CPointerToVBType ByVal lpSye&, SyeTable(1), NumOfSymbols% * 12

    Rem --- Clear the Graph label
    GraphWnd.Caption = " "

    Rem --- Clear previous entries from the List box
    ListOfOptions.Clear

    Rem --- Set Flags and variables used in the Permuation Algorithm
    OrMode = False
    OrModeBottom = 0
    CurrentBottom = 0

    Rem --- Traverse the Symbol Graph
    For i% = 1 To NumOfSymbols%
        Syv& = SyeTable(i%).Syv         'Get symbol value
        SyvType& = Syv& \ &H10000       'Calculate symbol type (SYVH_???) of symbol
                                        'By looking at the HiWord
        Rem --- Call subroutine to add symbol to graph
        AddToGraph Syv&, SyvType&
    
        Rem ------------------------------------------------------------
        Rem -- This is the permutation algorithm. This is included only
        Rem -- as an example of the information that may be gained from
        Rem -- the examination of the symbol graph.  Windows for Pens
        Rem -- provides an EnumSymbols API that in C can be used to
        Rem -- produce a similar list.
        Rem ------------------------------------------------------------

        Select Case SyvType&
            Case SYVHI_ANSI                             'If an ASCI Symbol then
                If (ListOfOptions.ListCount = 0) Then       'Add to list if list is empty
                    ListOfOptions.AddItem Chr$((Syv& And &HFF))
                Else
                    Rem --- Otherwise Check to see if an OR symbol has been encountered
                    If (OrMode) Then            'If so Duplicate Data
                        For j% = 1 To OrModeBottom
                            If (ListOfOptions.ListCount >= SizeOfArr) Then GoTo OverFlowErr
                            ListOfOptions.AddItem Left$(ListOfOptions.List(j% - 1), LenArr(j%))
                        Next j%
                    End If
                
                    For j% = CurrentBottom To (ListOfOptions.ListCount - 1)
                        ListOfOptions.List(j%) = ListOfOptions.List(j%) + Chr$((Syv& And &HFF))
                    Next j%
                
                    If ((OrModeBottom = 0) And (OrMode)) Then
                        If (ListOfOptions.ListCount >= SizeOfArr) Then GoTo OverFlowErr
                        ListOfOptions.AddItem Chr$((Syv& And &HFF))
                    End If
                
                    OrMode = False

                End If
            
            Case SYVHI_SPECIAL
                Rem --- If a special Symbol, determine which one

                Select Case Syv&
                    Case SYV_BEGINOR
                        Rem --- Save the current lengths of all elements
                        For j% = 1 To ListOfOptions.ListCount
                            LenArr(j%) = Len(ListOfOptions.List(j% - 1))
                        Next j%
                        Rem --- And make sure to note where the bottom of the list is
                        OrModeBottom = ListOfOptions.ListCount
                        CurrentBottom = 0
                
                    Case SYV_ENDOR
                        Rem --- Reset Flags
                        OrMode = False
                        OrModeBottom = 0
                        CurrentBottom = 0

                    Case SYV_OR
                        Rem --- Record an Or
                        OrMode = True
                        CurrentBottom = ListOfOptions.ListCount

                End Select
        End Select

    Next i%

    Rem --- Restore Mouse pointer
    Screen.MousePointer = 0

    Exit Sub


OverFlowErr:
    Rem --- Array too small

    Rem --- Restore Mouse Pointer
    Screen.MousePointer = 0
    MsgBox "Too many entries in table, did not complete", 64
    Exit Sub

End Sub

Sub ResetButton_Click ()
    ResetButton.Enabled = False
    SigField.EraseInk = True
    SigField.Enabled = True
End Sub

Sub SigField_RcResult (RcResult As Long)
    SigField.Enabled = False
    ResetButton.Enabled = True
End Sub

