VERSION 2.00
Begin Form DIALER 
   Caption         =   "MSComm Phone Dialer"
   ClientHeight    =   2205
   ClientLeft      =   2865
   ClientTop       =   1500
   ClientWidth     =   3270
   Height          =   2610
   Left            =   2805
   LinkTopic       =   "Form2"
   ScaleHeight     =   2205
   ScaleWidth      =   3270
   Top             =   1155
   Width           =   3390
   Begin CommandButton CancelButton 
      Caption         =   "Cancel"
      Enabled         =   0   'False
      Height          =   348
      Left            =   1200
      TabIndex        =   4
      Top             =   1728
      Width           =   852
   End
   Begin CommandButton QuitButton 
      Cancel          =   -1  'True
      Caption         =   "Quit"
      Height          =   348
      Left            =   2160
      TabIndex        =   2
      Top             =   1728
      Width           =   852
   End
   Begin MSComm Comm1 
      Interval        =   1000
      Left            =   0
      Top             =   0
   End
   Begin CommandButton DialButton 
      Caption         =   "Dial"
      Default         =   -1  'True
      Height          =   348
      Left            =   240
      TabIndex        =   1
      Top             =   1728
      Width           =   852
   End
   Begin ListBox List1 
      Height          =   1005
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   2775
   End
   Begin Label Status 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Select a party to call"
      Height          =   252
      Left            =   240
      TabIndex        =   3
      Top             =   1296
      Width           =   2772
   End
End
'--------------------------------------------------------
'-- DIALER.FRM
'   Copyright (c) 1993 Crescent Software, Inc.
'   by Carl Franklin
'
'   Demonstrates how to dial phone numbers with a modem.
'
'   In order for this program to work, your telephone and
'   modem must be connected to the same phone line.
'--------------------------------------------------------
Option Explicit
DefInt A-Z

'-- Phone numbers are stored here
Dim PhoneNumbers$()

'-- This flag is set when cancel is pressed
Dim CancelFlag

Sub CancelButton_Click ()
    
    '-- CancelFlag tells the Dial routine to exit
    CancelFlag = True

    CancelButton.Enabled = False

End Sub

Sub Dial (Number$)
    Dim DialString$, FromModem$, dummy

    '--- AT is the Hayes compatible ATTENTION command an is required to send commands to the modem.
    '--- DT means "Dial Tone" - The Dial command, using touch tones as opposed to pulse (DP = Dial Pulse)
    '--- PhoneNumbers$(Index) is the phone number of the person you're dialing
    '--- A semicolon tells the modem to return to command mode after dialing (important)
    '--- A Carriage return, Chr$(13), is required when sending commands to the modem.
    DialString$ = "ATDT" + Number$ + ";" + Chr$(13)

    '-- Comm port settings
    Comm1.Settings = "300,N,8,1"
    
    '-- Open the comm port
    On Error Resume Next
    Comm1.PortOpen = True
    If Err Then
       MsgBox "COM1: not available. Change the CommPort property to another port."
       Exit Sub
    End If
    
    '-- Flush the input buffer
    Comm1.InBufferCount = 0
    
    '-- Dial the number
    Comm1.Output = DialString$
    
    '-- Wait for "OK" to come back from the modem
    Do
       dummy = DoEvents()
       '-- If there is data in the buffer, then read it.
       If Comm1.InBufferCount Then
          FromModem$ = FromModem$ + Comm1.Input
          '-- Check for "OK"
          If InStr(FromModem$, "OK") Then
             '-- Notify the user to pick up the phone
             Beep
             MsgBox "Please pick up the phone and either press Enter, or click OK"
             Exit Do
          End If
       End If
        
       '-- Was Cancel pressed?
       If CancelFlag Then
          CancelFlag = False
          Exit Do
       End If
    Loop
    
    '-- Disconnect the modem
    Comm1.Output = "ATH" + Chr$(13)
    
    '-- Close the port
    Comm1.PortOpen = False
    
End Sub

Sub DialButton_Click ()
    Dim Number$, Temp$
    
    DialButton.Enabled = False
    QuitButton.Enabled = False
    CancelButton.Enabled = True
    
    '-- Get the number to dial
    Number$ = PhoneNumbers$(List1.ListIndex)

    Temp$ = Status
    Status = "Dialing - " + Number$
    
    '-- Dial the selected phone number
    Dial Number$

    DialButton.Enabled = True
    QuitButton.Enabled = True
    CancelButton.Enabled = False

    Status = Temp$

End Sub

Sub Form_Load ()
    
    '-- Setting InputLen to 0 tells MSComm to read the entire
    '   contents of the input buffer when the Input property
    '   is used.
    Comm1.InputLen = 0
    
    Dialer.Show

    '-- Load the list box with names
    List1.AddItem "Information"
    List1.AddItem "800 Information"

    '-- Phone numbers
    ReDim PhoneNumbers$(0 To List1.ListCount - 1)
    PhoneNumbers$(0) = "1-555-1212"
    PhoneNumbers$(1) = "1-800-555-1212"

    '-- Select the first name as default
    List1.ListIndex = 0
    
End Sub

Sub List1_DblClick ()
    
    '-- Invoke the Dial button
    DialButton_Click

End Sub

Sub QuitButton_Click ()
    End
End Sub

