Attribute VB_Name = "MODULE1"
' Module1
Option Explicit
Const Type_CURSOR = 1 ' &H1%
Const Type_BITMAP = 2 ' &H2%
Const Type_ICON = 3 ' &H3%
Const Type_MENU = 4 ' &H4%
Const Type_DIALOG = 5 ' &H5%
Const Type_STRING = 6 ' &H6%
Const Type_FONTDIR = 7 ' &H7%
Const Type_FONT = 8 ' &H8%
Const Type_ACCELERATOR = 9 ' &H9%
Const Type_RCData = 10 ' &HA%
Const Type_GROUPCURSOR = 12 ' &HC%
Const Type_GROUPICON = 14 ' &HE%
Const Type_NAMETABLE = 15 ' &HF%
Const Type_Version_Information = 16 ' &H10%

'Log Functions
Sub GD_DBGOut_NE(Line$, Optional DisplayLevel = 0)
#If ShowLog >= 20 Then
   GD_DBGOut Line, DisplayLevel
#End If
End Sub

Sub GD_DBGOut_NE_Data(Text$)
   GD_DBGOut_NE "NE_Data " & Text
End Sub


Sub GD_DBGOut_NE_Header(Text$)
   GD_DBGOut_NE "NE_Header " & Text
End Sub










Sub InitResTypeNameStringsArray()
2000
  gResTypeNameStrings(Type_CURSOR) = "CURSOR"
  gResTypeNameStrings(Type_BITMAP) = "BITMAP"
  gResTypeNameStrings(Type_ICON) = "ICON"
  gResTypeNameStrings(Type_MENU) = "MENU"
  gResTypeNameStrings(Type_DIALOG) = "DIALOG"
  gResTypeNameStrings(Type_STRING) = "STRING"
  gResTypeNameStrings(Type_FONTDIR) = "FONTDIR"
  gResTypeNameStrings(Type_FONT) = "FONT"
  gResTypeNameStrings(Type_ACCELERATOR) = "ACCELERATOR"
  gResTypeNameStrings(Type_RCData) = "RCDATA"
  gResTypeNameStrings(Type_GROUPCURSOR) = "GROUP CURSOR"
  gResTypeNameStrings(Type_GROUPICON) = "GROUP ICON"
  gResTypeNameStrings(Type_NAMETABLE) = "NAMETABLE"
  gResTypeNameStrings(Type_Version_Information) = "VERSIONINFO"
End Sub

Function IsInRange(ByVal Value&, ByVal Max&, Optional ByVal Min& = 0) As Integer
   IsInRange = ((Min <= Value) And (Value <= Max))
End Function

Function IsNotInRange(ByVal Value&, ByVal Max&, Optional ByVal Min& = 0) As Integer
   IsNotInRange = ((Min > Value) Or (Value > Max))
End Function


Sub SeekToEntrySegment()

  For curSegID = 1 To NE.SegmentTableEntryCount

    curSegOffs = 1 + GetSegOffset(curSegID)
    curSegSize = Uint32(Segs(curSegID).Alloc_size)
    
    Dim SegPageOffs%
    SegPageOffs = Segs(curSegID).SegOffset
    If IsInRange(NE.Initial_IP, SegPageOffs + curSegSize, SegPageOffs) Then
       Seek hVBFile, curSegOffs
       Exit Sub
    End If
  Next

   curSegOffs = 0
   curSegSize = 0

End Sub


Sub SeekToSegment(SegID As Integer)
2010
  curSegID = SegID
  
  If curSegID Then
    
    curSegOffs = 1 + GetSegOffset(SegID)
    curSegSize = Uint32(Segs(SegID).Alloc_size)
    
    Seek hVBFile, curSegOffs
  
  Else
    curSegOffs = 0
    curSegSize = 0
  End If
End Sub


Sub ReadFileData()
2020
  NE.Signature = -1
  VBVersion = -1
  
  GD_DBGOut_NE "Testing MZ-Signature"
' Reopen
  If hVBFile Then Close hVBFile Else hVBFile = FreeFile
  Open gIn_FileFulPath For Binary Access Read As hVBFile
  Get hVBFile, , MZ
  
 'Check MZ-Exe Signature
  If MZ.Signature <> MZ_MAGIC Or MZ.RelocTable < &H40 Then Exit Sub
  
  GD_DBGOut_NE "Testing NE-Signature"
 'Move to NE-Header & Check NE-Signature
  Get hVBFile, MZ.OffsetToNE + 1, NE
  If NE.Signature <> NE_MAGIC Then
     NE.Signature = 0
     Exit Sub
  End If
  
  GD_DBGOut_NE "NE_DataLoad Start"
  SegmentAlign = 2 ^ NE.MiscFlags
  GD_DBGOut_NE_Header "SegmentAlig: " & H16(SegmentAlign)
  
  LoadEntryTable
  LoadSegmInformation
  LoadResourceTable
  LoadResidentNameTable
  LoadModAndImpTbl      '...to get VB Version
  LoadNonResTbl
  
  GD_DBGOut_NE "NE_DataLoad Complete."
End Sub

Sub ApplyReloc(SegmentNum As Integer)
Dim i%
Dim VBCODEStruct_ As VBCODEStruct
Dim l00B6 As T1CBD

2030
  If SegmentNum = curSegID Then Exit Sub
  
  SeekToSegment SegmentNum
  
  If Segs(SegmentNum).Attributes And Seg_Attri_HasRelocInfo Then
  
    Get hVBFile, curSegOffs + curSegSize, ReLocCount
    If ReLocCount < 0 Then
      ReLocCount = 0
    End If
    
    ReDim gv0726(ReLocCount)
    For i = 1 To ReLocCount
    
      Get hVBFile, , VBCODEStruct_
      l00B6.Size_M13F4 = VBCODEStruct_.Size_M13F4
      l00B6.ArgsList = Asc(VBCODEStruct_.M1CA2)
      l00B6.isValid = Asc(VBCODEStruct_.isValid)
      l00B6.M1CB1 = VBCODEStruct_.M1CB1
      l00B6.M1CB7 = VBCODEStruct_.M1CB7
      
      gv0726(i) = l00B6
    Next i
    
  Else
    ReLocCount = 0
    
  End If
End Sub

Sub LoadEntryTable()
Dim EntryTableOffset As Long
Dim EntriesCount As Integer
Dim EntryType As Integer
Dim EntryEntries_Sum As Integer
Dim EntryTableRecord_Moveable As TEntryTableStruct_Moveable
Dim EntryTableRecord_Fixed As TEntryTableRecord_Fixed

2040
  EntryTableOffset = MZ.OffsetToNE + NE.ENTRYTABLE + 1
  GD_DBGOut_NE_Header "EntryTableOffset: " & H32(EntryTableOffset - 1)
  
' ===== Count_Loop EntryTable Entries  ====

  gEntryEntries_Sum = 0
  
 'Get first Byte in EntryTable
  Get hVBFile, EntryTableOffset, FixedByteBuff: EntriesCount = Asc(FixedByteBuff)
  
 'If Byte in EntryTable is not 0 loop
  While EntriesCount
    gEntryEntries_Sum = gEntryEntries_Sum + EntriesCount
   
   'Get next Byte in EntryTable => EntryType
    Get hVBFile, , FixedByteBuff: EntryType = Asc(FixedByteBuff)
    Select Case EntryType
    
    Case 0
    
    Case &HFF
      While EntriesCount
        Get hVBFile, , EntryTableRecord_Moveable
        EntriesCount = EntriesCount - 1
      Wend
      
    Case Else
      While EntriesCount
        Get hVBFile, , EntryTableRecord_Fixed
        EntriesCount = EntriesCount - 1
      Wend
    End Select
   
   'Get next Byte in EntryTable => EntryType
    Get hVBFile, , FixedByteBuff: EntriesCount = Asc(FixedByteBuff)
  Wend
  
  
' ===== Read_Loop EntryTable Entries ====
    
  ReDim gvNE_EntryTable_Entries(gEntryEntries_Sum)
  
 'Get first Byte in EntryTable
  Get hVBFile, EntryTableOffset, FixedByteBuff: EntriesCount = Asc(FixedByteBuff)
  GD_DBGOut_NE_Header "EntryTable_EntriesCount: " & H8(EntriesCount)
  
  EntryEntries_Sum = 0
  While EntriesCount
   'Get next Byte in EntryTable => EntryType
    Get hVBFile, , FixedByteBuff: EntryType = Asc(FixedByteBuff)
    Select Case EntryType
    
    Case 0
      GD_DBGOut_NE "Type_00", 1
      
      Inc EntryEntries_Sum
    
    Case &HFF
      GD_DBGOut_NE "Reading Moveable segment records Type_FF(exe)", 1
      While EntriesCount
        Get hVBFile, , EntryTableRecord_Moveable
'=============================================================================
' Entry table                                               at offset 0000160B
'=============================================================================
'   Moveable segment records         (  1 entries)
'     Entry      1:  03:057C     Exported
      With gvNE_EntryTable_Entries(EntryEntries_Sum)
         .Record_seg = Asc(EntryTableRecord_Moveable.Segm)
         .EntryType = Asc(EntryTableRecord_Moveable.Record_seg)
         .Record_off = EntryTableRecord_Moveable.Record_off
      End With
        Dec EntriesCount
        Inc EntryEntries_Sum
      Wend
    
    Case Else
'=============================================================================
' Entry table                                               at offset 000004BC
'=============================================================================
'   Fixed segment records            (  6 entries)
'     Entry      1:  01:003E     Exported   Single data
'     Entry      2:  01:005E     Exported   Single data
'     Entry      3:  01:020A     Exported   Single data
'     Entry      4:  01:026C     Exported   Single data
'     Entry      5:  01:0320     Exported   Single data
'     Entry      6:  01:0994     Exported   Single data
      GD_DBGOut_NE "Reading Fixed segment records Types_01..FE(dll)", 1
      While EntriesCount
         Get hVBFile, , EntryTableRecord_Fixed
         With gvNE_EntryTable_Entries(EntryEntries_Sum)
            .Record_seg = Asc(EntryTableRecord_Fixed.Record_seg)
            .EntryType = EntryType
            .Record_off = EntryTableRecord_Fixed.Record_off
         End With
         
         Dec EntriesCount
         Inc EntryEntries_Sum
         
      Wend
    End Select
   
   'Get next Byte in EntryTable => EntryType
    Get hVBFile, , FixedByteBuff: EntriesCount = Asc(FixedByteBuff)
    GD_DBGOut_NE_Header "EntryTable_EntriesCount: " & H8(EntriesCount) & " (Next)"
  Wend
  
End Sub

Sub LoadModAndImpTbl()
Dim ImpTbl As Long
Dim ModulTbl As Long
Dim ImpTbl_NameStart%
Dim i%
   
  VBVersion = 0
   
2050
  ModulTbl = MZ.OffsetToNE + NE.ModuleReferenceTable + 1
  GD_DBGOut_NE_Header "ModuleReferenceTable_Offset: " & H32(ModulTbl) & "  Count: " & H16(NE.ModuleTableEntryCount)
  
  ImpTbl = MZ.OffsetToNE + NE.IMPORTTABLE + 1
  GD_DBGOut_NE_Header "ImportsTable_Offset: " & H32(ImpTbl)
  
  ReDim DllImports(NE.ModuleTableEntryCount)
  
  For i = 1 To NE.ModuleTableEntryCount
    
   'Get StartOffset for Name in Importable
    Get hVBFile, ModulTbl, ImpTbl_NameStart: Inc ModulTbl, SIZE_OF_INTEGER
    
   'Get ModuleName (PascalString (<I8_Length><Stringdata>))
    Get hVBFile, ImpTbl + ImpTbl_NameStart, FixedByteBuff 'Get size
    DllImports(i) = Space$(Asc(FixedByteBuff))         'Create buffer
    Get hVBFile, , DllImports(i)                       'Fill Buffer/get da String
    
    GD_DBGOut_NE "Import: " & DllImports(i), 1
    
   'Test for VB-Runtime and get it's Version
    If UCase$(Left$(DllImports(i), 5)) = "VBRUN" Then
      VBVersion = Val(Mid$(DllImports(i), 6, 1))
      
    ElseIf Left$(DllImports(i), 5) = "VB400" Then
      VBVersion = 4
      
    End If
    
  Next i
End Sub

Sub LoadNonResTbl()
Dim Offset As Long
Dim filebuf As String
Dim i%
Dim NullPos As Integer

2060
  Offset = NE.NonResidentNameTable + 1
  
' === Count Loop ====
  NonResCount = 0
  Get hVBFile, Offset, FixedByteBuff
  
  While Asc(FixedByteBuff)
    
    NonResCount = NonResCount + 1
    
    filebuf = Space$(Asc(FixedByteBuff) + 2)
    Get hVBFile, , filebuf
    
    Get hVBFile, , FixedByteBuff
    
  Wend
  
  
' === Read Loop ====
  ReDim ResidentNames2(NonResCount)
  
  GD_DBGOut_NE_Header "Non-ResidentNamesOffset: " & H32(Offset - 1) & "  Count: " & NonResCount
  
  Seek hVBFile, Offset
  
  For i = 1 To NonResCount
    
   'Get Pascal String
    Get hVBFile, , FixedByteBuff
    filebuf = Space$(Asc(FixedByteBuff))
    Get hVBFile, , filebuf
    
   'Nullcut
    NullPos = InStr(filebuf, Chr$(0))
    If NullPos Then filebuf = Left$(filebuf, NullPos - 1)
    
    With ResidentNames2(i)
      .Name = filebuf
      Get hVBFile, , .AddData
      
      GD_DBGOut_NE "Name: " & .Name & "  " & "  AddData: " & .AddData, 1
   End With
    
  Next i
End Sub


Sub LoadResidentNameTable()
Dim Offset As Long
Dim Filebuff As String
Dim dummy%
Dim i%

2070
  ResidentCount = 0
  
  Offset = MZ.OffsetToNE + NE.ResidentNameTable + 1
  Get hVBFile, Offset, FixedByteBuff
  
  While Asc(FixedByteBuff)
    ResidentCount = ResidentCount + 1
    
    Filebuff = Space$(Asc(FixedByteBuff))
    
    Get hVBFile, , Filebuff
    Get hVBFile, , dummy
    Get hVBFile, , FixedByteBuff
  Wend
  
  ReDim ResidentNames(ResidentCount)
  GD_DBGOut_NE_Header "ResidentNameTableOffset: " & H32(Offset) & "  Count: " & ResidentCount

' Seek again back to ResidentNameTableOffset
  Seek hVBFile, Offset
  
  For i = 1 To ResidentCount
    
    Get hVBFile, , FixedByteBuff
    
    Filebuff = Space$(Asc(FixedByteBuff))
    Get hVBFile, , Filebuff
    
   'NullCut
    dummy = InStr(Filebuff, Chr$(0))
    If dummy Then Filebuff = Left$(Filebuff, dummy - 1)
    
    With ResidentNames(i)
      .Name = Filebuff
      Get hVBFile, , .AddData
      
      GD_DBGOut_NE "Index: " & i & _
                "  Name: " & .Name & _
                "  AddData: " & H32(.AddData), 1
   End With
    
  Next i
  
End Sub

Sub LoadResourceTable()
Dim ResRootTblItem As ResRootTblItemStruc
Dim lResItem As ResourceChildType
Dim Offset As Long
Dim i%
Dim Childs As Integer
Dim ResIndex As Integer
Dim iChild%
Dim ResObjType As Integer
Const RES_TYPE_MASK& = &H8000


2080
  If NE.RESOURCETABLE = NE.ResidentNameTable Then Exit Sub
  
  Offset = MZ.OffsetToNE + NE.RESOURCETABLE + 1
  
  GD_DBGOut_NE_Header "ResourceTableOffset: " & H32(Offset - 1)
  
' Get Alignment shift count for resource data.
  Get hVBFile, Offset, ResAlignment
  ResAlignment = 2 ^ ResAlignment
  GD_DBGOut_NE_Data "ResourceTable Alignment: " & H16(ResAlignment)
  
  ReDim ResRootTbl(0): ResRootCount = 0
  ReDim ResChilds(0): ResChildsCount = 0
  
  gResIdx_VersionInfo = 0
  gResIdx_RCData = 0
  gResIdx_RCData_Count = 0

  
'Read ResRoot + Dirs
  Do
    Get hVBFile, , ResRootTblItem
    
  ' Reached End?
    If ResRootTblItem.ObjType = 0 Then Exit Do
    
  ' Add Entry to array
    ResRootCount = ResRootCount + 1
    ReDim Preserve ResRootTbl(ResRootCount)
    
    With ResRootTbl(ResRootCount)
      .ObjType = ResRootTblItem.ObjType
      .Childs = ResRootTblItem.Childs
      .index = ResChildsCount
      
      GD_DBGOut_NE Join( _
            Array( _
               "Resindex: " & Format(ResRootCount, "00"), _
               "ObjType:" & H16(.ObjType), _
               "Childs:" & H16(.Childs) _
            ), "  "), 1
      
   End With
    
    Childs = ResRootTblItem.Childs
    
  ' Filter out RCData & VersionInfo
    Select Case (ResRootTblItem.ObjType Xor RES_TYPE_MASK)
     

      Case Type_RCData
       ' Store StartIndex to quick access it later inside ResChilds()
         gResIdx_RCData = ResChildsCount + 1      ' '...+1' because it is increased&filled out below
         gResIdx_RCData_Count = ResChildsCount + Childs
      
      Case Type_Version_Information
         gResIdx_VersionInfo = ResChildsCount + 1
    
    End Select
    

    
  ' Get Childs
    ReDim Preserve ResChilds(ResChildsCount + Childs)
    While Childs
      
      Inc ResChildsCount
      
      Get hVBFile, , lResItem
      With ResChilds(ResChildsCount)
         .ObjType = ResRootTblItem.ObjType
         .size = lResItem.size
         .FlagWord = lResItem.FlagWord
         .ResourceID = lResItem.ResourceID
         .Offset = lResItem.Offset
      End With
      
      Dec Childs
      
    Wend
    
  Loop
  
  
'
  For i = 1 To ResRootCount
    ResObjType = ResRootTbl(i).ObjType
    
   'Get ResDirNames
    If ResObjType < 0 Then
    
    Else
    
      Get hVBFile, Offset + ResObjType, FixedByteBuff
      ResRootTbl(i).TypeNameStr = Space$(Asc(FixedByteBuff))
      Get hVBFile, , ResRootTbl(i).TypeNameStr
      
    End If
    
    
   'Get ResChildNames
    ResIndex = ResRootTbl(i).index
    For iChild = ResIndex + 1 To ResIndex + ResRootTbl(i).Childs
      
      ResObjType = ResChilds(iChild).ResourceID
      If ResObjType < 0 Then
       'Generate Name (for ex. "800a")
        ResChilds(iChild).TypeNameStr = Hex$(ResObjType)
        
      Else
       'Get Name From File
        Get hVBFile, Offset + ResObjType, FixedByteBuff
        ResChilds(iChild).TypeNameStr = Space$(Asc(FixedByteBuff))
        Get hVBFile, , ResChilds(iChild).TypeNameStr
        
      End If
    
    Next iChild
  
  Next i
  
End Sub

Sub LoadSegmInformation()
Dim i%

2090
  gNE_Segments = NE.SegmentTableEntryCount
  GD_DBGOut_NE_Header "SegmentTableEntryCount: " & gNE_Segments
  
  ReDim Segs(1 To gNE_Segments)
  
  Seek hVBFile, MZ.OffsetToNE + NE.SegmentTableOffset + 1

  For i = 1 To gNE_Segments
    Get hVBFile, , Segs(i)
    With Segs(i)
      GD_DBGOut_NE Join( _
                  Array( _
                     "Segment: " & Format(i, "00"), _
                     "SegOffset:" & H16(.SegOffset), _
                     "Alloc_size:" & H16(.Alloc_size), _
                     "File_length:" & H16(.File_length), _
                     "Attributes:" & H16(.Attributes) & _
                     " -> HasReloc-> " & IIf(.Attributes And Seg_Attri_HasRelocInfo, "Yes", "No") _
                  ), "  "), 1
    End With
  Next i
  
End Sub

Sub sub011F(pReloc As Integer)
Dim l0114%
Dim l0118 As Integer
Dim l011A As Long
Dim l011E As T1CBD
Dim l0120%
Dim l0122 As Integer
Dim l0124 As String
Dim FuncNum() As Long

2100
  curSegID = 0: ApplyReloc pReloc
  
  Erase gv0680: gv06B2 = 0
  ReDim gv0680(gNE_Segments, 255)
  ReDim FuncNum(255) As Long
  For l0114 = 1 To ReLocCount
    l011E = gv0726(l0114)
    If l011E.isValid <> 0 Or l011E.ArgsList <> 2 Then
    Else
      l011A = Uint32(l011E.Size_M13F4)
      gv06B2 = 1: l0124 = Chr$(1)
      Do
        gv06B2 = gv06B2 + 1
        Get hVBFile, curSegOffs + l011A - 2, l0118: l011A = Uint32(l0118)
        FuncNum(gv06B2) = l011A
        For l0120 = 1 To Len(l0124)
          If FuncNum(Asc(Mid$(l0124, l0120, 1))) > l011A Then Exit For
        Next l0120
        l0124 = Left$(l0124, l0120 - 1) & Chr$(gv06B2) & Mid$(l0124, l0120)
      Get hVBFile, , l0118
      l011A = Uint32(l0118)
      Loop Until l0118 = &HFFFF
      For l0120 = 1 To Len(l0124)
        l0122 = Asc(Mid$(l0124, l0120, 1))
        gv0680(l011E.M1CB1, l0120) = ToSInt16(FuncNum(l0122))
      Next l0120
      gv0680(l011E.M1CB1, 0) = Len(l0124)
    End If
  
  Next l0114
  
End Sub

Function GetSegOffset(p0130 As Integer) As Long
2110
  GetSegOffset = PageToOffset(Segs(p0130).SegOffset, SegmentAlign)
End Function
