Attribute VB_Name = "MODULE13"
' Module13
Option Explicit
Global Const err_File_Not_Found_Or_Wrong_Version = 16384 ' &H4000%
'Const mc00B0 = 1 ' &H1%
'Const mc00B8 = 1 ' &H1%
'Const mc00BA = 2 ' &H2%
'Const mc00BC = 2 ' &H2%
'Const mc00BE = 3 ' &H3%
'Const mc00C0 = 3 ' &H3%
'Const mc00C2 = 4 ' &H4%
'Const mc00C4 = 4 ' &H4%
'Const mc00C6 = 5 ' &H5%
'Const mc00C8 = 5 ' &H5%
'Const mc00CA = 6 ' &H6%
'Const mc00CC = 6 ' &H6%
'Const mc00CE = 7 ' &H7%
'Const mc00D0 = 7 ' &H7%
'Const mc00D2 = 12 ' &HC%
'Const mc00D4 = 8 ' &H8%
'Const mc00D6 = 10 ' &HA%
'Const mc00D8 = 9 ' &H9%
'Const mc00DA = 8 ' &H8%
'Const mc00DC = 10 ' &HA%
'Const mc00DE = 9 ' &H9%
Const Err_VersionNotSupported = 4 ' &H4%

Sub Load_VBdis3i(ByVal LogCount As Integer)
Dim hFile As Integer
Dim intbuff%
 Const err_File_Not_Found_Or_Wrong_Version = 16384 ' &H4000%

18030

' ====  Load vbdis3i.dat into VBdis3i_TokenData ====
  hFile = FreeFile
  CurFilename = "vbdis3i.dat"
  If LogCount Then DispLog2 LogCount, "Loading " & CurFilename
  
 'open vbdis3i.dat
  Open AppPathwithSlash & CurFilename For Binary As hFile
  
 'GetSize
  Get hFile, , intbuff
  If intbuff = 0 Then ShowErrMsg err_File_Not_Found_Or_Wrong_Version ' 16384
  
  VBdis3i_KeyWordStrings = String$(intbuff, 0)
  
 'Read Struct & Strings
  Get hFile, , VBdis3i_TokenData
  Get hFile, , VBdis3i_KeyWordStrings
  
  Close hFile
  
' 'Type Convert Table
'  gvConvToType(1) = 0
'  gvConvToType(2) = 1
'  gvConvToType(3) = 2
'  gvConvToType(4) = 3
'  gvConvToType(5) = 4
'  gvConvToType(6) = 5
'  gvConvToType(7) = 6
'  gvConvToType(12) = 7
'  gvConvToType(10) = 8
'  gvConvToType(8) = 9
'  gvConvToType(9) = 10
'
'
' 'Type Convert Table
'  gvConvToTypeBits(0) = 1
'  gvConvToTypeBits(1) = 2
'  gvConvToTypeBits(2) = 3
'  gvConvToTypeBits(3) = 4
'  gvConvToTypeBits(4) = 5
'  gvConvToTypeBits(5) = 6
'  gvConvToTypeBits(6) = 7
'  gvConvToTypeBits(7) = 12
'  gvConvToTypeBits(8) = 10
'  gvConvToTypeBits(9) = 8
'  gvConvToTypeBits(10) = 9
'
  'Type Convert Table :             'Type Convert Table
  gvConvToType(&H1) = &H0:           gvConvToTypeBits(&H0) = &H1
  gvConvToType(&H2) = &H1:           gvConvToTypeBits(&H1) = &H2
  gvConvToType(&H3) = &H2:           gvConvToTypeBits(&H2) = &H3
  gvConvToType(&H4) = &H3:           gvConvToTypeBits(&H3) = &H4
  gvConvToType(&H5) = &H4:           gvConvToTypeBits(&H4) = &H5
  gvConvToType(&H6) = &H5:           gvConvToTypeBits(&H5) = &H6
  gvConvToType(&H7) = &H6:           gvConvToTypeBits(&H6) = &H7
  gvConvToType(&H8) = &H9:           gvConvToTypeBits(&H9) = &H8
  gvConvToType(&H9) = &HA:           gvConvToTypeBits(&HA) = &H9
  gvConvToType(&HA) = &H8:           gvConvToTypeBits(&H8) = &HA
  'b 11?
  gvConvToType(&HC) = &H7:           gvConvToTypeBits(&H7) = &HC


  
  gVB_a_TypeConv(1) = "Int"
  gVB_a_TypeConv(2) = "Lng"
  gVB_a_TypeConv(3) = "Sng"
  gVB_a_TypeConv(4) = "Dbl"
  gVB_a_TypeConv(5) = "Cur"
  gVB_a_TypeConv(6) = "Var"
  gVB_a_TypeConv(7) = "Str"
  
  
  gVB_a_DataTypes(0) = "<undefined>" 'Added
  gVB_a_DataTypes(1) = "Integer"
  gVB_a_DataTypes(2) = "Long"
  gVB_a_DataTypes(3) = "Single"
  gVB_a_DataTypes(4) = "Double"
  gVB_a_DataTypes(5) = "Currency"
  gVB_a_DataTypes(6) = "Variant"
  gVB_a_DataTypes(7) = "String"
  gVB_a_DataTypes(8) = "String *"
  
  Init_g_ConvTypeBits_To_Flags
End Sub

Function Dgb_GetKeyWord(pKeyWord As Integer) As String
Dim KeyWordStrOffset As Integer
Dim KeyWord_EndPos As Integer

18050
 'Get Offset Start
  KeyWordStrOffset = Abs(VBdis3i_TokenData.KeyWords(pKeyWord).KeyWordStrOffset)
  If KeyWordStrOffset = 0 Then Exit Function
  
 'Read until "" and Output
  KeyWord_EndPos = InStr(KeyWordStrOffset, VBdis3i_KeyWordStrings, "")
  Dgb_GetKeyWord = Mid$(VBdis3i_KeyWordStrings, KeyWordStrOffset, KeyWord_EndPos - KeyWordStrOffset)
End Function

Function GetVBDISKeyWord() As String
Dim lKeyWordStrOffset As Integer
Dim EndPos As Integer

18000
  lKeyWordStrOffset = TokenDat.KeyWordStrOffset
  If lKeyWordStrOffset <= 0 Then Exit Function
  
  EndPos = InStr(lKeyWordStrOffset, VBdis3i_KeyWordStrings, "")
  GetVBDISKeyWord = Mid$(VBdis3i_KeyWordStrings, lKeyWordStrOffset, EndPos - lKeyWordStrOffset)
End Function

Sub sub0BAC()
End Sub

Function fnGetVBObject(pID_FromFile As Integer) As String
Dim ObjIdx As Integer
Dim ObjSize As Integer

18020
  ObjIdx = VBDAT_VBObjectLookupBaseOffset + (pID_FromFile And &HFF) * &H18
  ObjSize = Asc(Mid$(VBDIS2, ObjIdx, 1))
  fnGetVBObject = Mid$(VBDIS2, ObjIdx + 1, ObjSize)
End Function

Sub LoadVBDisDatFiles(LogLvl As Integer)
Dim hFilel As Integer
Dim IntFileBuff As Integer


18040
 'Set Version
  Select Case VBVersion
  Case 2
      VBDAT_VBObjectLookupBaseOffset = &H7500
      CurFilename = "vbdis2x.dat"
      
  Case 3
      VBDAT_VBObjectLookupBaseOffset = &H5600
      CurFilename = "vbdis3x.dat"
      
  Case Else
    ShowErrMsg Err_VersionNotSupported
    Exit Sub
  End Select
  
 'Create Filename & show log
 ' CurFilename = "vbdis" & Format$(VBVersion) & "x.dat"
  If LogLvl Then DispLog2 LogLvl, "Loading " & CurFilename
  
 'Open File
  hFilel = FreeFile
  Open AppPathwithSlash & CurFilename For Binary As hFilel
  
 'Get Version
  Get hFilel, , IntFileBuff
  
 'MaskOut MainVersion
  '... IntFileBuff  becomes 0x0302        << 7
  IntFileBuff = IntFileBuff Xor (VBVersion * &H100)
 
 'if SubVersion is 02
  If IntFileBuff = 2 Then
    
  ' Size of VBDIS = 10837+1(0x2A56) Words
  '                        => 21676(0x54AC) Bytes
    Get hFilel, , VBDIS
    
   '10837 *3 => 32511 (7EFF)
    VBDIS_TypesInfo = String$(VBDISSize * 3, 0): Get hFilel, , VBDIS_TypesInfo
    
   '2+10837+65022 = 75861 '0x12855
   'Get VBDISSize
    Get hFilel, , IntFileBuff
    VBDIS2 = String$(IntFileBuff, 0): Get hFilel, , VBDIS2
  
  Else
    
    ShowErrMsg err_File_Not_Found_Or_Wrong_Version
    gCancel = True
  
  End If
  
  Close hFilel

End Sub
