Attribute VB_Name = "MODULE18"
' Module18
Option Explicit
Const vbCritical = 16 ' &H10%
Const vbExclamation = 48 '&H30
Const vbQuestion = 32 '(&H20)
Const vbInformation = 64 '(&H40)

Const vbOKCancel = 1

Function fn0EF1() As Integer
26000
  fn0EF1 = gErrors
End Function

Sub ShowErrMsg(ErrNum As Variant)
26010
  If gErr_on_LineNum = 0 Then
    gErr_on_LineNum = gDisOutLogDbgLineCount: gv7B38 = CurOffset
  End If
  
 'MsgBox if Str
  If VarType(ErrNum) = VbVarType.vbString Then
    MsgBox ErrNum, vbCritical, News_from_VB_Discompiler
    gStopCriticalError = -1
  Else
    If gErrors And ErrNum Then Exit Sub
    
    ErrorMsg Val(ErrNum), vbExclamation, 1
  End If
End Sub

Function fnContiuneExec() As Integer
26020
  fnContiuneExec = gStopCriticalError
End Function

Sub ResetErrors()
26030
  gStopCriticalError = 0: gErr_on_LineNum = 0
End Sub

Sub ErrorMsg(ErrNum As Integer, MsgBoxStyle As Integer, MsgBoxButtons As Integer)
  Dim ErrType As Integer
  Dim MsgBoxText As String

26040
  If gStopCriticalError = 0 Then gStopCriticalError = ErrNum
  If ErrNum And &H8088 Then ErrType = ErrType Or gcMask_1000
  If ErrNum And &H4100 Then ErrType = ErrType Or gcMask_0100
  If ErrNum And &H1F50 Then ErrType = ErrType Or gcMask_0010
  If ErrType = 0 Then ErrType = gcMask_0001
  gErrors = gErrors Or ErrNum
  
  Select Case ErrNum
  Case 0
  Case 1: MsgBoxText = "Found unknown data structures!"
  Case 2: MsgBoxText = "Not a Visual Basic program"
  Case 4: MsgBoxText = "VB Version" & Str$(VBVersion) & " is not supported"
  Case 8: MsgBoxText = "Found an unknown resource!"
  Case &H10: MsgBoxText = "Found unknown fixups!"
  Case &H20: MsgBoxText = "Error in Discompiler logic!"
  Case &H40
   
   'Replace ".300" with "VBX" in MsgBoxText
    If Right$(CurFilename, 4) = ".300" Then
      MsgBoxText = Left$(CurFilename, Len(CurFilename) - 3) & "VBX"
    Else
      MsgBoxText = CurFilename
    End If
    
    MsgBoxText = "Missing description for " & MsgBoxText
    MsgBoxStyle = vbCritical
'    MsgBoxButtons = vbRetryCancel
    MsgBoxButtons = vbAbortRetryIgnore + vbDefaultButton3
    
  Case &H80: MsgBoxText = CurFilename & " contains unknown structure!"
  Case &H100: MsgBoxText = "Found an unknown token!"
  Case &H200: MsgBoxText = "Unexpected variable reference!"
  Case &H400: MsgBoxText = "Found incompatible scopes!"
  Case &H800: MsgBoxText = "Found incompatible types"
  Case &H1000: MsgBoxText = "Found an unknown collection!"
  Case &H2000: MsgBoxText = "An already known problem occured"
  Case &H4000: MsgBoxText = "File not found or wrong version: " & Chr$(10) & CurFilename
  Case &H8000: MsgBoxText = "The program is too big for this version of VB Discompiler"
  Case Else: MsgBoxText = "Error " & Format$(ErrNum)
  End Select
  
  If Len(MsgBoxText) Then
    If Right$(MsgBoxText, 1) = "!" Then MsgBoxText = MsgBoxText & Chr$(10) & "You may send this program to DoDi to improve VB Discompiler"
    MsgBoxResponse = MsgBox(MsgBoxText, MsgBoxStyle Or MsgBoxButtons, News_from_VB_Discompiler)
    
    Select Case MsgBoxResponse
      Case vbRetry
        Exit Sub
      
      Case vbCancel, vbAbort, vbNo
        GoTo QuitApp
   End Select
  
  End If
  
' no useless hint...
   Exit Sub
  
  ErrType = ErrType And Not UnloadReason
  UnloadReason = UnloadReason Or ErrType
  Select Case ErrType
  Case 0
  Case gcMask_1000
    MsgBox "For this program you'll need an upgraded VB Discompiler", vbCritical, ErrorSituationVBDiscompiler
    MsgBoxResponse = vbIgnore
  Case gcMask_0100
    MsgBoxResponse = MsgBox("Severe errors may cause the Discompiler to crash", vbExclamation + vbOKCancel, ErrorSituationVBDiscompiler)
  Case gcMask_0010
    MsgBoxResponse = MsgBox("Internal problems, the code created may be buggy", vbQuestion + vbOKCancel, ErrorSituationVBDiscompiler)
  Case Else
    MsgBoxResponse = MsgBox("Do you have the latest edition of VB Discompiler?", vbInformation + vbOKCancel, ErrorSituationVBDiscompiler)
  End Select
  
  Select Case MsgBoxResponse
   Case vbCancel, vbAbort, vbNo
  
  Case Else
    Exit Sub
  
  End Select

QuitApp:
  UnloadReason = UnloadReason Or gcMask_0001_0000
  Unload FrmMain
End Sub
