#
#  ANSI Color Parsing Engine (revision: 2 / date: 7-12-98)
#  ================================================================
#  by conio (conio@bellsouth.net) (Sam Stephenson)
#
#  This script is purely a PARSING ENGINE. It will NOT replace
#  ANSI escape sequences with the correct colors until you either
#     - create a PRIVMSG event yourself or
#     - modify your script's PRIVMSG event.
#
#  Usually all this involves is placing a line at the top of a
#  script, such as "source ansi.tcl", and then putting
#  [ansitomirc ] around the arguments in the PRIVMSG alias.
#
#  I am, at the time of this writing, creating a script for XiRCON
#  which modifies it to look like the UNIX IRC client BitchX.
#  I have modified it to load my ANSI.TCL if available and utilize
#  it. I suggest all scripts be modified to do so -- remember:
#  this script is free, but please do not merge it in with your
#  script source. Leave it as a separate file.
#
#  If you have any questions or comments, or bug fixes, please
#  email me. Thanks.
#
#
#  Features of Revision 2a:
#     - All standard ANSI colors are parsed.
#     - Background colors are now parsed.
#     - Bolded (intensified) colors... correctly.
#     - Reverse (mode 7) color.   
#     - a: Freeze bug fixed (hopefully?)
#
#


set ANSIVERS "ANSI-2a"

#
#  This alias shows an example of the ANSI parsing.
#
alias atm {
    echo [ansitomirc "\x1B\[0mRegular text"]
    echo [ansitomirc "\x1B\[30mBlack"]
    echo [ansitomirc "\x1B\[1;30mGray"]
    echo [ansitomirc "\x1B\[31mDark Red"]
    echo [ansitomirc "\x1B\[1;31mRed"]
    echo [ansitomirc "\x1B\[32mGreen"]
    echo [ansitomirc "\x1B\[1;32mLime Green"]
    echo [ansitomirc "\x1B\[33mDark Yellow"]
    echo [ansitomirc "\x1B\[1;33mYellow"]
    echo [ansitomirc "\x1B\[34mNavy Blue"]
    echo [ansitomirc "\x1B\[1;34mCobalt Blue"]
    echo [ansitomirc "\x1B\[35mPurple"]
    echo [ansitomirc "\x1B\[1;35mMagenta"]
    echo [ansitomirc "\x1B\[36mCyan"]
    echo [ansitomirc "\x1B\[1;36mLight Blue"]
    echo [ansitomirc "\x1B\[37mLight Gray"]
    echo [ansitomirc "\x1B\[1;37mWhite"]
    complete
}

#
#  This alias shows all mIRC colors and their numbers.
#  It was very helpful during the development process :)
#
alias showcolors {
    if { [string tolower [lindex [args] 0]] == "-say" } {
        say "1 12 23 34 45 56 67 78 89 910 1011 1112 1213 1314 1415 1516 16"
    } else {
        echo "1 12 23 34 45 56 67 78 89 910 1011 1112 1213 1314 1415 1516 16"
    }
    complete
}

alias showansi {
    if { [string tolower [lindex [args] 0]] == "-say" } {
        say [ansitomirc "\x1B\[30m30 \x1B\[31m31 \x1B\[32m32 \x1B\[33m33 \x1B\[34m34 \x1B\[35m35 \x1B\[36m36 \x1B\[37m37 \x1B\[1;30m1;30 \x1B\[31m1;31 \x1B\[32m1;32 \x1B\[33m1;33 \x1B\[34m1;34 \x1B\[35m1;35 \x1B\[36m1;36 \x1B\[37m1;37"]
    } else {
        echo [ansitomirc "\x1B\[30m30 \x1B\[31m31 \x1B\[32m32 \x1B\[33m33 \x1B\[34m34 \x1B\[35m35 \x1B\[36m36 \x1B\[37m37 \x1B\[1;30m1;30 \x1B\[31m1;31 \x1B\[32m1;32 \x1B\[33m1;33 \x1B\[34m1;34 \x1B\[35m1;35 \x1B\[36m1;36 \x1B\[37m1;37"]
    }
    complete
}

#
#  ENGINE START ===================================================
#
proc findnext { string start lookfor } {
    set m [string first $lookfor $string]

    if { $m < $start } {
        for { set x $start } { $x < [string length $string] } { incr x } {
            if { [string index $string $x] == $lookfor } {
                return $x
                complete
            }
        }
    } else {
        return $m
    }
}

proc attrtolist { string } {
    set tmp $string
    set whileflag 0
    set list ""
    set pos 0

    while { $whileflag == 0 } {
        set semicolon [findnext $tmp $pos ";"]
        set list [concat $list [string range $tmp $pos [expr $semicolon - 1]]]
        set pos [expr $semicolon + 1]
        if { $pos >= [string length $tmp] } {
            set whileflag 1
        }
    }

    return $list
}

proc ansitomirc { string } {
    set tmp $string
    set boldflag 0

    while { [string match "*\x1B*m*" $tmp] == 1 } {
        set esc [string first "\x1B\[" $tmp]
        set m [findnext $tmp $esc "m"]
        set escseq [string range $tmp [expr $esc + 2] [expr $m - 1]]
        append escseq ";"
        set attrlist [attrtolist $escseq]
        catch { set attrlist [lsort $attrlist] }
        set mircattr ""
        set fgflag 0
    
        foreach x $attrlist {
            switch $x {
                0   { append mircattr "[color text]" ; set boldflag 0 }
                1   { set boldflag 1 }
                7   { append mircattr "" }
                30  { set fgflag 1 ; if { $boldflag == 1 } { append mircattr "14" } else { append mircattr "01" } }
                31  { set fgflag 1 ; if { $boldflag == 1 } { append mircattr "04" } else { append mircattr "05" } }
                32  { set fgflag 1 ; if { $boldflag == 1 } { append mircattr "09" } else { append mircattr "03" } }
                33  { set fgflag 1 ; if { $boldflag == 1 } { append mircattr "08" } else { append mircattr "07" } }
                34  { set fgflag 1 ; if { $boldflag == 1 } { append mircattr "12" } else { append mircattr "02" } }
                35  { set fgflag 1 ; if { $boldflag == 1 } { append mircattr "13" } else { append mircattr "06" } }
                36  { set fgflag 1 ; if { $boldflag == 1 } { append mircattr "11" } else { append mircattr "10" } }
                37  { set fgflag 1 ; if { $boldflag == 1 } { append mircattr "16" } else { append mircattr "15" } }
                40  { if { $fgflag == 1 } { append mircattr ",01" } else { append mircattr "15,01" } }
                41  { if { $fgflag == 1 } { append mircattr ",05" } else { append mircattr "15,05" } }
                42  { if { $fgflag == 1 } { append mircattr ",03" } else { append mircattr "15,03" } }
                43  { if { $fgflag == 1 } { append mircattr ",07" } else { append mircattr "15,07" } }
                44  { if { $fgflag == 1 } { append mircattr ",02" } else { append mircattr "15,02" } }
                45  { if { $fgflag == 1 } { append mircattr ",06" } else { append mircattr "15,06" } }
                46  { if { $fgflag == 1 } { append mircattr ",10" } else { append mircattr "15,10" } }
                47  { if { $fgflag == 1 } { append mircattr ",15" } else { append mircattr "15,15" } }
            }
        }
        set tmp [string range $tmp 0 [expr $esc - 1]]$mircattr[string range $tmp [expr $m + 1] [string length $tmp]]
    }               
    return $tmp
}
#
#  ENGINE END =====================================================
#