########################################################## ##  #
#
#  ButchX-p6
#_________________________________________________________ __  _
#
#  by conio (conio@bellsouth.net)
#  http://members.xoom.com/conio/
#
#  This script is visually oriented. It alters XiRCON to
#  look like the BitchX IRC client for UNIX. Many BitchX
#  commands and events have been implemented to provide
#  the look and feel of BitchX in Windows.
#
#  Please remember to read the README.TXT file in your
#  ButchX distribution. Thanks to Tony Klar, without whom
#  I might have stopped development after p4.
#
#_________________________________________________________ __  _





################################################### ##  #
#
#   Global Variables and Settings
#__________________________________________________ __  _


set ANSISCRIPT "ansi.tcl"
set invited ""
set butchxversion "ButchX-p6"
set butchxrevision "Mon Aug 24 1998 22:28 EST"
set version ""
set dccchatip ""
set dccchatport 0
set startaway 0 
set joinqueue ""
set topicqueue ""
set createdqueue ""
set nickinuse ""
set jointime 0
set loaded 0
set dns_nicks ""
set dnsnick ""
set idle_time 0
set msglog_file 0
set nums [list 402 403 405 407 409 411 412 413 414 422 423 424 431 436 441 442 443 444 445 446 451 461 462 463 464 465 467 472 474 483 491 501 502 300 302 303 321 322 323 324 331 332 341 342 351 352 315 353 366 364 365 367 368 371 374 381 382 391 392 393 394 395 200 201 202 203 204 205 206 208 261 211 212 213 214 215 216 218 219 241 242 243 244 252 253 254 255 256 257 258 259]

if { [catch { source $ANSISCRIPT }] } { set hasansi 0 } else { set hasansi 1 }
rename echo realecho












################################################### ##  #
#
#   Aliases
#__________________________________________________ __  _


alias about {
    echo "[greenline]"
    echo "9[p] 16$butchxversion [color text]by conio 14([color text]$butchxrevision14)"
    echo "9[l] [color text]Running on 16XiRCON [version][color text] by Mark Hanson."
    if { $hasansi == 1 } {
        echo "3[p] [color text]ANSI extension 14(16$ANSIVERS14) [color text]by conio is loaded."
        echo "14: [color text]ButchX home page: http://members.xoom.com/conio/"
    } else {
        echo "3[p] [color text]ButchX home page: http://members.xoom.com/conio/"
    }
    complete
}  

alias action {
    /me [arg]
    complete
}

alias ame {
    foreach c [channels] {
        /raw PRIVMSG $c :\001ACTION [arg]\001
        if { $bxset(NEW_STYLE_ACTION) == "ON" } {
            echo "14[e] 08[my_nick]/$c[color text] [arg]" channel $c
        } else {
            echo "14[e] 16[my_nick][color text] [arg]" channel $c
        }
    }
    complete
}

alias away {
    global startaway
    if { $startaway > 0 } {
        /back
        complete
    }

    set startaway [unixtime]
    if { [lindex [args] 0] == "" } {
        set awaymsg $bxset(DEFAULT_AWAY_MESSAGE)
    } else {
        set awaymsg [lrange [join [args]] 0 end]
    }

    if { $bxset(MSGLOG) == "ON" } {
        /ame is away: ($awaymsg) \[BX-MsgLog On]
        /raw AWAY : is away: ($awaymsg) \[BX-MsgLog On]
    } else {
        /ame is away: ($awaymsg) \[BX-MsgLog Off]
        /raw AWAY : is away: ($awaymsg) \[BX-MsgLog Off]
    }
    if { $bxset(MINIMIZE_ON_AWAY) == "ON" } {
        window minimize main
    }
    complete
}

alias back {
    if { $startaway != 0 } {
        global startaway
        set timegone [expr [unixtime] - $startaway]
        set gonestring "[expr $timegone / 3600] hrs [expr [expr $timegone / 60] % 60] min [expr $timegone % 60] secs"
    
        if { $bxset(MSGLOG) == "ON" && $msglog_file != 0 } {
            puts $msglog_file "MsgLog ended \[[timestamp]]"
            close $msglog_file
            set msglog_file 0
        }

        foreach c [channels] {
            /raw PRIVMSG $c :\001ACTION is back from the dead. Gone $gonestring\001
        }
        if { $bxset(MSGLOG) == "ON" } {
            echo "[bx] 16ButchX[color text]: You were /away for $gonestring. \[BX-MsgLog On]"
        } else {
            echo "[bx] 16ButchX[color text]: You were /away for $gonestring. \[BX-MsgLog Off]"
        }
    }
    /raw away :
    set startaway 0
    complete
}    

alias bans {
    if { [lindex [args] 0] == "" } {
        if { [channel] != "" } {
            /raw MODE [channel] b
            complete
        } else {
            echo "[bx] 16ButchX[color text]: You're not on a channel!"
            complete
        }
    } else {
        /raw MODE [lindex [args] 0] b
        complete
    }
}

alias bxlogo {
    if { [lindex [args] 0] > 0 & [lindex [args] 0] < 7 } {
        set which [lindex [args] 0]
    } else {
        random 1 6
        set which [random 1 6]
    }
    switch $which {
        "1" {
            echo " " status
            echo "   5%%%%%%%1   5%%%1  5%%%1  5%%%%%%%1   5%%%%%%%1  5%%%1  5%%%1  5%%%1  5%%%" status     
            echo "   5%%%%%%%%1  5%%%1  5%%%1  5%%%%%%%1  5%%%%%%%%1  5%%%1  5%%%1  5%%%1  5%%%" status
            echo "   5%%4!1  5%%%1  5%%4!1  5%%%1    5%%4!1    4!5%%1       5%%4!1  5%%%1  5%%4!1  4!5%%" status
            echo "   4!5%4   5%4!5%4  !5%4!  5%4!5%4    !5%4!    !5%4!       !5%4!  5%4!5%  4!5%4!  5%4!!" status
            echo "   5%4!5%4!5%4!5%   %4!5%  4!5%4!    5%4!!    !5%4!       5%4!5%4!5%4!5%4!   !5%%4!5%4!" status
            echo "   4!!!5%4!!!!  !5%4!  !!!    !!!    !!!       !!!5%4!!!!    5%4!!!" status
            echo "   4!!:  !!!  !!:  !!!    !!:    :!!       !!:  !!!   !: :!!" status
            echo "   4:!:  !:!  :!:  !:!    :!:    :!:       :!:  !:!  :!:  !:!" status
            echo "   4 :: ::::  ::::: ::     ::     ::: :::  ::   :::   ::  :::" status
            echo "   4:: : ::    : :  :      :      :: :: :   :   : :   :   ::" status
            echo " " status
            echo "   4B5utch4X16[string range $butchxversion [string first "-" $butchxversion] end] 14by 5conio 14(4conio@bellsouth.net14)" status
            echo " " status
        }
        "2" {
            echo "6                                              Y8b." status
            echo "   14888888b.            888            888      6Y88b   13d88P" status 
            echo "   14888  '88b           888            888       6Y88b 13d88P" status
            echo "   14888  .88P           888            888        6Y8813o88P" status
            echo "   148888888K.  888  888 888888 .d8888b 88888b.     6Y13888P" status
            echo "   14888  `Y88b 888  888 888   d88P'    888 `88b    13d8886b" status
            echo "   14888    888 888  888 888   888      888  888   13d8880688b" status
            echo "   14888   d88P Y88b 888 Y88b. Y88b.    888  888  13d88P 6Y88b" status
            echo "   148888888P'   `Y88888  `Y888 'Y8888P 888  888 13d88P   6Y88b" status
            echo "                                                       6Y88b" status
            echo "   13B6utc6h13X16[string range $butchxversion [string first "-" $butchxversion] end] 14by 6conio 14([color text]13conio@bellsouth.net14)             6Y88b" status
            echo " " status
        }
        "3" {
            echo " " status
            echo "   10oooooooooo.                 .             oooo        11ooooooo  ooooo" status
            echo "   10`888'   `Y8b              .o8             `888         11`8888    d8'" status
            echo "    10888     888 oooo  oooo .o888oo  .ooooo.   888 .oo.      11Y888..8P" status
            echo "    10888oooo888' `888  `888   888   d88' `\"Y8  888P\"Y88b      11`8888'" status
            echo "    10888    `88b  888   888   888   888        888   888     11.8PY888." status
            echo "    10888    .88P  888   888   888 . 888   .o8  888   888    11d8'  `888b" status
            echo "   10o888bood8P'   `V88V\"V8P'  \"888\" `Y8bod8P' o888o o888o 11o888o  o88888o" status
            echo " " status
            echo "   11B10utch11X16[string range $butchxversion [string first "-" $butchxversion] end] 14by 10conio 14([color text]11conio@bellsouth.net14)" status
            echo " " status
        }
        "4" {
            echo " " status
            echo "   0388888888ba                                88          098b        d8" status
            echo "   0388      \"8b               ,d              88           09Y8,    ,8P" status
            echo "   0388      ,8P               88              88            09`8b  d8'" status
            echo "   0388aaaaaa8P' 88       88 MM88MMM ,adPPYba, 88,dPPYba,      09Y88P" status
            echo "   0388\"\"\"\"\"\"8b, 88       88   88   a8\"     \"\" 88P'    \"8a     09d88b" status
            echo "   0388      `8b 88       88   88   8b         88       88  09 ,8P  Y8," status
            echo "   0388      a8P \"8a,   ,a88   88,  \"8a,   ,aa 88       88  09d8'    `8b" status
            echo "   0388888888P\"   `\"YbbdP'Y8   \"Y888 `\"Ybbd8\"' 88       88 098P        Y8" status
            echo " " status
            echo "   9B3utch9X16[string range $butchxversion [string first "-" $butchxversion] end] 14by 3conio 14([color text]9conio@bellsouth.net14)" status
            echo " " status
        }
        "5" {
            echo " " status
            echo "16                                                           '\"\$\$\$\$\"" status
            echo "16                                                             '\$\$;" status
            echo "16                                                              '\$\$,        '\"\$\$\$b" status
            echo "14                               ,                       15__      16\"\$\$,         \"\$P" status
            echo "14.o\$\$\$S'                        \$b,                  15.o\$\$\$S'     16\"\$\$,        \$\$\"" status
            echo "14l\$\$\$\$P                         \$\$\$b,                15l\$\$\$\$P       16\"\$\$,      \$\$\"" status
            echo "14!\$\$\$\$i           __            \$\$\$\$l           _    15!\$\$\$\$i   __   16\"\$\$,    \$\$\"" status
            echo "14 \$\$\$\$l.o\$\$\$\$\$o.!\$\$\$\$           lN\$\$\$;      ,j\$\$\$\$o,  15\$\$\$\$l.o\$\$\$\$o. 16\"\$\$,  \$\$\"" status
            echo "14 \$\$\$\$P\"''  \"'\$\$iN\$S\$    j\$\$. oQ\$\$\$N\$\$\$So,j\$\$\$\$ \"\$\$\$\$,15\$\$\$\$P\"''  \"'\$\$i16`\$\$.\$\$'" status
            echo "14 \$\$\$\"        \$\$l\$\$\$\$    \$\$\$\$   \$\$\$\$D\"\"'  j\$\$\$P   \"\$\$\$15\$\$\$\"        i\$\$ 16\"\$\$\$\"" status
            echo "14 \$\$\$        ;\$\$;\$\$\$\$    \$\$\$\$   \$\$\$\$S     \$\$\$\$'    `\",15\$\$\$         l\$\$  16X\$\$" status
            echo "14 \$\$l        \$\$\$ \$\$\$l    \$\$\$\$l  \$\$\$\$l ,.__\$\$\$Q     ,__15\$\$l        ,\$\$l 16\$\$\"\$\$," status
            echo "14 \$\$\$.      \$\$\$' l\$\$i    \$\$\$\$i  i\$\$\$i ;\$\$\$l\$\$\$     \$\$\$15\$\$\$.       l\$\$;16\$\$' `\$\$," status
            echo "14 '\$\$\$,   ,\$\$\$'  i\$\$:   ;i\$\$\$\$  ;\$\$\$;  \$\$\$`\$\$\$.    \$\$\$15'\$\$\$,     ,\$\$,16\$\$'   `\$\$," status
            echo "14  `\$\$\$..\$\$\$'    '\$\$\$,.i\$\$\$\$\$\$   \$\$\$\$,.\$\$\$ `\$\$b., \$\$\$\" 15`\$\$\$,    \$\$\$16\$\$'     `\$\$," status
            echo "14   `l\$o\$\$'       ';\$\$\$\$\$\$i'\$\$\$;,\"#\$\$\$\$\$\"    \"\$\$\$\$\$\"    15\";\$o;    \"16\$\$;       `\$\$," status
            echo "14    `\"                        \"\"   \"\"         \"\"\"       15'\"      16\"\"\"\"'       `\$\$," status
            echo "16    15B14utch15X16[string range $butchxversion [string first "-" $butchxversion] end] 14by 15conio 14([color text]16conio@bellsouth.net14)                              16.,;\$\$P" status
            echo " " status
        }
        "6" {
            echo " " status
            echo "4                                     \$\$      8%%%%%%%   %%%%%%" status
            echo "4   \$\$\$\$\$\$\$\$\$             \$          \$\$\$       8`%%%'     `%%'" status
            echo "4    `\$\$   `\$\$           \$\$          `\$\$         8%%      .%'" status
            echo "4     \$\$    \$\$           \$\$           \$\$          8%%    .%'" status
            echo "4     \$\$    \$\$ \$\$\$  \$\$\$ \$\$\$\$\$  .\$\$\$\$  \$\$.\$\$\$       8%%  .%'" status
            echo "4     \$\$    \$\$ `\$\$   \$\$ `\$\$   .\$\$  \$\$ \$\$\$' \$\$       8%%.%'" status
            echo "4 .s\$\$\$\$\$\$\$\$\$   \$\$   \$\$  \$\$   \$\$    \$ \$\$   \$\$        8%%'" status
            echo "4     \$\$    \$\$  \$\$   \$\$  \$\$   \$\$      \$\$   \$\$      8.%'%%" status
            echo "4     \$\$     \$\$ \$\$   \$\$  \$\$   \$\$      \$\$   \$\$     8.%'  %%" status
            echo "4     \$\$     \$\$ \$\$   \$\$  \$\$   \$\$\$   \$ \$\$   \$\$    8.%'    %%" status
            echo "4    .\$\$   .\$\$  \$\$ .\$\$\$\$ \$\$ \$  \$\$\$\$\$  \$\$  .\$\$   8.%%      %%" status
            echo "4   \$\$\$\$\$\$\$\$\$'   \$\$\$'\$\$  \$\$\$'  `\$\$\$' \$\$\$\$ \$\$\$\$ 8%%%%%      %%" status
            echo "                                                          8%%" status
            echo "16    8B7utch8X16[string range $butchxversion [string first "-" $butchxversion] end] 7by 8conio 14([color text]8conio@bellsouth.net14)               8%" status
            echo "                                                            8%" status
            echo "                                                             8." status
            echo " " status
        }

    }
    complete
}

alias ctcp {
    set what [string toupper [lindex [args] 1]]
    if { [string toupper [lindex [args] 1]] == "PING" && [lindex [args] 2] == "" } {
        /raw PRIVMSG [lindex [args] 0] :\x01$what [clock clicks]\x01
        echo "14\[5ctcp14(04[lindex [args] 0]14)\][color text] $what" 
    } else {
        echo "14\[5ctcp14(04[lindex [args] 0]14)\][color text] $what [lrange [join [args]] 2 end]" 
        /raw PRIVMSG [lindex [args] 0] :\x01$what [string range [raw_args] [expr [expr [string length [lindex [args] 0]] + 2] + [string length [lindex [args] 1]]] end]\x01    
    }
    complete
}

alias dns {
    global nickinuse
    global dnsnick
    set host [arg]
    if { [string match *.* $host] } {
        lookup $host
    } else {
        lappend dns_nicks [string tolower $host]
        set dnsnick [string tolower $host]
        whois $host
    }
    echo "[bx] 16ButchX[color text]: Checking tables..."
    complete
}

alias do {
    eval "[raw_args]"
    complete
}

alias echo {
    eval echo [raw_args]
    complete
}

alias help {
    set cmd [string toupper [lindex [args] 0]]
    set count 0
    set cmds [lsort [array names bxhelp]]
    set spaces "            "
    set tmp ""

    if { $cmd == "" } {
        foreach x $cmds {
            incr count
            append tmp "$x[string range $spaces [string length $x] end]"
            if { $count == 5 | $x == [lindex $cmds end] } {
                set count 0
                echo "[bx] $tmp"
                set tmp ""
            }
        }
        echo "[bx] Usage: /help 4\[[color text]command4][color text] to get help on specific commands"
    } else {
        if { [lsearch [array names bxhelp] $cmd] != -1 } {
            echo "[bx] Usage: /$cmd $bxhelp($cmd)"
        } else {
            echo "[bx] 16ButchX[color text]: No such command \[$cmd]"
        }
    }
    complete
}

alias invite {
    if { [lindex [args] 1] == "" } {
        set chan [channel]
    } else {
        set chan [lindex [args] 1]
    }
    /raw INVITE [lindex [args] 0] $chan
    echo "[arrows] Inviting [lindex [args] 0] to $chan"
    complete
}

alias kick {
    if { [window_type] == "channel" } {
        set chan [window_name]
    }
    if { [string index [lindex [args] 0] 0] == "#" } {
        if { [lindex [args] 1] == "" } {
            echo "[bx] Please specify a nickname"
            complete
        } else {
            set chan [lindex [args] 0]
            set nck [lindex [args] 1]
            set reason [lrange [join [args]] 2 end]
        }
    } elseif { [lindex [args] 0] != "" } {
        set nck [lindex [args] 0]
        set reason [lrange [join [args]] 1 end]
    }
    if { $reason == "" } {
        set reason $bxset(DEFAULT_REASON)
    }
    /raw KICK $chan $nck :$reason
    complete
}

alias me {
    /raw PRIVMSG [channel] :\001ACTION [arg]\001
    if { $bxset(NEW_STYLE_ACTION) } {
        echo "14[e] 08[my_nick]/[channel][color text] [arg]" channel [channel]
    } else {
        echo "14[e] 16[my_nick][color text] [arg]" channel [channel]
    }
    complete
}

alias msg {
    set txt [string range [raw_args] [expr [string first " " [raw_args]] + 1] end] 
    set text $txt
    set dest [string tolower [lindex [args] 0]]
    set x [string index $dest 0]

    if { $bxset(MSGLOG) == "ON" && $msglog_file != 0 } {
        puts $msglog_file "\[SEND_MSG] \[[clock format [clock seconds] -format "%I:%M%p"]] - [lindex [args] 0] $text"
        flush $msglog_file
    }

    if {$x == "#" || $x == "&"} {
        echo "13<[color text][my_nick]13>[color text] $text" channel $dest
    } elseif { $x == "=" } {
    } else {
        echo "14\[5msg14(04[lindex [args] 0]14)\][color text] [lrange [join [args]] 1 end]"
    }
    /raw PRIVMSG $dest :$txt
    complete
}

alias names {
    set x ""
    set echostring ""
    set blank "                "
    set count 0
    set chan ""

    if { [lindex [args] 0] == "" } {
        if { [channel] != "" } {
            set chan [channel]
        }
    } else {
        set chan [lindex [args] 0]
    }

    if { $chan != "" } {
        echo "[bx] 14\[9Users14(03$chan:[llength [nicks $chan]]14)\]"
        foreach x [nicks $chan] {
            incr count 
            switch [string index $x 0] {
                "@"     { append echostring "14\[11@12[string range $x 1 $bxset(CHANNEL_NAME_WIDTH)]" }
                "+"     { append echostring "14\[13v12[string range $x 1 $bxset(CHANNEL_NAME_WIDTH)]" }
                default { append echostring "14\[ 12[string range $x 0 [expr $bxset(CHANNEL_NAME_WIDTH) - 1]]" }
            }
            if { [string length [normalizenick $x]] < $bxset(CHANNEL_NAME_WIDTH) } {
                append echostring [string range $blank 1 [expr $bxset(CHANNEL_NAME_WIDTH) - [string length [normalizenick $x]]]]
            }
            append echostring "14\] "
            if { $count == $bxset(CHANNEL_NAME_COLS) || $x == [lindex [nicks $chan] end] } {
                echo $echostring
                set echostring ""
                set count 0
            }
        }
    }
    complete
}

alias notice {
    /raw NOTICE [lindex [args] 0] :[lrange [join [args]] 1 end]
    echo "14\[5notice14(04[lindex [args] 0]14)\][color text] [lrange [join [args]] 1 end]"
    if { $bxset(MSGLOG) == "ON" && $msglog_file != 0 } {
        puts $msglog_file "\[SEND_MSG] \[[clock format [clock seconds] -format "%I:%M%p"]] - [lindex [args] 0] [lrange [join [args]] 1 end]"
        flush $msglog_file
    }
    complete
}

alias privmsg {
    set text [string range [raw_args] [expr [string first " " [raw_args]] + 1] end] 
    set dest [string tolower [lindex [args] 0]]
    set x [string index $dest 0]

    set text [nickcomplete $text]

    if { $bxset(MSGLOG) == "ON" && $msglog_file != 0 } {
        puts $msglog_file "\[SEND_MSG] \[[clock format [clock seconds] -format "%I:%M%p"]] - [lindex [args] 0] $text"
        flush $msglog_file
    }

    if {$x == "#" || $x == "&"} {
        /raw PRIVMSG $dest :$text
        echo "13<[color text][my_nick]13>[color text] $text" channel $dest
        complete
    } else {
        /raw PRIVMSG $dest :$text
        echo "14\[5msg14(04[lindex [args] 0]14)\][color text] $text" [window_type] [window_name]
        complete
    }
}

alias raw {
    set idle_time 0
}

alias set {
    set periods ".............................."
    set sets [lsort [array names bxset]]

    if { [lindex [args] 0] == "" } {
        foreach x $sets {  
            echo "03[string range $periods 1 [expr [string length $periods] - [string length $x]]]$x 15$bxset($x)"
        }
    } elseif { [lindex [args] 0] != "" && [lindex [args] 1] == "" } {
        if { [lsearch -exact $sets [string toupper [lindex [args] 0]]] != -1 } {
            set x [string toupper [lindex [args] 0]]
            echo "03[string range $periods 1 [expr [string length $periods] - [string length $x]]]$x 15$bxset($x)"
        } else {
            set found 0
            set y [string toupper [lindex [args] 0]]
            foreach x $sets {
                if { [string match "$y*" $x] } {
                    if { $found == 0 } {
                        set found 1
                        echo "[bx] $y is ambiguous"
                    }
                    echo "03[string range $periods 1 [expr [string length $periods] - [string length $x]]]$x 15$bxset($x)"
                }
            }
            if { $found == 0 } {
                echo "[bx] No such variable \"$y\""
            }
        }
    } elseif { [lindex [args] 0] != "" && [lindex [args] 1] != "" } {
        set x [string toupper [lindex [args] 0]]
        set y [lindex [args] 1]
        set z [string toupper $y]

        if { [lsearch -exact $sets $x] == -1 } {
            echo "[bx] No such variable \"$x\""
        } else {
            set badflag 0
            switch $stype($x) {
                "1" {
                    if { $z != "ON" && $z != "OFF" && $z != "TOGGLE" } {
                        echo "[bx] Value must be either ON, OFF, or TOGGLE"
                        set badflag 1
                    } else {
                        set y $z
                    }
                } "2" {
                    if { ![isnum $y] } {
                        echo "[bx] Value of $x must be numeric!"
                        set badflag 1
                    } elseif { $y < 5 } {
                        set y 5
                    }
                } "3" {
                    set y [lrange [join [args]] 1 end]
                } "4" {
                    if { ![isnum $y] } {
                        echo "[bx] Value of $x must be numeric!"
                        set badflag 1
                    } elseif { $y < 2 } {
                        set y 2
                    }
                }
            }
            if { $badflag != 1 } {
                if { $z == "TOGGLE" } {
                    if { $bxset($x) == "ON" } {
                        set y "OFF"
                    } else {
                        set y "ON"
                    }
                }
                set bxset($x) $y
                set_cookie $x $y
                echo "[bx] Value of $x set to $y"
            }
        }
    } 
    complete
}

alias sv {
    if { [lindex [args] 0] == "" } {
        say $version
    } else {
        /msg [lindex [args] 0] $version
    }        
    complete
}





################################################### ##  #
#
#   Events
#__________________________________________________ __  _


on chat_accept {
    echo "[bx] 4DCC [color text]CHAT connection with 16[nick]14\[10$dccchatip port $dccchatport14\] [color text] established" chat [nick]
    set dccchatip ""
    set dccchatport 0
}

on chat_connect {
    echo "[bx] 4DCC [color text]CHAT connection with 16[nick]14\[10$dccchatip port $dccchatport14\] [color text] established" chat [nick]
    set dccchatip ""
    set dccchatport 0
}

on chat_send {
    echo "14\[5dcc14(4[nick]14)] [color text][lindex [args] 0]" chat [nick]
    complete
}

on chat_text {
    echo "14\[9[nick]14(3dcc14)] [color text][lindex [args] 0]" chat [nick]
    complete
}

on connect {
    global loaded
    set loaded [unixtime]
}

on ctcp {   
    global version
    set parm [string toupper [lindex [args] 1]]
    set cleanflag 0
    set all [lrange [join [args]] 1 end]

    if { $parm == "ACTION" } {
        if { [string match #* [lindex [join [args]] 0]] } {
            if { $bxset(NEW_STYLE_ACTION) == "ON" } {
                echo "14[e] 08[nick]/[lindex [args] 0][color text] [lindex [args] 2]" channel [lindex [args] 0]
            } else {
                echo "14[e] 16[nick][color text] [lindex [args] 2]" channel [lindex [args] 0]
            }
        } else {
            echo "14[e] 16[nick] [color text][lrange [join [args]] 2 end]" query [lindex [join [args]] 0]
        }
        set cleanflag 1
        complete
    }
    if { $bxset(CLOAK) == "ON" } {
        if { $cleanflag == 0 } {
            echo "[arrows] 11[nick] 14\[10[user]@[host]14\] 10requested $parm from [lindex [args] 0]"        
        }
    } else {
        if { $parm == "VERSION" } {
            /raw NOTICE [nick] :VERSION $version : Keep it to yourself!
            complete
        }
        if { $parm == "REVISION" } {
            /raw NOTICE [nick] :REVISION $butchxrevision
            complete
        }
        if { [string match "DCC CHAT chat*" $all] } {
            set blah1 [findnext $all 13 " "]
            set blah2 [findnext $all [expr $blah1 + 1] " "]
            set dccchatip [float2ip [string range $all [expr $blah1 + 1] [expr $blah2 - 1]]]]
            set dccchatport [string range $all [expr $blah2 + 1] end]
        }
        if { [string match "DCC *" $all] } {
            return
        }
        if { $parm == "PING" } {
            /raw NOTICE [nick] :$all
        }
        if { $parm == "CLIENTINFO" } {
            /raw NOTICE [nick] :CLIENTINFO XiRCON [version] http://www.xircon.com
        }
        if { $cleanflag != 1 } {
            if { $bxset(SHOW_EXTENDED_CTCP) == "ON" } {
                echo "[arrows] 09[nick] 14\[03[user]@[host]14\] 3requested $all from [lindex [args] 0]"
            } else {
                echo "[arrows] 09[nick] 14\[03[user]@[host]14\] 3requested $parm from [lindex [args] 0]"
            }
        }
    }
    complete
}

on ctcp_reply {
    global tcl_precision
    set tcl_precision 3
    set 2 ""

    if { [string toupper [lindex [args] 1]] == "PING" } {
        if { [string first "\[" [lindex [args] 2]] == -1 } {
            catch { set 2 "[expr (([clock clicks] + 0.000) - ([lindex [args] 2] + 0.000)) / 1000.000] sec" }
        }
    } else {
        set 2 [lrange [join [args]] 2 end]
    }
    if { $2 != "" } {
        echo "[bx] CTCP 16[string toupper [lindex [args] 1]] [color text]reply from [nick]: $2"
    }
    complete
}

on disconnect {
    global loaded
    set x [unixtime]
    set y [expr $x - $loaded]
    echo "[bx] Signon time  :    [join [clock format $loaded]]"
    echo "[bx] Signoff time :    [join [clock format $x]]"
    echo "[bx] Total uptime :    [expr $y / 86400]d [expr [expr $y / 3600] % 60]h [expr [expr $y / 60] % 60]m [expr $y % 60]s"
    complete
}

on error {
    echo "[bx] 16ButchX[color text]: [lrange [join [args]] 0 end]" status
    complete
}

on invite {
    global invited
    set invited [lindex [args] 1]
    echo "[arrows] [nick] Invites You to $invited"
    echo "[bx] 16ButchX[color text]: Press Ctrl-K to join $invited (Esc to cancel hotkey)"
    complete
}

on join {
    global joinqueue
    set chan [lindex [args] 0]
    if { [nick]==[my_nick] } {
        set jointime [clock clicks]
        set joinqueue "[bx] 11[nick] 14\[10[user]@[host]14\] [color text]has joined [args]"
    } else {
        echo "[bx] 11[nick] 14\[10[user]@[host]14\] [color text]has joined [args]" channel $chan
    }
    complete
}

on kick {
    if { [lindex [args] 1]==[my_nick] } {
        echo "[arrows] You [color text]have been kicked off 10[lindex [args] 0][color text] by 10[nick] 14([color text][lrange [join [args]] 2 end]14)" status
        if { $bxset(AUTO_REJOIN) == "ON" } {
            after 1 /join [lindex [args] 0]
        }
    } else {
        echo "[bx] 16[lindex [args] 1] [color text]has been kicked off 10[lindex [args] 0][color text] by 10[nick] 14([color text][lrange [join [args]] 2 end]14)" channel [lindex [args] 0]
    }    
    complete
}

on load {
    global version
    if { $loaded == 0 } {
        set loaded [unixtime]
    }
    echo " " status
    echo "Process \[[random 1 32767]] connected to \[/dev/ttyp0]" status
    echo " " status

    if { $hasansi == 0 } {
        window set_title "$butchxversion: XiRCON [version]" main
        set version "$butchxversion+ by conio - [osversion] (XiRCON [version])"
    } else {
        echo " " status ; echo "   \x1B\[1;37mANSI.TCL-enhanced\x1B\[1;30m:\x1B\[0m $ANSIVERS" status
        window set_title "XiRCON [version]: $butchxversion+$ANSIVERS" main
        set version "$butchxversion+$ANSIVERS by conio - [osversion] (XiRCON [version])"
    }
    eval /bxlogo

    complete
}

on lookup {
    set request [lindex [args] 0]
    set result  [lindex [args] 1]
    if { [string length $result] } {
        echo "[bx] 16ButchX[color text]: Resolved $request to $result"
    } else {
        echo "[bx] 16ButchX[color text]: Could not resolve $request"
    }
    set dnsnick ""
}

on mode {
    if { [nick] == "" } {
        set x [host]
    } else {
        set x [nick]
    }
    echo "[bx] mode14/10[lindex [args] 0] 14\[16[lrange [join [args]] 1 end]14\] [color text]by 16$x" channel [lindex [args] 0]
    complete
}

on nick {
    if { [nick]==[my_nick] } {
        echo "[arrows] You14([color text][nick]14) [color text]are now known as 10[lindex [args] 0]"
    } else {
        foreach chan [string tolower [channels]] { 
            if { [ison [nick] $chan] } {
                echo "[bx] 16[nick] [color text]is now known as 10[lindex [args] 0]" channel $chan
            } 
            complete
        }
    }    
    complete
}

on notice {
    if { [nick]=="" & [user]=="" & [host]=="" } {
        if { [string match  "*Notice -- *" [lrange [join [args]] 1 end]] == 1 } {
            echo "09\[[string range [server] [expr [findprev [server] [expr [string last "." [server]] - 1] "."] + 1] [expr [string last "." [server]] - 1]]\]!03[string range [server] 0 [string first " " [server]]][color text][lrange [join [args]] 4 end]" status
        } else {
            echo "09!03[string range [server] 0 [string first " " [server]]][color text][lrange [join [args]] 2 end]" status
        }
    } elseif { [user]=="" } {
        if { [string match  "*Notice -- *" [lrange [join [args]] 1 end]] == 1 } {
            echo "09\[[string range [server] [expr [findprev [server] [expr [string last "." [server]] - 1] "."] + 1] [expr [string last "." [server]] - 1]]\]!03[string range [server] 0 [string first " " [server]]][color text][lrange [join [args]] 4 end]" status
        } else {
            echo "09!03[string range [server] 0 [string first " " [server]]][color text][lrange [join [args]] 2 end]" status
        }
    } else {
        if { $bxset(MSGLOG) == "ON" && $msglog_file != 0 } {
            puts $msglog_file "\[NOTICES ] \[[clock format [clock seconds] -format "%I:%M%p"]] - [nick] [lindex [args] 1]"
            flush $msglog_file
        }
        echo "14-13[nick]14(06[user]@[host]14)-[color text] [lindex [args] 1]"
    }
    complete
}

on part {
    if { [nick]==[my_nick] } {
        echo "[bx] [nick] 14\[[color text][user]@[host]14\] [color text]has left [args] 14\[\]" status
    } else {
        echo "[bx] [nick] 14\[[color text][user]@[host]14\] [color text]has left [args] 14\[\]" channel [args]
    }
    complete
}

on privmsg {
    set recp [string tolower [lindex [args] 0]]
    set didit 0
    set text [join [lrange [args] 1 end]]
    set dest [string tolower [lindex [args] 0]]
    set x [string index $dest 0]
    if {$x == "&" || $x == "#"} {
        if {[string first [string tolower [my_nick]] [string tolower $text]] >= 0} {
            echo "12<08[nick]12>[color text] $text" channel $dest 
            complete
        } else {
            echo "12<[color text][nick]12>[color text] $text" channel $dest 
            complete
        }
    } else {
        set dest [string tolower [lindex [args] 0]]
        if { $bxset(MSGLOG) == "ON" && $msglog_file != 0 } {
            puts $msglog_file "\[MSGS    ] \[[clock format [clock seconds] -format "%I:%M%p"]] - [nick] $text"
            flush $msglog_file
        }
        if {$dest == [string tolower [my_nick]]} {
            set qnick [string tolower [nick]]
            foreach q [queries] {
                if {$qnick == [string tolower $q]} {
                    echo "14\[13[nick]14(06[user]@[host]14)\][color text] $text" query $q
                    set didit 1
                }
            }
            if { $didit == 0 } { echo "14\[13[nick]14(06[user]@[host]14)\][color text] $text" [window_type] [window_name] }
        }
        complete
    }
}

on quit {
    foreach chan [string tolower [channels]] { 
        if { [ison [nick] $chan] } {
            echo "[bx] SignOff 16[nick][color text]: $chan 14([color text][lrange [join [args]] 0 end]14)" channel $chan
        } 
        complete
    }
}

on timer {
    global idle_time
    incr idle_time

    if { $bxset(AUTO_AWAY) == "ON" && $idle_time == [expr $bxset(AUTO_AWAY_TIME) * 60] && $startaway == 0 && [connected] == 1 } {
        /away Auto-Away after $bxset(AUTO_AWAY_TIME) mins
    } 
    if { $bxset(MSGLOG) == "ON" && $msglog_file != 0 && [clock format [clock seconds] -format "%M:%S"] == "00:00" } {
        puts $msglog_file "\[TimeStamp [timestamp]]"
        flush $msglog_file
    }
    if { [string length $joinqueue] > 0 } {
        after 100 set chan [string range $joinqueue [expr [findprev $joinqueue [string length $joinqueue] " "] + 1] end]
        catch { while { [llength [nicks $chan]] == 0 } { if { [llength [nicks $chan]] != 0 ] } { break } } }
        echo $joinqueue channel $chan
        if { [string length $topicqueue] > 0 } {
            echo $topicqueue channel $chan
            set topicqueue ""
        }
        set joinqueue ""
        /names $chan        
    }
}

on topic {
    if { [lindex [args] 1] == "" } {
        echo "[bx] topic unset by [nick] on [lindex [args] 0]" channel [lindex [args] 0]
    } else {
        echo "[bx] 16[nick][color text] has changed the topic on channel [lindex [args] 0] to14: [color text][lrange [join [args]] 1 end]" channel [lindex [args] 0]
    }
    complete
}

on whois {
    set nick [string tolower [nick]]
    set i [lsearch $dns_nicks $nick]
    while { $i > -1 } {
        lookup [host]
        set dns_nicks [lreplace $dns_nicks $i $i]
        set i [lsearch $dns_nicks $nick]
    }
}

on unload {
    window set_title "" main
    if { $msglog_file != 0 } {
        puts $msglog_file "MsgLog ended \[[timestamp]]"
        close $msglog_file
    }
    if { $startaway != 0 } {
        set startaway 0
    }
    complete
}







################################################### ##  #
#
#   RPL Numerical Events
#__________________________________________________ __  _


on 001 {
    echo "[bx] [lrange [join [args]] 1 end]" status
    complete
}

on 002 {
    echo "[bx] [lrange [join [args]] 1 end]" status
    complete
}

on 003 {
    echo "[bx] [lrange [join [args]] 1 end]" status
    complete
} 

on 004 {
    echo "[bx] [lrange [join [args]] 1 end]" status
    complete
}

on 221 {
    echo "[bx] Mode change 14\[16[lindex [args] 1]14\][color text] for user 10[my_nick]"
    complete
}

on 251 {
    echo "[bx] [lrange [join [args]] 1 end]" status
    complete
}

on 265 {
    set what [lindex [args] 1]
    set local [string range $what [expr [string first ":" $what] + 2] [expr [string first "M" $what] - 3]]
    echo "[bx] 14\[[color text]local users on irc14(16$local14)]" status
    complete
} 

on 305 {
    echo "[bx] You are no longer marked as being away"
    complete
}

on 306 {
    global msglog_file
    echo "[bx] You have been marked as being away"
    if { $bxset(MSGLOG) == "ON" } {
        if { ![catch { set msglog_file [open $bxset(MSGLOG_FILE) "a+"] }] } {
            echo "[bx] 16ButchX[color text]: Now logging messages to: $bxset(MSGLOG_FILE)"
            puts $msglog_file "MsgLog started \[[timestamp]]"
            flush $msglog_file
        } else {
            echo "[bx] 16ButchX[color text]: Could not open $bxset(MSGLOG_FILE) for writing"
            set msglog_file 0
        }
    }
    complete
}

on 329 {
    global tcl_precision
    set tcl_precision 3

    if { [lindex [args] 2] < 1000000 } {
        echo "[bx] ButchX[color text]: [lindex [args] 1] has an invalid timestamp; corrected"
        set synctime [expr ([expr [clock clicks] - $jointime] + 0.000) / 1000.000]
        echo "[bx] 16ButchX[color text]: Join to [lindex [args] 1] was synced in $synctime secs!!" channel [lindex [args] 1]
        complete
    } else {
        echo "[bx] Channel [lindex [args] 1] was created at [join [clock format [lindex [args] 2]]]" channel [lindex [args] 1]
        set synctime [expr ([expr [clock clicks] - $jointime] + 0.000) / 1000.000]
        echo "[bx] 16ButchX[color text]: Join to [lindex [args] 1] was synced in $synctime secs!!" channel [lindex [args] 1]
        complete
    }
}

on 332 {
    set topicqueue "[bx] Topic for 10[lindex [args] 1]14: [color text][lindex [args] 2]"
    complete
}

on 333 {
    append topicqueue "\n[bx] topic set by 10[lindex [args] 2] 14\[10[join [clock format [lindex [args] 3]]]14\]"
    complete
}

on 341 {
    complete
}

on 369 {
    complete
}

on 372 {
    complete
}

on 375 {
    complete
}

on 376 {
    complete
}

on 401 {
    set nick [lindex [args] 1]
    set i [lsearch $dns_nicks $nick]
    while { $i > -1 } {
        set dns_nicks [lreplace $dns_nicks $i $i]
        set i [lsearch $dns_nicks $nick]
    }
}

on 401 {
    echo "16[lindex [args] 1]14: [color text]No such nick/channel"
    complete
}

on 404 {
    echo "[bx] [lindex [args] 1]  Cannot send to channel"
    complete
}

on 406 {
    echo "[bx] [lindex [args] 1]  There was no such nickname"
    complete
}

on 421 {
    echo "[bx] 16ButchX[color text]: Unknown command: [lindex [args] 1]"
    complete
}


on 432 {
    echo "[bx] 16ButchX[color text]: Nickname specified is illegal."
    complete
}

on 433 {
    global nickinuse
    set nickinuse [lindex [args] 1]
    echo "[bx] $nickinuse  Nickname is already in use."
    /raw WHOIS $nickinuse
    complete
}

on 471 {
    echo "[bx] \[[lindex [args] 1]] Channel is full"
    complete
}

on 473 {
    echo "[bx] \[[lindex [args] 1]] Invite only channel"
    complete
}

on 475 {
    echo "[bx] \[[lindex [args] 1]] Bad channel key"
    complete
}

on 482 {
    echo "[bx] You're not opped on [lindex [args] 1]"
    complete
}

on 481 {
    echo "[bx] [lrange [join [args]] 1 end]"
    complete
}




################################################### ##  #
#
#   WHOIS Events
#__________________________________________________ __  _


on 311 {
    global nickinuse
    global dnsnick
    if { $nickinuse == "+" } {
        set nickinuse ""
    }
    if { [string length $nickinuse] != 0 } {
        echo "[bx] Your nick 04\[[color text]$nickinuse4\][color text] is owned by 16[lindex [args] 2]@[lindex [args] 3]"
        set nickinuse "+"
        complete
    }
    if { $dnsnick == [string tolower [lindex [args] 1]] } {
        set dnsnick ""
        set nickinuse "+"
        complete
    }
    if { $nickinuse != "+" } {
        echo "[greenline]"
        echo "9[p] 16[lindex [args] 1] 14([color text][lindex [args] 2]@[lindex [args] 3]14)"
        echo "9[l] 16i[color text]rcname  : [lindex [args] 5]"
    }
    complete
}

on 314 {
    echo "[greenline]"
    echo "9[p] 16[lindex [args] 1] [color text]was 14([color text][lindex [args] 2]@[lindex [args] 3]14)"
    echo "9[l] 16i[color text]rcname  : [lindex [args] 5]"
    complete
}

on 319 {
    global nickinuse
    if { $nickinuse != "+" } {
        echo "3[p] 16c[color text]hannels : [lindex [args] 2]"
    }
    complete
}

on 312 {
    global nickinuse
    if { $nickinuse != "+" } {
        echo "14[l] 16s[color text]erver   : [lindex [args] 2] ([lrange [join [args]] 3 end])"
    }
    complete
}

on 301 {
    global nickinuse
    if { $nickinuse != "+" } {
        echo "14[p] 16a[color text]way     : [lindex [args] 2]"
    }
    complete
}

on 313 {
    global nickinuse
    if { $nickinuse != "+" } {
        echo "14[p] 16o[color text]perator : [lindex [args] 1]  (is 16NOT[color text] an IRC warrior)"
    }
    complete
}

on 317 {
    global nickinuse
    if { $nickinuse != "+" } {
        echo "14: 16i[color text]dle     : [expr [lindex [args] 2] / 3600] hours [expr [expr [lindex [args] 2] / 60] % 60] minutes [expr [lindex [args] 2] % 60] seconds (signon: [join [clock format [lindex [args] 3]]])"
    }
    complete
}






################################################### ##  #
#
#   Hotkeys
#__________________________________________________ __  _


hotkey control+k {
    global invited
    if { $invited != "" } {
        /join $invited
        set invited ""
        complete
    }
}

hotkey escape {
    global invited
    if { $invited != "" } {
        set invited ""
        complete
        echo "[bx] Invite hotkey unset"
    }
}

hotkey space {
    if { $bxset(FIX_MISTAKES) == "ON" } {
        set pos [input get_sel_start]
        set txt [string range [input get_text] 0 $pos]
        set all [input get_text]
        set words [lsort [array names bxfix]]
        foreach x $words {
            if { [string match "$x" $txt] || [string match "* $x" $txt] } {
                set w [string last "$x" $txt]
                input set_text "[string range $all 0 [expr $w - 1]]$bxfix($x)[string range $all [expr $w + [string length $x]] end]"
                set pos [string length "[string range $all 0 [expr $w - 1]]$bxfix($x) "]
            }
        }
        input set_sel_start $pos
        input set_sel_length 0
    }
}

hotkey tab {
    if { $bxset(TAB) == "ON" } {
        set pos [input get_sel_start]
        set txt [input get_text]
        input set_text [string range $txt 0 [expr $pos - 1]][format "%-$bxset(TAB_SPACES)s" " "][string range $txt $pos end]
        input set_sel_start [expr $pos + $bxset(TAB_SPACES)]
        input set_sel_length 0
        complete
        return
    }
}







################################################### ##  #
#
#   Procs
#__________________________________________________ __  _


proc arg { } {
    return [join [args]]
}

proc arrows { } {
    return "14>15>16>"
}

proc bx { } {
    global bxset
    if { $bxset(ANSI_FONT) == "ON" } {
        return "4164[color text]"
    } else {
        return "4164[color text]"
    }
}

proc e { } {
    global bxset
    if { $bxset(ANSI_FONT) == "ON" } {
        return ""
    } else {
        return ""
    }
}

proc echo { args } {
    global hasansi
    global bxset
    global echobuffer
    set text [lindex $args 0]

    if { $bxset(TAB) == "ON" } {
        regsub -all -nocase "\t" $text [format "%-$bxset(TAB_SPACES)s" " "] text
    }

    if { $bxset(REMOVE_HYPERLINKS) == "ON" } {
        regsub -all -nocase "ftp." $text "ftp." text
        regsub -all -nocase "www." $text "www." text
        regsub -all -nocase "://" $text "://" text
    }

    if { [lindex [args] 1] != "query" && [lindex [args] 2] != ".(butchx-paste)." } {
        if { $hasansi == 1 } {
            set text [ansitomirc $text]
        }
        realecho $text [lindex $args 1] [lindex $args 2]
    }

}

proc findnext { string start lookfor } {
    set m [string first $lookfor $string]

    if { $m < $start } {
        for { set x $start } { $x < [string length $string] } { incr x } {
            if { [string index $string $x] == $lookfor } {
                return $x
                complete
            }
        }
    } else {
        return $m
    }
}

proc findprev { string start lookfor } {
    set m [string last $lookfor $string]

    if { $m > $start } {
        for { set x $start } { $x >= 0 } { set x [expr $x-1] } {
            if { [string index $string $x] == $lookfor } {
                return $x
                complete
            }
        }
    } else {
        return $m
    }
}

proc float2intstr {fl} {
    return [format "%.0f" $fl]
}

proc float2ip {float} {
    global tcl_precision
    set tcl_precision 17

    set p0 [expr pow(256, 0)]
    set p1 [expr pow(256, 1)]
    set p2 [expr pow(256, 2)]
    set p3 [expr pow(256, 3)]

    set a [expr int($float / $p3)]
    set tmp [expr $float - ($a * $p3)]
    set b [expr int($tmp / $p2)]
    set tmp [expr $tmp - ($b * $p2)]
    set c [expr int($tmp / $p1)]
    set tmp [expr $tmp - ($c * $p1)]
    set d [expr int($tmp / $p0)]
    return "$a.$b.$c.$d"
}

proc getvar { varname default } {
    set x [get_cookie [string toupper $varname]]
    if { $x == "" } { 
        set_cookie [string toupper $varname] $default
        set x $default
    }
    return $x
}

proc greenline { } {
    global bxset
    if { $bxset(ANSI_FONT) == "ON" } {
        return "9---3--93-93----14-314-314--- --  -"
    } else {
        return "9.---3--93-93----14-314-314--- --  -"
    }
}

proc intstr2float { str } {
    if {![regexp {\.} $str]} {
        set str "${str}.0"
    }
    return [expr double("$str")]
}

proc ilsearch {list item} { 
    set idx 0
    foreach i $list {
        if {[sCompare $item $i]} {
            return $idx
        }
        incr idx
    }
    return -1
} 

proc ip2float {ip} {
    regexp {([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+)} $ip a i3 i2 i1 i0
    set total [expr double($i3) * pow(256,3)]
    set total [expr $total + double($i2) * pow(256,2)]
    set total [expr $total + double($i1) * pow(256,1)]
    set total [expr $total + double($i0) * pow(256,0)]
    return $total
}

proc isnum { x } {
    if { ![catch { expr $x / 1 }] } {
        return 1
    } else {
        return 0
    }
}

proc ison { nick chan } {
    foreach i [nicks $chan] {
        if ![stricmp $nick [normalizenick $i]] {
            return 1
        }
    }
    return 0
}

proc newl { } {
    return "\n           "
}

proc nickcomplete { text } {
    global bxset
    set nicklist ""
    set newnl ""
    set returnvalue ""

    if { $bxset(NICK_COMPLETION) == "ON" } {
        if { [channel] != "" } {
            foreach x [nicks [channel]] {
                lappend nicklist [normalizenick $x]
            }
        } elseif { [query] != "" } {
            set nicklist [list [query]]
        }
        if { [llength $nicklist] != 0 } {
            set firstword [string range $text 1 [expr [string first " " $text] - 1]]
            set colon [string first ":" $text]
            if { $colon != -1  && [string range $text 0 [expr $colon - 1]] != "" } {
                set nick [string tolower [string range $text 0 [expr $colon - 1]]]
                set index [ilsearch $nicklist "$nick*"]
                if { $index != -1 } {
                    set returnvalue "[lindex $nicklist $index]:[string range $text [expr $colon + 1] end]"
                }
            }
        }
    }

    if { $returnvalue != "" } {
        return $returnvalue
    } else {
        return $text
    }
}

proc normalizenick { nick } {
    return [string trimleft $nick "@+"]
}

proc osversion { } {
    global tcl_platform
    set x $tcl_platform(os)
    set y $tcl_platform(osVersion)
    if { $x == "Windows 95" && $y == 4 } {
        return "Windows 95"
    } elseif { $x == "Windows 95" && $y == 4.1 } {
        return "Windows 98"
    } else {
        return "Windows NT $y"
    }
}

proc p { } {
    global bxset
    if { $bxset(ANSI_FONT) == "ON" } {
        return "|"
    } else {
        return ""
    }
}

proc l { } {
    global bxset
    if { $bxset(ANSI_FONT) == "ON" } {
        return ""
    } else {
        return "|"
    }
}

proc sCompare { a b } {
    return [string match [string tolower $a] [string tolower $b]]
}

proc stricmp { s1 s2 } {
    return [string compare [string tolower $s1] [string tolower $s2]]
}

proc timestamp { } {
    return [join [clock format [clock seconds]]]
}

proc unixtime { } {
    return [clock seconds]
}





################################################### ##  #
#
#   Help
#__________________________________________________ __  _


set bxhelp(ABOUT)  "- Shows information about your ButchX version"
set bxhelp(AME)    "<action>[newl]- Sends an action to every channel you're on"
set bxhelp(AWAY)   "4\[[color text]reason4][color text][newl]- Sets you away on server with 4\[[color text]reason4]"
set bxhelp(BACK)   "- Sets you back from being away"
set bxhelp(BXLOGO) "4\[[color text]logo4][color text][newl]- Displays a certain ButchX logo in the status[newl]  window if 4\[[color text]logo4][color text], else displays a random logo"
set bxhelp(CTCP)   "8<11nick8> <[color text]request8>[color text][newl]- CTCP sends 8<11nick8>[color text] with 8<[color text]request8>"
set bxhelp(DNS)    "8DNS<[color text]nick|hostname8>[color text][newl]- Attempts to nslookup on nick or hostname"
set bxhelp(INVITE) "8<11nick8> 4\[[color text]channel4][color text][newl]- Invites 8<11nick8>[color text] to current channel or 4\[[color text]channel4]"
set bxhelp(ME)     "<action>[newl]- Sends an action to the current channel"
set bxhelp(MSG)    "8<11nick8> 8<[color text]text8>[color text][newl]- Sends 8<11nick8>[color text] a message with 8<[color text]text8>"
set bxhelp(NAMES)  "4\[[color text]channel4][color text][newl]- Shows names on current channel or 4\[[color text]channel4]"
set bxhelp(NOTICE) "8<11nick|channel8> 8<[color text]text8>[color text][newl]- Sends a notice to 8<11nick|channel8>[color text] with 8<[color text]text8>"
set bxhelp(SV)     "4\[[color text]nick|channel4][color text][newl]- Show client version information"






################################################### ##  #
#
#   ButchX /set Variables
#__________________________________________________ __  _


set bxset(ANSI_FONT)            [getvar ANSI_FONT ON]                       ; set stype(ANSI_FONT)              "1"
set bxset(AUTO_AWAY)            [getvar AUTO_AWAY ON]                       ; set stype(AUTO_AWAY)              "1"
set bxset(AUTO_AWAY_TIME)       [getvar AUTO_AWAY_TIME 10]                  ; set stype(AUTO_AWAY_TIME)         "2"
set bxset(AUTO_REJOIN)          [getvar AUTO_REJOIN ON]                     ; set stype(AUTO_REJOIN)            "1"
set bxset(CHANNEL_NAME_COLS)    [getvar CHANNEL_NAME_COLS 4]                ; set stype(CHANNEL_NAME_COLS)      "4"
set bxset(CHANNEL_NAME_WIDTH)   [getvar CHANNEL_NAME_WIDTH 10]              ; set stype(CHANNEL_NAME_WIDTH)     "2"
set bxset(CLOAK)                [getvar CLOAK OFF]                          ; set stype(CLOAK)                  "1"
set bxset(DEFAULT_AWAY_MESSAGE) [getvar DEFAULT_AWAY_MESSAGE "away"]        ; set stype(DEFAULT_AWAY_MESSAGE)   "3"
set bxset(DEFAULT_REASON)       [getvar DEFAULT_REASON "ButchX-BaBy!"]      ; set stype(DEFAULT_REASON)         "3"
set bxset(EXPERIMENTAL_RPLS)    [getvar EXPERIMENTAL_RPLS OFF]              ; set stype(EXPERIMENTAL_RPLS)      "1"
set bxset(FIX_MISTAKES)         [getvar FIX_MISTAKES ON]                    ; set stype(FIX_MISTAKES)           "1"
set bxset(FIX_MISTAKES_FILE)    [getvar FIX_MISTAKES_FILE "ButchX.fix"]     ; set stype(FIX_MISTAKES_FILE)      "3"
set bxset(MINIMIZE_ON_AWAY)     [getvar MINIMIZE_ON_AWAY OFF]               ; set stype(MINIMIZE_ON_AWAY)       "1"
set bxset(MSGLOG)               [getvar MSGLOG ON]                          ; set stype(MSGLOG)                 "1"
set bxset(MSGLOG_FILE)          [getvar MSGLOG_FILE "ButchX.away"]          ; set stype(MSGLOG_FILE)            "3"
set bxset(NICK_COMPLETION)      [getvar NICK_COMPLETION ON]                 ; set stype(NICK_COMPLETION)        "1"
set bxset(NEW_STYLE_ACTION)     [getvar NEW_STYLE_ACTION OFF]               ; set stype(NEW_STYLE_ACTION)       "1"
set bxset(REMOVE_HYPERLINKS)    [getvar REMOVE_HYPERLINKS OFF]              ; set stype(REMOVE_HYPERLINKS)      "1"
set bxset(SHOW_EXTENDED_CTCP)   [getvar SHOW_EXTENDED_CTCP OFF]             ; set stype(SHOW_EXTENDED_CTCP)     "1"
set bxset(SPLIT_DETECTION)      [getvar SPLIT_DETECTION ON]                 ; set stype(SPLIT_DETECTION)        "1"
set bxset(TAB)                  [getvar TAB ON]                             ; set stype(TAB)                    "1"
set bxset(TAB_SPACES)           [getvar TAB_SPACES 4]                       ; set stype(TAB_SPACES)             "4"








################################################### ##  #
#
#   FIX_MISTAKES
#__________________________________________________ __  _


if { ![catch { set fixfile [open $bxset(FIX_MISTAKES_FILE) r] }] } {
    while { ![eof $fixfile] } {
        set line [gets $fixfile]
        if { [string match "*?=?*" $line] } {
            set e [string first "=" $line]
            set x [string trim [string range $line 0 [expr $e - 1]]]
            set y [string trim [string range $line [expr $e + 1] end]]
            set bxfix($x) $y
        }
    }
}




################################################### ##  #
#
#   Experimental Automatic RPL Parsing
#__________________________________________________ __  _


if { $bxset(EXPERIMENTAL_RPLS) == "ON" } {
    foreach z $nums {
        on $z {
            echo "[bx] [lrange [join [args]] 1 end]"
            complete
        }
    }
} else {
    foreach z $nums {
        on $z {
            complete
        }
    }
}

