;==============================================================================
; ALIVE AND KICKING
; SKELETON Version 3.0
; Copyright 2000 Wayne J. Radburn
;
; Assembles with Microsoft MASM v6.14.8444 as follows:
;    ML /c /coff Alive.asm
;
; Links with Microsoft LINK v5.12.8181 as follows:
;    LINK /SUBSYSTEM:WINDOWS /ENTRY:Main Alive.obj AliveRC.obj
;
; See Alive.rc for how to create AliveRC.obj
;==============================================================================

	.586			;32-Bit when .586 before .MODEL
	.MODEL	FLAT, STDCALL
	OPTION	CASEMAP:NONE

	INCLUDE Kernel32.inc
	INCLUDE	User32.inc
	INCLUDE	Gdi32.inc
	INCLUDE	ComDlg32.inc
	INCLUDE	ComCtl32.inc
	INCLUDE	AdvApi32.inc
	INCLUDE	htmlhelp.inc

;;
;;	RESOURCE IDs
;;

IDI_ICON	EQU	01h
IDB_TOOLBAR	EQU	01h
IDM_MENU	EQU	01h
IDA_ACCEL	EQU	01h
IDD_ABOUT	EQU	01h

IDM_FILEMENU	EQU	20h
IDM_VIEWMENU	EQU	21h
IDM_HELPMENU	EQU	22h

IDM_OPEN	EQU	23h
IDM_CLOSE	EQU	24h
IDM_EXIT	EQU	25h

IDM_TOOLBAR	EQU	26h
IDM_STATUSBAR	EQU	27h
IDM_TREEVIEW	EQU	28h
IDM_SPLIT	EQU	29h
IDM_FONT	EQU	2Ah

IDM_HELPTOPICS	EQU	2Bh
IDM_ABOUT	EQU	2Ch

;;
;;	WINDOW IDs
;;

ID_TOOLBAR	EQU	0F0h
ID_STATUSBAR	EQU	0F1h
ID_TREEVIEW	EQU	0F2h
ID_VIEW		EQU	0F3h

;;
;;	MAIN THREAD, WINDOW, and MESSAGE LOOP
;;

	.CODE
Main	PROC
;Initialize the Main window
	call	MainINIT	;returns exit code in EAX

	test	eax,eax		;Z to continue
	jnz	Exit		;NZ to exit

;Process queued messages until WM_QUIT is received
	call	MsgLOOP		;returns exit code in EAX

;End this process and all its threads
Exit:
	push	eax			;nExitCode
	call	[ExitProcess]		;KERNEL

	ret
Main	ENDP

	ALIGN	4
MsgLOOP	PROC
	push	ebp
	sub	esp,SIZEOF(MSG)	;LOCAL EBP=OFFSET msg
	mov	ebp,esp
	jmp	Retrieve

;Dispatch the message to a window procedure
Dispatch:
	push	ebp			;pMsg
	push	[hAccel]		;hAccTable
	push	[hwndMain]		;hWnd
	call	[TranslateAccelerator]	;USER

	test	eax,eax
	jnz	Retrieve	;NZ if already translated and processed

	push	ebp			;pMsg
	call	[TranslateMessage]	;USER

	push	ebp			;pMsg
	call	[DispatchMessage]	;USER

;Retrieve a message from the thread message queue
Retrieve:
	push	0			;wMsgFilterMax
	push	0			;wMsgFilterMin
	push	0			;hWnd
	push	ebp			;pMsg
	call	[GetMessage]		;USER

	cmp	eax,-1
	je	Exit		;E if error so exit

	test	eax,eax		;EAX=0 if WM_QUIT
	jnz	Dispatch	;NZ if other message retrieved so process it

	mov	eax,[ebp+MSG.wParam]	;return ExitCode
Exit:
	add	esp,SIZEOF(MSG)	;LOCAL msg removed
	pop	ebp
	ret
MsgLOOP	ENDP

;;
;;	MAIN WINDOW MESSAGES
;;

       	.CONST
MainMsg	DWORD	WM_NOTIFY, WM_COMMAND, WM_MENUSELECT,
		WM_SIZING, WM_ENTERSIZEMOVE, WM_WINDOWPOSCHANGED,
		WM_MOUSEMOVE, WM_LBUTTONDOWN, WM_LBUTTONUP, WM_RBUTTONDOWN,
		WM_KEYDOWN, WM_CANCELMODE,
		WM_ERASEBKGND, WM_ACTIVATE,
		WM_CREATE, WM_CLOSE, WM_DESTROY,
		WM_SYSCOLORCHANGE, WM_SETTINGCHANGE
	DWORD	MainWM_NOTIFY, MainWM_COMMAND, MainWM_MENUSELECT,
		MainWM_SIZING, MainWM_ENTERSIZEMOVE, MainWM_WINDOWPOSCHANGED,
		MainWM_MOUSEMOVE, MainWM_LBUTTONDOWN, MainWM_LBUTTONUP, MainWM_RBUTTONDOWN,
		MainWM_KEYDOWN, MainWM_CANCELMODE,
		MainWM_ERASEBKGND, MainWM_ACTIVATE,
		MainWM_CREATE, MainWM_CLOSE, MainWM_DESTROY,
		MainWM_SYSCOLORCHANGE, MainWM_SETTINGCHANGE

;Equates used to simplify references to window procedure parameters
lParam 	TEXTEQU	<ebp+14h>
wParam 	TEXTEQU	<ebp+10h>
uMsg   	TEXTEQU	<ebp+0Ch>
hWnd   	TEXTEQU	<ebp+08h>

	.CODE
MainWND	PROC
	push	ebp
	mov	ebp,esp	;hWnd=EBP+08h, uMsg=EBP+0Ch, wParam=EBP+10h, lParam=EBP+14h

	push	ebx
	push	esi
	push	edi

;IF message is not found
	mov	eax,[uMsg]
	mov	edi,OFFSET MainMsg
	mov	ecx,LENGTHOF MainMsg
	repne scasd
	je	Process

;THEN let DefWindowProc handle this message
Default:
	push	[lParam]		;lParam
	push	[wParam]		;wParam
	push	[uMsg]			;Msg
	push	[hWnd]			;hWnd
	call	[DefWindowProc]		;USER

	jmp	Return

;ELSE process this message possibly setting carry flag for default processing
	ALIGN 4
Process:
	call	DWORD PTR [edi+(SIZEOF MainMsg-4)]
	jc	Default
Return:
	pop	edi
	pop	esi
	pop	ebx

	mov	esp,ebp
	pop	ebp
	ret	10h
MainWND	ENDP

;;
;;	MAIN WINDOW NOTIFICATION MESSAGES
;;

	.CONST
MainNtf	DWORD	TVN_KEYDOWN, NM_SETFOCUS, TTN_GETDISPINFO
	DWORD	TVNKeyDown, NMSetFocus, TTNGetDispInfo

	.CODE
MainWM_NOTIFY PROC
;IF message is not found
	mov	ebx,[lParam]	;lParam=pNMHDR
	mov	edi,OFFSET   MainNtf
	mov	ecx,LENGTHOF MainNtf
	mov	eax,[ebx+NMHDR.code]
	repne	scasd
	je	Process

;THEN let DefWindowProc handle this message
	stc		;set carry flag for default processing
	jmp	Return

;ELSE process this message possibly setting carry flag for default processing
Process:
	call	DWORD PTR [edi+(SIZEOF MainNtf-4)]
Return:
 	ret
MainWM_NOTIFY ENDP

;;
;;	MAIN WINDOW MENU COMMANDS
;;

	.CONST
MainCmd	DWORD	IDM_OPEN, IDM_CLOSE, IDM_EXIT,
		IDM_TOOLBAR, IDM_STATUSBAR, IDM_TREEVIEW, IDM_SPLIT,
		IDM_FONT,
		IDM_HELPTOPICS, IDM_ABOUT
	DWORD	FileOPEN, FileCLOSE, MainWM_CLOSE,
		ViewTB, ViewSB, ViewTV, SplitCMD,
		ViewFONT,
		HelpTOPICS, HelpABOUT

	.CODE
MainWM_COMMAND PROC
;IF message is not found
	mov	eax,[wParam]	;LOWORD(wParam)=ID
	mov	edi,OFFSET   MainCmd
	mov	ecx,LENGTHOF MainCmd
	and	eax,0FFFFh
	repne	scasd
	je	Process

;THEN let DefWindowProc handle this message
	stc		;set carry flag for default processing
	jmp	Return

;ELSE process this message possibly setting carry flag for default processing
Process:
	call	DWORD PTR [edi+(SIZEOF MainCmd-4)]
Return:
 	ret
MainWM_COMMAND ENDP

;;
;;	MAIN WINDOW CREATION
;;

	.CONST
szMainClass	BYTE	"Main",0,0,0,0
szToolBar	BYTE	"ToolBarWindow32",0
szTreeView	BYTE	"SysTreeView32",0,0,0

	.DATA
;Bits for view options TV SB TB
fOptions	DWORD	0111b

miiTB	MENUITEMINFO <SIZEOF(MENUITEMINFO),MIIM_STATE,,MFS_CHECKED,IDM_TOOLBAR,>
miiSB	MENUITEMINFO <SIZEOF(MENUITEMINFO),MIIM_STATE,,MFS_CHECKED,IDM_STATUSBAR,>
miiTV	MENUITEMINFO <SIZEOF(MENUITEMINFO),MIIM_STATE,,MFS_CHECKED,IDM_TREEVIEW,>
miiS	MENUITEMINFO <SIZEOF(MENUITEMINFO),MIIM_STATE,,MFS_ENABLED,IDM_SPLIT,>

tbButtons	TBBUTTON <0, IDM_OPEN, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0>

	.DATA?
hInst		HINSTANCE ?
hwndMain	HWND	?
hMenu		HMENU	?
hCursor		HCURSOR	?
hAccel		HACCEL	?

hToolBar	HWND	?
hStatusBar	HWND	?
hTreeView	HWND	?

	.CODE
MainINIT PROC
;Make sure only one instance of this application is running
	call	MainINSTANCE

	test	eax,eax
	jz	Error

;Get system info
	call	MainSETTING

;Get saved settings from the Registry
	call	RegGET

;Get module handle for this process
	push	0			;pModuleName
	call	[GetModuleHandle]	;KERNEL

	test	eax,eax
	jz	Error

	mov	[hInst],eax
	mov	ebx,eax		;EBX=hInst

;Initialize Common Controls
	sub	esp,SIZEOF(INITCOMMONCONTROLSEX)	;LOCAL ESP=OFFSET iccex

	mov	[esp+INITCOMMONCONTROLSEX.dwSize],SIZEOF(INITCOMMONCONTROLSEX)
	mov	[esp+INITCOMMONCONTROLSEX.dwICC],ICC_TREEVIEW_CLASSES OR ICC_BAR_CLASSES

	push	esp			;pInitCtrls
	call	[InitCommonControlsEx]	;COMCTL

	add	esp,SIZEOF(INITCOMMONCONTROLSEX)	;LOCAL iccex removed

;Register the Main window class
	sub	esp,SIZEOF(WNDCLASSEX)	;LOCAL ESP=OFFSET wcex

	xor	eax,eax		;EAX=0
	mov	[esp+WNDCLASSEX.cbSize],SIZEOF(WNDCLASSEX)
	mov	[esp+WNDCLASSEX.style],eax
	mov	[esp+WNDCLASSEX.lpfnWndProc],OFFSET MainWND
	mov	[esp+WNDCLASSEX.cbClsExtra],eax
	mov	[esp+WNDCLASSEX.cbWndExtra],eax
	mov	[esp+WNDCLASSEX.hInstance],ebx

	push	0			;fuLoad
	push	32			;cyDesired
	push	32			;cxDesired
	push	IMAGE_ICON		;uType
	push	IDI_ICON		;pszName - image identifier
	push	ebx			;hinst
	call	[LoadImage]		;USER

	mov	[esp+WNDCLASSEX.hIcon],eax

	push	LR_DEFAULTSIZE OR LR_SHARED	;fuLoad
	push	0			;cyDesired - uses default
	push	0			;cxDesired - uses default
	push	IMAGE_CURSOR		;uType
	push	OCR_SIZEWE		;pszName - image identifier
	push	0			;hinst - OEM image
	call	[LoadImage]		;USER

	mov	[esp+WNDCLASSEX.hCursor],eax
	mov	[hCursor],eax

	mov	[esp+WNDCLASSEX.hbrBackground],0	;paint own background
	mov	[esp+WNDCLASSEX.lpszMenuName],IDM_MENU
	mov	[esp+WNDCLASSEX.lpszClassName],OFFSET szMainClass

	push	0			;fuLoad
	push	16			;cyDesired
	push	16			;cxDesired
	push	IMAGE_ICON		;uType
	push	IDI_ICON		;pszName - image identifier
	push	ebx			;hinst
	call	[LoadImage]		;USER

	mov	[esp+WNDCLASSEX.hIconSm],eax

	push	esp			;pwcx
	call	[RegisterClassEx]	;USER

	add	esp,SIZEOF(WNDCLASSEX)	;LOCAL wcex removed

	test	eax,eax
	jz	Error

;Create the Main window
	xor	eax,eax		;EAX=0

	push	eax			;pParam
	push	ebx			;hInstance
	push	eax			;hMenu - NULL, use class menu
	push	eax			;hWndParent
	push	eax			;nHeight
	push	eax			;nWidth
	push	eax			;y
	push	eax			;x
	push	WS_OVERLAPPEDWINDOW	;dwStyle
	push	eax			;pWindowName
	push	OFFSET szMainClass	;pClassName
	push	eax			;dwExStyle
	call	[CreateWindowEx]	;USER

	test 	eax,eax		;EAX=hwndMain
	jz	Error

;Set the Main window placement
	mov	esi,OFFSET wpMain
	mov	edi,eax		;EDI=hwndMain
	mov	eax,[esi+WINDOWPLACEMENT.showCmd]
	mov	edx,SW_SHOWNORMAL
	cmp	eax,SW_SHOWMINIMIZED	;do not open minimized
	jne	@F

	mov	[esi+WINDOWPLACEMENT.showCmd],edx
@@:
	push	esi			;pWINDOWPLACEMENT
	push	edi			;hWnd
	call	[SetWindowPlacement]	;USER

;Update the Main window
	push	edi			;hWnd
	call	[UpdateWindow]		;USER

;Set the text for the Main window title bar
	call	FileINIT

	xor	eax,eax		;return 0 to continue
Return:
	ret
Error:
	inc	eax		;return non-zero exit code
	jmp	Return
MainINIT ENDP

	ALIGN 4
MainINSTANCE PROC
;IF a Semaphore can be created for the first instance
	push	OFFSET szTitle		;pName
	push	1			;MaximumCount
	push	0			;MinimumCount
	push	0			;pSemaphoreAttributes
	call	[CreateSemaphore]	;KERNEL

	mov	edi,eax		;EDI=hSemaphore

	call	[GetLastError]		;KERNEL

	cmp	eax,ERROR_ALREADY_EXISTS
	je	Exists

	cmp	eax,ERROR_SUCCESS
	jne	Find		;NE if CreateSemaphore failed so find other instance

;THEN continue
	xor	eax,eax
	inc	eax		;return non-zero to continue
	jmp	Return

;ELSE the Semaphore already exists so close its handle
Exists:
	push	edi			;hObject
	call	[CloseHandle]		;KERNEL

;THEN try to find another instance already running
Find:
	push	0			;pWindowName
	push	OFFSET szMainClass	;pClassName
	call	[FindWindow]		;USER

	test	eax,eax
	jz	Return		;return 0 to exit

	push	eax			;hWnd
	call	[GetLastActivePopup]	;USER

	mov	esi,eax		;ESI=hMainWnd or hPopupWnd

;IF the window is minimized
	push	esi			;hWnd
	call	[IsIconic]		;USER

	test	eax,eax
	jz	Activate	;Z if not minimized

;THEN restore window to its normal placement
	push	SW_RESTORE		;nCmdShow
	push	esi			;hWnd
	call	[ShowWindow]		;USER

	jmp	Return0		;return 0 to exit

;ELSE activate the window and bring it to the foreground
Activate:
	push	esi			;hWnd
	call	[SetForegroundWindow]	;USER
Return0:
	xor	eax,eax		;return 0 to exit
Return:
	ret
MainINSTANCE ENDP

	ALIGN 4
MainWM_CREATE PROC
;Get handle to Main window and save it
	mov	esi,[hWnd]	;ESI=hwndMain
	mov	ebx,[hInst]	;EBX=hInst
	mov	[hwndMain],esi

;Load Accelerators
	push	IDA_ACCEL		;pTableName - resource identifier
	push	ebx			;hInstance
	call	[LoadAccelerators]	;USER

	test	eax,eax
	jz	Error

	mov	[hAccel],eax

;Get handle to Main menu and save it
	push	esi			;hWnd
	call	[GetMenu]		;USER

	test	eax,eax
	jz	Error

	mov	[hMenu],eax
	mov	edi,eax		;EDI=hMenu

;Create the ToolBar window and update its menu item info
	mov	eax,MFS_UNCHECKED	;hidden state
	mov	ecx,WS_CHILD OR TBSTYLE_TOOLTIPS OR TBSTYLE_FLAT
	test	[fOptions],1		;ToolBar bit
	jz	@F

	mov	eax,MFS_CHECKED		;visible state
	or	ecx,WS_VISIBLE		;visible style adjustment
@@:
	mov	[miiTB.fState],eax
	xor	eax,eax		;EAX=0

	push	eax			;pParam
	push	ebx			;hInstance
	push	ID_TOOLBAR		;hMenu - window identifier
	push	esi			;hWndParent
	push	eax			;nHeight
	push	eax			;nWidth
	push	eax			;y
	push	eax			;x
	push	ecx			;dwStyle
	push	eax			;pWindowName
	push	OFFSET szToolBar	;pClassName
	push	eax			;dwExStyle
	call	[CreateWindowEx]	;USER

	test	eax,eax
	jz	Error

	mov	[hToolBar],eax

	push	OFFSET miiTB		;pmii
	push	FALSE			;fByPosition
	push	IDM_TOOLBAR		;uItem
	push	edi			;hMenu
	call	[SetMenuItemInfo]	;USER

;Initialize the ToolBar window
	push	edi			;save hMenu
	sub	esp,SIZEOF(TBADDBITMAP)	;LOCAL ESP=OFFSET tbab

	mov	edi,[hToolBar]		;EDI=hToolBar
	mov	[esp+TBADDBITMAP.hInst],ebx
	mov	[esp+TBADDBITMAP.nID],IDB_TOOLBAR

	push	0			;lParam
	push	SIZEOF(TBBUTTON)	;wParam - cbSize
	push	TB_BUTTONSTRUCTSIZE	;Msg
	push	edi			;hWnd
	call	[SendMessage]		;USER

	push	0			;lParam
	push	8			;wParam - indentation in pixels
	push	TB_SETINDENT		;Msg
	push	edi			;hWnd
	call	[SendMessage]		;USER

	push	esp			;lParam	- ptbab
	push	1			;wParam - nButtons
	push	TB_ADDBITMAP		;Msg
	push	edi			;hWnd
	call	[SendMessage]		;USER

	push	OFFSET tbButtons	;lParam	- pButtons
	push	1			;wParam - uNumButtons
	push	TB_ADDBUTTONS		;Msg
	push	edi			;hWnd
	call	[SendMessage]		;USER

	push	0			;lParam
	push	0			;wParam
	push	TB_AUTOSIZE		;Msg
	push	edi			;hWnd
	call	[SendMessage]		;USER

	add	esp,SIZEOF(TBADDBITMAP)	;LOCAL tbab removed
	pop	edi			;restore hMenu

;Create the StatusBar window and update its menu item info
	mov	eax,MFS_UNCHECKED	;hidden state
	mov	ecx,WS_CHILD		;hidden style
	test	[fOptions],2		;StatusBar bit
	jz	@F

	mov	eax,MFS_CHECKED		;visible state
	or	ecx,WS_VISIBLE		;visible style adjustment
@@:
	mov	[miiSB.fState],eax

	push	ID_STATUSBAR		;wID
	push	esi			;hwndParent
	push	OFFSET szReady		;pszText
	push	ecx			;style
	call	[CreateStatusWindow]	;COMCTL

	test	eax,eax
	jz	Error

	mov	[hStatusBar],eax

	push	OFFSET miiSB		;pmii
	push	FALSE			;fByPosition
	push	IDM_STATUSBAR		;uItem
	push	edi			;hMenu
	call	[SetMenuItemInfo]	;USER

;Create the TreeView window with keyboard focus and update its menu item info
	mov	eax,MFS_UNCHECKED	;hidden state
	mov	ecx,WS_CHILD OR TVS_SHOWSELALWAYS OR TVS_LINESATROOT OR TVS_HASLINES OR TVS_HASBUTTONS
	mov	[miiS.fState],MFS_DISABLED	;hidden split state
	test	[fOptions],4		;TreeView bit
	jz	@F

	mov	eax,MFS_CHECKED		;visible state
	or	ecx,WS_VISIBLE		;visible style adjustment
	mov	[miiS.fState],MFS_ENABLED	;visible split state
@@:
	mov	[miiTV.fState],eax
	xor	eax,eax

	push	eax			;pParam
	push	ebx			;hInstance
	push	ID_TREEVIEW		;hMenu - window identifier
	push	esi			;hWndParent
	push	eax			;nHeight
	push	eax			;nWidth
	push	eax			;y
	push	eax			;x
	push	ecx			;dwStyle
	push	eax			;pWindowName
	push	OFFSET szTreeView	;pClassName
	push	WS_EX_CLIENTEDGE	;dwExStyle
	call	[CreateWindowEx]	;USER

	test	eax,eax
	jz	Error

	mov	[hTreeView],eax
	mov	[hwndFocus],eax

	push	eax			;hWnd
	call	[SetFocus]		;USER

	push	OFFSET miiTV		;pmii
	push	FALSE			;fByPosition
	push	IDM_TREEVIEW		;uItem
	push	edi			;hMenu
	call	[SetMenuItemInfo]	;USER

	push	OFFSET miiS		;pmii
	push	FALSE			;fByPosition
	push	IDM_SPLIT		;uitem
	push	edi			;hMenu
	call	[SetMenuItemInfo]	;USER

;Initialize the View window
	call	ViewINIT
	jz	Error

	xor	eax,eax		;return 0 to continue
Return:
	ret
Error:
	dec	eax		;return -1 to exit
	jmp	Return
MainWM_CREATE ENDP

	ALIGN 4
MainWM_SETTINGCHANGE PROC
	call	MainSETTING	;get settings
	call	MainCHANGED	;update display
	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_SETTINGCHANGE ENDP

	ALIGN 4
MainSETTING PROC
;Get system scroll bar size used to limit sizing of Main window
	push	SM_CXVSCROLL		;nIndex
	call	[GetSystemMetrics]	;USER

	mov	[cxVScroll],eax

;Get system drag state used in display of splitter bar movement
	push	0			;fWinIni
	push	OFFSET bDragFull	;pvParam
	push	0			;uiParam
	push	SPI_GETDRAGFULLWINDOWS	;uiAction
	call	[SystemParametersInfo]	;USER
Return:
	ret
MainSETTING ENDP

;;
;;	MAIN WINDOW TERMINATION
;;

	.CODE
MainWM_CLOSE PROC
;Close the file
	call	FileUNMAP

;Save settings to the Registry
	call	RegSET

;Delete saved settings from the Registry?
	push	MB_YESNO	;uType
	push	OFFSET szRegDc	;pCaption
	push	OFFSET szRegDt	;pText
	push	[hwndMain]	;hWnd
	call	[MessageBox]	;User

	cmp	eax,IDNO
	je	@F

	call	RegDELETE
@@:
;Send WM_DESTROY to destroy the Main window and exit
	push	[hwndMain]		;hWnd
	call	[DestroyWindow]		;USER

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_CLOSE ENDP

	ALIGN	4
MainWM_DESTROY PROC
;Delete the Font
	push	[hOldFont]		;hgdiobj
	push	[hdcView]		;hdc
	call	[SelectObject]		;GDI

	push	[hFont]			;hObject
	call	[DeleteObject]		;GDI

;Post WM_QUIT to the message queue to exit
	push	0			;nExitCode
	call	[PostQuitMessage]	;USER

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_DESTROY ENDP

;;
;;	REGISTRY MANAGEMENT FOR SAVED SETTINGS
;;

	.CONST
szMainKey 	BYTE	"Software\WJR",0,0,0,0
szSubKey	BYTE	"Software\WJR\Alive",0
szFont		BYTE	"Font",0,0,0,0
szOptions	BYTE	"Options",0
szPlacement	BYTE	"Placement",0,0,0

szRegDc		BYTE	"Alive - Delete Settings?",0,0,0,0
szRegDt		BYTE	"Settings have been saved in the Registry.",0Dh,0Ah
		BYTE	"If you have finished playing with Alive,",0Dh,0Ah
		BYTE	"would you like these settings removed?",0

	.DATA?
hkSubKey	DWORD	?
cbData		DWORD	?
cSubKeys	DWORD	?

	.CODE
RegGET	PROC
	xor	ebx,ebx		;EBX=0 for some parameters

;Get handle to Registry SubKey if it exists
	mov	esi,OFFSET hkSubKey

	push	esi			;phkResult
	push	KEY_READ		;samDesired
	push	ebx			;ulOptions - reserved 0
	push	OFFSET szSubKey		;pSubKey
	push	HKEY_CURRENT_USER	;hKey
	call	[RegOpenKeyEx]		;ADVAPI

	test	eax,eax		;ERROR_SUCCESS=0
	jnz	Return		;NZ if run for the first time

;Get saved information in Registry
	mov	edi,OFFSET cbData	;EDI=pcbData
	mov	esi,[esi]		;ESI=hkSubKey
;Font
	mov	DWORD PTR [edi],SIZEOF(LOGFONT)

	push	edi			;pcbData
	push	OFFSET lfView		;pData
	push	ebx			;pType
	push	ebx			;pReserved
	push	OFFSET szFont		;pValueName
	push	esi			;hKey
	call	[RegQueryValueEx]	;ADVAPI
;Options
	mov	DWORD PTR [edi],4

	push	edi			;pcbData
	push	OFFSET fOptions		;pData
	push	ebx			;pType
	push	ebx			;pReserved
	push	OFFSET szOptions	;pValueName
	push	esi			;hKey
	call	[RegQueryValueEx]	;ADVAPI
;Placement
	mov	DWORD PTR [edi],SIZEOF(WINDOWPLACEMENT)+4	;wpMain + rcSplit.Left

	push	edi			;pcbData
	push	OFFSET wpMain		;pData
	push	ebx			;pType
	push	ebx			;pReserved
	push	OFFSET szPlacement	;pValueName
	push	esi			;hKey
	call	[RegQueryValueEx]	;ADVAPI

;Close handle to Registry SubKey - should return ERROR_SUCCESS=0
	push	esi			;hKey
	call	[RegCloseKey]		;ADVAPI
Return:
	ret
RegGET	ENDP

	ALIGN 4
RegSET	PROC
	xor	ebx,ebx		;EBX=0 for some parameters

;Get handle to Registry SubKey and create it if it does not exist
	mov	esi,OFFSET hkSubKey

	push	ebx			;pdwDisposition - NULL, not needed
	push	esi			;phkResult
	push	ebx			;pSecurityAttributes
	push	KEY_WRITE		;samDesired
	push	REG_OPTION_NON_VOLATILE	;dwOptions
	push	ebx			;pClass
	push	ebx			;Reserved
	push	OFFSET szSubKey		;pSubKey
	push	HKEY_CURRENT_USER	;hKey
	call	[RegCreateKeyEx]	;ADVAPI

	test	eax,eax		;ERROR_SUCCESS=0
	jnz	Return

;Save settings in Registry
	mov	esi,[esi]	;ESI=hkSubKey
;Font
	push	SIZEOF(LOGFONT)		;cbData
	push	OFFSET lfView		;pData
	push	REG_BINARY		;dwType
	push	ebx			;Reserved
	push	OFFSET szFont		;pValueName
	push	esi			;hKey
	call	[RegSetValueEx]		;ADVAPI
;Options
	push	4			;cbData
	push	OFFSET fOptions		;pData
	push	REG_DWORD		;dwType
	push	ebx			;Reserved
	push	OFFSET szOptions	;pValueName
	push	esi			;hKey
	call	[RegSetValueEx]		;ADVAPI
;Placement
	push	SIZEOF(WINDOWPLACEMENT)+4	;cbData = wpMain + rcSplit.Left
	push	OFFSET wpMain		;pData
	push	REG_BINARY		;dwType
	push	ebx			;Reserved
	push	OFFSET szPlacement	;pValueName
	push	esi			;hKey
	call	[RegSetValueEx]		;ADVAPI

;Close handle to Registry SubKey - should return ERROR_SUCCESS=0
	push	esi			;hKey
	call	[RegCloseKey]		;ADVAPI
Return:
	ret
RegSET	ENDP

	ALIGN 4
RegDELETE PROC
	xor	ebx,ebx		;EBX=0 for some parameters

;Delete Registry SubKey for saved settings
	push	OFFSET szSubKey		;pSubKey
	push	HKEY_CURRENT_USER	;hKey
	call	[RegDeleteKey]		;ADVAPI

;IF Registry MainKey exists
	mov	esi,OFFSET hkSubKey

	push	esi			;phkResult
	push	KEY_READ		;samDesired
	push	ebx			;ulOptions - reserved 0
	push	OFFSET szMainKey	;pSubKey
	push	HKEY_CURRENT_USER	;hKey
	call	[RegOpenKeyEx]		;ADVAPI

	test	eax,eax		;ERROR_SUCCESS=0
	jnz	Return		;NZ if it does not exist

;THEN get the number of SubKeys
	mov	esi,[esi]		;ESI=hMainKey
	mov	edi,OFFSET cSubKeys	;EDI=pcSubKeys

	push	ebx			;pftLastWriteTime
	push	ebx			;pcbSecurityDescriptor
	push	ebx			;pcbMaxValueLen
	push	ebx			;pcbMaxValueNameLen
	push	ebx			;pcValues
	push	ebx			;pcbMaxClassLen
	push	ebx			;pcbMaxSubKeyLen
	push	edi			;pcSubKeys
	push	ebx			;pReserved
	push	ebx			;pcbClass
	push	ebx			;pClass
	push	esi			;hKey
	call	[RegQueryInfoKey]	;ADVAPI

	push	esi			;hKey
	call	[RegCloseKey]		;ADVAPI

;AND IF SubKeys do not exist
	mov	eax,[edi]
	test	eax,eax
	jnz	Return		;NZ if subkeys exist so do not delete

;THEN delete Registry MainKey - should return ERROR_SUCCESS=0
	push	OFFSET szMainKey	;pSubKey
	push	HKEY_CURRENT_USER	;hKey
	call	[RegDeleteKey]		;ADVAPI
Return:
	ret
RegDELETE ENDP

;;
;;	MAIN WINDOW PLACEMENT
;;

	.DATA
wpMain	WINDOWPLACEMENT	<SIZEOF(WINDOWPLACEMENT),0,SW_SHOWDEFAULT,\
		<0,0>, <0,0>, <0, 0, 260h, 1A0h>>
;IMPORTANT to keep rcSplit after wpMain for Registry Placement setting.
;Split bar becomes effective Main client area after removing child window areas
rcSplit	RECT	<0BCh,0,0,0>	;rcSplit.right=0 when not visible

	.DATA?
rcMain		RECT	<>	;Main window client area
rcToolBar	RECT	<>	;ToolBar screen coordinates
rcStatusBar	RECT	<>	;StatusBar screen coordinates

cxVScroll DWORD	?	;initialized in MainSETTING
rcSizing RECT	<>	;used to limit sizing
xMain	DWORD	?	;used to detect change in position
cxMain	DWORD	?	;used to detect change in size

	.CODE
MainWM_ENTERSIZEMOVE PROC
;Set rcSizing limits for left and right movement
	mov	esi,OFFSET rcSizing
	mov	edi,[hwndMain]

	mov	ecx,[cxVScroll]
	mov	eax,[rcSplit.left]
	mov	edx,[rcSplit.right]
	lea	ecx,[ecx+ecx*2]		;3*cxVScroll to limit left and right movement
	test	edx,edx			;NZ if TreeView visible
	jnz	Adjust

	add	ecx,ecx			;x2
	mov	eax,[rcMain.right]
	mov	edx,[rcMain.left]
Adjust:
	sub	eax,ecx
	add	edx,ecx
	sub	eax,4			;adjustment for borders
	add	edx,2
	mov	[esi+RECT.left],eax
	mov	[esi+RECT.right],edx

	push	esi			;pPOINT
	push	edi			;hWnd
	call	[ClientToScreen]	;USER

	push	OFFSET rcSizing.right	;pPOINT
	push	edi			;hWnd
	call	[ClientToScreen]	;USER

;Set rcSizing limits for top and bottom movement
	sub	esp,SIZEOF(RECT)	;LOCAL ESP=OFFSET rcSizeMove

	push	esp			;pRECT
	push	edi			;hWnd
	call	[GetWindowRect]		;USER

	mov	eax,[cyChar]		;allow for three lines of text
	lea	ecx,[eax+eax*2+80h]	;3*cyChar + adjustment for title and menu

	mov	eax,[esp+RECT.bottom]	;for limit of top movement
	mov	edx,[esp+RECT.top]	;for limit of bottom movement
	sub	eax,ecx
	add	edx,ecx
	mov	[esi+RECT.top],eax
	mov	[esi+RECT.bottom],edx
	add	esp,SIZEOF(RECT)	;LOCAL rcSizeMove removed

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_ENTERSIZEMOVE ENDP

	ALIGN	4
MainWM_SIZING PROC
	mov	esi,OFFSET rcSizing
	mov	edi,[lParam]
;Limit left movement
	mov	eax,[esi+RECT.left]
	cmp	eax,[edi+RECT.left]
	jge	@F

	mov	[edi+RECT.left],eax
@@:
;Limit top movement
	mov	eax,[esi+RECT.top]
	cmp	eax,[edi+RECT.top]
	jge	@F

	mov	[edi+RECT.top],eax
@@:
;Limit right movement
	mov	eax,[esi+RECT.right]
	cmp	eax,[edi+RECT.right]
	jle	@F

	mov	[edi+RECT.right],eax
@@:
;Limit bottom movement
	mov	eax,[esi+RECT.bottom]
	cmp	eax,[edi+RECT.bottom]
	jle	@F

	mov	[edi+RECT.bottom],eax
@@:
	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_SIZING ENDP

	ALIGN 4
MainWM_WINDOWPOSCHANGED PROC
;Get window placement of Main window
	mov	edi,OFFSET wpMain
	mov	esi,[lParam]		;ESI=pWINDOWPOS

	push	edi			;pWINDOWPLACEMENT
	push	[hwndMain]		;hWnd
	call	[GetWindowPlacement]	;USER

;Adjust split position so that sizing with left border does not move split bar
	mov	ecx,[edi+WINDOWPLACEMENT.showCmd]
	mov	eax,[esi+WINDOWPOS.x]
	mov	edx,[esi+WINDOWPOS._cx]
	cmp	ecx,SW_SHOWMINIMIZED
	je	Continue	;E if minimized so no Split adjustment

	mov	ecx,[xMain]	;get old position and width
	mov	ebx,[cxMain]
	mov	[xMain],eax	;set new position and width
	mov	[cxMain],edx

	test	ebx,ebx		;no Split adjustment if cxMain=0 on startup
	jz	Continue

	sub	ecx,eax		;ECX=change in xMain position
	jz	Continue	;Z if no change so no Split adjustment

	sub	edx,ebx		;EDX=change in cxMain width
	jz	Continue	;Z if no change so no Split adjustment

	mov	eax,[rcSplit.left]
	mov	edx,[rcSplit.right]
	add	eax,ecx		;adjust split position
	test	edx,edx		;rcSplit.right=0 if not visible
	mov	[rcSplit.left],eax
	jz	Continue

	add	eax,3		;rcSplit.right if visible
	mov	[rcSplit.right],ecx
Continue:

;Get client area of Main window
	mov	edi,OFFSET rcMain

	push	edi			;pRECT
	push	[hwndMain]		;hWnd
	call	[GetClientRect]		;USER

;Set HIWORD(EBX)=nHeight and LOWORD(EBX)=nWidth for ToolBar and StatusBar
	mov	eax,[edi+RECT.bottom]
	mov	ebx,[edi+RECT.right]
	shl	eax,16
	add	ebx,eax		;EBX=client area

;Notify ToolBar of size change and get new dimensions in screen coordinates
	push	ebx			;lParam	- client area
	push	SIZE_RESTORED		;wParam - resizing flag
	push	WM_SIZE			;Msg
	push	[hToolBar]		;hWnd
	call	[SendMessage]		;USER

	push	OFFSET rcToolBar	;pRECT
	push	[hToolBar]		;hWnd
	call	[GetWindowRect]		;USER

;Notify StatusBar of size change and get new dimensions in screen coordinates
	push	ebx			;lParam - client area
	push	SIZE_RESTORED		;wParam - resizing flag
	push	WM_SIZE			;Msg
	push	[hStatusBar]		;hWnd
	call	[SendMessage]		;USER

	push	OFFSET rcStatusBar	;pRECT
	push	[hStatusBar]		;hWnd
	call	[GetWindowRect]		;USER

;Update display
	call	MainCHANGED
Return:
	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_WINDOWPOSCHANGED ENDP

	ALIGN	4
MainCHANGED PROC
;Limit left and right splitter bar movement
	mov	ecx,[cxVScroll]
	mov	eax,[rcSplit.left]
	lea	ecx,[ecx+ecx*2]		;3*cxVScroll
	mov	edx,[rcMain.right]
	cmp	eax,ecx
	jg	@F		;G if split position is OK at left

	mov	eax,ecx		;ELSE set to left most position
@@:
	sub	edx,ecx
	dec	edx
	cmp	eax,edx
	jbe	@F		;BE if split position is OK at right

	mov	eax,edx		;ELSE set to right most position
@@:
	mov	[rcSplit.left],eax

	mov	eax,[fOptions]	;EAX=fOptions
	xor	ecx,ecx		;rcSplit.right=0 if not visible
	test	eax,4		;TreeView bit
	jz	NoTV		;Z if not visible

	mov	ecx,[rcSplit.left]
	add	ecx,3		;rcSplit.right if visible
NoTV:
	mov	[rcSplit.right],ecx

;Set vertical position and size of View and TreeView windows
	mov	esi,[rcMain.top]	;ESI=yView
	mov	edi,[rcMain.bottom]	;EDI=cyView
	test	eax,1		;ToolBar bit
	jz	NoTB		;Z if not visible

	mov	ecx,[rcToolBar.bottom]
	mov	edx,[rcToolBar.top]
	sub	ecx,edx
	add	esi,ecx		;adjusted by cyToolBar
NoTB:
	test	eax,2		;StatusBar bit
	jz	NoSB		;Z if not visible

	mov	ecx,[rcStatusBar.bottom]
	mov	edx,[rcStatusBar.top]
	sub	ecx,edx
	sub	edi,ecx		;adjusted by cyStatusBar
NoSB:
	mov	[rcSplit.top],esi
	mov	[rcSplit.bottom],edi
	sub	edi,esi		;adjusted by cyToolBar and cyStatusBar

	mov	eax,[rcSplit.right]	;EAX=xView  =0 if TreeView not visible
	mov	ecx,[rcMain.right]
	sub	ecx,eax			;ECX=cxView  =cxMain-cxTreeView

;Update dimensions of the View window
	push	SWP_NOZORDER OR SWP_NOACTIVATE OR SWP_NOSENDCHANGING	;uFlags
	push	edi			;cy
	push	ecx			;cx
	push	esi			;Y
	push	eax			;X
	push	0			;hWndInsertAfter
	push	[hwndView]		;hWnd
	call	[SetWindowPos]		;USER

;Update dimensions of the TreeView window
	push	SWP_NOZORDER OR SWP_NOACTIVATE OR SWP_NOSENDCHANGING	;uFlags
	push	edi			;cy
	push	[rcSplit.left]		;cx
	push	esi			;Y
	push	0			;X
	push	0			;hWndInsertAfter
	push	[hTreeView]		;hWnd
	call	[SetWindowPos]		;USER
Return:
	ret
MainCHANGED ENDP

;;
;;	SPLITTER BAR MOVEMENT SUPPORT
;;

	.DATA?
bDragFull	DWORD	?	;initialized in MainSETTING
bDragSplit	DWORD	?	;0 inactive, 1 active
hdcSplit	HDC	?
xSplit		DWORD	?
hwndFocus	DWORD	?	;used with SplitBEGIN and SplitEND
				; and with MainWM_ACTIVATE, NMSetFocus

	.CODE
SplitCMD PROC
;Get midpoint coordinates of splitter bar
	sub	esp,SIZEOF(RECT)	;LOCAL ESP=OFFSET rcSplit in screen coordinates

	mov	edx,[rcSplit.left]
	mov	eax,[rcSplit.top]
	mov	[esp+RECT.left],edx
	mov	[esp+RECT.top],eax
	mov	edx,[rcSplit.right]
	mov	eax,[rcSplit.bottom]
	mov	[esp+RECT.right],edx
	mov	[esp+RECT.bottom],eax

	push	esp			;pPOINT
	push	[hwndMain]		;hWnd
	call	[ClientToScreen]	;USER

	lea	eax,[esp+RECT.right]

	push	eax			;pPOINT
	push	[hwndMain]		;hWnd
	call	[ClientToScreen]	;USER

	mov	ecx,[esp+RECT.bottom]
	mov	edx,[esp+RECT.top]
	mov	eax,[esp+RECT.left]	;EAX=xPos of cursor

	add	esp,SIZEOF(RECT)	;LOCAL rcSplit removed

	add	ecx,edx
	shr	ecx,1		;ECX=yPos of cursor

;Set cursor position to midpoint of splitter bar
	push	ecx			;X
	push	eax			;Y
	call	[SetCursorPos]		;USER

;Display split cursor
	push	[hCursor]		;hCursor
	call	[SetCursor]		;USER

;Activate split movement
	call	SplitBEGIN
	xor	eax,eax
	ret
SplitCMD ENDP

	ALIGN	4
SplitBEGIN PROC
;IF already active THEN cancel ELSE activate
	mov	ebx,[bDragSplit]
	mov	edi,[hwndMain]
	test	ebx,ebx
	jnz	Cancel		;NZ if already active so end

	inc	ebx
	mov	[bDragSplit],ebx	;1=active

;Direct all mouse input to Main window
	push	edi			;hWnd
	call	[SetCapture]		;USER

;Direct all keyboard input to Main window saving previous keyboard focus
	push	edi			;hWnd
	call	[SetFocus]		;USER

	mov	[hwndFocus],eax

;Limit cursor movement to within the Main window
	sub	esp,SIZEOF(RECT)	;LOCAL ESP=OFFSET rcClip

	mov	ecx,[cxVScroll]
	mov	eax,[rcSplit.top]
	lea	ecx,[ecx+ecx*2]		;minimum size 3*cxVScroll
	mov	[esp+RECT.top],eax
	mov	[esp+RECT.left],ecx
	mov	edx,[rcMain.right]
	mov	eax,[rcSplit.bottom]
	sub	edx,ecx
	mov	[esp+RECT.bottom],eax
	mov	[esp+RECT.right],edx

	push	esp			;pPOINT
	push	edi			;hWnd
	call	[ClientToScreen]	;USER

	lea	eax,[esp+RECT.right]

	push	eax			;pPOINT
	push	edi			;hWnd
	call	[ClientToScreen]	;USER

	push	esp			;pRECT
	call	[ClipCursor]		;USER

	add	esp,SIZEOF(RECT)	;LOCAL rcClip removed

;Save split position
	mov	eax,[rcSplit.left]
	mov	[xSplit],eax

;Initialize split drawing
	push	edi			;hWnd
	call	[GetDC]			;USER

	mov	[hdcSplit],eax

	xor	ebx,ebx		;EBX=0 to draw new drag rectangle
	call	SplitDRAW
Return:
	ret
Cancel:
	mov	ebx,[rcSplit.left]	;EBX=split xPosition
	call	SplitEND
	jmp	Return
SplitBEGIN ENDP

	ALIGN	4
SplitDRAW PROC			;EBX=0 on/off ELSE xPosition
	mov	eax,[bDragSplit]
	test	eax,eax
	jz	Return

	mov	esi,OFFSET rcSplit
	mov	edi,[hdcSplit]

;Support for SPI_GETDRAGFULLWINDOWS - no drag rectangle
	mov	eax,[bDragFull]
	test	eax,eax
	jz	DrawSplit	;Z if no drag full windows

	test	ebx,ebx
	jz	Return		;Z to turn on/off

	sub	ebx,[esi+RECT.left]	;EBX=change in position
	jz	Return			;move only if position changed

	add	[esi+RECT.left],ebx	;update split position
	add	[esi+RECT.right],ebx
	call	MainCHANGED		;update display

	jmp	Return

;IF still active AND split position has moved
DrawSplit:
	test	ebx,ebx
	jz	@F		;Z to turn on/off

	sub	ebx,[esi+RECT.left]	;EBX=change in position
	jz	Return			;move only if position changed

;THEN erase old drag rectangle
	push	esi			;pRECT
	push	edi			;hDC
 	call	[DrawFocusRect]		;USER

	add	[esi+RECT.left],ebx	;update split position
	add	[esi+RECT.right],ebx

;ELSE draw new OR erase old drag rectangle
@@:
	push	esi			;pRECT
	push	edi			;hDC
 	call	[DrawFocusRect]		;USER
Return:
	ret
SplitDRAW ENDP

	ALIGN	4
SplitEND PROC			;EBX=xPosition
;IF deactivated THEN return ELSE deactivate
	mov	eax,[bDragSplit]
	test	eax,eax
	jz	Return		;Z if already inactive so end

;Restore normal mouse input
	push	0			;pRECT - NULL to move anywhere
	call	[ClipCursor]		;USER

	call	[ReleaseCapture]	;USER

;Erase drag rectangle and end split drawing
	push	ebx		;save position

	xor	ebx,ebx		;EBX=0 to erase drag rectangle
	call	SplitDRAW

	pop	ebx		;restore position

	push	[hdcSplit]		;hDC
	push	[hwndMain]		;hWnd
	call	[ReleaseDC]		;USER

;Update the split position and display if moved
	mov	[rcSplit.right],ebx
	mov	[rcSplit.left],ebx
	add	[rcSplit.right],3
	cmp	ebx,[xSplit]
	je	Done

	call	MainCHANGED	;update display only if moved
Done:
	xor	eax,eax
	mov	[bDragSplit],eax	;0=inactive

;Restore the keyboard focus
	push	[hwndFocus]		;hWnd
	call	[SetFocus]		;USER
Return:
	ret
SplitEND ENDP

;;
;;	SPLITTER BAR MOVEMENT MESSAGES
;;

	.CODE
MainWM_MOUSEMOVE PROC
	xor	ebx,ebx		;LOWORD(lParam) = x-coordinate of cursor
	mov	bx,WORD PTR [lParam]	;EBX=split xPosition
	call	SplitDRAW

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_MOUSEMOVE ENDP

	ALIGN	4
MainWM_LBUTTONDOWN PROC
	call	SplitBEGIN

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_LBUTTONDOWN ENDP

	ALIGN	4
MainWM_LBUTTONUP PROC
	mov	ebx,[rcSplit.left]	;EBX=split xPosition
	call	SplitEND

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_LBUTTONUP ENDP

	ALIGN	4
MainWM_RBUTTONDOWN PROC
	mov	ebx,[xSplit]	;EBX=split xPosition
	call	SplitEND

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_RBUTTONDOWN ENDP

	ALIGN	4
MainWM_KEYDOWN PROC
	mov	eax,[wParam]	;virtual-key code
	cmp	eax,VK_LEFT
	je	KeyL

	cmp	eax,VK_RIGHT
	je	KeyR

	cmp	eax,VK_ESCAPE
	je	KeyEsc

	cmp	eax,VK_RETURN
	je	KeyRet

	stc		;set carry flag for default processing
	jmp	Return
KeyL:
	mov	edi,-4
	jmp	Update
KeyR:
	mov	edi,4
	jmp	Update
KeyEsc:
	mov	ebx,[xSplit]	;EBX=split xPosition
	call	SplitEND
	jmp	Return0
KeyRet:
	mov	ebx,[rcSplit.left]	;EBX=split xPosition
	call	SplitEND
	jmp	Return0

;Update cursor xPosition by +/- amount in EDI
Update:
	sub	esp,SIZEOF(POINT)	;LOCAL ESP=OFFSET POINT

	push	esp			;pPOINT
	call	[GetCursorPos]		;USER

	mov	eax,[esp+POINT.x]
	mov	edx,[esp+POINT.y]

	add	esp,SIZEOF(POINT)	;LOCAL POINT removed
	add	eax,edi

	push	edx			;Y
	push	eax			;X
	call	[SetCursorPos]		;USER
Return0:
	xor	eax,eax		;return 0 - message processed, clear carry flag
Return:
	ret
MainWM_KEYDOWN ENDP

	ALIGN	4
MainWM_CANCELMODE PROC
	mov	ebx,[xSplit]	;EBX=split xPosition
	call	SplitEND

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_CANCELMODE ENDP

;;
;;	OTHER MAIN WINDOW MESSAGES
;;

	.CODE
MainWM_ERASEBKGND PROC
;IF the ToolBar is visible
	mov	eax,[fOptions]
	xor	ecx,ecx		;ECX=0 for left and top
	test	eax,1		;ToolBar bit
	jz	NoTB		;Z if ToolBar not visible

;THEN erase background for transparent ToolBar
	sub	esp,SIZEOF(RECT)	;LOCAL ESP=OFFSET rcTB

	mov	eax,[rcToolBar.right]
	mov	edx,[rcToolBar.left]
	sub	eax,edx			;width
	mov	[esp+RECT.left],ecx
	mov	[esp+RECT.right],eax
	mov	eax,[rcToolBar.bottom]
	mov	edx,[rcToolBar.top]
	sub	eax,edx			;height
	mov	[esp+RECT.top],ecx
	mov	[esp+RECT.bottom],eax
	mov	eax,esp			;EAX=prcTB

	push	COLOR_3DFACE + 1	;hBrush
	push	eax	      		;pRECT
	push	[wParam]      		;hDC
	call	[FillRect]    		;USER

	add	esp,SIZEOF(RECT)	;LOCAL rcTB removed
NoTB:
;IF the TreeView is visible
	mov	eax,[fOptions]
	test	eax,4		;TreeView bit
	jz	NoTV		;Z if TreeView not visible

;THEN erase background for splitter bar
	push	COLOR_3DFACE + 1	;hBrush
	push	OFFSET rcSplit		;pRECT
	push	[wParam]      		;hDC
	call	[FillRect]    		;USER
NoTV:
	xor	eax,eax		;message processed, clear carry flag
	inc	eax		;return nonzero - background erased
	ret
MainWM_ERASEBKGND ENDP

	ALIGN	4
MainWM_ACTIVATE PROC
;IF activated AND not minimized
	mov	eax,[wParam]	;fActive = LOWORD(wParam)
	mov	edx,0FFFF0000h
	test	eax,WA_ACTIVE OR WA_CLICKACTIVE
	jz	Return

	and	eax,edx		;fMinimized = HIWORD(wParam)
	jnz	Return

;THEN use saved TreeView or View keyboard focus OR set View as default
	mov	eax,[hwndFocus]
	mov	edx,[hwndView]
	test	eax,eax
	jnz	@F

	mov	eax,edx
@@:
	push	eax			;hWnd
	call	[SetFocus]		;USER
Return:
	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_ACTIVATE ENDP

	ALIGN 4
MainWM_SYSCOLORCHANGE PROC
;TreeView should get this message too
	push	0			;lParam
	push	0			;wParam
	push	WM_SYSCOLORCHANGE	;Msg
	push	[hTreeView]		;hWnd
	call	[SendMessage]		;USER

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_SYSCOLORCHANGE ENDP

;;
;;	STATUS BAR MANAGEMENT
;;

	.CONST
MenuHelpIDs	DWORD	0, IDM_FILEMENU	;for StatusBar help text
		DWORD	0, 0

szReady	DB	"Ready",0,0,0
szOpening DB	"Opening...",0,0
szClosing DB	"Closing...",0,0

	.CODE
MainWM_MENUSELECT PROC
	push	OFFSET MenuHelpIDs	;pwIDs
	push	[hStatusBar]		;hwndStatus
	push	[hInst]			;hInst
	push	[hMenu]			;hMainMenu
	push	[lParam]		;lParam
	push	[wParam]		;wParam
	push	[uMsg]			;uMsg
	call	[MenuHelp]		;COMCTL

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_MENUSELECT ENDP

	ALIGN 4
StatusUPDATE PROC		;ESI=pszStatusText
;Update StatusBar text with given string
	push	esi			;lParam - pszText
	push	0			;wParam - iPart | uType
	push	SB_SETTEXT		;Msg
	push	[hStatusBar]		;hWnd
	call	[SendMessage]		;USER
Return:
	ret
StatusUPDATE ENDP

;;
;;	TOOLTIP NOTIFICATION MESSAGES
;;

	.CODE
TTNGetDispInfo PROC		;EBX=lParam
	mov	eax,[ebx+NMTTDISPINFO.hdr.idFrom]
	mov	edx,[hInst]
	add	eax,80h		;EAX=Tooltip StringID
	mov	[ebx+NMTTDISPINFO.lpszText],eax
	mov	[ebx+NMTTDISPINFO.hinst],edx
	ret
TTNGetDispInfo ENDP

;;
;;	TREEVIEW NOTIFICATION MESSAGES
;;

	.CODE
NMSetFocus PROC
;TreeView now has keyboard focus
	mov	eax,[hTreeView]
	mov	[hwndFocus],eax

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
NMSetFocus ENDP

	ALIGN	4
TVNKeyDown PROC			;EBX=lParam PTR NMTVKEYDOWN
	xor	eax,eax
	mov	ax,[ebx+NMTVKEYDOWN.wVKey]

	cmp	eax,VK_TAB
	je	KeyTab

	xor	eax,eax		;return 0 - include character in search
	jmp	Return

;TAB key sets the View window to have the keyboard focus
KeyTab:
	mov	esi,[hwndView]
	mov	[hwndFocus],esi

	push	esi			;hWnd
	call	[SetFocus]		;USER

	xor	eax,eax
	inc	eax		;return non-zero - exclude character from search
Return:
	ret
TVNKeyDown ENDP

;;
;;	FILE MENU COMMANDS
;;

	.CONST
szTitle		BYTE	"Alive - "
szUntitled	BYTE	"Untitled",0,0,0,0
szFilter	BYTE	"All Files (*.*)",0,"*.*",0,0

	.DATA
miiFC	MENUITEMINFO <SIZEOF(MENUITEMINFO),MIIM_STATE,,MFS_DISABLED,IDM_CLOSE,>
ofn	OPENFILENAME <SIZEOF(OPENFILENAME), 0, 0,\
			OFFSET szFilter, 0, 0, 1,\
			OFFSET szFileTemp, MAX_PATH,\
			0, 0,\
			0, 0, 0, 0, 0,\
			0, 0, 0, 0>

	.DATA?
pCmdLine	DWORD	?
szWindowName	BYTE	LENGTHOF szTitle DUP (?)
szFile		BYTE	MAX_PATH DUP (?)
szFileTemp	BYTE	MAX_PATH DUP (?)

	.CODE
FileINIT PROC
;Set the text for the Main window title bar to the default
	mov	esi,OFFSET szTitle
	call	FileNAME

;Process command line arguments
	call	[GetCommandLine]	;KERNEL

	mov	[pCmdLine],eax

	;;**** COMMAND LINE PROCESSING ****
	;;* possibly calling FileOPENING  *

	ret
FileINIT ENDP

	ALIGN	4
FileNAME PROC		;ESI=pszTitle or NULL for already initialized
;IF ESI points to text
	mov	edi,OFFSET szWindowName
	test	esi,esi
	jz	Update

;THEN set szWindowName to this text for the title bar
	mov	ecx,LENGTHOF szTitle + LENGTHOF szUntitled
	push	edi
	rep movsb
	pop	edi

;Update the text for the Main window title bar
Update:
	push	edi			;pString
	push	[hwndMain]		;hWnd
	call	[SetWindowText]		;USER

	ret
FileNAME ENDP

	ALIGN	4
FileOPEN PROC
;Select a new file to open
	mov	esi,OFFSET ofn
	mov	eax,[hwndMain]
	mov	ecx,OFN_PATHMUSTEXIST OR OFN_FILEMUSTEXIST OR OFN_HIDEREADONLY OR OFN_EXPLORER
	mov	[esi+OPENFILENAME.hwndOwner],eax
	mov	[esi+OPENFILENAME.Flags],ecx

	push	esi			;pOPENFILENAME
	call	[GetOpenFileName]	;COMDLG

	test	eax,eax
	jz	Return

;Close the current file
	call	FileCLOSE

;Open the new file
	call	FileOPENING

Return:
	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
FileOPEN ENDP

	ALIGN	4
FileOPENING PROC
;Display "Opening..." on the status bar
	mov	esi,OFFSET szOpening
	call	StatusUPDATE

;Open the file
	call	FileMAP		;returns EAX=cbFile or 0

	test	eax,eax
	jz	Error		;Z if error opening file

;Update the name of the currently opened file
	mov	ecx,MAX_PATH
	mov	esi,OFFSET szFileTemp
	mov	edi,OFFSET szFile
	rep movsb

;Set the text for the Main window title bar
	xor	esi,esi
	mov	DWORD PTR [szFileTemp],esi	;clear for next OPENFILENAME
	call	FileNAME

;Set the state for the File Close menu item
	mov	[miiFC.fState],MFS_ENABLED

	push	OFFSET miiFC		;pMENUITEMINFO
	push	FALSE			;fByPosition
	push	IDM_CLOSE		;uItem
	push	[hMenu]			;hMenu
	call	[SetMenuItemInfo]	;USER

;View the file
	call	ViewFILE
Return:
	ret
Error:
;Close the file
	call	FileUNMAP

;Display "Ready" on the status bar
	mov	esi,OFFSET szReady
	call	StatusUPDATE

	jmp	Return
FileOPENING ENDP

	ALIGN	4
FileCLOSE PROC
;Display "Closing..." on the status bar
	mov	esi,OFFSET szClosing
	call	StatusUPDATE

;Close the file
	call	FileUNMAP

;Set the text for the Main window title bar to the default
	mov	esi,OFFSET szTitle
	call	FileNAME

;Disable the File Close menu item
	mov	[miiFC.fState],MFS_DISABLED

	push	OFFSET miiFC		;pMENUITEMINFO
	push	FALSE			;fByPosition
	push	IDM_CLOSE		;uItem
	push	[hMenu]			;hMenu
	call	[SetMenuItemInfo]	;USER

;Display "Ready" on the status bar
	mov	esi,OFFSET szReady
	call	StatusUPDATE

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
FileCLOSE ENDP

;;
;;	MEMORY MAPPED FILE MANAGEMENT
;;

	.DATA?
hFile		HANDLE	?
hMapFile	HANDLE	?
pMapFile	DWORD	?
cbFile		DWORD	?

	.CODE
FileMAP	PROC
;Open the file
	push	0			;hTemplateFile
	push	FILE_ATTRIBUTE_NORMAL	;dwFlagsAndAttributes
	push	OPEN_EXISTING		;dwCreationDisposition
	push	0			;pSecurityAttributes
	push	FILE_SHARE_READ		;dwShareMode
	push	GENERIC_READ		;dwDesiredAccess
	push	OFFSET szFileTemp	;pFileName
	call	[CreateFile]		;KERNEL

	cmp	eax,INVALID_HANDLE_VALUE
	je	Error

	mov	[hFile],eax

;Create file mapping
	push	0			;pName
	push	0			;dwMaximumSizeLow
	push	0			;dwMaximumSizeHigh
	push	PAGE_READONLY		;fProtect
	push	0			;pAttributes
	push	eax			;hFile
	call	[CreateFileMapping]	;KERNEL

	test	eax,eax
	jz	Error

	mov	[hMapFile],eax

;Map view of file
	push	0			;dwNumberOfBytesToMap
	push	0			;dwFileOffsetLow
	push	0			;dwFileOffsetHigh
	push	FILE_MAP_READ		;dwDesiredAccess
	push	eax			;hFileMappingObject
	call	[MapViewOfFile]		;KERNEL

	test	eax,eax
	jz	Error

	mov	[pMapFile],eax

;Get the file size
	xor	eax,eax
	mov	[cbFile],eax

	push	0			;pFileSizeHigh
	push	[hFile]			;hFile
	call	[GetFileSize]		;KERNEL

	cmp	eax,0FFFFFFFFh
	je	Error

	mov	[cbFile],eax	;return EAX=cbFile
Return:
	ret
Error:
;Close the file
	call	FileUNMAP	;returns EAX=0
	jmp	Return
FileMAP	ENDP

	ALIGN	4
FileUNMAP PROC
;Unmap view of file
	mov	eax,[pMapFile]
	test	eax,eax
	jz	@F

	push	eax			;pBaseAddress
	call	[UnmapViewOfFile]	;KERNEL

	xor	eax,eax
	mov	[pMapFile],eax
@@:
;Close file mapping
	mov	eax,[hMapFile]
	test	eax,eax
	jz	@F

	push	eax			;hObject
	call	[CloseHandle]		;KERNEL

	xor	eax,eax
	mov	[hMapFile],eax
@@:
;Close the file
	mov	eax,[hFile]
	test	eax,eax
	jz	@F

	push	eax			;hObject
	call	[CloseHandle]		;KERNEL

	xor	eax,eax
	mov	[hFile],eax
@@:
	ret			;return 0
FileUNMAP ENDP

;;
;;	VIEW MENU COMMANDS
;;

	.CODE
ViewTB	PROC
;Switch state of ToolBar
	xor	[fOptions],1	;ToolBar bit
	mov	esi,OFFSET miiTB
	mov	eax,SW_HIDE
	xor	[esi+MENUITEMINFO.fState],MFS_CHECKED
	jz	@F

	mov	eax,SW_SHOW
@@:
;Set new show state and menu item info
	push	eax			;nCmdShow
	push	[hToolBar]		;hWnd
	call	[ShowWindow]		;USER

	push	esi			;pMENUITEMINFO
	push	FALSE			;fByPosition
	push	IDM_TOOLBAR		;uItem
	push	[hMenu]			;hMenu
	call	[SetMenuItemInfo]	;USER

;Update display
	call	MainCHANGED

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
ViewTB	ENDP

	ALIGN	4
ViewSB	PROC
;Switch state of StatusBar
	xor	[fOptions],2	;StatusBar bit
	mov	esi,OFFSET miiSB
	mov	eax,SW_HIDE
	xor	[esi+MENUITEMINFO.fState],MFS_CHECKED
	jz	@F

	mov	eax,SW_SHOW
@@:
;Set new show state and menu item info
	push	eax			;nCmdShow
	push	[hStatusBar]		;hWnd
	call	[ShowWindow]		;USER

	push	esi			;pMENUITEMINFO
	push	FALSE			;fByPosition
	push	IDM_STATUSBAR		;uItem
	push	[hMenu]			;hMenu
	call	[SetMenuItemInfo]	;USER

;Update display
	call	MainCHANGED

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
ViewSB	ENDP

	ALIGN	4
ViewTV	PROC
;Switch state of TreeView
	xor	[fOptions],4	;TreeView bit
	mov	edi,OFFSET miiS
	mov	esi,OFFSET miiTV
	mov	eax,SW_HIDE
	xor	[edi+MENUITEMINFO.fState],MFS_DISABLED
	xor	[esi+MENUITEMINFO.fState],MFS_CHECKED
	jz	@F

	mov	eax,SW_SHOW
@@:
;Set new show state and menu item info
	push	eax			;nCmdShow
	push	[hTreeView]		;hWnd
	call	[ShowWindow]		;USER

	push	esi			;pMENUITEMINFO
	push	FALSE			;fByPosition
	push	IDM_TREEVIEW		;uItem
	push	[hMenu]			;hMenu
	call	[SetMenuItemInfo]	;USER

	push	edi			;pMENUITEMINFO
	push	FALSE			;fByPosition
	push	IDM_SPLIT		;uItem
	push	[hMenu]			;hMenu
	call	[SetMenuItemInfo]	;USER

;Update display
	call	MainCHANGED

;IF TreeView is visible THEN set keyboard focus to it ELSE to View window
	mov	ecx,[fOptions]
	mov	eax,[hwndView]
	test	ecx,4		;TreeView bit
	jz	@F

	mov	eax,[hTreeView]
@@:
	push	eax			;hWnd
	call	[SetFocus]		;USER

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
ViewTV	ENDP

;;
;;	FONT MANAGEMENT
;;

	.DATA
lfView	LOGFONT	<16, 0, 0, 0, FW_NORMAL, 0, 0, 0, 0, 0, 0,\
		PROOF_QUALITY, FIXED_PITCH OR FF_MODERN, "Arial">

	.DATA?
cf	CHOOSEFONT	<>
hFont		HFONT	?
hOldFont	HFONT	?
cyChar		DWORD	?
cxChar		DWORD	?

	.CODE
ViewFONT PROC
;Choose a new Font
	mov	ebx,OFFSET cf
	mov	ecx,SIZEOF(CHOOSEFONT)
	mov	eax,[hwndMain]
	mov	[ebx+CHOOSEFONT.lStructSize],ecx
	mov	[ebx+CHOOSEFONT.hwndOwner],eax
	mov	[ebx+CHOOSEFONT.lpLogFont],OFFSET lfView
	mov	[ebx+CHOOSEFONT.Flags],CF_INITTOLOGFONTSTRUCT OR CF_BOTH	;CF_SCREENFONTS

	push	ebx			;pCHOOSEFONT
	call	[ChooseFont]		;COMDLG

	test	eax,eax
	jz	Return

;Restore previous Font and delete current Font
	push	[hOldFont]		;hgdiobj
	push	[hdcView]		;hdc
	call	[SelectObject]		;USER

	push	eax			;hObject
	call	[DeleteObject]		;USER

;Update windows with new Font
	call	FontUPDATE

	xor	eax,eax		;return 0 - message processed, clear carry flag
Return:
	ret
ViewFONT ENDP

	ALIGN 4
FontUPDATE PROC
;Create new Font
	push	OFFSET lfView		;pLOGFONT
	call	[CreateFontIndirect]	;GDI

	test	eax,eax		;EAX=hFont
	jz	Return

	mov	[hFont],eax

;Select new Font into View window device context
	mov	esi,[hdcView]

	push	eax			;hgdiobj
	push	esi			;hDC
	call	[SelectObject]		;GDI

	mov	[hOldFont],eax

;Get height of characters
	sub	esp,SIZEOF(TEXTMETRIC)	;LOCAL ESP=OFFSET tm

	push	esp			;ptm
	push	esi			;hdc
	call	[GetTextMetrics]	;GDI

	mov	eax,[esp+TEXTMETRIC.tmHeight]
	mov	[cyChar],eax
	add	esp,SIZEOF(TEXTMETRIC)	;LOCAL tm removed

;Notify TreeView of new Font
	push	TRUE			;lParam	- TRUE to redraw
	push	[hFont]			;wParam - hFont
	push	WM_SETFONT		;Msg
	push	[hTreeView]		;hWnd
	call	[SendMessage]		;USER

;Update View window with new Font
	push	TRUE			;bErase - erase background
	push	OFFSET rcView		;pRECT
	push	[hwndView]		;hWnd
	call	[InvalidateRect]	;USER
Return:
	ret
FontUPDATE ENDP

;;
;;	HELP MENU COMMANDS
;;

	.CONST
szHelpFile BYTE	"Skeleton.chm",0

	.CODE
HelpTOPICS PROC
	push	0	       		;dwData
	push	HH_DISPLAY_TOPIC	;uCommand
	push	OFFSET szHelpFile	;pszFile
	push	[hWnd]	 		;hwndCaller
	call	[HtmlHelp]		;HTMLHELP

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
HelpTOPICS ENDP

	ALIGN	4
HelpABOUT PROC
	push	0	       		;dwInitParam
	push	OFFSET AboutDLG		;pDialogFunc
	push	[hWnd]	 		;hWndParent
	push	IDD_ABOUT		;pTemplateName - integer resource identifierID
	push	[hInst]	       		;hInstance
	call	[DialogBoxParam]	;USER

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
HelpABOUT ENDP

	ALIGN	4
AboutDLG PROC
	push	ebp
	mov	ebp,esp	;hWnd=EBP+08h, uMsg=EBP+0Ch, wParam=EBP+10h, lParam=EBP+14h

	mov	eax,[uMsg]

	cmp	eax,WM_INITDIALOG
	je	Processed	;E to process - no initializing required

	cmp	eax,WM_COMMAND
	je	Commands
Default:
	xor	eax,eax		;return FALSE for message not processed
	jmp	Return
Commands:
	mov	eax,[wParam]
	and	eax,0FFFFh
	cmp	eax,IDOK
	je	Done

	cmp	eax,IDCANCEL
	je	Done

	jmp	Default
Done:
	push	TRUE			;nResult
	push	[hWnd]			;hDlg
	call	[EndDialog]		;USER
Processed:
	mov	eax,TRUE	;return TRUE for message processed
Return:
	mov	esp,ebp
	pop	ebp
	ret	10h
AboutDLG ENDP

;;
;;	VIEW WINDOW CREATION
;;

	.CONST
szViewClass	BYTE	"View",0,0,0,0

	.DATA?
hwndView HANDLE	?
hdcView	HDC	?

	.CODE
ViewINIT PROC
;Register View window class
	sub	esp,SIZEOF(WNDCLASSEX)	;LOCAL ESP=OFFSET wcex

	xor	eax,eax		;EAX=0
	mov	ebx,[hInst]	;EBX=hInst

	mov	[esp+WNDCLASSEX.cbSize],SIZEOF(WNDCLASSEX)
	mov	[esp+WNDCLASSEX.style],CS_OWNDC
	mov	[esp+WNDCLASSEX.lpfnWndProc],OFFSET ViewWND
	mov	[esp+WNDCLASSEX.cbClsExtra],eax
	mov	[esp+WNDCLASSEX.cbWndExtra],eax
	mov	[esp+WNDCLASSEX.hInstance],ebx
	mov	[esp+WNDCLASSEX.hIcon],eax
	mov	[esp+WNDCLASSEX.hIconSm],eax

	push	LR_DEFAULTSIZE OR LR_SHARED	;fuLoad
	push	0			;cyDesired - uses default
	push	0			;cxDesired - uses default
	push	IMAGE_CURSOR		;uType
	push	OCR_NORMAL		;pszName - image identifier
	push	0			;hinst - OEM image
	call	[LoadImage]		;USER

	mov	[esp+WNDCLASSEX.hCursor],eax
	mov	[esp+WNDCLASSEX.hbrBackground],COLOR_WINDOW + 1
	mov	[esp+WNDCLASSEX.lpszMenuName],IDM_MENU
	mov	[esp+WNDCLASSEX.lpszClassName],OFFSET szViewClass

	push	esp			;pWNDCLASSEX
	call	[RegisterClassEx]	;USER

	add	esp,SIZEOF(WNDCLASSEX)	;LOCAL wcex removed

	test	eax,eax
	jz	Return

;Create the View window
	xor	eax,eax		;EAX=0

	push	eax			;pParam
	push	ebx			;hInstance
	push	ID_VIEW			;hMenu - window identifier
	push	[hwndMain]		;hWndParent
	push	eax			;nHeight
	push	eax			;nWidth
	push	eax			;y
	push	eax			;x
	push	WS_CHILD OR WS_CLIPSIBLINGS OR WS_VISIBLE OR WS_VSCROLL OR WS_HSCROLL ;dwStyle
	push	eax			;pWindowName
	push	OFFSET szViewClass	;pClassName
	push	WS_EX_CLIENTEDGE OR WS_EX_NOPARENTNOTIFY	;dwExStyle
	call	[CreateWindowEx]	;USER

	test 	eax,eax		;EAX=hwndView
	jz	Return

	mov	[hwndView],eax

;Get CS_OWNDC for the View window and update Font
	push	eax			;hWnd
	call	[GetDC]			;USER

	mov	[hdcView],eax

	call	FontUPDATE

	xor	eax,eax
	inc	eax		;return non-zero to continue
Return:
	ret
ViewINIT ENDP

;;
;;	VIEW WINDOW MESSAGES
;;

       	.CONST
ViewMsg	DWORD	WM_PAINT, WM_KEYDOWN, WM_WINDOWPOSCHANGED
	DWORD	ViewWM_PAINT, ViewWM_KEYDOWN, ViewWM_WINDOWPOSCHANGED

	.CODE
ViewWND	PROC
	push	ebp
	mov	ebp,esp	;hWnd=EBP+08h, uMsg=EBP+0Ch, wParam=EBP+10h, lParam=EBP+14h

	push	ebx
	push	esi
	push	edi

;IF message is not found
	mov	eax,[uMsg]
	mov	edi,OFFSET   ViewMsg
	mov	ecx,LENGTHOF ViewMsg
	repne scasd
	je	Process

;THEN let DefWindowProc handle this message
Default:
	push	[lParam]		;lParam
	push	[wParam]		;wParam
	push	[uMsg]			;uMsg
	push	[hWnd]			;hWnd
	call	[DefWindowProc]		;USER

	jmp	Return

;ELSE process this message possibly setting carry flag for default processing
	ALIGN 4
Process:
	call	DWORD PTR [edi+(SIZEOF ViewMsg-4)]
	jc	Default
Return:
	pop	edi
	pop	esi
	pop	ebx

	mov	esp,ebp
	pop	ebp
	ret	10h
ViewWND	ENDP

;;
;;	VIEW WINDOW PLACEMENT
;;

	.DATA?
rcView	RECT	<>		;View window client area

	.CODE
ViewWM_WINDOWPOSCHANGED PROC
;Get client area of View window
	push	OFFSET rcView		;pRECT
	push	[hwndView]		;hWnd
	call	[GetClientRect]		;USER

	;;****  OTHER SIZE/POSITION PROCESSING  ****

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
ViewWM_WINDOWPOSCHANGED ENDP

;;
;;	OTHER VIEW WINDOW MESSAGES
;;

	.CODE
ViewWM_PAINT PROC
	sub	esp,SIZEOF(PAINTSTRUCT)	;LOCAL ESP=OFFSET ps

	push	esp			;pPAINTSTRUCT
	push	[hwndView]		;hWnd
	call	[BeginPaint]		;USER

	;;****  PAINT CLIENT AREA  ****

	push	esp			;pPAINTSTRUCT
	push	[hwndView]		;hWnd
	call	[EndPaint]		;USER
Return:
	add	esp,SIZEOF(PAINTSTRUCT)	;LOCAL ps removed

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
ViewWM_PAINT ENDP

	ALIGN 4
ViewWM_KEYDOWN PROC
	mov	eax,[wParam]	;virtual-key code

	cmp	eax,VK_TAB
	je	KeyTab

	stc		;set carry flag for default processing
	jmp	Return

;TAB key sets the TreeView window to have the keyboard focus
KeyTab:
	mov	eax,[hTreeView]
	mov	[hwndFocus],eax

	push	eax			;hWnd
	call	[SetFocus]		;USER
Return0:
	xor	eax,eax		;return 0 - message processed, clear carry flag
Return:
	ret
ViewWM_KEYDOWN ENDP

	ALIGN 4
ViewFILE PROC

	;;**** OTHER FILE PROCESSING ****

;Update the client area of the View window
	push	TRUE			;bErase
	push	OFFSET rcView		;pRect
	push	[hwndView]		;hWnd
	call	[InvalidateRect]	;USER

;Display "Ready" on the status bar
	mov	esi,OFFSET szReady
	call	StatusUPDATE

	ret
ViewFILE ENDP

	END