;;=============================================================================
;;	This file contains a subset of the
;;	Microsoft Win32 API Constants, Structures, and Functions
;;	converted from the Platform SDK Header and Library files for MASM
;;=============================================================================

INCLUDELIB User32.Lib

;;=============================================================================
;;	Winuser.h
;;=============================================================================

SB_HORZ		EQU 0h
SB_VERT		EQU 1h
SB_CTL		EQU 2h
SB_BOTH		EQU 3h

SB_LINEUP	EQU 0h
SB_LINELEFT	EQU 0h
SB_LINEDOWN	EQU 1h
SB_LINERIGHT	EQU 1h
SB_PAGEUP	EQU 2h
SB_PAGELEFT	EQU 2h
SB_PAGEDOWN	EQU 3h
SB_PAGERIGHT	EQU 3h
SB_THUMBPOSITION EQU 4h
SB_THUMBTRACK	EQU 5h
SB_TOP		EQU 6h
SB_LEFT		EQU 6h
SB_BOTTOM	EQU 7h
SB_RIGHT	EQU 7h
SB_ENDSCROLL	EQU 8h

SW_HIDE		EQU 00h
SW_SHOWNORMAL	EQU 01h
SW_SHOWMINIMIZED EQU 02h
SW_SHOWMAXIMIZED EQU 03h
SW_SHOW		EQU 05h
SW_RESTORE	EQU 09h
SW_SHOWDEFAULT	EQU 0Ah

VK_TAB		EQU 09h
VK_RETURN	EQU 0Dh
VK_SHIFT	EQU 10h
VK_CONTROL	EQU 11h
VK_ESCAPE	EQU 1Bh
VK_PRIOR	EQU 21h
VK_NEXT		EQU 22h
VK_END		EQU 23h
VK_HOME		EQU 24h
VK_LEFT		EQU 25h
VK_UP		EQU 26h
VK_RIGHT	EQU 27h
VK_DOWN		EQU 28h

WNDCLASSEX	STRUCT
 cbSize		DD ?
 style		DD ?
 lpfnWndProc	DD ?
 cbClsExtra	DD ?
 cbWndExtra	DD ?
 hInstance	DD ?
 hIcon		DD ?
 hCursor	DD ?
 hbrBackground	DD ?
 lpszMenuName	DD ?
 lpszClassName	DD ?
 hIconSm	DD ?
WNDCLASSEX	ENDS

MSG		STRUCT
 hwnd		DD ?
 message	DD ?
 wParam		DD ?
 lParam		DD ?
 time		DD ?
 pt		POINT <>
MSG		ENDS

GWL_WNDPROC	EQU -4
GWL_HINSTANCE	EQU -6
GWL_HWNDPARENT	EQU -8
GWL_ID		EQU -12
GWL_STYLE	EQU -16
GWL_EXSTYLE	EQU -20
GWL_USERDATA	EQU -21

WM_CREATE	EQU 0001h
WM_DESTROY	EQU 0002h
WM_MOVE		EQU 0003h
WM_SIZE		EQU 0005h
WM_ACTIVATE	EQU 0006h

WA_INACTIVE	EQU 0000h
WA_ACTIVE	EQU 0001h
WA_CLICKACTIVE	EQU 0002h

WM_SETFOCUS	EQU 0007h
WM_KILLFOCUS	EQU 0008h
WM_SETTEXT	EQU 000Ch
WM_PAINT	EQU 000Fh
WM_CLOSE	EQU 0010h
WM_ERASEBKGND	EQU 0014h
WM_SYSCOLORCHANGE EQU 0015h
WM_SETTINGCHANGE EQU 001Ah
WM_CANCELMODE	EQU 001Fh
WM_SETCURSOR	EQU 0020h
WM_SETFONT	EQU 0030h
WM_GETFONT	EQU 0031h
WM_WINDOWPOSCHANGED	EQU 0047h
WM_NOTIFY	EQU 004Eh
WM_HELP		EQU 0053h
WM_KEYDOWN	EQU 0100h
WM_CHAR		EQU 0102h
WM_INITDIALOG	EQU 0110h
WM_COMMAND	EQU 0111h
WM_TIMER	EQU 0113h
WM_HSCROLL	EQU 0114h
WM_VSCROLL	EQU 0115h
WM_MENUSELECT	EQU 011Fh
WM_CTLCOLORDLG	EQU 0136h
WM_MOUSEMOVE	EQU 0200h
WM_LBUTTONDOWN	EQU 0201h
WM_LBUTTONUP	EQU 0202h
WM_LBUTTONDBLCLK EQU 0203h
WM_RBUTTONDOWN	EQU 0204h
WM_RBUTTONUP	EQU 0205h
WM_RBUTTONDBLCLK EQU 0206h
WM_MBUTTONDOWN	EQU 0207h
WM_MBUTTONUP	EQU 0208h
WM_MBUTTONDBLCLK EQU 0209h
WM_MOUSEWHEEL	EQU 020Ah

WHEEL_DELTA	EQU 120
WHEEL_PAGESCROLL EQU  0FFFFh

WM_SIZING	EQU 0214h
WM_ENTERSIZEMOVE EQU 0231h
WM_DROPFILES	EQU 0233h
WM_CUT		EQU 0300h
WM_COPY		EQU 0301h
WM_PASTE	EQU 0302h
WM_CLEAR	EQU 0303h
WM_UNDO		EQU 0304h
WM_USER		EQU 0400h

SIZE_RESTORED	EQU 0h
SIZE_MINIMIZED	EQU 1h
SIZE_MAXIMIZED	EQU 2h
SIZE_MAXSHOW	EQU 3h
SIZE_MAXHIDE	EQU 4h

WINDOWPOS	STRUCT
 hwnd		DD ?
 hwndInsertAfter DD ?
 x		DD ?
 y		DD ?
 _cx		DD ?
 cy		DD ?
 flags		DD ?
WINDOWPOS	ENDS

MK_LBUTTON	EQU 01h
MK_RBUTTON	EQU 02h
MK_SHIFT	EQU 04h
MK_CONTROL	EQU 08h
MK_MBUTTON	EQU 10h

WS_POPUP	EQU 80000000h
WS_CHILD	EQU 40000000h
WS_MINIMIZE	EQU 20000000h
WS_VISIBLE	EQU 10000000h
WS_CLIPSIBLINGS	EQU 04000000h
WS_CLIPCHILDREN	EQU 02000000h
WS_MAXIMIZE	EQU 01000000h
WS_CAPTION	EQU 00C00000h
WS_BORDER	EQU 00800000h
WS_DLGFRAME	EQU 00400000h
WS_VSCROLL	EQU 00200000h
WS_HSCROLL	EQU 00100000h
WS_SYSMENU	EQU 00080000h
WS_SIZEBOX	EQU 00040000h
WS_GROUP	EQU 00020000h
WS_TABSTOP	EQU 00010000h
WS_MINIMIZEBOX	EQU 000020000h
WS_MAXIMIZEBOX	EQU 000010000h
WS_OVERLAPPEDWINDOW	EQU 000CF0000h
WS_EX_NOPARENTNOTIFY	EQU 000000004h
WS_EX_ACCEPTFILES	EQU 000000010h
WS_EX_WINDOWEDGE	EQU 000000100h
WS_EX_CLIENTEDGE	EQU 000000200h
WS_EX_OVERLAPPEDWINDOW	EQU WS_EX_WINDOWEDGE + WS_EX_CLIENTEDGE

CS_VREDRAW		EQU 00001h
CS_HREDRAW		EQU 00002h
CS_OWNDC		EQU 00020h
CS_PARENTDC		EQU 00080h
CS_BYTEALIGNWINDOW 	EQU 02000h

BDR_RAISEDOUTER	EQU 01h
BDR_SUNKENOUTER	EQU 02h
BDR_RAISEDINNER	EQU 04h
BDR_SUNKENINNER	EQU 08h
EDGE_RAISED	EQU BDR_RAISEDOUTER + BDR_RAISEDINNER
EDGE_SUNKEN	EQU BDR_SUNKENOUTER + BDR_SUNKENINNER
EDGE_ETCHED	EQU BDR_SUNKENOUTER + BDR_RAISEDINNER
EDGE_BUMP	EQU BDR_RAISEDOUTER + BDR_SUNKENINNER
BF_LEFT		EQU 01h
BF_TOP		EQU 02h
BF_RIGHT	EQU 04h
BF_BOTTOM	EQU 08h
BF_RECT		EQU BF_LEFT + BF_TOP + BF_RIGHT + BF_BOTTOM

PAINTSTRUCT	STRUCT
 hdc		DD ?
 fErase		DD ?
 rcPaint	RECT <>
 fRestore	DD ?
 fIncUpdate	DD ?
 rgbReserved	DB 32 DUP (?)
PAINTSTRUCT	ENDS

WINDOWPLACEMENT	STRUCT
 cbSize		DD ?
 flags		DD ?
 showCmd	DD ?
 ptMinPosition	POINT <>
 ptMaxPosition	POINT <>
 rcNormalPosition RECT <>
WINDOWPLACEMENT	ENDS

WPF_SETMINPOSITION	EQU 01h
WPF_RESTORETOMAXIMUM	EQU 02h

NMHDR		STRUCT
 hwndFrom	DD ?
 idFrom		DD ?
 code		DD ?
NMHDR		ENDS

PM_NOREMOVE	EQU 00h
PM_REMOVE	EQU 01h
PM_NOYIELD	EQU 02h

CW_USEDEFAULT	EQU 80000000h
HWND_DESKTOP	EQU 0h

SWP_NOSIZE	EQU 01h
SWP_NOMOVE	EQU 02h
SWP_NOZORDER	EQU 04h
SWP_NOREDRAW	EQU 08h
SWP_NOACTIVATE	EQU 10h
SWP_FRAMECHANGED EQU 20h
SWP_SHOWWINDOW	EQU 40h
SWP_HIDEWINDOW	EQU 80h
SWP_DRAWFRAME	EQU SWP_FRAMECHANGED
SWP_NOSENDCHANGING EQU 400h
HWND_TOP	EQU 000h

DLGTEMPLATE	STRUCT
 style		DD ?
 dwExtendedStyle DD ?
 cdit		DW ?
 x		DW ?
 y		DW ?
 nx		DW ?
 ny		DW ?
DLGTEMPLATE	ENDS

DLGWINDOWEXTRA	EQU 00000001Eh

SM_CXSCREEN	EQU 000h
SM_CYSCREEN	EQU 001h
SM_CXVSCROLL	EQU 002h
SM_CYHSCROLL	EQU 003h
SM_CXFULLSCREEN	EQU 010h
SM_CYFULLSCREEN	EQU 011h

MIIM_STATE	EQU 01h
MIIM_ID		EQU 02h
MIIM_SUBMENU	EQU 04h
MIIM_CHECKMARKS	EQU 08h
MIIM_TYPE	EQU 10h
MIIM_DATA	EQU 20h

MENUITEMINFO	STRUCT
 cbSize		DD ?
 fMask		DD ?
 fType		DD ?
 fState		DD ?
 wID		DD ?
 hSubMenu	DD ?
 hbmpChecked	DD ?
 hbmpUnchecked	DD ?
 dwItemData	DD ?
 dwTypeData	DD ?
 cch		DD ?
MENUITEMINFO	ENDS

RDW_INVALIDATE		EQU 0001h
RDW_INTERNALPAINT	EQU 0002h
RDW_ERASE		EQU 0004h
RDW_VALIDATE		EQU 0008h
RDW_NOINTERNALPAINT	EQU 0010h
RDW_NOERASE		EQU 0020h
RDW_NOCHILDREN		EQU 0040h
RDW_ALLCHILDREN		EQU 0080h
RDW_UPDATENOW		EQU 0100h
RDW_ERASENOW		EQU 0200h
RDW_FRAME		EQU 0400h
RDW_NOFRAME		EQU 0800h

SW_SCROLLCHILDREN	EQU 1h
SW_INVALIDATE		EQU 2h
SW_ERASE		EQU 4h
SW_SMOOTHSCROLL		EQU 10h

MB_OK			EQU 0h
MB_OKCANCEL		EQU 1h
MB_ABORTRETRYIGNORE	EQU 2h
MB_YESNOCANCEL		EQU 3h
MB_YESNO		EQU 4h
MB_RETRYCANCEL		EQU 5h
MB_ICONSTOP		EQU 10h
MB_ICONERROR		EQU 10h
MB_ICONQUESTION		EQU 20h
MB_ICONWARNING		EQU 30h
MB_ICONINFORMATION	EQU 40h
MB_USERICON		EQU 80h

COLOR_SCROLLBAR		EQU 00h
COLOR_DESKTOP		EQU 01h
COLOR_ACTIVECAPTION	EQU 02h
COLOR_INACTIVECAPTION	EQU 03h
COLOR_MENU		EQU 04h
COLOR_WINDOW		EQU 05h
COLOR_WINDOWFRAME	EQU 06h
COLOR_MENUTEXT		EQU 07h
COLOR_WINDOWTEXT	EQU 08h
COLOR_CAPTIONTEXT	EQU 09h
COLOR_ACTIVEBORDER	EQU 0Ah
COLOR_INACTIVEBORDER	EQU 0Bh
COLOR_APPWORKSPACE	EQU 0Ch
COLOR_HIGHLIGHT		EQU 0Dh
COLOR_HIGHLIGHTTEXT	EQU 0Eh
COLOR_3DFACE		EQU 0Fh
COLOR_3DSHADOW		EQU 10h
COLOR_GRAYTEXT		EQU 11h
COLOR_BTNTEXT		EQU 12h
COLOR_INACTIVECAPTIONTEXT EQU 13h
COLOR_3DHIGHLIGHT	EQU 14h
COLOR_3DDKSHADOW	EQU 15h
COLOR_3DLIGHT		EQU 16h
COLOR_INFOTEXT		EQU 17h
COLOR_INFOBK		EQU 18h

MF_POPUP	EQU 00010h
MF_SYSMENU	EQU 02000h
MFT_SEPARATOR	EQU 00800h
MFS_DISABLED	EQU 00003h
MFS_UNCHECKED	EQU 00000h
MFS_CHECKED	EQU 00008h
MFS_ENABLED	EQU 00000h

SC_SIZE		EQU 0F000h
SC_MOVE		EQU 0F010h
SC_MINIMIZE	EQU 0F020h
SC_MAXIMIZE	EQU 0F030h
SC_CLOSE	EQU 0F060h
SC_RESTORE	EQU 0F120h

IDC_SIZEWE	EQU 07F84h
IDC_ARROW	EQU 07F00h

IMAGE_BITMAP		EQU 0000h
IMAGE_ICON		EQU 0001h
IMAGE_CURSOR		EQU 0002h
LR_LOADFROMFILE		EQU 0010h
LR_LOADTRANSPARENT	EQU 0020h
LR_DEFAULTSIZE		EQU 0040h
LR_LOADMAP3DCOLORS	EQU 1000h
LR_SHARED		EQU 8000h

OCR_NORMAL	EQU 32512
OCR_IBEAM	EQU 32513
OCR_WAIT	EQU 32514
OCR_SIZENWSE	EQU 32642
OCR_SIZENESW	EQU 32643
OCR_SIZEWE	EQU 32644
OCR_SIZENS	EQU 32645
OCR_SIZEALL	EQU 32646

IDOK		EQU 01h
IDCANCEL	EQU 02h
IDABORT		EQU 03h
IDRETRY		EQU 04h
IDIGNORE	EQU 05h
IDYES		EQU 06h
IDNO		EQU 07h
IDCLOSE		EQU 08h
IDHELP		EQU 09h

ES_LEFT		EQU 0000h
ES_CENTER	EQU 0001h
ES_RIGHT	EQU 0002h
ES_MULTILINE	EQU 0004h
ES_AUTOVSCROLL	EQU 0040h
ES_AUTOHSCROLL	EQU 0080h
ES_READONLY	EQU 0800h
ES_WANTRETURN	EQU 1000h
ES_NUMBER	EQU 2000h

EN_SETFOCUS	EQU 0100h

BM_GETCHECK	EQU 0F0h
BM_SETCHECK	EQU 0F1h
BM_CLICK	EQU 0F5h
BM_SETIMAGE	EQU 0F7h

BST_UNCHECKED	EQU 00h
BST_CHECKED	EQU 01h
BST_INDETERMINATE EQU 02h

SS_LEFT		EQU 00h
SS_CENTER	EQU 01h
SS_RIGHT	EQU 02h
SS_ICON		EQU 03h
SS_BLACKFRAME	EQU 07h

DS_MODALFRAME	EQU 0080h
DS_NOIDLEMSG	EQU 0100h
DS_3DLOOK	EQU 0004h
DS_CENTER	EQU 0800h
DS_CENTERMOUSE	EQU 1000h

CB_DELETESTRING	EQU 0144h
CB_INSERTSTRING	EQU 014Ah
CB_SETCURSEL	EQU 014Eh

SBS_HORZ		EQU 00h
SBS_VERT		EQU 01h
SBS_BOTTOMALIGN		EQU 04h
SBS_RIGHTALIGN		EQU 04h
SBS_SIZEBOX		EQU 08h
SBS_SIZEGRIP		EQU 10h
SBM_SETPOS		EQU 0E0h
SBM_GETPOS		EQU 0E1h
SBM_SETRANGE		EQU 0E2h
SBM_SETRANGEDRAW	EQU 0E6h
SBM_GETRANGE		EQU 0E3h
SBM_ENABLE_ARROWS	EQU 0E4h
SBM_SETSCROLLINFO	EQU 0E9h
SBM_GETSCROLLINFO	EQU 0EAh
SIF_RANGE		EQU 01h
SIF_PAGE		EQU 02h
SIF_POS			EQU 04h
SIF_DISABLENOSCROLL 	EQU 08h
SIF_TRACKPOS		EQU 10h
SIF_ALL			EQU SIF_RANGE OR SIF_PAGE OR SIF_POS OR SIF_TRACKPOS

SCROLLINFO	STRUCT
 cbSize		DD ?
 fMask		DD ?
 nMin		DD ?
 nMax		DD ?
 nPage		DD ?
 nPos		DD ?
 nTrackPos	DD ?
SCROLLINFO	ENDS

HELP_CONTEXT	EQU 01h
HELP_QUIT	EQU 02h
HELP_INDEX	EQU 03h
HELP_CONTENTS	EQU 03h
HELP_HELPONHELP	EQU 04h
HELP_CONTEXTMENU EQU 0Ah
HELP_FINDER	EQU 0Bh
HELP_WM_HELP	EQU 0Ch

SPI_GETDRAGFULLWINDOWS	EQU 38
SPI_GETWHEELSCROLLLINES	EQU 104

;;=============================================================================
;;	User32.Lib Functions
;;=============================================================================

API ActivateKeyboardLayout, 8
API AdjustWindowRect, 12
API AdjustWindowRectEx, 16
API AllowSetForegroundWindow, 4
API AnimateWindow, 12
API AnyPopup, 0
API AppendMenu, 16, %AW
API ArrangeIconicWindows, 4
API AttachThreadInput, 12
API BeginDeferWindowPos, 4
API BeginPaint, 8
API BlockInput, 4
API BringWindowToTop, 4
API BroadcastSystemMessage, 20, %AW
API CallMsgFilter, 8, %AW
API CallNextHookEx, 16
API CallWindowProc, 20, %AW
API CascadeChildWindows, 8
API CascadeWindows, 20
API ChangeClipboardChain, 8
API ChangeDisplaySettings, 8, %AW
API ChangeDisplaySettingsEx, 20, %AW
API ChangeMenu, 20, %AW
API CharLower, 4, %AW
API CharLowerBuff, 8, %AW
API CharNext, 4, %AW
API CharNextExA, 12
API CharPrev, 8, %AW
API CharPrevExA, 16
API CharToOem, 8, %AW
API CharToOemBuff, 12, %AW
API CharUpper, 4, %AW
API CharUpperBuff, 8, %AW
API CheckDlgButton, 12
API CheckMenuItem, 12
API CheckMenuRadioItem, 20
API CheckRadioButton, 16
API ChildWindowFromPoint, 12
API ChildWindowFromPointEx, 16
API ClientToScreen, 8
API ClipCursor, 4
API CloseClipboard, 0
API CloseDesktop, 4
API CloseWindow, 4
API CloseWindowStation, 4
API CopyAcceleratorTable, 12, %AW
API CopyIcon, 4
API CopyImage, 20
API CopyRect, 8
API CountClipboardFormats, 0
API CreateAcceleratorTable, 8, %AW
API CreateCaret, 16
API CreateCursor, 28
API CreateDesktop, 24, %AW
API CreateDialogIndirectParam, 20, %AW
API CreateDialogParam, 20, %AW
API CreateIcon, 28
API CreateIconFromResource, 16
API CreateIconFromResourceEx, 28
API CreateIconIndirect, 4
API CreateMDIWindow, 40, %AW
API CreateMenu, 0
API CreatePopupMenu, 0
API CreateWindowEx, 48, %AW
API CreateWindowStation, 16, %AW
API DdeAbandonTransaction, 12
API DdeAccessData, 8
API DdeAddData, 16
API DdeClientTransaction, 32
API DdeCmpStringHandles, 8
API DdeConnect, 16
API DdeConnectList, 20
API DdeCreateDataHandle, 28
API DdeCreateStringHandle, 12, %AW
API DdeDisconnect, 4
API DdeDisconnectList, 4
API DdeEnableCallback, 12
API DdeFreeDataHandle, 4
API DdeFreeStringHandle, 8
API DdeGetData, 16
API DdeGetLastError, 4
API DdeImpersonateClient, 4
API DdeInitialize, 16, %AW
API DdeKeepStringHandle, 8
API DdeNameService, 16
API DdePostAdvise, 12
API DdeQueryConvInfo, 12
API DdeQueryNextServer, 8
API DdeQueryString, 20, %AW
API DdeReconnect, 4
API DdeSetQualityOfService, 12
API DdeSetUserHandle, 12
API DdeUnaccessData, 4
API DdeUninitialize, 4
API DefDlgProc, 16, %AW
API DefFrameProc, 20, %AW
API DefMDIChildProc, 16, %AW
API DefWindowProc, 16, %AW
API DeferWindowPos, 32
API DeleteMenu, 12
API DestroyAcceleratorTable, 4
API DestroyCaret, 0
API DestroyCursor, 4
API DestroyIcon, 4
API DestroyMenu, 4
API DestroyWindow, 4
API DialogBoxIndirectParam, 20, %AW
API DialogBoxParam, 20, %AW
API DispatchMessage, 4, %AW
API DlgDirList, 20, %AW
API DlgDirListComboBox, 20, %AW
API DlgDirSelectComboBoxEx, 16, %AW
API DlgDirSelectEx, 16, %AW
API DragDetect, 12
API DragObject, 20
API DrawAnimatedRects, 16
API DrawCaption, 16
API DrawEdge, 16
API DrawFocusRect, 8
API DrawFrame, 16
API DrawFrameControl, 16
API DrawIcon, 16
API DrawIconEx, 36
API DrawMenuBar, 4
API DrawState, 40, %AW
API DrawText, 20, %AW
API DrawTextEx, 24, %AW
API EditWndProc, 16
API EmptyClipboard, 0
API EnableMenuItem, 12
API EnableScrollBar, 12
API EnableWindow, 8
API EndDeferWindowPos, 4
API EndDialog, 8
API EndMenu, 0
API EndPaint, 8
API EnumChildWindows, 12
API EnumClipboardFormats, 4
API EnumDesktopWindows, 12
API EnumDesktops, 12, %AW
API EnumDisplayDevices, 16, %AW
API EnumDisplayMonitors, 16
API EnumDisplaySettings, 12, %AW
API EnumDisplaySettingsEx, 16, %AW
API EnumProps, 8, %AW
API EnumPropsEx, 12, %AW
API EnumThreadWindows, 12
API EnumWindowStations, 8, %AW
API EnumWindows, 8
API EqualRect, 8
API ExcludeUpdateRgn, 8
API ExitWindowsEx, 8
API FillRect, 12
API FindWindow, 8, %AW
API FindWindowEx, 16, %AW
API FlashWindow, 8
API FlashWindowEx, 4
API FrameRect, 12
API FreeDDElParam, 8
API GetActiveWindow, 0
API GetAltTabInfo, 20, %AW
API GetAncestor, 8
API GetAsyncKeyState, 4
API GetCapture, 0
API GetCaretBlinkTime, 0
API GetCaretPos, 4
API GetClassInfo, 12, %AW
API GetClassInfoEx, 12, %AW
API GetClassLong, 8, %AW
API GetClassName, 12, %AW
API GetClassWord, 8
API GetClientRect, 8
API GetClipCursor, 4
API GetClipboardData, 4
API GetClipboardFormatName, 12, %AW
API GetClipboardOwner, 0
API GetClipboardSequenceNumber, 0
API GetClipboardViewer, 0
API GetComboBoxInfo, 8
API GetCursor, 0
API GetCursorInfo, 4
API GetCursorPos, 4
API GetDC, 4
API GetDCEx, 12
API GetDesktopWindow, 0
API GetDialogBaseUnits, 0
API GetDlgCtrlID, 4
API GetDlgItem, 8
API GetDlgItemInt, 16
API GetDlgItemText, 16, %AW
API GetDoubleClickTime, 0
API GetFocus, 0
API GetForegroundWindow, 0
API GetGUIThreadInfo, 8
API GetGuiResources, 8
API GetIconInfo, 8
API GetInputDesktop, 0
API GetInputState, 0
API GetKBCodePage, 0
API GetKeyNameText, 12, %AW
API GetKeyState, 4
API GetKeyboardLayout, 4
API GetKeyboardLayoutList, 8
API GetKeyboardLayoutName, 4, %AW
API GetKeyboardState, 4
API GetKeyboardType, 4
API GetLastActivePopup, 4
API GetLastInputInfo, 4
API GetListBoxInfo, 4
API GetMenu, 4
API GetMenuBarInfo, 16
API GetMenuCheckMarkDimensions, 0
API GetMenuContextHelpId, 4
API GetMenuDefaultItem, 12
API GetMenuInfo, 8
API GetMenuItemCount, 4
API GetMenuItemID, 8
API GetMenuItemInfo, 16, %AW
API GetMenuItemRect, 16
API GetMenuState, 12
API GetMenuString, 20, %AW
API GetMessage, 16, %AW
API GetMessageExtraInfo, 0
API GetMessagePos, 0
API GetMessageTime, 0
API GetMonitorInfo, 8, %AW
API GetMouseMovePointsEx, 20
API GetNextDlgGroupItem, 12
API GetNextDlgTabItem, 12
API GetOpenClipboardWindow, 0
API GetParent, 4
API GetPriorityClipboardFormat, 8
API GetProcessDefaultLayout, 4
API GetProcessWindowStation, 0
API GetProp, 8, %AW
API GetQueueStatus, 4
API GetScrollBarInfo, 12
API GetScrollInfo, 12
API GetScrollPos, 8
API GetScrollRange, 16
API GetShellWindow, 0
API GetSubMenu, 8
API GetSysColor, 4
API GetSysColorBrush, 4
API GetSystemMenu, 8
API GetSystemMetrics, 4
API GetTabbedTextExtent, 20, %AW
API GetThreadDesktop, 4
API GetTitleBarInfo, 8
API GetTopWindow, 4
API GetUpdateRect, 12
API GetUpdateRgn, 12
API GetUserObjectInformation, 20, %AW
API GetUserObjectSecurity, 20
API GetWindow, 8
API GetWindowContextHelpId, 4
API GetWindowDC, 4
API GetWindowInfo, 8
API GetWindowLong, 8, %AW
API GetWindowModuleFileName, 12, %AW
API GetWindowPlacement, 8
API GetWindowRect, 8
API GetWindowRgn, 8
API GetWindowText, 12, %AW
API GetWindowTextLength, 4, %AW
API GetWindowThreadProcessId, 8
API GetWindowWord, 8
API GrayString, 36, %AW
API HideCaret, 4
API HiliteMenuItem, 16
API IMPGetIME, 8, %AW
API IMPQueryIME, 4, %AW
API IMPSetIME, 8, %AW
API ImpersonateDdeClientWindow, 8
API InSendMessage, 0
API InSendMessageEx, 4
API InflateRect, 12
API InsertMenu, 20, %AW
API InsertMenuItem, 16, %AW
API IntersectRect, 12
API InvalidateRect, 12
API InvalidateRgn, 12
API InvertRect, 8
API IsCharAlpha, 4, %AW
API IsCharAlphaNumeric, 4, %AW
API IsCharLower, 4, %AW
API IsCharUpper, 4, %AW
API IsChild, 8
API IsClipboardFormatAvailable, 4
API IsDialogMessage, 8, %AW
API IsDlgButtonChecked, 8
API IsIconic, 4
API IsMenu, 4
API IsRectEmpty, 4
API IsWindow, 4
API IsWindowEnabled, 4
API IsWindowUnicode, 4
API IsWindowVisible, 4
API IsZoomed, 4
API KillTimer, 8
API LoadAccelerators, 8, %AW
API LoadBitmap, 8, %AW
API LoadCursor, 8, %AW
API LoadCursorFromFile, 4, %AW
API LoadIcon, 8, %AW
API LoadImage, 24, %AW
API LoadKeyboardLayout, 8, %AW
API LoadMenu, 8, %AW
API LoadMenuIndirect, 4, %AW
API LoadString, 16, %AW
API LockSetForegroundWindow, 4
API LockWindowUpdate, 4
API LockWorkStation, 0
API LookupIconIdFromDirectory, 8
API LookupIconIdFromDirectoryEx, 20
API MapDialogRect, 8
API MapVirtualKey, 8, %AW
API MapVirtualKeyEx, 12, %AW
API MapWindowPoints, 16
API MenuItemFromPoint, 16
API MessageBeep, 4
API MessageBox, 16, %AW
API MessageBoxEx, 20, %AW
API MessageBoxIndirect, 4, %AW
API ModifyMenu, 20, %AW
API MonitorFromPoint, 12
API MonitorFromRect, 8
API MonitorFromWindow, 8
API MoveWindow, 24
API MsgWaitForMultipleObjects, 20
API MsgWaitForMultipleObjectsEx, 20
API NotifyWinEvent, 16
API OemKeyScan, 4
API OemToChar, 8, %AW
API OemToCharBuff, 12, %AW
API OffsetRect, 12
API OpenClipboard, 4
API OpenDesktop, 16, %AW
API OpenIcon, 4
API OpenInputDesktop, 12
API OpenWindowStation, 12, %AW
API PackDDElParam, 12
API PaintDesktop, 4
API PeekMessage, 20, %AW
API PostMessage, 16, %AW
API PostQuitMessage, 4
API PostThreadMessage, 16, %AW
API PtInRect, 12
API RealChildWindowFromPoint, 12
API RealGetWindowClass, 12, %AW
API RedrawWindow, 16
API RegisterClass, 4, %AW
API RegisterClassEx, 4, %AW
API RegisterClipboardFormat, 4, %AW
API RegisterDeviceNotification, 12, %AW
API RegisterHotKey, 16
API RegisterWindowMessage, 4, %AW
API ReleaseCapture, 0
API ReleaseDC, 8
API RemoveMenu, 12
API RemoveProp, 8, %AW
API ReplyMessage, 4
API ReuseDDElParam, 20
API ScreenToClient, 8
API ScrollDC, 28
API ScrollWindow, 20
API ScrollWindowEx, 32
API SendDlgItemMessage, 20, %AW
API SendIMEMessageEx, 8, %AW
API SendInput, 12
API SendMessage, 16, %AW
API SendMessageCallback, 24, %AW
API SendMessageTimeout, 28, %AW
API SendNotifyMessage, 16, %AW
API SetActiveWindow, 4
API SetCapture, 4
API SetCaretBlinkTime, 4
API SetCaretPos, 8
API SetClassLong, 12, %AW
API SetClassWord, 12
API SetClipboardData, 8
API SetClipboardViewer, 4
API SetCursor, 4
API SetCursorPos, 8
API SetDebugErrorLevel, 4
API SetDeskWallpaper, 4
API SetDlgItemInt, 16
API SetDlgItemText, 12, %AW
API SetDoubleClickTime, 4
API SetFocus, 4
API SetForegroundWindow, 4
API SetKeyboardState, 4
API SetLastErrorEx, 8
API SetLayeredWindowAttributes, 16
API SetMenu, 8
API SetMenuContextHelpId, 8
API SetMenuDefaultItem, 12
API SetMenuInfo, 8
API SetMenuItemBitmaps, 20
API SetMenuItemInfo, 16, %AW
API SetMessageExtraInfo, 4
API SetMessageQueue, 4
API SetParent, 8
API SetProcessDefaultLayout, 4
API SetProcessWindowStation, 4
API SetProp, 12, %AW
API SetRect, 20
API SetRectEmpty, 4
API SetScrollInfo, 16
API SetScrollPos, 16
API SetScrollRange, 20
API SetShellWindow, 4
API SetSysColors, 12
API SetSystemCursor, 8
API SetThreadDesktop, 4
API SetTimer, 16
API SetUserObjectInformation, 16, %AW
API SetUserObjectSecurity, 12
API SetWinEventHook, 28
API SetWindowContextHelpId, 8
API SetWindowLong, 12, %AW
API SetWindowPlacement, 8
API SetWindowPos, 28
API SetWindowRgn, 12
API SetWindowText, 8, %AW
API SetWindowWord, 12
API SetWindowsHook, 8, %AW
API SetWindowsHookEx, 16, %AW
API ShowCaret, 4
API ShowCursor, 4
API ShowOwnedPopups, 8
API ShowScrollBar, 12
API ShowWindow, 8
API ShowWindowAsync, 8
API SubtractRect, 12
API SwapMouseButton, 4
API SwitchDesktop, 4
API SystemParametersInfo, 16, %AW
API TabbedTextOut, 32, %AW
API TileChildWindows, 8
API TileWindows, 20
API ToAscii, 20
API ToAsciiEx, 24
API ToUnicode, 24
API ToUnicodeEx, 28
API TrackMouseEvent, 4
API TrackPopupMenu, 28
API TrackPopupMenuEx, 24
API TranslateAccelerator, 12, %AW
API TranslateMDISysAccel, 8
API TranslateMessage, 4
API UnhookWinEvent, 4
API UnhookWindowsHook, 8
API UnhookWindowsHookEx, 4
API UnionRect, 12
API UnloadKeyboardLayout, 4
API UnpackDDElParam, 16
API UnregisterClass, 8, %AW
API UnregisterDeviceNotification, 4
API UnregisterHotKey, 8
API UpdateLayeredWindow, 36
API UpdateWindow, 4
API UserHandleGrantAccess, 12
API ValidateRect, 8
API ValidateRgn, 8
API VkKeyScan, 4, %AW
API VkKeyScanEx, 8, %AW
API WINNLSEnableIME, 8
API WINNLSGetEnableStatus, 4
API WINNLSGetIMEHotkey, 4
API WaitForInputIdle, 8
API WaitMessage, 0
API Win32PoolAllocationStats, 24
API WinHelp, 16, %AW
API WindowFromDC, 4
API WindowFromPoint, 8
API keybd_event, 16
API mouse_event, 20

wsprintfA PROTO C :DWORD,:VARARG
wsprintfW PROTO C :DWORD,:VARARG
IFDEF	UNICODE
  wsprintf TEXTEQU <wsprintfW>
ELSE
  wsprintf TEXTEQU <wsprintfA>
ENDIF

API wvsprintf, 12, %AW