;
;	________________________________________________________________
;
;	                         W32VINES.inc
;	                 Banyan VINES Header File V1.00
;	        05-17-1996 Sven B. Schreiber sbs@psbs.franken.de
;	                 This is Public Domain Software
;	________________________________________________________________
;
.386
;
;==============================================================================
;
;	DISCLAIMER
;
;==============================================================================
;
; This software is provided "as is" and any express or implied warranties,
; including, but not limited to, the implied warranties of merchantibility and
; fitness for a particular purpose are disclaimed. In no event shall the
; author Sven B. Schreiber be liable for any direct, indirect, incidental,
; special, exemplary, or consequential damages (including, but not limited to,
; procurement of substitute goods or services; loss of use, data, or profits;
; or business interruption) however caused and on any theory of liability,
; whether in contract, strict liability, or tort (including negligence or
; otherwise) arising in any way out of the use of this software, even if
; advised of the possibility of such damage.
;
;==============================================================================
;
;	CONSTANTS
;
;==============================================================================
;
STDA_RETRY		equ	100		;max number of stda retries
;
STDATYPE_USER		equ	0001h		;browse users
STDATYPE_NICKNAME	equ	0002h		;browse nicknames
STDATYPE_LIST		equ	0004h		;browse lists
STDATYPE_PRINT_SERVICE	equ	0008h		;browse print services
STDATYPE_FILE_SERVICE	equ	0010h		;browse file services
STDATYPE_MISC_SERVICE	equ	0020h		;browse miscellaneous services
STDATYPE_ALL		equ	0FFFh		;browse all services
;
STDATYPE_STANDARD	equ	STDATYPE_USER+STDATYPE_NICKNAME+STDATYPE_LIST
;
;------------------------------------------------------------------------------
;
MAINBODY		equ	 0		;main body text
ATTACH1			equ	 1		;attachment #01
ATTACH2			equ	 2		;attachment #02
ATTACH3			equ	 3		;attachment #03
ATTACH4			equ	 4		;attachment #04
ATTACH5			equ	 5		;attachment #05
ATTACH6			equ	 6		;attachment #06
ATTACH7			equ	 7		;attachment #07
ATTACH8			equ	 8		;attachment #08
ATTACH9			equ	 9		;attachment #09
ATTACH10		equ	10		;attachment #10
ATTACH11		equ	11		;attachment #11
ATTACH12		equ	12		;attachment #12
ATTACH13		equ	13		;attachment #13
;
VNS_MAX_FILES		equ	11		;max number of mail files
VNS_END_PARTS		equ	-1		;mail parts list terminator
;
;------------------------------------------------------------------------------
;
NOTPRESENT		equ	0		;item not present
PRESENT			equ	1		;item present
;
;------------------------------------------------------------------------------
;
UNDEFCONT		equ	'0'		;undefined contents
FREETXT1		equ	'1'		;free text using LF
FREETXT2		equ	'2'		;free text using CRLF
;
;------------------------------------------------------------------------------
;
MAXNAME			equ	  64		;max name length
MAXSUBSTR		equ	  64		;max subject length
MAXTRACE		equ	 256		;max trace info length
MAXREPLYTO		equ	 512 		;max reply-to address length
MAXFROMSTR		equ	  64		;max from address length
MAXADDRSTR		equ	1000		;max adress length
MAXIDLEN		equ	  14		;max message id length
MAXFOLDERNAME		equ	  13		;max folder name length
MAXPROFENTRY		equ	 256		;max profile eintry length
MAXMSGBUF		equ	1024		;max message buffer length
MAXBODYPART		equ	  14		;max number of body parts
MAXLABLEN		equ	 128		;max label length
;
;------------------------------------------------------------------------------
;
MA_NEW			equ	'0'		;message new
MA_UNREAD		equ	'1'		;message unread
MA_UNSENT		equ	'2'		;message unsent
MA_SENT			equ	'3'		;message sent
MA_UNRESOLVED		equ	'3'		;message sent
MA_OLD			equ	'4'		;message read
MA_READ			equ	'4'		;message read
MA_DELETED		equ	'5'		;message deleted
MA_EXPIRED		equ	'6'		;message expired
MA_RESOLVED		equ	'7'
MA_DEAD			equ	'9'
MA_NOTFOUND		equ	'?'
MA_RESTORE		equ	'R'
;
;------------------------------------------------------------------------------
;
MESCONFIRM		equ	'Y'		;use message confirmation
NOMESCONFIRM		equ	'N'		;no message confirmation
;
;------------------------------------------------------------------------------
;
LOW_PRIORITY		equ	'2'		;low priority
MED_PRIORITY		equ	'3'		;medium priority
HIGH_PRIORITY		equ	'4'		;high priority
;
;------------------------------------------------------------------------------
;
IPMES			equ	'M'		;standard message
STATUSMES		equ	'S'		;status message
UNDELIVMES		equ	'U'		;message undeliverable
;
;------------------------------------------------------------------------------
;
RECIPIENTTO		equ	1		;"to:" name list id
RECIPIENTCC		equ	2		;"cc:" name list id
RECIPIENTBCC		equ	3		;"bcc:" name list id
;
;==============================================================================
;
;	STRUCTURES
;
;==============================================================================
;
VNSLIBVERSION		struct
vlv_interface_version	WORD	0
vlv_vines_version	WORD	0
vlv_lib_edit_level	DWORD	0
vlv_lib_timestamp	DWORD	0
VNSLIBVERSION		ends
VNSLIBVERSION_		equ	2+2+4+4
;
;------------------------------------------------------------------------------
;
TIME			struct
time_gmt_seconds	DWORD	0
time_tz_off		WORD	0
time_tz			BYTE	4 dup (0)
TIME			ends
TIME_			equ	4+2+4
;
;------------------------------------------------------------------------------
;
BODYPARTINFO		struct
bpi_present		BYTE	0
bpi_bodypartId		BYTE	0
bpi_contentType		WORD	0
bpi_contentSubType	WORD	0
bpi_label		BYTE	MAXLABLEN dup (0)
bpi_contentAttributes	BYTE	10 dup (0)
BODYPARTINFO		ends
BODYPARTINFO_		equ	1+1+2+2+MAXLABLEN+10
;
;------------------------------------------------------------------------------
;
ENVELOPE		struct
env_from		BYTE	MAXFROMSTR dup (0)
env_forwarder		BYTE	MAXFROMSTR dup (0)
env_subject		BYTE	MAXSUBSTR dup (0)
env_traceinfo		BYTE	MAXTRACE dup (0)
env_status		BYTE	0
env_certified		BYTE	0
env_replyTo		BYTE	MAXREPLYTO dup (0)
env_priority		BYTE	0
env_creationDate	BYTE	TIME_ dup (0)
env_sendDate		BYTE	TIME_ dup (0)
env_messageType		BYTE	0
env_messageId		BYTE	MAXIDLEN dup (0)
env_expireDate		BYTE	TIME_ dup (0)
env_delivDate		BYTE	TIME_ dup (0)
env_alternateRecip	BYTE	MAXNAME dup (0)
env_deferDate		BYTE	TIME_ dup (0)
env_nondeliv		BYTE	0
ENVELOPE		ends
ENVELOPE_		equ	MAXFROMSTR+MAXFROMSTR+MAXSUBSTR+MAXTRACE+1+1+\
				MAXREPLYTO+1+TIME_+TIME_+1+MAXIDLEN+TIME_+\
				TIME_+MAXNAME+TIME_+1
;
;==============================================================================

