; Example mouse code (uses VBE) - switches to 640x480x256 mode, puts up
; a simple background and displays a clipped mouse cursor on the screen.
; Press escape once you've had enough
;
[BITS 32]
%include "Gaz\Dos\Macros\Mouse.mac"
%include "Gaz\Dos\Macros\Video.mac"
%include "Gaz\Dos\Macros\System.mac"
[section .text]
GLOBAL _Wdosxstart
_Wdosxstart:
	push	ds
	pop	es
	VBEInit 1				; initialise VBE subsystem, report information
	jc	near _end			; no VBE!
	VBESetMode 640,480,8,1			; try and set 640x480x256
	jnc	_init_vbe_mode_ok		; all cool?
	mov	edx,VESAErrorStr		; no, can't set mode!
	mov	ah,9
	int	$21
	jmp	_end
_init_vbe_mode_ok:
;
; Change the next line to MouseInit 640,480,1 and de-comment the line
; 'MouseGetState' below to try it without installing the mouse handler.
;
	MouseInit 640,480,0			; install the handler
	jnc	_init_mouse_ok			; all cool?
	mov	edx,MouseErrorStr		; no, can't detect mouse!
	mov	ah,9
	int	$21
	jmp	_end
_init_mouse_ok:
_init_ok:
	mov	edi,[_VESAScreen]		; put up a simple background
	mov	ecx,76800
	cmp	[_VESALFBDoubleFlag],dword 0
	je	_myloop
	shl	ecx,1
_myloop:
	mov	[edi],dword $0aabbccdd
	add	edi,4
	dec	ecx
	jnz	_myloop
;
; Change the ...32_8 to ...16_8 to use a 16x16 cursor
;
	MouseSetCursor32_8 _mymouse_cursor_default32_8	; setup a standard cursor
	MouseDraw32_8				; draw + undraw the cursor to start with
	MouseUnDraw32_8				; displaying it on the screen
	VBEDoScreen				; we do it twice in case we've got
	MouseDraw32_8				; a LFB + double-buffer running since if
	MouseUnDraw32_8				; we don't the other screen won't get
	VBEDoScreen				; updated properly
	MouseDraw32_8				; can start properly now, so draw the mouse in
_main_loop:
	MouseUnDraw32_8				; restore the original background
;
; De-comment the next line and change the 'MouseInit 640,480,0' to 'MouseInit 640,480,1' when
; initialising the mouse driver above to try it without the handler.
;
;	MouseGetState				; get the current mouse state
	MouseDraw32_8				; draw the cursor at it's new position
	VBEDoScreen				; display the screen
	mov	ah,6				; direct console I/O
	mov	dl,$0ff				; request input
	int	$21
	jz	_main_loop			; zero flag = input not ready
	cmp	al,$01b				; key there, is it escape?
	jne	_main_loop			; no, keep looping
_end:
	Exit					; exit
;
;-------------------------------------------------------------------------
;
[section .data]
	times ($$-$) & 31 db 0
VESAErrorStr	db 10,13,"Madness! Your graphics card doesn't support 640x480x256 mode!$"
MouseErrorStr	db 10,13,"No mouse detected, has the driver been installed?$"
;
;-------------------------------------------------------------------------
;
%include "Gaz\Dos\Includes\Routs.inc"