; CD-Audio subsystem
; by Gaz
;
%ifndef _MYCD
%define _MYCD
[BITS 32]
[section .bss]
_mycd_spare1		resd 1
_mycd_spare2		resd 1
_mycd_spare3		resd 1

_mycd_drive		resw 1		; drive number of first CD-ROM drive
_mycd_dosseg		resw 1		; segment of allocated DOS memory
_mycd_dossel		resw 1		; selector of allocated DOS memory
_mycd_doslin		resd 1		; linear address of allocated DOS memory

_mycd_ioctl:				; MSCDEX IO control command block
_mycd_ioctl_length	resb 1		; Request header - length of request header in bytes
_mycd_ioctl_SUC		resb 1		; Request header - SubUnitCode for minor devices
_mycd_ioctl_code	resb 1		; Request header - command code
_mycd_ioctl_status	resw 1		; Request header - status
_mycd_ioctl_reserved	resb 8		; Request header - reserved
_mycd_ioctl_descriptor	resb 1		; Media descriptor byte from BPB (0)
_mycd_ioctl_control_off	resw 1		; transfer address
_mycd_ioctl_control_seg	resw 1
_mycd_ioctl_tlength	resw 1		; number of bytes to transfer
_mycd_ioctl_sector	resw 1		; starting sector number (0)
_mycd_ioctl_volumeid	resd 1		; dword ptr to requested volume ID (0)

_mycd_control_block	resb 256	; control block

_mycd_dosoffset		equ _mycd_control_block - _mycd_ioctl

[section .data]
_mycd_flag		dd 0		; MSCDEX not detected yet
_mycd_loop_flag		dd 0		; don't loop tracks
_mycd_loop_start	dd 0		; start of loop (High Sierra Format)
_mycd_loop_length	dd 0		; length of loop (High Sierra Format)

[section .text]
;
;------------------------------------------------------------------------------------
;
; Call to initialise the routines. _mycd_flag holds the result - 0 on error (no MSCDEX,
; early MSCDEX version, no CD-ROM drive or DPMI error) or the MSCDEX version otherwise.
; Carry will be clear on success, set otherwise.
;
%ifdef _MYCD_INIT_MACRO
_mycd_init_2:
	push	eax			; save registers
	push	ebx
	push	ecx
	push	edx
	push	edi
	mov	dword [_RMR_SP], 0	; real-mode register structure stack pointer
	mov	[_mycd_dosseg],word 0
	mov	[_mycd_dossel],word 0
	mov	[_mycd_doslin],dword 0
	mov	ax,$100			; allocate some low memory
	mov	bx,32			; 512 bytes to allocate
	int	$31
	jc	near _mycd_init_error	; DPMI error!
	mov	[_mycd_dosseg],ax	; segment address
	mov	[_mycd_dossel],dx	; selector allocated
	mov	ecx,eax			; convert segment address to linear address
	and	ecx,0ffffh
	shl	ecx,4
	mov	[_mycd_doslin],ecx	; linear address of allocated memory
	mov	ax,$1500		; get number of CD-ROM drive letters
	xor	ebx,ebx
	int	$2f
	cmp	bx,0			; MSCDEX installed?
	je	_mycd_init_error	; no
	mov	[_mycd_drive],cx	; yes, get number of first CD-ROM drive
	mov	ax,$150c		; get MSCDEX version
	int	$2f
	cmp	bx,0			; early MSCDEX version?
	je	_mycd_init_error	; yes, don't use it
	and	ebx,$0ffff		; mask off top word
	mov	[_mycd_flag],eax	; flag installed
	pop	edi			; restore registers
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	clc				; flag success
	ret
_mycd_init_error:
	mov	[_mycd_flag],dword 0	; no MSCDEX or no CD-ROM drive
	pop	edi			; restore registers
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	stc				; flag error
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Call before exit to deallocate resources
;
%ifdef _MYCD_EXIT_MACRO
_mycd_exit_2:
	push	eax			; save registers
	push	edx
	CDStop				; stop the drive if it's playing
	cmp	[_mycd_dossel],word 0	; any memory allocated?
	je	_mycd_exit_end
	mov	ax,$101			; free allocated DOS memory
	mov	dx,[_mycd_dossel]
	int	$31
	mov	[_mycd_dossel],word 0	; no memory allocated
_mycd_exit_end:
	mov	[_mycd_flag],dword 0	; flag uninstalled
	pop	edx			; restore registers
	pop	eax
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Call to get the current volume.
;
%ifdef _MYCD_GET_VOLUME_MACRO
_mycd_get_volume_2:
	push	eax
	cmp	[_mycd_flag],dword 0		; MSCDEX installed?
	je	_mycd_get_volume_error		; no
	mov	[_mycd_ioctl_code],byte 3	; yes, IOCTL input
	mov	[_mycd_ioctl_length],byte _mycd_dosoffset	; length of IOCTL structure
	mov	[_mycd_control_block],byte 4	; audio channel info command code
	mov	[_mycd_ioctl_tlength],word 9	; 9 bytes to transfer
	call	_mycd_call_mscdex
	and	eax,$08000
	jnz	_mycd_get_volume_error
	xor	eax,eax
	mov	al,[_mycd_control_block + 2]	; assume all channels are the same
	mov	[_mycd_spare1],eax
	pop	eax
	clc					; flag success
	ret
_mycd_get_volume_error:
	pop	eax
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Call to set the volume.
;
%ifdef _MYCD_SET_VOLUME_MACRO
_mycd_set_volume_2:
	push	eax
	cmp	[_mycd_flag],dword 0		; MSCDEX installed?
	je	_mycd_set_volume_error		; no
	mov	[_mycd_ioctl_code],byte 12	; yes, IOCTL output
	mov	[_mycd_ioctl_length],byte _mycd_dosoffset	; length of IOCTL structure
	mov	[_mycd_control_block],byte 3	; audio channel control command code
	mov	[_mycd_ioctl_tlength],word 9	; 9 bytes to transfer
	mov	eax,[esp + 8]
	cmp	eax,$0ff			; volume to set above $ff?
	jbe	_mycd_set_volume_ok		; no
	mov	eax,$0ff			; yes, set to $ff
_mycd_set_volume_ok:
	mov	[_mycd_control_block + 1],byte 0
	mov	[_mycd_control_block + 2],al
	mov	[_mycd_control_block + 3],byte 1
	mov	[_mycd_control_block + 4],al
	mov	[_mycd_control_block + 5],byte 2
	mov	[_mycd_control_block + 6],al
	mov	[_mycd_control_block + 7],byte 3
	mov	[_mycd_control_block + 8],al
	call	_mycd_call_mscdex
	and	eax,$08000
	jnz	_mycd_set_volume_error
	pop	eax
	clc
	ret
_mycd_set_volume_error:
	pop	eax
	stc
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Call to play an audio track.
;
%ifdef _MYCD_PLAY_TRACK_MACRO
_mycd_play_track_2:
	push	eax
	push	ebx
	push	ecx
	mov	eax,[esp + 16]
	cmp	[_mycd_flag],dword 0		; MSCDEX installed?
	je	_mycd_play_track_error		; no
	CDTrackInfo eax,ebx,ecx			; yes, get track info
	jc	_mycd_play_track_error		; end if error
	CDStop					; stop any audio if it's playing
	jc	_mycd_play_track_error		; end if error
	mov	[_mycd_ioctl_code],byte 132	; play command
	mov	[_mycd_ioctl_length],byte 22	; length of IOCTL structure
	mov	[_mycd_ioctl_descriptor],byte 0	; HSG addressing mode
	CDRedBookToHSG ebx,eax
	mov	[_mycd_ioctl_control_off],eax	; starting sector to play
	CDRedBookToHSG ecx,eax
	mov	[_mycd_ioctl_tlength],eax	; number of sectors to play
	call	_mycd_call_mscdex2
	and	eax,$08000
	jnz	_mycd_play_track_error
	pop	ecx
	pop	ebx
	pop	eax
	clc					; flag success
	ret
_mycd_play_track_error:
	pop	ecx
	pop	ebx
	pop	eax
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Call to play an audio track looped.
;
%ifdef _MYCD_PLAY_TRACK_LOOPED_MACRO
_mycd_play_track_looped_2:
	push	eax
	push	ebx
	push	ecx
	mov	eax,[esp + 16]
	cmp	[_mycd_flag],dword 0		; MSCDEX installed?
	je	_mycd_play_track_looped_error	; no
	CDTrackInfo eax,ebx,ecx			; yes, get track info
	jc	_mycd_play_track_looped_error	; end if error
	CDStop					; stop any audio if it's playing
	jc	_mycd_play_track_looped_error
	mov	[_mycd_ioctl_code],byte 132	; play command
	mov	[_mycd_ioctl_length],byte 22	; length of IOCTL structure
	mov	[_mycd_ioctl_descriptor],byte 0	; HSG addressing mode
	CDRedBookToHSG ebx,eax
	mov	[_mycd_ioctl_control_off],eax	; starting sector to play
	mov	[_mycd_loop_start],eax		; save loop start point
	CDRedBookToHSG ecx,eax
	mov	[_mycd_ioctl_tlength],eax	; number of sectors to play
	mov	[_mycd_loop_length],eax		; save loop length
	call	_mycd_call_mscdex2
	and	eax,$08000			; error?
	jnz	_mycd_play_track_looped_error	; yes
	mov	[_mycd_loop_flag],dword 1	; no, flag looping on
	pop	ecx
	pop	ebx
	pop	eax
	clc					; flag success
	ret
_mycd_play_track_looped_error:
	pop	ecx
	pop	ebx
	pop	eax
	stc					; flag error
	ret

%endif
;
;------------------------------------------------------------------------------------
;
; Call to play a set of audio tracks.
;
%ifdef _MYCD_PLAY_TRACKS_MACRO
_mycd_play_tracks_2:
	push	eax
	push	ebx
	push	ecx				; save registers
	push	edx
	mov	eax,[esp + 24]
	mov	ebx,[esp + 20]
	cmp	[_mycd_flag],dword 0		; MSCDEX installed?
	je	near _mycd_play_tracks_error	; no
	CDStop					; stop any audio if it's playing
	jc	near	_mycd_play_tracks_error	; end if error
	cmp	eax,ebx				; start track before end track?
	jbe	_mycd_play_tracks_noswap	; yes
	push	eax				; no, swap start and end track
	mov	eax,ebx
	pop	ebx
_mycd_play_tracks_noswap:
	push	eax				; save start and end track
	push	ebx
	CDInfo	eax,ebx,ecx			; get audio CD info
	jc	near _mycd_play_tracks_error	; end if error
	mov	ecx,ebx				; no, save CD's start track number
	mov	edx,eax				; last track = number of tracks
	add	edx,ecx				; + start track
	dec	edx				; - 1
	pop	ebx				; restore start and end track
	pop	eax
	cmp	ecx,eax				; first track on CD before our start track?
	jbe	_mycd_play_tracks_startgo	; yes
	mov	eax,ecx				; no, make start track = first track on CD
_mycd_play_tracks_startgo:
	cmp	edx,ebx				; end track on CD after our end track?
	jae	_mycd_play_tracks_startloop	; yes
	mov	ebx,edx				; no, make our end track = last track on CD
_mycd_play_tracks_startloop:
	push	eax				; save track number and end track
	push	ebx
	CDTrackInfo eax,ebx,ecx			; get info on track
	jnc	_mycd_play_tracks_startok	; not a data track?
	pop	ebx				; yes, restore end track and track number
	pop	eax
	inc	eax				; next track
	cmp	eax,ebx				; is track above our end track?
	ja	near _mycd_play_tracks_error	; yes (can't find an audio track...)
	jmp	_mycd_play_tracks_startloop	; no, keep looking
_mycd_play_tracks_startok:
	pop	ebx				; restore end track and our start track
	pop	eax
	push	eax				; save start and end track
	push	ebx
	CDTrackInfo eax,ebx,ecx
	jnc	_mycd_play_tracks_startok2	; go on if no error
	pop	ebx				; no, restore registers
	pop	eax
	jmp	_mycd_play_tracks_error		; exit
_mycd_play_tracks_startok2:
	mov	[_mycd_loop_start],ebx		; loop start = start of track (use loop variable temporarily)
	pop	ebx				; restore start and end track
	pop	eax
	mov	[_mycd_loop_length],dword 0	; loop length is 0 to start with
	sub	ebx,eax				; end track - start track
	inc	ebx				; + 1 = number of tracks to get info on
_mycd_play_tracks_lengthloop:
	mov	edx,eax				; save track number
	push	ebx				; save number of tracks to do
	CDTrackInfo eax,ebx,ecx			; get info on track
	pop	ebx				; restore number of tracks to do
	jc	_mycd_play_tracks_error		; exit if error
	add	[_mycd_loop_length],ecx		; no, add length of track to loop length
	mov	eax,edx				; restore track number
	inc	eax				; onto next track
	dec	ebx				; another track done
	jnz	_mycd_play_tracks_lengthloop	; do all tracks
	mov	[_mycd_ioctl_code],byte 132	; play command
	mov	[_mycd_ioctl_length],byte 22	; length of IOCTL structure
	mov	[_mycd_ioctl_descriptor],byte 0	; HSG addressing mode
	mov	eax,[_mycd_loop_start]		; get the start point
	CDRedBookToHSG eax,eax
	mov	[_mycd_ioctl_control_off],eax	; starting sector to play
	mov	eax,[_mycd_loop_length]		; get the total length to play
	CDRedBookToHSG eax,eax
	mov	[_mycd_ioctl_tlength],eax	; number of sectors to play
	call	_mycd_call_mscdex2
	and	eax,$08000			; error?
	jnz	_mycd_play_tracks_error		; yes
	pop	edx				; no, restore registers
	pop	ecx
	pop	ebx
	pop	eax
	clc
	ret
_mycd_play_tracks_error:
	pop	edx				; restore registers
	pop	ecx
	pop	ebx
	pop	eax
	stc
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Call to play a set of audio tracks looped.
;
%ifdef _MYCD_PLAY_TRACKS_LOOPED_MACRO
_mycd_play_tracks_looped_2:
	push	eax
	push	ebx
	push	ecx				; save registers
	push	edx
	mov	eax,[esp + 24]
	mov	ebx,[esp + 20]
	cmp	[_mycd_flag],dword 0		; MSCDEX installed?
	je	near _mycd_play_tracks_looped_error	; no
	CDStop					; stop any audio playing
	jc	near _mycd_play_tracks_looped_error	; end if error
	cmp	eax,ebx				; start track before end track?
	jbe	_mycd_play_tracks_looped_noswap	; yes
	push	eax				; no, swap start and end track
	mov	eax,ebx
	pop	ebx
_mycd_play_tracks_looped_noswap:
	push	eax				; save start and end track
	push	ebx
	CDInfo	eax,ebx,ecx			; get audio CD info
	jc	near _mycd_play_tracks_looped_error	; end if error
	mov	ecx,ebx				; no, save CD's start track number
	mov	edx,eax				; last track = number of tracks
	add	edx,ecx				; + start track
	dec	edx				; - 1
	pop	ebx				; restore start and end track
	pop	eax
	cmp	ecx,eax				; first track on CD before our start track?
	jbe	_mycd_play_tracks_looped_startgo	; yes
	mov	eax,ecx				; no, make start track = first track on CD
_mycd_play_tracks_looped_startgo:
	cmp	edx,ebx				; end track on CD after our end track?
	jae	_mycd_play_tracks_looped_startloop	; yes
	mov	ebx,edx				; no, make our end track = last track on CD
_mycd_play_tracks_looped_startloop:
	push	eax				; save track number and end track
	push	ebx
	CDTrackInfo eax,ebx,ecx
	jnc	_mycd_play_tracks_looped_startok	; not a data track?
	pop	ebx				; yes, restore end track and track number
	pop	eax
	inc	eax				; next track
	cmp	eax,ebx				; is track above our end track?
	ja	near _mycd_play_tracks_looped_error	; yes (can't find an audio track...)
	jmp	_mycd_play_tracks_looped_startloop	; no, keep looking
_mycd_play_tracks_looped_startok:
	pop	ebx				; restore end track and our start track
	pop	eax
	push	eax				; save start and end track
	push	ebx
	CDTrackInfo eax,ebx,ecx			; get info on start track
	jnc	_mycd_play_tracks_looped_startok2	; no error?
	pop	ebx				; no, restore registers
	pop	eax
	jmp	_mycd_play_tracks_looped_error	; exit
_mycd_play_tracks_looped_startok2:
	mov	[_mycd_loop_start],ebx		; loop start = start of track (use loop variable temporarily)
	pop	ebx				; restore start and end track
	pop	eax
	mov	[_mycd_loop_length],dword 0	; loop length is 0 to start with
	sub	ebx,eax				; end track - start track
	inc	ebx				; + 1 = number of tracks to get info on
_mycd_play_tracks_looped_lengthloop:
	mov	edx,eax				; save track number
	push	ebx				; save number of tracks to do
	CDTrackInfo eax,ebx,ecx			; get info on track
	pop	ebx				; restore number of tracks to do
	jc	_mycd_play_tracks_looped_error	; end if error
	add	[_mycd_loop_length],ecx		; no, add length of track to loop length
	mov	eax,edx				; restore track number
	inc	eax				; onto next track
	dec	ebx				; another track done
	jnz	_mycd_play_tracks_looped_lengthloop	; do all tracks
	mov	[_mycd_ioctl_code],byte 132	; play command
	mov	[_mycd_ioctl_length],byte 22	; length of IOCTL structure
	mov	[_mycd_ioctl_descriptor],byte 0	; HSG addressing mode
	mov	eax,[_mycd_loop_start]		; get the start point
	CDRedBookToHSG eax,eax
	mov	[_mycd_ioctl_control_off],eax	; starting sector to play
	mov	eax,[_mycd_loop_length]		; get the total length to play
	CDRedBookToHSG eax,eax
	mov	[_mycd_ioctl_tlength],eax	; number of sectors to play
	call	_mycd_call_mscdex2
	and	eax,$08000			; error?
	jnz	_mycd_play_tracks_looped_error	; yes
	mov	[_mycd_loop_flag],dword 1	; no, flag looping
	pop	edx				; restore registers
	pop	ecx
	pop	ebx
	pop	eax
	clc
	ret
_mycd_play_tracks_looped_error:
	pop	edx				; restore registers
	pop	ecx
	pop	ebx
	pop	eax
	stc
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Call this periodically when in loop mode so we can start the loop again. This can
; be called regardless of whether you're looping or not.
;
%ifdef _MYCD_POLL_MACRO
_mycd_poll_2:
	push	eax				; save register
	cmp	[_mycd_flag],dword 0		; MSCDEX installed?
	je	_mycd_poll_end			; no
	cmp	[_mycd_loop_flag],dword 0	; yes, should we be looping?
	je	_mycd_poll_end			; no
	CDAudioPlaying				; yes, is audio playing?
	jnc	_mycd_poll_end			; yes, do nothing
	mov	[_mycd_ioctl_code],byte 132	; no, tell drive to play
	mov	[_mycd_ioctl_length],byte 22	; length of IOCTL structure
	mov	[_mycd_ioctl_descriptor],byte 0	; HSG addressing mode
	mov	eax,[_mycd_loop_start]
	mov	[_mycd_ioctl_control_off],eax	; starting sector to play
	mov	eax,[_mycd_loop_length]
	mov	[_mycd_ioctl_tlength],eax	; number of sectors to play
	call	_mycd_call_mscdex2		; assume it works... :(
_mycd_poll_end:
	pop	eax				; restore register
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Call to see if the drive's playing audio.
;
%ifdef _MYCD_AUDIO_PLAYING_MACRO
_mycd_audio_playing_2:
	push	eax
	push	ebx
	cmp	[_mycd_flag],dword 0		; MSCDEX installed?
	je	_mycd_audio_playing_error	; no
	mov	[_mycd_ioctl_code],byte 3	; yes, IOCTL input
	mov	[_mycd_ioctl_length],byte _mycd_dosoffset	; length of IOCTL structure
	mov	[_mycd_control_block],byte 6	; device status command code
	mov	[_mycd_ioctl_tlength],word 5	; 5 bytes to transfer
	call	_mycd_call_mscdex
	mov	ebx,eax				; save status
	and	eax,$08000			; error?
	jnz	_mycd_audio_playing_error	; yes
	mov	eax,[_mycd_control_block + 1]	; get status dword
	and	eax,1				; bit 0 is the door open flag
	jnz	_mycd_audio_playing_error	; it's set if the door's open, ie not playing audio, _but_ the drive's flagged as busy...
	and	ebx,512				; bit 9 is the busy bit
	jz	_mycd_audio_playing_error	; which is clear if it's not playing
	pop	ebx
	pop	eax
	clc
	ret
_mycd_audio_playing_error:
	pop	ebx
	pop	eax
	stc
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Takes the passed Red Book minute/second/frame address and returns the High Sierra
; sector number
;
%ifdef _MYCD_REDBOOK_TO_HSG_MACRO
_mycd_redbook_to_HSG_2:
	push	eax
	push	ebx
	push	ecx
	mov	eax,[esp + 16]
	mov	ebx,eax
	and	ebx,$0ff		; get frame number
	sub	ebx,150
	mov	ecx,eax			; get seconds
	and	ecx,$0ff00
	shr	ecx,8
	imul	ecx,75			; *75
	shr	eax,16			; and now get minutes
	and	eax,$0ff
	imul	eax,4500		; *60 *75
	add	eax,ebx
	add	eax,ecx
	mov	[_mycd_spare1],eax
	pop	ecx
	pop	ebx
	pop	eax
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Call to open the drive door
;
%ifdef _MYCD_DOOR_OPEN_MACRO
_mycd_door_open_2:
	push	eax
	cmp	[_mycd_flag],dword 0		; MSCDEX installed?
	je	_mycd_door_open_end		; no
	CDStop					; stop any audio playing
	mov	[_mycd_ioctl_code],byte 12	; IOCTL output
	mov	[_mycd_ioctl_length],byte _mycd_dosoffset	; length of IOCTL structure
	mov	[_mycd_control_block],byte 0	; eject command code
	mov	[_mycd_ioctl_tlength],word 1	; 1 byte to transfer
	call	_mycd_call_mscdex
_mycd_door_open_end:
	pop	eax
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Call to close the drive door
;
%ifdef _MYCD_DOOR_CLOSE_MACRO
_mycd_door_close_2:
	push	eax
	cmp	[_mycd_flag],dword 0	; MSCDEX installed?
	je	_mycd_door_close_end	; no
	mov	[_mycd_ioctl_code],byte 12	; yes, IOCTL output
	mov	[_mycd_ioctl_length],byte _mycd_dosoffset	; length of IOCTL structure
	mov	[_mycd_control_block],byte 5	; close tray command code
	mov	[_mycd_ioctl_tlength],word 1	; 1 byte to transfer
	call	_mycd_call_mscdex
_mycd_door_close_end:
	pop	eax
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Call to get track info
;
%ifdef _MYCD_GET_TRACK_INFO_MACRO
_mycd_get_track_info_2:
	push	eax
	push	ebx
	push	ecx
	push	edx
	mov	eax,[esp + 20]
	cmp	[_mycd_flag],dword 0		; MSCDEX installed?
	je	near _mycd_get_track_info_error	; no
	mov	edx,eax				; yes, save track number
	CDInfo	eax,ebx,ecx			; get CD info
	jc	near _mycd_get_track_info_error	; end if error
	cmp	edx,ebx				; no, track to get info on before start track?
	jb	near _mycd_get_track_info_error	; yes, don't try to play it
	add	eax,ebx				; no, last track = number of tracks + start track
	dec	eax				; - 1
	cmp	edx,eax				; track to get info on after last track?
	ja	near _mycd_get_track_info_error	; yes, don't try to play it
	mov	ebx,eax				; no, save number of last track
	mov	[_mycd_ioctl_code],byte 3	; IOCTL input
	mov	[_mycd_ioctl_length],byte _mycd_dosoffset	; length of IOCTL structure
	mov	[_mycd_control_block],byte 11	; audio track info command
	mov	[_mycd_control_block + 1],byte dl	; track to get info on
	mov	[_mycd_ioctl_tlength],word 7	; 7 bytes to transfer
	call	_mycd_call_mscdex
	and	eax,$08000			; error?
	jnz	_mycd_get_track_info_error	; yes
	mov	al,[_mycd_control_block + 6]	; no, get track control information
	and	eax,64				; mask off all but data track bit
	jnz	_mycd_get_track_info_error	; data track!
	cmp	ebx,edx				; is track to get info on last track?
	je	_mycd_get_track_info_last_track	; yes
	mov	ebx,[_mycd_control_block + 2]	; no, get starting point of this track
	mov	[_mycd_ioctl_code],byte 3	; IOCTL input
	mov	[_mycd_ioctl_length],byte _mycd_dosoffset	; length of IOCTL structure
	mov	[_mycd_control_block],byte 11	; audio track info command
	inc	edx				; now get info on next track
	mov	[_mycd_control_block + 1],byte dl	; track to get info on
	mov	[_mycd_ioctl_tlength],word 7	; 7 bytes to transfer
	call	_mycd_call_mscdex
	and	eax,$08000			; error?
	jnz	_mycd_get_track_info_error	; yes
	mov	ecx,[_mycd_control_block + 2]	; no, get starting point of next track
	dec	ecx				; - 1 to get end of track we're interested in
	sub	ecx,ebx				; subtract start point to get length of track
	jmp	_mycd_get_track_info_ok
_mycd_get_track_info_last_track:
	mov	ebx,[_mycd_control_block + 2]	; get starting point of track
	sub	ecx,ebx				; subtract start point from start point of lead-out track to get length of track
_mycd_get_track_info_ok:
	mov	[_mycd_spare1],ebx
	mov	[_mycd_spare2],ecx
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	clc
	ret
_mycd_get_track_info_error:
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	stc
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Call to get cd info
;
%ifdef _MYCD_GET_CD_INFO_MACRO
_mycd_get_cd_info_2:
	push	eax
	push	ebx
	push	ecx
	mov	eax,[esp + 16]
	cmp	[_mycd_flag],dword 0		; MSCDEX installed?
	je	_mycd_get_cd_info_error
	mov	[_mycd_ioctl_code],byte 3	; IOCTL input
	mov	[_mycd_ioctl_length],byte _mycd_dosoffset	; length of IOCTL structure
	mov	[_mycd_control_block],byte 10	; audio disk info command
	mov	[_mycd_ioctl_tlength],word 7	; 7 bytes to transfer
	call	_mycd_call_mscdex
	and	eax,$08000			; error?
	jnz	_mycd_get_cd_info_error
	xor	eax,eax
	xor	ebx,ebx
	mov	bl,[_mycd_control_block + 1]	; lowest track number (ie start track)
	mov	al,[_mycd_control_block + 2]	; highest track number
	sub	eax,ebx				; number of tracks = highest track - lowest track
	inc	eax				; + 1
	mov	ecx,[_mycd_control_block + 3]	; lead-out starting point
	mov	[_mycd_spare1],eax
	mov	[_mycd_spare2],ebx
	mov	[_mycd_spare3],ecx
	pop	ecx
	pop	ebx
	pop	eax
	clc
	ret
_mycd_get_cd_info_error:
	pop	ecx
	pop	ebx
	pop	eax
	stc
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Call to resume audio playing
;
%ifdef _MYCD_RESUME_MACRO
_mycd_resume_2:
	push	eax
	cmp	[_mycd_flag],dword 0		; MSCDEX installed?
	je	_mycd_resume_error
	mov	[_mycd_ioctl_code],byte 136	; resume command
	mov	[_mycd_ioctl_length],byte _mycd_dosoffset	; length of IOCTL structure
	call	_mycd_call_mscdex2
	and	eax,$08000
	jnz	_mycd_resume_error
	pop	eax
	clc					; flag success
	ret
_mycd_resume_error:
	pop	eax
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Call to stop audio playing
;
%ifdef _MYCD_STOP_MACRO
_mycd_stop_2:
	push	eax
	cmp	[_mycd_flag],dword 0		; MSCDEX installed?
	je	_mycd_stop_error
	mov	[_mycd_loop_flag],dword 0	; flag not looping
	mov	[_mycd_ioctl_code],byte 133	; stop command
	mov	[_mycd_ioctl_length],byte _mycd_dosoffset	; length of IOCTL structure
	call	_mycd_call_mscdex2
	and	eax,$08000
	jnz	_mycd_stop_error
	pop	eax
	clc					; flag success
	ret
_mycd_stop_error:
	pop	eax
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Copies command structure to low memory and calls MSCDEX to execute the command
; On return, ax holds the status
;
_mycd_call_mscdex:
	push	esi
	push	edi
	push	ebx
	push	ecx
	cmp	[_mycd_flag],dword 0	; MSCDEX installed?
	je	near _mycd_call_mscdex_error
	mov	[_mycd_ioctl_status],word 0
	mov	[_mycd_ioctl_descriptor],byte 0
	mov	[_mycd_ioctl_sector],word 0
	mov	[_mycd_ioctl_volumeid],dword 0
	mov	ax,[_mycd_dosseg]	; set control block segment and offset
	mov	[_mycd_ioctl_control_seg],ax
	mov	[_mycd_ioctl_control_off],word _mycd_dosoffset
	mov	esi,_mycd_ioctl		; source->MSCDEX IO control structure
	mov	edi,[_mycd_doslin]	; destination->allocated DOS memory
	mov	ecx,512			; 512 bytes to copy
	rep	movsb			; copy structure to DOS memory
	mov	edi,_RMRegisters	; real-mode register structure
	mov	[_RMR_AX],word $1510	; call CD-ROM driver
	mov	ax,[_mycd_drive]
	mov	[_RMR_CX],ax		; drive number of CD-ROM to use
	mov	ax,[_mycd_dosseg]
	mov	[_RMR_ES],ax		; segment address of allocated DOS memory
	mov	[_RMR_BX],word 0	; offset of allocated DOS memory
	mov	ax,$300			; simulate real-mode interrupt
	mov	bx,$2f			; interrupt $2f
	mov	cx,0			; don't copy any of the pm stack
	int	$31
	jc	_mycd_call_mscdex_error	; DPMI error!
	mov	edi,_mycd_ioctl		; destination->MSCDEX IO control structure
	mov	esi,[_mycd_doslin]	; source->allocated DOS memory
	mov	ecx,512			; 512 bytes to copy
	rep	movsb			; copy structure back to pmode memory
	mov	ax,[_mycd_ioctl_status]	; ax holds the status
	pop	ecx
	pop	ebx
	pop	edi
	pop	esi
	ret
_mycd_call_mscdex_error:
	mov	ax,$08000		; flag error bit
	pop	ecx
	pop	ebx
	pop	edi
	pop	esi
	ret
;
;------------------------------------------------------------------------------------
;
; Copies command structure to low memory and calls MSCDEX to execute the command
; On return, ax holds the status. This version assumes you're not using a control block
;
_mycd_call_mscdex2:
	push	esi
	push	edi
	push	ebx
	push	ecx
	cmp	[_mycd_flag],dword 0	; MSCDEX installed?
	je	near _mycd_call_mscdex2_error
	mov	[_mycd_ioctl_status],word 0
	mov	[_mycd_ioctl_sector],word 0
	mov	[_mycd_ioctl_volumeid],dword 0
	mov	esi,_mycd_ioctl		; source->MSCDEX IO control structure
	mov	edi,[_mycd_doslin]	; destination->allocated DOS memory
	mov	ecx,512			; 512 bytes to copy
	rep	movsb			; copy structure to DOS memory
	mov	edi,_RMRegisters	; real-mode register structure
	mov	[_RMR_AX],word $1510	; call CD-ROM driver
	mov	ax,[_mycd_drive]
	mov	[_RMR_CX],ax		; drive number of CD-ROM to use
	mov	ax,[_mycd_dosseg]
	mov	[_RMR_ES],ax		; segment address of allocated DOS memory
	mov	[_RMR_BX],word 0	; offset of allocated DOS memory
	mov	ax,$300			; simulate real-mode interrupt
	mov	bx,$2f			; interrupt $2f
	mov	cx,0			; don't copy any of the pm stack
	int	$31
	jc	_mycd_call_mscdex2_error	; DPMI error!
	mov	edi,_mycd_ioctl		; destination->MSCDEX IO control structure
	mov	esi,[_mycd_doslin]	; source->allocated DOS memory
	mov	ecx,512			; 512 bytes to copy
	rep	movsb			; copy structure back to pmode memory
	mov	ax,[_mycd_ioctl_status]	; ax holds the status
	pop	ecx
	pop	ebx
	pop	edi
	pop	esi
	ret
_mycd_call_mscdex2_error:
	mov	ax,$08000		; flag error bit
	pop	ecx
	pop	ebx
	pop	edi
	pop	esi
	ret

%ifdef _MYCD_INIT_MACRO
%ifndef _MYCD_EXIT_MACRO
%error "CDExit not called!"
%endif
%endif

%endif
