; Keyboard subsystem
; Original routines by Shawn Hargreaves. Converted to NASM by Gaz
;
%ifndef _MYKB
%define _MYKB
;
[BITS 32]
[segment .bss]
_mykb_spare1	resd 1

[segment .text]
;
;-------------------------------------------------------------------------
;
; Initialises the handler
;
%ifdef _MYKB_INIT_MACRO
_mykb_init_2:
	cmp	[_mykb_present],dword 0		; handler already present?
	je	_mykb_init_go			; no, install handler
	stc					; flag already installed
	ret					; return
_mykb_init_go:
	cli					; don't interrupt us
	push	ebx				; save registers
	push	ecx
	push	edx
	DetectOS
	mov	[_mykb_present],dword 1		; flag installed (can't be any errors)
	KBBufferClear2				; clear the key buffer
	mov	eax,$417			; shift state is at $417 (from start of memory)
	xor	ebx,ebx				; clear ebx so we can use 32bits
	mov	bx,[eax]			; get the shift state word
	mov	[_mykb_oldshift],bx		; save for uninstall later
	mov	eax,ebx				; save the actual shift state
	xor	ecx,ecx				; ecx holds our shift state (nothing at present)
	and	eax,1				; right shift?
	jz	_mykb_init1			; no
	or	ecx,_mykbd_shift_flag		; yes, set in our shift state
	mov	[_kb_key_table + _kb_rightshift],dword 1	; flag key pressed
_mykb_init1:
	mov	eax,ebx				; repeat for the other keys
	and	eax,2				; left shift?
	jz	_mykb_init2
	or	ecx,_mykbd_shift_flag
	mov	[_kb_key_table + _kb_leftshift],dword 1
_mykb_init2:
	mov	eax,ebx
	and	eax,4				; control?
	jz	_mykb_init3
	or	ecx,_mykbd_ctrl_flag
	mov	[_kb_key_table + _kb_control],dword 1
_mykb_init3:
	mov	eax,ebx
	and	eax,8				; alt?
	jz	_mykb_init4
	or	ecx,_mykbd_alt_flag
	mov	[_kb_key_table + _kb_alt],dword 1
_mykb_init4:
	mov	eax,ebx
	and	eax,16				; scrollock?
	jz	_mykb_init5
	or	ecx,_mykbd_scrolllock_flag
_mykb_init5:
	mov	eax,ebx
	and	eax,32				; numlock?
	jz	_mykb_init6
	or	ecx,_mykbd_numlock_flag
_mykb_init6:
	mov	eax,ebx
	and	eax,64				; capslock?
	jz	_mykb_init7
	or	ecx,_mykbd_capslock_flag
_mykb_init7:
	mov	[_mykb_shifts],ecx		; set current shift state
	mov	eax,0204h			; get old kb handler
	mov	ebx,9
	int	$31
	mov	[_mykb_oldsel],cx		; save old selector
	mov	[_mykb_oldoff],edx		; save old offset
	mov	ax,0205h			; set new handler
	mov	ebx,9
	mov	cx,ds				; save the data selector that our handler
	mov	[_mykb_dseg],cx			; will use
	mov	cx,cs				; if this fails our cs selector
	mov	edx,_mykb_handler		; is invalid...
	mov	[_mykb_led_flag],dword 0	; no LED updating initially
	int	$31				; set the new handler
	sti					; start interrupts
_mykb_init_end:
%define _MYKB_EXIT_MACRO
	AtExit	_mykb_exit_2
	pop	edx				; restore registers
	pop	ecx
	pop	ebx
	clc					; flag success
	ret					; return
%endif
;
;-------------------------------------------------------------------------
;
; Restores the old keyboard routine
;
%ifdef _MYKB_EXIT_MACRO
_mykb_exit_2:
	push	eax				; save registers
	push	ebx
	push	ecx
	push	edx
	cmp	[_mykb_present],dword 0		; handler installed?
	je	near _mykb_end_end		; no, exit
	cli					; yes, don't interrupt us
	mov	eax,$417			; restore the shift state
	mov	bx,[_mykb_oldshift]		; the old shift state
	mov	ecx,[_mykb_present]		; only set the shift states to the
	dec	ecx				; current key state if we've updated
	jz	near _mykb_end_shift		; the LEDs, otherwise things might get a little strange
	xor	ebx,ebx				; ebx holds the shift state
	cmp	[_kb_key_table + _kb_rightshift],dword 0	; right shift pressed?
	je	_mykb_end1			; no
	or	ebx,1				; yes, set
_mykb_end1:
	cmp	[_kb_key_table + _kb_leftshift],dword 0	; left shift?
	je	_mykb_end2
	or	ebx,2
_mykb_end2:
	cmp	[_kb_key_table + _kb_control],dword 0	; control?
	je	_mykb_end3
	or	ebx,4
_mykb_end3:
	cmp	[_kb_key_table + _kb_alt],dword 0	; alt?
	je	_mykb_end4
	or	ebx,8
_mykb_end4:
	mov	ecx,[_mykb_shifts]
	mov	edx,ecx
	and	edx,_mykbd_scrolllock_flag	; scrollock?
	jz	_mykb_end5
	or	ebx,16
_mykb_end5:
	mov	edx,ecx
	and	edx,_mykbd_numlock_flag		; numlock?
	jz	_mykb_end6
	or	ebx,32
_mykb_end6:
	mov	edx,ecx
	and	edx,_mykbd_capslock_flag	; capslock?
	jz	_mykb_end_shift
	or	ebx,64
_mykb_end_shift:
	mov	[eax],bx			; set new shift state
	mov	eax,0205h			; restore old handler
	mov	ebx,9
	mov	cx,[_mykb_oldsel]		; old selector
	mov	edx,[_mykb_oldoff]		; old offset
	int	$31				; set handler
	sti					; start interrupts
	mov	[_mykb_present],dword 0		; flag not present
_mykb_end_end:
	pop	edx				; restore registers
	pop	ecx
	pop	ebx
	pop	eax
	clc					; flag success
	ret					; return
%endif
;
;-------------------------------------------------------------------------
;
; Turns LED updating on
;
%ifdef _MYKB_LEDS_ON_MACRO
_mykb_leds_on_2:
	cmp	[_mykb_present],dword 0		; handler installed?
	je	_mykb_leds_on_end		; no
	cli
	mov	[_mykb_led_flag],dword 1
	mov	[_mykb_present],dword 2		; flag we're updating the LEDs
	sti
_mykb_leds_on_end:
	clc
	ret
%endif
;
;-------------------------------------------------------------------------
;
; Turns LED updating off
;
%ifdef _MYKB_LEDS_OFF_MACRO
_mykb_leds_off_2:
	cmp	[_mykb_present],dword 0		; handler installed?
	je	_mykb_leds_off_end		; no
	cli
	mov	[_mykb_led_flag],dword 0
	mov	[_mykb_present],dword 1		; flag we're not updating the LEDs
	sti
_mykb_leds_off_end:
	clc
	ret
%endif
;
;-------------------------------------------------------------------------
;
; Macro for the end of the handler
;
%macro _mykb_handler_exitmacro 0
	mov	eax,$020			; acknowledge interrupt
	out	$020,al
	pop	ds
	pop	edx				; restore registers
	pop	ecx
	pop	ebx
	pop	eax
	iretd					; exit
%endmacro
;
;-------------------------------------------------------------------------
;
; Macro for adding a key to the key buffer (key to add is in eax)
;
%macro _mykb_handler_addkeymacro 0
	cmp	[_mykb_bsize],dword 16		; buffer full?
	je	._mykb_handler_addend		; yes, don't add key
	inc	dword [_mykb_bsize]		; no, update buffer size
	mov	ebx,[_mykb_bend]		; get the end of the buffer
	mov	[_mykb_buffer + ebx],ax		; add key to buffer
	add	ebx,2				; 2 bytes/key
	cmp	ebx,32				; end of the buffer?
	jne	._mykb_handler_addok		; no
	xor	ebx,ebx				; yes, back to the start of the buffer
._mykb_handler_addok:
	mov	[_mykb_bend],ebx		; store new buffer end position
._mykb_handler_addend:
%endmacro
;
;-------------------------------------------------------------------------
;
; The handler itself
;
%ifdef _MYKB_INIT_MACRO
	times ($$-$) & 31 nop			; 32-byte alignment
_mykb_handler:
	push	eax				; save registers
	push	ebx
	push	ecx
	push	edx
	push	ds				; save data selector
	mov	ax,[cs:_mykb_dseg]		; set this segment's data selector
	mov	ds,ax
	xor	eax,eax				; want to work with full 32-bit register
	in	al,$060				; eax holds the keyboard byte
	cmp	dword [_mykb_pauseloop],0	; are we receiving the pause sequence?
	jne	near _mykb_handler_pauseloop	; yes, do the pause loop
	cmp	eax,$0e1			; no, pause key pressed?
	je	near _mykb_handler_pausekey	; yes, do the pause key routine
	cmp	eax,$0e0			; no, extended key pressed?
	je	near _mykb_handler_extendedkey	; yes, do the extended key routine
	mov	ebx,eax				; no, process the key
	and	eax,$7f				; bits 0-6 = key code = eax
	shl	eax,2				; *4
	and	ebx,$080			; bit 7 = release flag = ebx
	mov	ecx,_mykbd_normal		; ecx = key table mask
	cmp	[_mykb_extended],dword 0	; extended key?
	je	near _mykb_notextended		; 0=no
	mov	ecx,_mykbd_extended		; 1=yes, set mask
	mov	[_mykb_extended],dword 0	; flag not extended key any more
	mov	edx,[_mykb_extended_table + eax]	; get the value from the extended key table
	cmp	edx,0				; 0 - use the byte as scancode as with a normal key
	je	near _mykb_notextended
	cmp	edx,1				; 1 - ignore this extended key
	je	near _mykb_handler_exit
	cmp	edx,2				; 2 - use the scancode but put the shift flags instead of the ASCII code
	jne	_mykb_extendedkey
	cmp	ebx,0				; key released?
	je	_mykb_extendedkeynorelease
	not	ecx				; yes, invert the mask
	and	[_mykb_key_table + eax],ecx	; unset the table
	_mykb_handler_exitmacro			; end handler
_mykb_extendedkeynorelease:
	or	[_mykb_key_table + eax],ecx	; set the table
	shl	eax,6
	mov	ebx,[_mykb_shifts]
	or	ebx,_mykbd_special_mask
	_mykb_handler_addkeymacro		; add key to buffer
	_mykb_handler_exitmacro			; end handler
_mykb_extendedkey:
	cmp	edx,123				; CTRL-PAUSE?
	jne	_mykb_extendedkey2
	cmp	ebx,0				; key released?
	jne	near _mykb_handler_exit
	xor	[_kb_key_table + _kb_pause],dword _mykbd_extended	; toggle key in table
	mov	eax,_kb_pause
	shl	eax,6
	_mykb_handler_addkeymacro		; add key to buffer
	_mykb_handler_exitmacro			; end handler
_mykb_extendedkey2:
	mov	eax,edx				; use value from table in all other cases
	shl	eax,2				; *4 and process as normal
_mykb_notextended:
	cmp	ebx,0				; key released?
	je	near _mykb_keypressed		; no
	not	ecx				; yes, invert mask
	and	[_mykb_key_table + eax],ecx	; set table
	mov	ebx,[_mykb_special_table + eax]	; special key?
	cmp	ebx,0
	je	near _mykb_handler_exit		; no, exit
	cmp	ebx,_mykbd_scrolllock_flag
	jge	_mykb_keyreleased1
	cmp	ebx,_mykbd_alt_flag
	je	_mykb_keyreleased1
	not	ebx
	and	[_mykb_shifts],ebx		; unset flag
	_mykb_handler_exitmacro			; end handler
_mykb_keyreleased1:
	cmp	ebx,_mykbd_alt_flag
	jne	near _mykb_handler_exit
	not	ebx
	and	[_mykb_shifts],ebx		; set flag
	mov	ebx,[_mykb_shifts]
	and	ebx,_mykbd_inaltseq_flag
	jz	near _mykb_handler_exit
	and	[_mykb_shifts],dword ~_mykbd_inaltseq_flag
	mov	eax,[_mykb_keypadseq]
	and	eax,$0ff
	_mykb_handler_addkeymacro		; add key to buffer
	_mykb_handler_exitmacro			; end handler
_mykb_keypressed:
	or	[_mykb_key_table + eax],ecx	; key pressed, set table
	mov	ebx,[_mykb_special_table + eax]
	cmp	ebx,0				; special key?
	je	near _mykb_kp_notspecial	; no
	cmp	ebx,_mykbd_scrolllock_flag	; yes
	jb	_mykb_kp_special1
	cmp	ebx,_mykbd_inaltseq_flag
	jge	_mykb_kp_special1
	cmp	[_mykb_led_flag],dword 0
	jz	near _mykb_kp_notspecial
	xor	[_mykb_shifts],ebx
	mov	eax,$0ed
	call	_mykb_send_data
	push	eax
	mov	eax,[_mykb_shifts]
	shr	eax,8
	and	eax,7
	call	_mykb_send_data
	pop	ebx
	cmp	ebx,0
	jne	near _mykb_handler_exit
	cmp	eax,0
	jne	near _mykb_handler_exit
_mykb_kp_special0:
	mov	eax,$0f4
	call	_mykb_send_data
	_mykb_handler_exitmacro			; end handler
_mykb_kp_special1:
	cmp	ebx,_mykbd_accent1_flag
	jb	_mykb_kp_special2
	cmp	[_kb_key_table + _kb_altgr],dword 0
	je	_mykb_kp_special1b
	mov	ebx,[_mykb_ascii_table + eax]
	shl	eax,6
	add	eax,ebx
	_mykb_handler_addkeymacro		; add key to buffer
	jmp	_mykb_kp_notspecial
_mykb_kp_special1b:
	mov	ecx,[_mykb_shifts]
	and	ecx,_mykbd_shift_flag
	jz	_mykb_kp_special1b2
	shl	ebx,1
	or	[_mykb_shifts],ebx
	jmp	_mykb_kp_notspecial
_mykb_kp_special1b2:
	or	[_mykb_shifts],ebx
	jmp	_mykb_kp_notspecial
_mykb_kp_special2:
	or	[_mykb_shifts],ebx		; set the shift status
_mykb_kp_notspecial:
	mov	ebx,[_mykb_shifts]
	and	ebx,_mykbd_alt_flag
	jz	near _mykb_kp_notalt
	cmp	eax,$011c			; $047 << 2
	jb	_mykb_kp_alt2
	cmp	[_mykb_extended_table + eax],dword 2
	jne	_mykb_kp_alt2
	mov	ebx,[_mykb_shifts]
	and	ebx,_mykbd_inaltseq_flag
	jz	_mykb_kp_alt1
	mov	ebx,[_mykb_keypadseq]
	imul	ebx,10
	mov	ecx,[_mykb_numlock_table + eax]
	sub	cl,'0'
	add	ebx,ecx
	mov	[_mykb_keypadseq],ebx
	jmp	_mykb_kp_notalt
_mykb_kp_alt1:
	or	[_mykb_shifts],dword _mykbd_inaltseq_flag
	mov	ebx,[_mykb_numlock_table + eax]
	sub	bl,'0'
	mov	[_mykb_keypadseq],ebx
	jmp	_mykb_kp_notalt
_mykb_kp_alt2:
	cmp	[_kb_key_table + _kb_altgr],dword 0
	jne	_mykb_kp_alt2b
	shl	eax,6
	_mykb_handler_addkeymacro		; add key to buffer
	jmp	_mykb_kp_notalt
_mykb_kp_alt2b:
	shl	eax,6
	_mykb_handler_addkeymacro		; add key to buffer
_mykb_kp_notalt:
	and	[_mykb_shifts],dword ~_mykbd_inaltseq_flag
	mov	ebx,[_mykb_shifts]
	mov	ecx,ebx
	and	ebx,_mykbd_ctrl_flag
	jz	_mykb_kp_notctrl
	mov	ebx,[_mykb_control_table + eax]
	shl	eax,6
	add	eax,ebx
	_mykb_handler_addkeymacro		; add key to buffer
	_mykb_handler_exitmacro			; end handler
_mykb_kp_notctrl:
	mov	ebx,ecx
	and	ebx,_mykbd_shift_flag
	jz	near _mykb_kp_notshift
	mov	ebx,ecx
	and	ebx,_mykbd_capslock_flag
	jz	near _mykb_kp_notcapslock
	mov	ebx,[_mykb_ascii_table + eax]
	cmp	[_mykb_capslock_table + eax],ebx
	jne	_mykb_kp_notshift2
	mov	ebx,[_mykb_shift_table + eax]
	shl	eax,6
	add	eax,ebx
	_mykb_handler_addkeymacro		; add key to buffer
	_mykb_handler_exitmacro			; end handler
_mykb_kp_notshift2:
	mov	ebx,[_mykb_ascii_table + eax]
	shl	eax,6
	add	eax,ebx
	_mykb_handler_addkeymacro		; add key to buffer
	_mykb_handler_exitmacro			; end handler
_mykb_kp_notcapslock:
	mov	ebx,[_mykb_shift_table + eax]
	or	ebx,ebx				; is it zero?
	jz	_mykb_notcapslock2		; yes, ignore the key
	shl	eax,6
	add	eax,ebx
	_mykb_handler_addkeymacro		; add key to buffer
_mykb_notcapslock2:
	_mykb_handler_exitmacro			; end handler
_mykb_kp_notshift:
	mov	ebx,ecx
	and	ebx,_mykbd_numlock_flag
	jz	_mykb_kp_notnum
	cmp	[_mykb_numlock_table + eax],dword 0
	je	_mykb_kp_notnum
	mov	ebx,[_mykb_numlock_table + eax]
	mov	eax,_kb_pad
	shl	eax,8
	or	eax,ebx
	_mykb_handler_addkeymacro		; add key to buffer
	_mykb_handler_exitmacro			; end handler
_mykb_kp_notnum:
	mov	ebx,ecx
	and	ebx,_mykbd_capslock_flag
	jz	_mykb_kp_notcapslock2
	mov	ebx,[_mykb_capslock_table + eax]
	shl	eax,6
	add	eax,ebx
	_mykb_handler_addkeymacro		; add key to buffer
	_mykb_handler_exitmacro			; end handler
_mykb_kp_notcapslock2:
	mov	ebx,[_mykb_ascii_table + eax]
	shl	eax,6
	add	eax,ebx
	_mykb_handler_addkeymacro		; add key to buffer
_mykb_handler_exit:
	_mykb_handler_exitmacro			; end handler
;
;-------------------------------------------------------------------------
;
; The pause key sends an odd 6-byte sequence so this bit loops until the next
; 5 keyboard bytes have arrived
;
_mykb_handler_pauseloop:
	dec	dword [_mykb_pauseloop]		; skip this pause byte
	_mykb_handler_exitmacro			; end handler
;
;-------------------------------------------------------------------------
;
; If the pause key's been pressed then toggle it in the table
;
_mykb_handler_pausekey:
	xor	[_kb_key_table + _kb_pause],dword _mykbd_extended	; toggle pause key
	mov	[_mykb_pauseloop],dword 5	; must skip the next 5 keyboard bytes (pause key sends very odd code)
	mov	eax,_kb_pause			; add key value to buffer
	shl	eax,6				; key value already shifted by 2 (*4)
	_mykb_handler_addkeymacro		; add key to buffer
	_mykb_handler_exitmacro			; end handler
;
;-------------------------------------------------------------------------
;
; If we've received the extended key byte ($e0) then flag that we're expecting
; an extended key and wait for the next byte to arrive
;
_mykb_handler_extendedkey:
	mov	[_mykb_extended],dword 1	; flag extended key
	_mykb_handler_exitmacro			; end handler
;
;-------------------------------------------------------------------------
;
; Sends the byte in eax to the keyboard. Returns 1 in eax on success, 0 on failure
; Uses eax-edx and preserves none (only called from the keyboard handler)
;
	times ($$-$) & 31 nop
_mykb_send_data:
	cmp	[_os_type],dword _OS_TYPE_WINNT
	je	_mykb_send_data_loop_end_ok	; can't send data to the keyboard under NT
	mov	edx,eax				; preserve data to be sent
	mov	ecx,4				; 4 retries
_mykb_send_data_loop:
	mov	ebx,1000000			; wait until the keyboard's ready for writing
_mykb_send_data_write_wait_loop:
	dec	ebx
	jz	_mykb_send_data_write_wait_loop_end
	in	al,$064
	and	eax,2
	jnz	_mykb_send_data_write_wait_loop
_mykb_send_data_write_wait_loop_end:
	mov	eax,edx				; data to be sent
	out	$060,al				; send byte
_mykb_send_data_loop2:
	mov	ebx,2000000			; error sending?
	dec	ebx
	jz	_mykb_send_data_loop_end	; yes
	push	ebx
	mov	ebx,1000000			; wait until the keyboard's ready for reading
_mykb_send_data_read_wait_loop:
	dec	ebx
	jz	_mykb_send_data_read_wait_loop_end
	in	al,$064
	and	eax,1
	jz	_mykb_send_data_read_wait_loop
_mykb_send_data_read_wait_loop_end:
	pop	ebx
	in	al,$60				; check keyboard status
	cmp	al,$0fa
	je	_mykb_send_data_loop_end_ok	; data sent ok
	cmp	al,$0fe				; error
	jne	_mykb_send_data_loop2
_mykb_send_data_loop_end:
	dec	ecx				; tried four times?
	jnz	_mykb_send_data_loop		; no, keep going
	cmp	ebx,0				; timed out for return?
	jnz	_mykb_send_data_loop
	mov	eax,0				; error
	ret
_mykb_send_data_loop_end_ok:
	mov	eax,1				; ok
	ret
%endif
;
;-------------------------------------------------------------------------
;
; Waits for a keypress
;
%ifdef _MYKB_WAIT_KEY_MACRO
_mykb_wait_key_2:
	KBBufferClear				; clear the key buffer
	push	eax
_mykb_wait_key_loop:
	KBReadKey eax				; try and read a key from the buffer
	jc	_mykb_wait_key_loop		; loop if no key available
	mov	[_mykb_spare1],eax
	pop	eax
	ret
%endif
;
;-------------------------------------------------------------------------
;
; Reads a key from the key buffer
;
%ifdef _MYKB_READ_KEY_MACRO
_mykb_read_key_2:
	cmp	[_mykb_bsize],dword 0		; any keys
	je	_mykb_read_key_none		; no
	cli
	push	eax
	push	ebx
	xor	eax,eax
	dec	dword [_mykb_bsize]		; one less key in buffer
	mov	ebx,[_mykb_bstart]		; start of the buffer
	mov	ax,[_mykb_buffer + ebx]		; get the key
	add	ebx,2				; 2 bytes/key
	cmp	ebx,32				; end of buffer?
	jne	_mykb_read_key_ok		; no
	xor	ebx,ebx				; yes, back to start
_mykb_read_key_ok:
	mov	[_mykb_bstart],ebx		; save new buffer start point
	mov	[_mykb_spare1],eax
	pop	eax
	pop	ebx
	clc					; flag keys available
	sti
	ret
_mykb_read_key_none:
	stc					; flag no keys
	ret
%endif
;
;-------------------------------------------------------------------------
;
; Returns the number of keys in the buffer
;
%ifdef _MYKB_BUFFER_COUNT_MACRO
_mykb_buffer_count_2:
	push	eax
	mov	eax,[_mykb_bsize]
	mov	[_mykb_spare1],eax
	pop	eax
	ret
%endif
;
;-------------------------------------------------------------------------
;
; Clears the key buffer
;
%ifdef _MYKB_INIT_MACRO
_mykb_buffer_clear:
	cli
	mov	[_mykb_bstart],dword 0
	mov	[_mykb_bend],dword 0
	mov	[_mykb_bsize],dword 0
	mov	[_mykb_buffer],dword 0
	mov	[_mykb_buffer + 4],dword 0
	mov	[_mykb_buffer + 8],dword 0
	mov	[_mykb_buffer + 12],dword 0
	mov	[_mykb_buffer + 16],dword 0
	mov	[_mykb_buffer + 20],dword 0
	mov	[_mykb_buffer + 24],dword 0
	mov	[_mykb_buffer + 28],dword 0
	sti
	ret
_mykb_buffer_clear2:
	mov	[_mykb_bstart],dword 0
	mov	[_mykb_bend],dword 0
	mov	[_mykb_bsize],dword 0
	mov	[_mykb_buffer],dword 0
	mov	[_mykb_buffer + 4],dword 0
	mov	[_mykb_buffer + 8],dword 0
	mov	[_mykb_buffer + 12],dword 0
	mov	[_mykb_buffer + 16],dword 0
	mov	[_mykb_buffer + 20],dword 0
	mov	[_mykb_buffer + 24],dword 0
	mov	[_mykb_buffer + 28],dword 0
	ret
%endif
;
;-------------------------------------------------------------------------
;
[segment .data]
%ifdef _MYKB_INIT_MACRO
	times ($$-$) & 31 db 0			; alignment
_mykb_dseg	dd 0
_mykb_bstart	dd 0
_mykb_bend	dd 0
_mykb_bsize	dd 0
_mykb_buffer	times 8 dd 0
_mykb_extended	dd 0
_mykb_shifts	dd 0
_mykb_pauseloop	dd 0
_mykb_led_flag	dd 0
_mykb_keypadseq	dd 0
_kb_key_table:
_mykb_key_table:
	times 128 dd 0
_mykb_ascii_table:
	dd	0,   27,  '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '=', 8,   9
	dd	'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', '[', ']', 13,  0,   'a', 's'
	dd	'd', 'f', 'g', 'h', 'j', 'k', 'l', ';', 39,  '`', 0,   92,  'z', 'x', 'c', 'v'
	dd	'b', 'n', 'm', ',', '.', '/', 0,   '*', 0,   ' ', 0,   3,   3,   3,   3,   8
	dd	3,   3,   3,   3,   3,   0,   0,   0,   0,   0,   '-', 0,   0,   0,   '+', 0
	dd	0,   0,   0,   127, 0,   0,   92,  3,   3,   0,   0,   0,   0,   0,   0,   0
	dd	13,  0,   '/', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   '/', 0,   0,   0,   0,   0

_mykb_capslock_table:
	dd	0,   27,  '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '=', 8,   9
	dd	'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '[', ']', 13,  0,   'A', 'S'
	dd	'D', 'F', 'G', 'H', 'J', 'K', 'L', ';', 39,  '`', 0,   92,  'Z', 'X', 'C', 'V'
	dd	'B', 'N', 'M', ',', '.', '/', 0,   '*', 0,   ' ', 0,   3,   3,   3,   3,   8
	dd	3,   3,   3,   3,   3,   0,   0,   0,   0,   0,   '-', 0,   0,   0,   '+', 0
	dd	0,   0,   0,   127, 0,   0,   92,  3,   3,   0,   0,   0,   0,   0,   0,   0
	dd	13,  0,   '/', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   '/', 0,   0,   0,   0,   0

_mykb_shift_table:
	dd	0,   27,  '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '+', 126, 126
	dd	'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '{', '}', 126, 0,   'A', 'S'
	dd	'D', 'F', 'G', 'H', 'J', 'K', 'L', ':', 34,  '~', 0,   '|', 'Z', 'X', 'C', 'V'
	dd	'B', 'N', 'M', '<', '>', '?', 0,   '*', 0,   1,   0,   1,   1,   1,   1,   1
	dd	1,   1,   1,   1,   1,   0,   0,   0,   0,   0,   '-', 0,   0,   0,   '+', 0
	dd	0,   0,   1,   127, 0,   0,   0,   1,   1,   0,   0,   0,   0,   0,   0,   0
	dd	13,  0,   '/', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   '/', 0,   0,   0,   0,   0

_mykb_control_table:
	dd	0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   127, 127
	dd	17,  23,  5,   18,  20,  25,  21,  9,   15,  16,  2,   2,   10,  0,   1,   19
	dd	4,   6,   7,   8,   10,  11,  12,  0,   0,   0,   0,   0,   26,  24,  3,   22
	dd	2,   14,  13,  0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2
	dd	2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   2,   0,   0,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0

%macro _mykb_empty_table 0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
%endmacro

_mykb_altgr_table:
_mykb_empty_table

;_mykb_accent1_lower_table:
;_mykb_empty_table

;_mykb_accent1_upper_table:
;_mykb_empty_table

;_mykb_accent1_shift_lower_table:
;_mykb_empty_table

;_mykb_accent1_shift_upper_table:
;_mykb_empty_table

;_mykb_accent2_lower_table:
;_mykb_empty_table

;_mykb_accent2_upper_table:
;_mykb_empty_table

;_mykb_accent2_shift_lower_table:
;_mykb_empty_table

;_mykb_accent2_shift_upper_table:
;_mykb_empty_table

_mykb_numlock_table:
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', 0,   '4', '5', '6', 0,   '1'
	dd	'2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0

_mykb_extended_table:
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   122, 0,   84,  121, 0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   123, 2,   2,   2,   0,   2,   2,   2,   0,   2
	dd	2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0

_mykb_special_table:
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   1,   0,   4,   0,1024,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0, 512, 256,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,  16,  32,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
	dd	0,   0,   0,   0,   0,   0,   0,   0,   2,   4,   0,   0,   0,   0,   0,   0
;
_mykb_oldshift	dw 0
_mykb_oldsel	dw 0
_mykb_oldoff	dd 0
_mykb_present	dd 0
%endif

%ifdef _MYKB_READ_KEY_MACRO
%ifndef _MYKB_INIT_MACRO
%error "Must call KBInit before you can use KBReadKey!"
%endif
%endif

%ifdef _MYKB_WAIT_KEY_MACRO
%ifndef _MYKB_INIT_MACRO
%error "Must call KBInit before you can use KBWaitKey!"
%endif
%endif

%endif
