; StringList class
; by Gaz
;
%ifndef _MYSTRINGLIST
%define _MYSTRINGLIST

[BITS 32]
[section .bss]

_mystringlist_spare	resd	1

[section .text]
;
;------------------------------------------------------------------------------
;
; Creates the string list
;
%ifdef _MYSTRINGLIST_CREATE_MACRO
_mystringlist_create_2:
	push	esi				; save registers
	push	eax
	Malloc	24,eax				; allocate object
	jc	_mystringlist_create_error
	Malloc	4096,esi			; allocate list
	jc	_mystringlist_create_error2
	mov	[eax + _SL_LISTPTR],esi		; store address of list
	mov	[eax + _SL_LISTALLOC],dword 1024	; 1024 entries allocated for the list
	mov	[eax + _SL_COUNT],dword 0	; 0 used
	mov	[eax + _SL_SORTED],dword FALSE	; list is unsorted
	mov	[eax + _SL_DUPLICATES],dword 0	; ignore duplicates
	mov	[_mystringlist_spare],eax
	pop	eax				; restore registers
	pop	esi
	clc					; flag success
	ret
_mystringlist_create_error2:
	Free	eax
_mystringlist_create_error:
	mov	[_mystringlist_spare],dword 0
	pop	eax				; restore registers
	pop	esi
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------
;
; Frees the string list
;
%ifdef _MYSTRINGLIST_FREE_MACRO
_mystringlist_free_2:
	push	esi				; save registers
	push	edi
	mov	esi,[esp + 12]
	StringList.Clear esi			; free up all the items
	Free	[esi + _SL_LISTPTR]		; and the list array
	Free	esi				; and the object itself
	jc	_mystringlist_free_error
	pop	edi				; restore registers
	pop	esi
	clc					; flag success
	ret
_mystringlist_free_error:
	pop	edi				; restore registers
	pop	esi
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------
;
; Loads a file into the list
;
%ifdef _MYSTRINGLIST_LOADFROMFILE_MACRO
_mystringlist_loadfromfile_2:
	push	eax				; save registers
	push	ebx
	push	ecx
	push	edx
	push	esi
	push	edi
	mov	esi,[esp + 32]
	mov	eax,[esp + 28]
	FileOpen eax,ax				; open file
	jc	near _mystringlist_loadfromfile_error
	FileSize ax,ebx				; get the file's size
	inc	ebx
	jc	near _mystringlist_loadfromfile_error2
	Malloc	ebx,edx				; allocate some memory for the file
	jc	near _mystringlist_loadfromfile_error2
	mov	edi,edx
	FileClose ax				; close the file
	jc	near _mystringlist_loadfromfile_error3
	mov	eax,[esp + 28]
	FileLoad eax,edi			; load the file into memory
	jc	_mystringlist_loadfromfile_error3
	dec	ebx
	add	ebx,edi
	mov	[ebx],byte 13			; put in a terminator
	PosChar	edi,13,ecx			; find the first terminator
	add	ecx,edi
	cmp	ecx,ebx				; is this the terminator we just put in?
	je	_mystringlist_loadfromfile_end	; yes, nothing to do
_mystringlist_loadfromfile_loop:
	mov	[ecx],byte 0			; put in a null-terminator
	StringList.Add esi,edi			; add in this string
	jc	_mystringlist_loadfromfile_error3
	lea	edi,[ecx + 2]			; point edi to the next string
	PosChar	edi,13,ecx			; look for a string terminator
	add	ecx,edi				; make ecx into an address
	cmp	ecx,ebx				; done all the strings?
	jne	_mystringlist_loadfromfile_loop	; no, keep going
	cmp	edi,ebx				; was there a final string though?
	je	_mystringlist_loadfromfile_end	; no
	mov	[ebx],byte 0			; yes, add in the last string
	StringList.Add esi,edi
_mystringlist_loadfromfile_end:
	Free	edx
	jc	_mystringlist_loadfromfile_error
	pop	edi				; restore registers
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	clc					; flag success
	ret
_mystringlist_loadfromfile_error3:
	Free	edx
	pop	edi				; restore registers
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	stc
	ret
_mystringlist_loadfromfile_error2:
	FileClose ax				; close the file
_mystringlist_loadfromfile_error:
	pop	edi				; restore registers
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------
;
; Adds a string to the list
;
%ifdef _MYSTRINGLIST_ADD_MACRO
_mystringlist_add_2:
	push	eax				; save registers
	push	ebx
	push	ecx
	push	edx
	push	esi
	push	edi
	push	ebp
	mov	esi,[esp + 36]
	cmp	[esi + _SL_COUNT],dword 0	; no items in the list?
	je	_mystringlist_add_noitems	; no, so don't check for it being sorted
	cmp	[esi + _SL_SORTED],dword TRUE	; is it a sorted list?
	je	near _mystringlist_add_sorted	; yes
_mystringlist_add_noitems:
	mov	eax,[esi + _SL_COUNT]		; get number of items in the list
	cmp	eax,[esi + _SL_LISTALLOC]	; number of items=number allocated?
	jne	_mystringlist_add_space		; no, everything's ok
	mov	eax,[esi + _SL_LISTALLOC]	; yes, add another 1024 entries to the list
	add	eax,1024
	shl	eax,2				; *4 because each entry is a dword
	Realloc	[esi + _SL_LISTPTR],eax,edi	; resize the list
	jc	near _mystringlist_add_error	; no space left!
	mov	[esi + _SL_LISTPTR],edi		; save the new list pointer
	add	[esi + _SL_LISTALLOC],dword 1024	; and update the entry count
_mystringlist_add_space:
	mov	eax,[esp + 32]			; eax -> string to add
	Length	eax,ecx				; get the string's length
	Malloc	ecx,edi				; allocate space for the string
	jc	near _mystringlist_add_error	; no space for the string!
	mov	ebx,[esi + _SL_COUNT]		; no, get number of items
	shl	ebx,2				; *4 because each item is a dword address
	add	ebx,[esi + _SL_LISTPTR]		; ecx -> place to add new list entry
	mov	[ebx],edi			; save address of new string
	inc	dword [esi + _SL_COUNT]		; another item added
	mov	esi,eax				; esi -> string to add
	rep	movsb				; copy the string to the buffer
	pop	ebp				; restore registers
	pop	edi
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	clc					; flag success
	ret
_mystringlist_add_sorted:
	mov	edi,FALSE			; find correct place to add the string
	xor	eax,eax				; start from first index
	mov	ebx,[esi + _SL_COUNT]		; and end at the last index
	dec	ebx				; indices start from 0
	mov	ebp,[esi + _SL_LISTPTR]		; ebp -> array of string pointers
_mystringlist_add_loop:
	cmp	eax,ebx				; bottom index <= top index?
	jg	_mystringlist_add_loop_end	; no, must have finished looking
	mov	ecx,eax				; yes, work out middle index
	add	ecx,ebx
	shr	ecx,1
	push	ebx				; compare two strings
	push	ecx
	push	esi
	push	edi
	mov	esi,ecx				; esi holds current middle index
	shl	esi,2				; *4 because each pointer's a dword
	mov	esi,[esi + ebp]			; esi -> current middle index string
	mov	edi,[esp + 48]			; edi -> string to add
	Length	esi,ebx				; get lengths of strings
	Length	edi,edx
	mov	ecx,ebx
	cmp	ecx,edx				; which string's shortest?
	jbe	_mystringlist_add_check0	; the middle indexed one
	mov	ecx,edx				; the string to add
_mystringlist_add_check0:
	cmp	ecx,ecx
	repe	cmpsb
	je	_mystringlist_add_check1
	xor	edx,edx
	xor	ebx,ebx
	mov	dl,[edi - 1]
	mov	bl,[esi - 1]
_mystringlist_add_check1:
	sub	edx,ebx
	pop	edi
	pop	esi
	pop	ecx
	pop	ebx
	cmp	edx,0				; found a string the same or greater?
	jl	_mystringlist_add_loop_found	; yes, got the insert position
	mov	eax,ecx				; no, insert position must be after the
	inc	eax				; middle somewhere so keep looking from
	jmp	_mystringlist_add_loop		; there
_mystringlist_add_loop_found:
	mov	ebx,ecx				; if we haven't actually found an identical string, the insert
	dec	ebx				; position must be below the middle somewhere so look until there
	or	edx,edx				; identical string?
	jne	_mystringlist_add_loop		; no, keep looking
	mov	edi,TRUE			; yes, flag we've found one
	cmp	[esi + _SL_DUPLICATES],dword 2	; should we just add duplicate strings?
	je	_mystringlist_add_loop		; yes, continue looking
	mov	eax,ecx				; no, this must be the place to insert it
_mystringlist_add_loop_end:
	cmp	edi,TRUE			; found an identical string?
	jne	_mystringlist_add_not_found	; no, just insert the string
	cmp	[esi + _SL_DUPLICATES],dword 0	; yes, should we ignore duplicate strings?
	je	_mystringlist_add_end		; yes, end
	cmp	[esi + _SL_DUPLICATES],dword 1	; should we flag an error?
	je	_mystringlist_add_error		; yes, error
_mystringlist_add_not_found:
	mov	ebx,[esp + 32]			; ebx -> string to add
	StringList.Insert esi,ebx,eax		; insert the string
	jc	_mystringlist_add_error		; couldn't insert the string!
_mystringlist_add_end:
	pop	ebp				; restore registers
	pop	edi
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	clc					; flag success
	ret
_mystringlist_add_error:
	pop	ebp				; restore registers
	pop	edi
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------
;
; Clears the list
;
%ifdef _MYSTRINGLIST_CLEAR_MACRO
_mystringlist_clear_2:
	push	esi				; save registers
	push	eax
	push	ebx
	mov	esi,[esp + 16]
	mov	eax,[esi + _SL_COUNT]		; number of items in the list
	or	eax,eax				; no items to free?
	je	_mystringlist_clear_end		; no
	mov	ebx,eax				; get to last item in list
	dec	ebx
	shl	ebx,2	
	add	ebx,[esi + _SL_LISTPTR]
_mystringlist_clear_loop:
	Free	[ebx]				; free all the list items
	sub	ebx,4				; onto previous item
	dec	eax
	jnz	_mystringlist_clear_loop
_mystringlist_clear_end:
	Realloc	[esi + _SL_LISTPTR],4096,eax	; resize list buffer
	jc	_mystringlist_clear_error	; heap failure
	mov	[eax + _SL_LISTPTR],eax
	mov	[eax + _SL_LISTALLOC],dword 1024	; 1024 entries allocated for the list
	mov	[eax + _SL_COUNT],dword 0	; 0 used
	pop	ebx				; restore registers
	pop	eax
	pop	esi
	clc					; flag success
	ret
_mystringlist_clear_error:
	pop	ebx				; restore registers
	pop	eax
	pop	esi
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------
;
; Deletes a string from the list
;
%ifdef _MYSTRINGLIST_DELETE_MACRO
_mystringlist_delete_2:
	push	esi				; save registers
	push	edi
	push	eax
	push	ecx
	mov	esi,[esp + 24]
	mov	edi,[esp + 20]			; get index to delete
	mov	ecx,[esi + _SL_COUNT]
	cmp	edi,ecx				; is the index not in the list?
	jae	_mystringlist_delete_error	; yes, error
	sub	ecx,edi				; no, get number of items after this one
	shl	edi,2				; make index into offset
	add	edi,[esi + _SL_LISTPTR]		; and get to pointer in list
	Free	[edi]				; free up the string
	jc	_mystringlist_delete_error	; couldn't deallocate the string!
	dec	dword [esi + _SL_COUNT]		; one less item
	lea	esi,[edi + 4]			; source is next pointer on
	rep	movsd				; move pointers down
	pop	ecx				; restore registers
	pop	eax
	pop	edi
	pop	esi
	clc					; flag success
	ret
_mystringlist_delete_error:
	pop	ecx				; restore registers
	pop	eax
	pop	edi
	pop	esi
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------
;
; Exchanges two items in the list
;
%ifdef _MYSTRINGLIST_EXCHANGE_MACRO
_mystringlist_exchange_2:
	push	esi				; save registers
	push	eax
	push	ebx
	push	ecx
	mov	esi,[esp + 28]
	mov	eax,[esi + _SL_COUNT]
	mov	ebx,[esp + 24]
	cmp	ebx,eax
	jae	_mystringlist_exchange_error
	mov	ecx,[esp + 20]
	cmp	ecx,eax
	jae	_mystringlist_exchange_error
	mov	esi,[esi + _SL_LISTPTR]		; esi -> string pointer array
	shl	ebx,2				; *4 because they're dwords
	shl	ecx,2
	mov	eax,[esi + ebx]			; swap pointers around
	push	dword [esi + ecx]
	pop	dword [esi + ebx]
	mov	[esi + ecx],eax
	pop	ecx				; restore registers
	pop	ebx
	pop	eax
	pop	esi
	clc					; flag success
	ret
_mystringlist_exchange_error:
	pop	ecx				; restore registers
	pop	ebx
	pop	eax
	pop	esi
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------
;
; Returns the first occurrence of the string specified
;
%ifdef _MYSTRINGLIST_INDEXOF_MACRO
_mystringlist_indexof_2:
	push	ecx				; save registers
	push	esi
	push	edi
	mov	esi,[esp + 20]
	mov	edi,[esp + 16]
	mov	ecx,[esi + _SL_COUNT]		; ecx holds number of items to search
	mov	esi,[esi + _SL_LISTPTR]		; esi -> array of string pointers
_mystringlist_indexof_loop:
	CompareStrings [esi],edi		; are the strings the same?
	jnc	_mystringlist_indexof_found	; yes
	add	esi,4				; no, another item checked
	dec	ecx
	jnz	_mystringlist_indexof_loop	; any more to check?
	mov	[_mystringlist_spare],dword -1	; no, flag not found
	pop	edi				; restore registers
	pop	esi
	pop	ecx
	stc					; flag error
	ret
_mystringlist_indexof_found:
	mov	esi,[esp + 20]
	mov	esi,[esi + _SL_COUNT]
	sub	esi,ecx
	mov	[_mystringlist_spare],esi
	pop	edi				; restore registers
	pop	esi
	pop	ecx
	clc					; flag success
	ret
%endif
;
;------------------------------------------------------------------------------
;
; Returns the first occurrence of the string specified (case insensitive)
;
%ifdef _MYSTRINGLIST_INDEXOFTEXT_MACRO
_mystringlist_indexoftext_2:
	push	ecx				; save registers
	push	esi
	push	edi
	mov	esi,[esp + 20]
	mov	edi,[esp + 16]
	mov	ecx,[esi + _SL_COUNT]		; ecx holds number of items to search
	mov	esi,[esi + _SL_LISTPTR]		; esi -> array of string pointers
_mystringlist_indexoftext_loop:
	CompareText [esi],edi			; are the strings the same?
	jnc	_mystringlist_indexoftext_found	; yes
	add	esi,4				; no, another item checked
	dec	ecx
	jnz	_mystringlist_indexoftext_loop	; any more to check?
	mov	[_mystringlist_spare],dword -1	; no, flag not found
	pop	edi				; restore registers
	pop	esi
	pop	ecx
	stc					; flag error
	ret
_mystringlist_indexoftext_found:
	mov	esi,[esp + 20]
	mov	esi,[esi + _SL_COUNT]
	sub	esi,ecx
	mov	[_mystringlist_spare],esi
	pop	edi				; restore registers
	pop	esi
	pop	ecx
	clc					; flag success
	ret
%endif
;
;------------------------------------------------------------------------------
;
; Inserts a string into the list
;
%ifdef _MYSTRINGLIST_INSERT_MACRO
_mystringlist_insert_2:
	push	eax
	push	ebx
	push	ecx
	push	esi
	push	edi
	mov	esi,[esp + 32]
	mov	ebx,[esp + 24]			; ebx holds insertion point
	mov	eax,[esi + _SL_COUNT]
	cmp	ebx,eax				; insertion point outside list?
	ja	near _mystringlist_insert_error	; yes, error
	cmp	eax,[esi + _SL_LISTALLOC]	; number of items=number allocated?
	jne	_mystringlist_insert_space	; no, everything's ok
	mov	eax,[esi + _SL_LISTALLOC]	; yes, add another 1024 entries to the list
	add	eax,1024
	shl	eax,2				; *4 because each entry is a dword
	Realloc	[esi + _SL_LISTPTR],eax,edi	; resize the list
	jc	_mystringlist_insert_error	; no space left!
	mov	[esi + _SL_LISTPTR],edi		; save the new list pointer
	add	[esi + _SL_LISTALLOC],dword 1024	; and update the entry count
_mystringlist_insert_space:
	mov	eax,[esp + 28]			; eax -> string to add
	Length	eax,ecx				; get the string's length
	Malloc	ecx,edi				; allocate space for the string
	jc	_mystringlist_insert_error	; no space for the string!
	push	eax				; save address of string to add
	push	ecx				; save string length
	push	edi				; save allocated address
	mov	eax,[esi + _SL_LISTPTR]		; eax -> array of string pointers
	lea	eax,[eax + ebx*4]		; eax -> position to insert new string
	mov	ecx,[esi + _SL_COUNT]		; ecx holds number of items in the list
	inc	dword [esi + _SL_COUNT]		; another item added
	mov	esi,[esi + _SL_LISTPTR]		; esi -> array of string pointers
	lea	esi,[esi + ecx*4]		; esi -> dword after array
	sub	esi,4				; esi -> last dword in array
	sub	ecx,ebx				; ecx now holds number of items to copy
	lea	edi,[esi + 4]			; edi -> dword after last entry
	std					; going down
	rep	movsd				; copy array
	pop	edi				; edi -> allocated address of string
	pop	ecx				; ecx holds string length
	pop	esi				; esi -> string to add
	cld					; going up
	mov	[eax],edi			; save address of string to pointer array
	rep	movsb				; copy the string to the buffer
	pop	edi
	pop	esi
	pop	ecx
	pop	ebx
	pop	eax
	clc					; flag success
	ret
_mystringlist_insert_error:
	pop	edi
	pop	esi
	pop	ecx
	pop	ebx
	pop	eax
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------
;
; Moves a string from one position in the list to another
;
; Oh dear, I did two separate move routines when I should have just changed the
; direction flag, but I can't be bothered fixing this right now.
;
%ifdef _MYSTRINGLIST_MOVE_MACRO
_mystringlist_move_2:
	push	eax
	push	ebx
	push	ecx
	push	edx
	push	esi
	push	edi
	mov	esi,[esp + 36]
	mov	eax,[esp + 32]			; current index
	mov	ebx,[esp + 28]			; new index
	cmp	eax,[esi + _SL_COUNT]		; current index in the list?
	jae	_mystringlist_move_error	; no, error
	cmp	ebx,[esi + _SL_COUNT]		; new index in the list?
	jae	_mystringlist_move_error	; no, error
	cmp	eax,ebx				; current index same as new index?
	je	_mystringlist_move_end		; yes, end
	cmp	eax,ebx				; current index after new index?
	ja	_mystringlist_move_above	; yes
	mov	esi,[esi + _SL_LISTPTR]		; esi -> array of string pointers
	push	esi
	lea	edi,[esi + eax*4]		; edi -> current index position
	mov	edx,[edi]			; save current string address
	lea	esi,[edi + 4]			; esi -> index after current index position
	mov	ecx,ebx				; work out count
	sub	ecx,eax
	rep	movsd				; move indices down by one
	pop	esi
	lea	esi,[esi + ebx*4]		; and put back string address
	mov	[esi],edx
_mystringlist_move_end:
	pop	edi				; restore registers
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	clc					; flag success
	ret
_mystringlist_move_above:
	mov	esi,[esi + _SL_LISTPTR]		; esi -> array of string pointers
	lea	edi,[esi + eax*4]		; edi -> current index position
	mov	edx,[edi]			; save current string address
	mov	esi,edi				; esi -> index before current index position
	sub	esi,4
	mov	ecx,eax				; work out count
	sub	ecx,ebx
_mystringlist_move_loop:
	mov	eax,[esi]			; move indices up by one
	mov	[edi],eax
	sub	esi,4
	sub	edi,4
	dec	ecx
	jnz	_mystringlist_move_loop
	mov	[edi],edx			; put back string address
	pop	edi				; restore registers
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	clc					; flag success
	ret
_mystringlist_move_error:
	pop	edi				; restore registers
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------
;
; Saves the list to a file
;
%ifdef _MYSTRINGLIST_SAVETOFILE_MACRO
_mystringlist_savetofile_2:
	push	eax
	push	ebx
	push	ecx
	push	edx
	push	esi
	mov	esi,[esp + 28]
	mov	ecx,[esi + _SL_COUNT]
	mov	esi,[esi + _SL_LISTPTR]
	mov	eax,[esp + 24]			; eax -> filename
	push	dword $00a0d0a0d		; temporary CR/LF pair
	mov	edx,esp				; save address
	FileCreate eax,ax			; create the file
	jc	_mystringlist_savetofile_error	; couldn't create file!
_mystringlist_savetofile_loop:
	Length	[esi],ebx			; get length of this string
	dec	ebx
	FileWrite ax,[esi],ebx			; write string to file
	jc	_mystringlist_savetofile_error2	; error writing string!
	FileWrite ax,edx,2			; add a CR/LF pair
	jc	_mystringlist_savetofile_error2	; error writing string!
	add	esi,4				; onto the next
	dec	ecx				; another string done
	jnz	_mystringlist_savetofile_loop	; do all strings
	FileClose ax				; close the file
	jc	_mystringlist_savetofile_error	; couldn't close file!
	pop	esi
	pop	esi				; restore registers
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	clc					; flag success
	ret
_mystringlist_savetofile_error2:
	FileClose ax				; close the file
_mystringlist_savetofile_error:
	pop	esi
	pop	esi				; restore registers
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------
;
; Sets a string in the list
;
%ifdef _MYSTRINGLIST_SETSTRING_MACRO
_mystringlist_setstring_2:
	push	eax				; save registers
	push	ecx
	push	esi
	push	edi
	mov	esi,[esp + 28]
	mov	eax,[esp + 24]
	cmp	eax,[esi + _SL_COUNT]		; is the string to set not in the list?
	jae	_mystringlist_setstring_error	; no, error
	shl	eax,2				; *4 because each entry is a dword
	add	eax,[esi + _SL_LISTPTR]		; get to right index entry
	mov	esi,[esp + 20]			; get address of string to set
	Length	esi,ecx				; get length
	Realloc	[eax],ecx,edi			; re-size current string
	jc	_mystringlist_setstring_error	; couldn't resize the string!
	mov	[eax],edi			; save new address
	rep	movsb				; copy new string into place
	pop	edi				; restore registers
	pop	esi
	pop	ecx
	pop	eax
	clc					; flag success
	ret
_mystringlist_setstring_error:
	pop	edi				; restore registers
	pop	esi
	pop	ecx
	pop	eax
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------
;
; Sorts the list
;
%macro StringList.QuickSort 3
	push	dword %1
	push	dword %2
	push	dword %3
	call	_mystringlist_quicksort
	lea	esp,[esp + 12]
%endmacro
%ifdef _MYSTRINGLIST_SORT_MACRO
_mystringlist_sort_2:
	push	eax				; save registers
	push	esi
	mov	esi,[esp + 12]
	cmp	[esi + _SL_SORTED],dword TRUE	; is the list already sorted?
	je	_mystringlist_sort_end		; yes, don't bother sorting it
	mov	[esi + _SL_SORTED],dword TRUE	; flag the list's sorted
	mov	eax,[esi + _SL_COUNT]		; get the number of items in the list
	dec	eax				; one less because it's used as an index
	StringList.QuickSort esi,0,eax		; sort the list from index 0 to the last index
_mystringlist_sort_end:
	pop	esi				; restore registers
	pop	eax
	clc					; flag success
	ret
_mystringlist_quicksort:
	push	eax				; the actual sorting routine
	push	ebx
	push	ecx
	push	edx
	push	esi
	push	edi
	push	ebp
	mov	esi,[esp + 40]
	mov	ebp,[esi + _SL_LISTPTR]		; ebp -> array of string pointers
_mystringlist_quicksort_loop:
	mov	eax,[esp + 36]			; eax holds current left index
	mov	ebx,[esp + 32]			; ebx holds current right index
	mov	ecx,eax				; find middle index between these
	add	ecx,ebx
	shr	ecx,1
	shl	ecx,2				; *4 because pointers are dwords
	mov	ecx,[ecx + ebp]			; ecx -> middle string of this part of the list to sort
	Length	ecx,edx				; get length in edx
_mystringlist_quicksort_loop2:
	push	edx
	push	ebx				; compare two strings
	push	ecx
	push	esi
	mov	esi,eax				; esi holds current left index
	shl	esi,2				; *4 because each pointer's a dword
	mov	esi,[esi + ebp]			; esi -> current left index string
	mov	edi,ecx				; edi -> middle string
	Length	esi,ebx				; get length of string
	mov	ecx,ebx
	cmp	ecx,edx				; which string's shortest?
	jbe	_mystringlist_quicksort_check0	; the left indexed one
	mov	ecx,edx				; the middle one so make the count the middle string's length
_mystringlist_quicksort_check0:
	cmp	ecx,ecx
	repe	cmpsb
	je	_mystringlist_quicksort_check1
	xor	edx,edx
	xor	ebx,ebx
	mov	dl,[edi - 1]
	mov	bl,[esi - 1]
_mystringlist_quicksort_check1:
	sub	edx,ebx
	pop	esi
	pop	ecx
	pop	ebx
	cmp	edx,0
	jle	_mystringlist_quicksort_loop2b
	pop	edx
	inc	eax
	jmp	_mystringlist_quicksort_loop2
_mystringlist_quicksort_loop2b:
	pop	edx
_mystringlist_quicksort_loop2c:
	push	edx
	push	ebx				; compare two strings
	push	ecx
	push	esi
	mov	esi,ebx				; esi holds current right index
	shl	esi,2				; *4 because each pointer's a dword
	mov	esi,[esi + ebp]			; esi -> current right index string
	mov	edi,ecx				; edi -> middle string
	Length	esi,ebx				; get length of string
	mov	ecx,ebx
	cmp	ecx,edx				; which string's shortest?
	jbe	_mystringlist_quicksort_check2	; the right indexed one
	mov	ecx,edx				; the middle one so make the count the middle string's length
_mystringlist_quicksort_check2:
	cmp	ecx,ecx
	repe	cmpsb
	je	_mystringlist_quicksort_check3
	xor	edx,edx
	xor	ebx,ebx
	mov	dl,[edi - 1]
	mov	bl,[esi - 1]
_mystringlist_quicksort_check3:
	sub	edx,ebx
	pop	esi
	pop	ecx
	pop	ebx
	cmp	edx,0
	jge	_mystringlist_quicksort_loop2d
	pop	edx
	dec	ebx
	jmp	_mystringlist_quicksort_loop2c
_mystringlist_quicksort_loop2d:
	pop	edx
_mystringlist_quicksort_swapcheck:
	cmp	eax,ebx				; indices passed each other?
	ja	_mystringlist_quicksort_noswap	; yes, do nothing
	push	eax				; no, swap strings round
	push	ebx
	shl	eax,2				; *4 because each pointer's a dword
	shl	ebx,2
	mov	edx,[ebp + eax]
	push	dword [ebp + ebx]
	pop	dword [ebp + eax]
	mov	[ebp + ebx],edx
	pop	ebx
	pop	eax
	Inc	eax
	Dec	ebx
_mystringlist_quicksort_noswap:
	cmp	eax,ebx				; indices passed each other?
	jbe	near _mystringlist_quicksort_loop2	; no, keep sorting
	cmp	[esp + 36],ebx			; is original left index less than current right index?
	jae	_mystringlist_quicksort_nosort	; no, must have finished this bit
	mov	edx,[esp + 36]
	StringList.QuickSort esi,edx,ebx	; yes, recursively sort the new bit
_mystringlist_quicksort_nosort:
	mov	[esp + 36],eax			; original left index = current left index
	cmp	eax,[esp + 32]			; finished sorting this stretch?
	jb	near _mystringlist_quicksort_loop	; no, continue sorting
	pop	ebp				; yes, restore registers
	pop	edi
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	clc
	ret
%endif

%endif