;
;                        CD-ROM Eject/Close Sample Program
;                                               by Dolphinz
;
;       This is a little sample prog to show how to open/close
;       the CD-ROM door using MCI commands, the source code
;       is also included, to build the program you need
;       TASM 5.0 and winmm.dll library, which can be found
;       in the "\WINDOWS\SYSTEM\" directory, so you can learn of it,
;       I hope.
;       If you have any comments, questions... write me.
;                                       dolphinz@lettera.net
;
;
.386p                                           ; 386 op instructions
locals
jumps
.model flat, stdcall                            ; Memory model I use
include cdrom.inc                               ; My include file


;
; External Win32 Functions
;
extrn   GetModuleHandleA        : PROC
extrn   DialogBoxParamA         : PROC
extrn   ExitProcess             : PROC
extrn   EndDialog               : PROC
extrn   LoadLibraryA            : PROC
extrn   FreeLibrary             : PROC
extrn   GetProcAddress          : PROC
extrn   MessageBoxA             : PROC

.data

IDD_DIALOG                      equ     100     ; Dialog defines in .RC file
IDC_OPEN                        equ     1000    ; OPEN button
IDC_CLOSE                       equ     2000    ; CLOSE button
IDC_EXIT                        equ     3000    ; EXIT button

;
; Handles
;
hInst           dd      0                       ; hInstance
hDll            dd      0                       ; handle for the DLL
ProcAddress     dd      0                       ; handle for the procedure

;
; Strings and buffers
;

szOpenString    db      'set cdaudio door open',0       ; Open CD-ROM command
szCloseString   db      'set cdaudio door closed',0     ; Close CD-ROM command
szLibCaption    db      'Library Error',0
szLibError      db      'Could`t load winmm.dll library, please check if WINMM.DLL is here \WINDOWS\SYSTEM\',0
szProcName      db      'mciSendStringA',0      ; Function we need to call
szLibName       db      'c:\windows\system\winmm.dll',0 ; Library name
szBuffer        db      255 dup(0)              ; Buffer for returned info.

.code

start:
        call    GetModuleHandleA, 0             ; Get Instance
        mov     hInst, eax                      ; and save here

        call    LoadLibraryA, offset szLibName  ; Load the library
        mov     [hDll],eax                      ; and save handle here
        .if     hDll==0
                call    MessageBoxA, 0, offset szLibError, offset szLibCaption, 0
                ret
        .endif
        ; Before calling "mciSendStringA" procedure stored in the dll
        ; we have to get the procedure address
        call    GetProcAddress, [hDll], offset szProcName
        mov     ProcAddress, eax

        ; Create our Dialog box
        call    DialogBoxParamA, hInst, IDD_DIALOG, 0, offset DlgProc, 0
        call    ExitProcess, 0

;
; This is our Dialog procedure                                           
;
DlgProc PROC    hwnd: dword, message: dword, wparam: dword, lparam: dword
        .IF     message==WM_COMMAND
                        call      command
        .ELSEIF message==WM_DESTROY
                        call      destroy
        .ELSE
                        xor eax, eax
                        ret
        .ENDIF
                        xor eax, eax
                        ret 
command:
        cmp     wparam, IDC_OPEN                ; OPEN button pressed?
        jz      open_cdrom                 
        cmp     wparam, IDC_CLOSE               ; CLOSE button pressed?
        jz      close_cdrom
        cmp     wparam, IDC_EXIT                ; EXIT button pressed?
        jz      destroy
        cmp     wparam, IDCANCEL                ;
        jz      destroy
        xor     eax, eax
        ret

open_cdrom:
        ; At this point I have the address of the procedure
        ; and I pass the "Open" command
        call    ProcAddress, offset szOpenString, offset szBuffer, 255, hwnd
        xor     eax, eax
        ret

close_cdrom:
        ; Now I use the address of the procedure
        ; and I pass the "Close" command
        call    ProcAddress, offset szCloseString, offset szBuffer, 255, hwnd
        xor     eax, eax
        ret

destroy:
        call    FreeLibrary, [hDll]             ; Unload library
        call    EndDialog, hwnd, 0              ; Finish dialog
        ret
DlgProc endp


ends
        end     start
