;-----------------------------------------------------------------------------------
; Title:              : CrueMe v1.0
; Author              : Cruehead
; Creation date       : 98-06-02
; Source release date : 99-02-13
;
; Description:
; This is the source code for yet another "CrackMe" program. This one
; has proven to be fairly hard to beat, and it took approx 8 months before
; I received five solutions. The most interesting among those solutions is the one I got
; from "MerCuur". He wrote a generic brute forcer based on mutations and life forms.
; I included his source code (in C) in this zip archive...It's really interesting.
;
; The crackme features some polymorphic code to hide the real
; encryption and check routine. As soon as the real check has been executed
; the code will be overwritten with useless code, and a fake
; encryption/check routine will be executed. Every time the "Check It!"
; button is pressed the real encryption/check routine is beeing written
; to the correct place again. Before the real encryption/check routine is executed
; the string is fetched through the GetText message beeing sent.
; A breakpoint detection is made on the "GetDlgItemTextA" function as this
; is the routine that is used to fetch the string and then execute the fake test.
; All of this just to confuse the cracker into thinking he's on the right path
; when seeing the "No breakpoint allowed..." message. Also the file called "CRUEME.DAT" has
; nothing to do what so ever with the real check - it's only used as a red herring.
; Knowing this one can easily figure out that the "FileMon" detection is also only
; used as a red herring to distract the user from the real interesting piece of
; the code.
; Another thing is that all the functions used in the program are stored in a
; separate place thus making it a lookup table. This is only to confuse
; dead-listing crackers (and perhaps to cause some headaches for Sice users as well).
; Conclusion: Alot of things to draw the cracker's attention to other useless
; pieces of the code. Also the ability to hide the real psw checking routine so the
; cracker wont see anything suspicious when browsing through the program using softice.
;
; I wont comment much of the code, and it might be a bit hard to follow everything
; but the program works as I described above and that is - if you ask me - the really
; interesting thing to know.
;
;
;
; Oh yeah! Perhaps you'd be interested to know that the password I choosed was
; "Cracking4U". Alot of other passwords will pass as well though, and I doubht
; that it's even possible to find the password I had in mind.
;-----------------------------------------------------------------------------------

.386
locals
jumps
.model flat,STDCALL

;----------------------------------------------------------
;Structure, EQU, Includefiles declaration
;----------------------------------------------------------

include win32.inc           ; some 32-bit constants and structures
L equ <LARGE>

IDD_STAT		 EQU 1010
IDD_CLOSE		 EQU 1004
IDD_GO			 EQU 1003
IDD_EDIT1		 EQU 1002
IDI_ICON1		 EQU 100

TRUE	         EQU 1
FALSE 	         EQU 0
NULL             EQU 0

;----------------------------------
; Our Variables
;----------------------------------

.data

szTitleName      db '',0
szClassName      db 'ASMCLASS32',0
lppaint          PAINTSTRUCT <?>
msg              MSGSTRUCT   <?>
wc               WNDCLASS    <?>
tm		         TEXTMETRIC  <?>
RC				 RECT	     <?>
Systime			 SYSTEMTIME  <?>

dlg_start        db 'DLG_START',0
Buffert			 db 7,41,25,22,37,6,1,12,35,24,11,8,23,14,5,42,33,38,27,3,21,4,39,10,20,26,19,28,32,40,31,29,34,9,17,36,15,18,13,30,2,16

psw				 db 14 dup (0)
fakebuff		 db 8 dup (0)
loopindex		 db 0ffh

FileFakePsw		 db 0ffh,077h,088h,066h,099h,055h,0aah,044h,0bbh,033h,0cch,022h,0ddh,011h,0eeh

Flagst	    	 dd 0c0h			; Open with these flags! (RWE)

FileMon			 db 05dh,0a5h,0b9h,0e4h,0d4h,080h,019h,0a5h,0b1h,095h,080h,035h,0bdh,0b9h,0a5h,0d1h,0bdh,0c9h,0
ProcID			 dd 0
handle			 dd 0

WhyNot1			 dd 015263748h
WhyNot2			 dd 0596a7b8ch
NoNeed1			 dd 0
NoNeed2			 dd 0
length			 dd 0

Filename		 db 'CRUEME.DAT',0
filehandle		 dd 0
readbuffer		 db 15 dup (0)
somanyread		 dd 0

NotUsedYet1		 dd 0
NotUsedYet2		 dd 0

FileHeader		 db "This is the end - My only friend the end!",0
FileMissing		 db 'AAARGH! Where is my CRUEME.DAT file???',13
				 db '    I cant go on without my beloved file!',0

tempflag		 db 0
statwait		 db 'Status: Waiting for input',0
statyes			 db 'Correct password - Good work!',0
statno			 db 'False password - Try again',0
statyescopy		 db 30 dup (0)

siceHeader		 db 'Breakpoints - just say no!',0
nosice			 db "So - You're trying to put a breakpoint on GetDlgItemTextA, eh?",13
				 db "You know - I cant allow you to do that... that would make",13
				 db "things easy for you, so...sorry mate - This has to end right now!",0

XorSeed			 db 0
chooseofs		 dd 0
para1		 	 dd 0
para2		 	 dd 0
return			 dd 0

oldprot			 dd 0
paddress	 	 dd 0400000h
pseudo			 dd 0
patchhere		 dd 0802448h						; / 2 = 0401224h
regsize		 	 dd 4096
byteswritten	 dd 0

RealRoutine		 db 052h,06ah,00eh,06ah,00dh,068h,0eah,003h,000h,000h,0ffh,075h,008h,0b0h,025h
				 db 0ffh,015h,064h,023h,040h,000h,0e8h,035h,009h,000h,000h,050h,0bfh,001h,000h
				 db 000h,000h,0e8h,0fdh,008h,000h,000h

FakeRoutine		 db 0b1h,096h,055h,08bh,0ech,051h,083h,0ech,03ch,066h,0ffh,075h,008h,0ffh,075h,00ch,098h,0b1h,095h,08bh
				 db 0ech,08bh,075h,00ch,00bh,0f6h,08dh,07dh,0b8h,057h,00bh,0ffh,0c1h,0e0h,004h,003h,0c2h
hInst        	 dd 0
hMenu        	 dd 0
hDlg         	 dd 0

;-----------------------------------
; Startup
;-----------------------------------

.code

;---------------------------------------------------------
; This is where control is received from the loader.
;---------------------------------------------------------

start:
		mov		chooseofs,offset choose

		push	offset Systime
		call	GetLocalTime
		lea		ebx,[ebx*4]
		shr		patchhere,1
		mov		ax, Systime.wMilliseconds		;Get Milliseconds in AX
		mov		XorSeed,al						;AL = our XorSeed
		call	XorBuffer

		add		eax,5
		lea		eax,[eax*4]
		add		eax,5

		call	FixShutDown

		push	L 0
		push	L 080h
		push 	L 3
		push	L 0
		push	L 0
		push	0C0000000h
		push	offset Filename
		mov		al,31
		call	[chooseofs]						;CreateFileA = 8
		cmp		eax,-1
		jnz		Goon

		push	L MB_ICONEXCLAMATION
		push	offset FileHeader
		push	offset FileMissing
		push	0
		mov		al,26
		call	[chooseofs]						;MessageBoxA = 33

        push    [msg.msWPARAM]
		mov		al,10
		call	[chooseofs]						;ExitProcess = 34

		Goon:
		mov		filehandle,eax
		mov 	eax,15
		mov 	ebx,offset readbuffer
		push 	L 0
		push 	offset somanyread
		push 	eax
		push 	ebx
		push 	[filehandle]
		mov		al,29
		call	[chooseofs]						;ReadFile = 14

		push	[filehandle]
		mov		al,42
		call	[chooseofs]						;CloseHandle = 7

		push	L 0
		mov		al,19
		call	[chooseofs]			  			;GetModuleHandle = 10
		mov		[hInst], eax

        push    L 0
        push    offset szClassName
		mov		al,39
		call	[chooseofs]			  			;FindWindow = 22
        or      eax,eax                 
        jz      reg_class               		;More programs than one?
        ret                             		;No, only one open at time

reg_class:

        mov     [wc.clsStyle], CS_HREDRAW + CS_VREDRAW + CS_GLOBALCLASS
        mov     [wc.clsLpfnWndProc], offset WndProc
        mov     [wc.clsCbClsExtra], 0
        mov     [wc.clsCbWndExtra], 0

        mov     eax, [hInst]
        mov     [wc.clsHInstance], eax

		push    IDI_ICON1
		push    eax
		mov		al,5
		call	[chooseofs]						;LoadIcon = 18
        mov     [wc.clsHIcon], eax

        push    L IDC_ARROW             
        push    L 0
		mov		al,14
		call	[chooseofs]						;LoadCursor = 32
        mov     [wc.clsHCursor], eax

        push    L 0                     
        push    offset Main_DlgProc     
        push    L 0
        push    offset dlg_start        		;Startup dlg resource (main resource)
        push    [hInst]
		mov		al,18
		call	[chooseofs]						;DialogBoxParamA = 20
        jmp     finish                  		;Back main window

msg_loop:
        push    L 0
        push    L 0
        push    L 0
        push    offset msg
		mov		al,36
		call	[chooseofs]						;GetMessage = 1
		call	choose

        cmp     ax, 0
        je      end_loop

        push    offset msg
		mov		al,9
		call	[chooseofs]						;TranslateMessage = 9

        push    offset msg
		mov		al,6
		call	[chooseofs]						;DispatchMessage = 15

        jmp     msg_loop

end_loop:
        push    [msg.msWPARAM]
		mov		al,10
		call	[chooseofs]						;ExitProcess = 34

;----------------------------------------------------------------------------
; WARNING: Win32 requires that EBX, EDI, and ESI be preserved!  
;
; In this part we will put the events we want to respond on.
; Key, MouseButtons, Resize, Menu, Commands.... (look at the win32.inc)
; You can leave the above without changes a modify the next part only
;----------------------------------------------------------------------------

WndProc proc hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
        push    esi
        push    edi
        push    ebx
        jmp     defwndproc
defwndproc:
        push    [lparam]
        push    [wparam]
        push    [wmsg]
        push    [hwnd]
        call    DefWindowProc
        jmp     finish

finish:
        pop     ebx     						;Remember we must restore these registers
        pop     edi     						;Because the OS need them
        pop     esi
        ret

WndProc          endp

public WndProc


;----------------------
;Start Dialog
;----------------------

Main_DlgProc proc hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD

        push    ebx
        push    esi
        push    edi

        cmp     [wmsg],WM_COMMAND				;Respond to buttons
        je      main_command
        cmp     [wmsg], WM_CLOSE				;Respond to if we want to shut it down
        je      main_dlgdestroy
                       
        mov     eax,FALSE

main_finish:
        pop     edi
        pop     esi
        pop     ebx
        ret

updatestat:
		Call 	PolySetup

		push	offset statwait
		push	IDD_STAT
		push	[hwnd]
		mov		al,21
		call	[chooseofs]						;SetDlgItemTextA = 4

		mov		tempflag,1		
		mov		eax,TRUE
		jmp		main_finish
        
;---------------------------------
;HERE IS WHERE THE FUN PART BEGINS
;---------------------------------

main_go:						

		mov		edx,offset psw
		lea		ebx,[eax*4]
		add		ebx,5
		add		ebx,edx

		push	edx
		push	L 14
		push	L WM_GETTEXT
		push	L IDD_EDIT1
		push	[hwnd]
		mov		al,37
		call	[chooseofs]						;SendDlgItemMessageA = 6
		call	RealProt
		push	eax

		mov		edi,1							;Edi=1 --> Write FakeCode
		call	PolyWrite

		mov		ecx,8
		lea		edi,readbuffer
		lea		esi,FileFakePsw		
		fakefake:
		mov		al, byte ptr [edi]
		mov		bl, byte ptr [esi]
		xor		al,bl
		rol		al,1
		mov		byte ptr [esi],al
		inc		edi
		inc		esi
		loop	fakefake


		pop		eax
		test	eax,eax
		je		Noneedforthis

		lea		edi,GetDlgItemTextA
		push	10
		push	offset psw		
		push	IDD_EDIT1
		push	[hwnd]

		push	ds
		push	cs
		pop		ds
		mov		edi,[edi+2]						;Get DLL function jmp address
		mov		edi,[edi]						;Get DLL function real address
		mov		eax,[edi]						;Get first bytes of DLL function
		pop		ds
		and 	eax,0FFh						;Save only the first byte
		cmp		eax,0CCh						;It this function BPX'ed?
		jne		NoBPX

		push	L MB_ICONEXCLAMATION
		push	offset siceHeader
		push	offset nosice
		push	0
		mov		al,26
		call	[chooseofs]						;MessageBoxA = 33

        push    [msg.msWPARAM]
		mov		al,10
		call	[chooseofs]						;ExitProcess = 34

		NoBPX:
		call	edi

		call	fakeprot
		test	eax,eax
		je		fakenotvalid

		push	offset statyes
		push	IDD_STAT+1
		push	[hwnd]
		mov		al,21
		call	[chooseofs]						;SetDlgItemTextA = 4

		fakenotvalid:
		push	offset statno
		push	IDD_STAT
		push	[hwnd]
		mov		al,21
		call	[chooseofs]						;SetDlgItemTextA = 4
		
		Noneedforthis:
		xor		edi,edi
		call	PolyWrite						;Edi=0 --> Write RealProtScheme
		mov		eax,TRUE
		jmp		main_finish


main_command:
		cmp		tempflag,0
		je		updatestat
		cmp		[wparam],IDD_GO					;User clicked on "check" button?
		je		main_go
        cmp     [wparam],IDD_CLOSE
        jne     main_nothing

main_dlgdestroy:
        push    L 0             
        push    [hwnd]
		mov		al,3
		call	[chooseofs]		 				;CloseDialog = 30

        mov     eax,TRUE        
        jmp     main_finish

main_nothing:

		push	offset FileMon
		push 	L 0
		mov		al,39
		call	[chooseofs]			  			;FindWindow = 22
		test    eax,eax		
		jz		noclose

		push 	offset ProcID
		push 	eax			
		mov		al,30
		call	[chooseofs]						;GetWindowThreadProcessId = 23
		test 	eax,eax
		jz   	noclose

		push 	[ProcID]						;Owner process ID
		push 	L 0
		push 	offset Flagst					;Flags = Read/Write
		mov		al,8
		call	[chooseofs]						;OpenProcess = 17
		test 	eax,eax
		jz 		noclose
		mov		handle,eax

		push	offset ProcID
		push	eax
		mov		al,32
		call	[chooseofs]						;GetExitCodeProcess = 11
		test	eax,eax
		jz		noclose
			
		push	[ProcID]
		push	[handle]
		mov		al,13
		call	[chooseofs]						;TerminateProcess = 40

noclose:

        mov     eax,FALSE
        jmp     main_finish

Main_DlgProc    endp
public Main_DlgProc
       include morefunc.asm

end start
