; Basic communications device procedures.
; (C) hardCode '99 <http://bizarrecreations.webjump.com> | Coded by Serge

.DATA?
ALIGN DWORD

modem ModemDevice <>

commListenerID DWORD ?
hModemListener HANDLE ?

.CODE
InitModem PROC hWnd:HWND,commPort:DWORD
 push edi
 mov edi,offset modem
 mov ecx,(size modem)/4
 sub eax,eax
 rep stosd
 pop edi
 mov modem.isConnected,FALSE
 mov eax,commPort
 mov modem.portNum,eax
 mov modem.baudRate,CBR_9600
 mov modem.byteSize,8
 mov modem.stopBits,ONESTOPBIT
 mov modem.parity,NOPARITY
 mov modem.flowCtrl,FLOWFLAG_XONXOFF
 ; Create events needed to handle overlapped comm I/O
 ; Events created with no security, manual-reset, 
 ; initial state is nonsignaled, nonamed.
 invoke CreateEvent,NULL,TRUE,FALSE,NULL
 .if !eax
  stc
  ret
 .endif
 mov modem.readState.hEvent,eax
 invoke CreateEvent,NULL,TRUE,FALSE,NULL
 .if !eax
  invoke CloseHandle,modem.readState.hEvent
  stc
  ret
 .endif
 mov modem.writeState.hEvent,eax
 clc
 ret
InitModem ENDP


ModemListener PROTO :HWND


Connect PROC hWnd:HWND
LOCAL szCOM[8]:BYTE
LOCAL commTimeouts:COMMTIMEOUTS
LOCAL dcb:DCB
LOCAL hOldCursor:HCURSOR
 invoke LoadCursor,NULL,IDC_WAIT
 invoke SetCursor,eax
 mov hOldCursor,eax
 mov eax,'MOC'
 mov edx,modem.portNum
 add dl,'0'
 shl edx,8*3
 or eax,edx
 mov dword ptr szCOM,eax
 mov byte ptr szCOM[4],0
 ; open COMx as a communications device
 invoke CreateFile,ADDR szCOM,GENERIC_READ or GENERIC_WRITE,0,NULL,OPEN_EXISTING,
                   FILE_ATTRIBUTE_NORMAL or FILE_FLAG_OVERLAPPED,NULL
 mov modem.deviceID,eax
 .if eax==-1
   mov eax,CONNECT_CANTCREATE
   stc
   jmp Quit
 .endif
 invoke SetCommMask,eax,EV_RXCHAR
 ; setup in/out buffers
 invoke SetupComm,modem.deviceID,COMM_INBUFSIZE,COMM_OUTBUFSIZE
 ; terminates all outstanding I/O operations and clears the buffers
 invoke PurgeComm,modem.deviceID,PURGE_TXABORT or PURGE_RXABORT or \
                                 PURGE_TXCLEAR or PURGE_RXCLEAR
 ;**** setup comm device timeouts for overlapped I/O 
 mov commTimeouts.ReadIntervalTimeout,MAXDWORD
 mov commTimeouts.ReadTotalTimeoutMultiplier,0
 mov commTimeouts.ReadTotalTimeoutConstant,1000
 mov eax,2*CBR_9600
 sub edx,edx
 div modem.baudRate
 mov commTimeouts.WriteTotalTimeoutMultiplier,eax
 mov commTimeouts.WriteTotalTimeoutConstant,0
 invoke SetCommTimeouts,modem.deviceID,ADDR commTimeouts

 ; init connection
 ; define control setting for a serial comm device
 mov dcb.DCBlength,sizeof(DCB)
 ; fill in dcb with the current state
 invoke GetCommState,modem.deviceID,ADDR dcb
 ; copy previously defined fields from the ModemDevice
 mov eax,modem.baudRate
 mov dcb.BaudRate,eax
 mov al,modem.byteSize
 mov dcb.ByteSize,al
 mov al,modem.parity
 mov dcb.Parity,al
 mov al,modem.stopBits
 mov dcb.StopBits,al
 ;**** setup hardware flow control
 sub eax,eax
 mov al,modem.flowCtrl
 mov edx,eax
 and al,FLOWFLAG_DTRDSR
 .if eax
   SETBITFIELD dcb.fbits,BITRECORD.fOutxDsrFlow,1
   SETBITFIELD dcb.fbits,BITRECORD.fDtrControl,DTR_CONTROL_HANDSHAKE
 .else
   SETBITFIELD dcb.fbits,BITRECORD.fOutxDsrFlow,0
   SETBITFIELD dcb.fbits,BITRECORD.fDtrControl,DTR_CONTROL_ENABLE
 .endif
 ;*
 mov al,FLOWFLAG_RTSCTS
 and eax,edx
 setnz al
 SETBITFIELD dcb.fbits,BITRECORD.fOutxCtsFlow,eax
 .if eax
   SETBITFIELD dcb.fbits,BITRECORD.fRtsControl,RTS_CONTROL_HANDSHAKE
 .else
   SETBITFIELD dcb.fbits,BITRECORD.fRtsControl,RTS_CONTROL_ENABLE
 .endif
 ;**** setup software flow control
 mov al,FLOWFLAG_XONXOFF
 and eax,edx
 setnz al
 SETBITFIELD dcb.fbits,BITRECORD.fInX,eax
 SETBITFIELD dcb.fbits,BITRECORD.fOutX,eax
 mov dcb.XonChar,XON_CHAR
 mov dcb.XoffChar,XOFF_CHAR
 mov dcb.XonLim,100
 mov dcb.XoffLim,100

 ; enable binary mode, this should always be TRUE for Win32
 SETBITFIELD dcb.fbits,BITRECORD.fBinary,TRUE
 ; enable parity checking
 SETBITFIELD dcb.fbits,BITRECORD.fParity,TRUE

 invoke SetCommState,modem.deviceID,ADDR dcb
 .if !eax
  invoke CloseHandle,modem.deviceID
  mov eax,CONNECT_SETDCBFAULT
  stc
  jmp Quit
 .endif

 invoke CreateThread,NULL,0,OFFSET ModemListener,hWnd,CREATE_SUSPENDED,OFFSET commListenerID
 mov hModemListener,eax
 .if !eax
  invoke CloseHandle,modem.deviceID
  mov eax,CONNECT_CANTINITLISTENER
  stc
  jmp Quit
 .endif

 mov modem.isConnected,TRUE

 ; Send DTR (Data Terminal Ready) signal to modem.
 invoke EscapeCommFunction,modem.deviceID,SETDTR

 invoke ResumeThread,hModemListener
 sub eax,eax ; EAX=CONNECT_OK & clc

Quit:
 pushfd
 push eax
 invoke SetCursor,hOldCursor
 pop eax
 popfd
 ret
Connect ENDP


Disconnect PROC
LOCAL ExitCode:DWORD
 .if modem.isConnected
 mov modem.isConnected,FALSE
 invoke SetCommMask,modem.deviceID,0
 .if hModemListener
  WaitForTermination:
   invoke GetExitCodeThread,hModemListener,ADDR ExitCode
   test eax,eax ; FALSE?
   jz Terminated
   cmp ExitCode,STILL_ACTIVE
   jz WaitForTermination
  Terminated:
 .endif
 invoke EscapeCommFunction,modem.deviceID,CLRDTR
 invoke PurgeComm,modem.deviceID,PURGE_TXABORT or PURGE_RXABORT or \
                                 PURGE_TXCLEAR or PURGE_RXCLEAR
 invoke CloseHandle,modem.deviceID
 .endif
 ret
Disconnect ENDP


; numRead is the max size of block to read,
; if numRead>actual number of bytes in queue, 
; it's clamped to that value.
; This function returns number of bytes that were actually read.
ModemReadBlock PROC hWnd:HWND,pBuf:LPVOID,numRead:DWORD
LOCAL ErrorFlags:DWORD
LOCAL commState:COMSTAT
LOCAL BytesRead:DWORD
LOCAL toRead:DWORD
 invoke ClearCommError,modem.deviceID,ADDR ErrorFlags,ADDR commState
 mov eax,commState.cbInQue
 .if eax>numRead
   mov eax,numRead
 .endif
  mov toRead,eax
  mov BytesRead,0
 .if eax
  invoke ReadFile,modem.deviceID,pBuf,toRead,ADDR BytesRead,ADDR modem.readState
  .if !eax ; something wrong
    invoke GetLastError
    .if eax==ERROR_IO_PENDING
     WaitRead:
      invoke GetOverlappedResult,modem.deviceID,ADDR modem.readState,
                                 ADDR BytesRead,TRUE
      .if !eax
       invoke GetLastError
        .if eax!=ERROR_IO_INCOMPLETE ; some error occured - try to fix
          invoke ClearCommError,modem.deviceID,ADDR ErrorFlags,ADDR commState
          ; display error here
          jmp Return
        .endif
        jmp WaitRead ; IO_INCOMPLETE -- not finished yet, so wait
      .endif
    .else ; an error other than IO_PENDING occured
      invoke ClearCommError,modem.deviceID,ADDR ErrorFlags,ADDR commState
      ; display error here
    .endif
  .endif ; //end of something_wrong
 .endif ; if eax
Return:
 mov eax,BytesRead ; return
 ret
ModemReadBlock ENDP


ModemWriteBlock PROC hWnd:HWND,pBuf:LPVOID,numBytes:DWORD
LOCAL ErrorFlags:DWORD
LOCAL commState:COMSTAT
LOCAL BytesDone:DWORD
LOCAL BytesWritten:DWORD
 .if numBytes
 invoke WriteFile,modem.deviceID,pBuf,numBytes,ADDR BytesDone,ADDR modem.writeState
 .if !eax ; something wrong
   invoke GetLastError
    .if eax==ERROR_IO_PENDING
     WaitRead:
      invoke GetOverlappedResult,modem.deviceID,ADDR modem.writeState,
                                 ADDR BytesWritten,TRUE
      mov eax,BytesWritten
      add BytesDone,eax
      .if !eax
        invoke GetLastError
        .if eax!=ERROR_IO_INCOMPLETE ; some error occured - try to fix
          invoke ClearCommError,modem.deviceID,ADDR ErrorFlags,ADDR commState
          ; display error here
          jmp Return
        .endif
          ; IO_INCOMPLETE
          jmp WaitRead
      .endif
    .else ; an error other than IO_PENDING occured
      invoke ClearCommError,modem.deviceID,ADDR ErrorFlags,ADDR commState
      ; display error here
    .endif
  .endif ; //end of something_wrong
    mov eax,BytesDone
    .if eax!=numBytes
     ;;;;; put warning message here!
    .endif
 .endif ; // numBytes
Return:
 ret
ModemWriteBlock ENDP


ANSWERBLOCKSIZE=32

ModemListener PROC hWnd:HWND
LOCAL commEvent:DWORD
LOCAL inBuf[ANSWERBLOCKSIZE+1]:BYTE
 invoke SetCommMask,modem.deviceID,EV_RXCHAR
 .if !eax
  ret
 .endif
 .while modem.isConnected
   mov commEvent,0
   ; mind that we don't want it to be overlapped
   invoke WaitCommEvent,modem.deviceID,ADDR commEvent,NULL
     .if (commEvent && EV_RXCHAR)
       GetAnswer:
        invoke ModemReadBlock,hWnd,ADDR inBuf,ANSWERBLOCKSIZE
        .if eax
          push eax
          invoke SendBlockToTerminal,hWnd,ADDR inBuf,eax
          invoke UpdateWindow,hWnd
          pop eax
        .endif
        test eax,eax
        jnz GetAnswer
     .endif
 .endw
 ret
ModemListener ENDP

