; (C) hardCode '99 <http://bizarrecreations.webjump.com> | Coded by Serge

.DATA
szTerminalDefFont db 'FixedSys',0

.DATA?
ALIGN DWORD

terminal Terminal <>

.CODE
ResizeTerminalBuffer PROC x,y
 mov eax,terminal.tBackbuffPtr
 .if eax
  invoke GlobalFree,eax
 .endif
 mov eax,x
 or eax,y
 .if ZERO?
    mov eax,terminal.tBackbuffPtr
   .if eax
    invoke GlobalFree,eax
   .endif
  sub eax,eax
  mov terminal.numCols,eax
  mov terminal.maxCol,eax
  mov terminal.numRows,eax
  mov terminal.maxRow,eax
 .else
 mov eax,x
 mul y
 push eax
 invoke GlobalAlloc,GMEM_FIXED OR GMEM_ZEROINIT,eax
 pop ecx
 mov terminal.tBackbuffPtr,eax
 lea edx,[eax+ecx]
 mov terminal.maxPtr,edx
 xchg edi,eax
 push eax
 mov al,' '
 rep stosb
 pop edi
 mov eax,x
 mov terminal.numCols,eax
 dec eax
 mov terminal.maxCol,eax
 mov eax,y
 mov terminal.numRows,eax
 dec eax
 mov terminal.maxRow,eax
 .endif
 ret
ResizeTerminalBuffer ENDP

MoveTerminalCursor PROC hWnd:HWND
 .if (terminal.tBackbuffPtr && terminal.tCursorState)
  mov eax,terminal.tPosX
  mul terminal.tCharWidth
  sub eax,terminal.tScrollX
  mov ecx,terminal.tPosY
  xchg eax,ecx
  mul terminal.tCharHeight
  sub eax,terminal.tScrollY
  invoke SetCaretPos,ecx,eax
 .endif
 ret
MoveTerminalCursor ENDP

InitTerminal PROC hWnd:HWND
LOCAL FontMetrix:TEXTMETRIC
LOCAL winRect:RECT
 push edi
 push esi
 ASSUME edi:PTR LOGFONT
 mov edi,OFFSET terminal.ltFont
 sub eax,eax
 mov [edi].lfHeight,17
 mov [edi].lfWidth,eax      ; let the font mapper find a closest match for the width
 mov [edi].lfEscapement,eax
 mov [edi].lfOrientation,eax
 mov [edi].lfWeight,eax     ; use default weight
 mov [edi].lfItalic,al      ; no italic
 mov [edi].lfUnderline,al   ; no underline
 mov [edi].lfStrikeOut,al
 mov [edi].lfCharSet,OEM_CHARSET ; ANSI_CHARSET
 mov [edi].lfOutPrecision,OUT_DEFAULT_PRECIS
 mov [edi].lfClipPrecision,CLIP_DEFAULT_PRECIS
 mov [edi].lfQuality,DEFAULT_QUALITY ; PROOF_QUALITY
 mov [edi].lfPitchAndFamily,FIXED_PITCH or FF_MODERN
 push edi
 lea edi,[edi].lfFaceName
 mov esi,offset szTerminalDefFont
 mov ecx,SIZEOF szTerminalDefFont
 rep movsb
 pop edi

 invoke GetDC,hWnd
 mov terminal.tDC,eax
 mov terminal.tTextColor,0040FF40h
 ;;invoke GetSysColor,COLOR_WINDOW
 mov terminal.tBackColor,0

 invoke CreateFontIndirect,edi
 mov terminal.htFont,eax
 invoke SelectObject,terminal.tDC,eax
 invoke GetTextMetrics,terminal.tDC,ADDR FontMetrix
 mov eax,FontMetrix.tmAveCharWidth
 mov terminal.tCharWidth,eax
 ; char height = ascent+descent+extra space between rows
 mov eax,FontMetrix.tmHeight
 add eax,FontMetrix.tmExternalLeading
 mov terminal.tCharHeight,eax

 ; 80x40 window
 invoke ResizeTerminalBuffer,80,40

 invoke GetWindowRect,hWnd,ADDR winRect
 mov eax,winRect.right
 mov edx,winRect.bottom
 sub eax,winRect.left
 sub edx,winRect.top
 ; MAKELONG
 movzx eax,ax
 shl edx,16
 or eax,edx
 invoke SendMessage,hWnd,WM_SIZE,SIZENORMAL,eax

 ASSUME edi:nothing
 pop esi
 pop edi
 ret
InitTerminal ENDP

KillTerminal PROC
 invoke ResizeTerminalBuffer,0,0
 ret
KillTerminal ENDP

CreateTerminalCursor PROC hWnd:HWND
 ; Create text cursor
 mov eax,terminal.tCharHeight
 imul eax,7
 shr eax,3
 invoke CreateCaret,hWnd,NULL,2,eax
 invoke ShowCaret,hWnd
 mov terminal.tCursorState,TRUE
 invoke MoveTerminalCursor,hWnd
 ret
CreateTerminalCursor ENDP

KillTerminalCursor PROC hWnd:HWND
 invoke HideCaret,hWnd
 invoke DestroyCaret
 mov terminal.tCursorState,FALSE
 ret
KillTerminalCursor ENDP



X2CHARS MACRO
 sub edx,edx
 div terminal.tCharWidth
ENDM

Y2CHARS MACRO
 sub edx,edx
 div terminal.tCharHeight
ENDM

GETMIN MACRO x,y
 .if x>y
  mov x,y
 .endif
ENDM

PaintTerminal PROC hWnd:HWND
LOCAL ps:PAINTSTRUCT
LOCAL OldFontHandle:HFONT
LOCAL sX:DWORD
LOCAL sY:DWORD
LOCAL eX:DWORD
LOCAL eY:DWORD
LOCAL clipRect:RECT
LOCAL numChars:DWORD
 invoke BeginPaint,hWnd,ADDR ps
 invoke SelectObject,terminal.tDC,terminal.htFont
 mov OldFontHandle,eax
 invoke SetTextColor,terminal.tDC,terminal.tTextColor
 invoke SetBkColor,terminal.tDC,terminal.tBackColor
 invoke SetBkMode,terminal.tDC,OPAQUE
 ;----
 mov eax,ps.rcPaint.left
 add eax,terminal.tScrollX
 .if SIGN?
  xor eax,eax
 .else
  X2CHARS
  GETMIN eax,terminal.maxCol
 .endif
 mov sX,eax ; position in virtual buffer of a leftmost visible char
 mul terminal.tCharWidth
 sub eax,terminal.tScrollX
 mov clipRect.left,eax ; horizontal position
 ;----
 mov eax,ps.rcPaint.top
 add eax,terminal.tScrollY
 .if SIGN?
  xor eax,eax
 .else
  Y2CHARS
  GETMIN eax,terminal.maxRow
 .endif
 mov sY,eax ; position in virtual buffer of a topmost visible char
 mul terminal.tCharHeight
 sub eax,terminal.tScrollY
 mov clipRect.top,eax
 ;----
 mov eax,ps.rcPaint.right
 add eax,terminal.tScrollX
 dec eax
 X2CHARS
 GETMIN eax,terminal.maxCol
 mov eX,eax     ; rightmost
 mov edx,eax
 sub eax,sX
 inc eax
 mov numChars,eax    ; number of visible chars in line
 inc edx
 mov eax,terminal.tCharWidth
 mul edx
 mov clipRect.right,eax
 ;----
 mov eax,ps.rcPaint.bottom
 add eax,terminal.tScrollY
 dec eax
 Y2CHARS
 GETMIN eax,terminal.maxRow
 mov eY,eax
 inc eax
 mul terminal.tCharHeight
 mov clipRect.bottom,eax
 ;----
 ;Calc address of a first char in the offscreen buffer
 mov eax,sY
 mul terminal.numCols
 add eax,sX
 add eax,terminal.tBackbuffPtr
 mov ecx,eY
 xchg edi,eax
 sub ecx,sY ; Num lines
 push eax
PrintOut:
 push ecx
 invoke ExtTextOut,terminal.tDC,clipRect.left,clipRect.top,\
        ETO_OPAQUE or ETO_CLIPPED,ADDR clipRect,edi,numChars,NULL
 add edi,terminal.numCols ; move to the next line in the offscreen buffer
 mov eax,terminal.tCharHeight
 add clipRect.top,eax
 add clipRect.bottom,eax
 pop ecx
 dec ecx
 jns PrintOut
 invoke SelectObject,terminal.tDC,OldFontHandle ; restore font
 invoke EndPaint,hWnd,ADDR ps
 pop edi
 ret
PaintTerminal ENDP


SendBlockToTerminal PROC hWnd:HWND,BlockPtr:LPVOID,BlockSize:DWORD
LOCAL RefreshRect:RECT
 .if !BlockSize
  ret
 .endif
 mov eax,terminal.tBackbuffPtr
 .if eax
  xchg edi,eax
  push eax
  push esi
  mov eax,terminal.tPosY
  mul terminal.numCols
  add eax,terminal.tPosX
  mov esi,BlockPtr
  add edi,eax
  mov ecx,BlockSize
PrintBlock:
  lodsb
 .if al==10  ; LF
   inc terminal.tPosY
   mov terminal.tPosX,0
   mov eax,terminal.tPosY
   mul terminal.numCols
   add eax,terminal.tBackbuffPtr
   mov edi,eax
   .if edi>=terminal.maxPtr
     call Feed
   .endif
 .elseif al==13 ; CR
 .elseif al==8  ; BS
  .if terminal.tPosX>0
     dec terminal.tPosX
     dec edi
     mov byte ptr [edi],' '
     call RefreshChar
  .endif
 .else
 ; put symbol into offcreen buffer
 stosb
 ; show symbol on the screen
 call RefreshChar
 ; move further in the X direction
 mov eax,terminal.tPosX
 inc eax
  .if eax>terminal.maxCol
    inc terminal.tPosY
     .if edi>=terminal.maxPtr
       call Feed
     .endif
    xor eax,eax
  .endif
 mov terminal.tPosX,eax
 .endif
 dec ecx
 jnz PrintBlock
 invoke MoveTerminalCursor,hWnd
 .endif
 ret
Feed:
  push esi
  push ecx
  mov edi,terminal.tBackbuffPtr
  mov ecx,terminal.numCols
  mov edx,terminal.maxRow ; (numRows-1)
  lea esi,[edi+ecx]
  imul ecx,edx
  mov terminal.tPosY,edx
  rep movsb
  push edi
  push eax
  mov ecx,terminal.numCols
  mov al,' '
  rep stosb
  invoke InvalidateRect,hWnd,NULL,FALSE
  pop eax
  pop edi
  pop ecx
  pop esi
  retn
RefreshChar:
  mov eax,terminal.tPosX
  mul terminal.tCharWidth
  sub eax,terminal.tScrollX
  mov RefreshRect.left,eax
  add eax,terminal.tCharWidth
  mov RefreshRect.right,eax
  mov eax,terminal.tPosY
  mul terminal.tCharHeight
  sub eax,terminal.tScrollY
  mov RefreshRect.top,eax
  add eax,terminal.tCharHeight
  mov RefreshRect.bottom,eax
  pushad
  invoke InvalidateRect,hWnd,ADDR RefreshRect,FALSE
  popad
  retn
SendBlockToTerminal ENDP

ResizeTerminalWindow PROC hWnd:HWND,newWidth:DWORD,newHeight:DWORD
 mov eax,newWidth
 mov terminal.tWinWidth,eax
 mov ecx,terminal.tCharWidth
 neg eax
 imul ecx,terminal.numCols
 add eax,ecx ; UnvisibleWidth=numColumns*CharWidth-WindowWidth
 .if SIGN?   ; sanity check
  sub eax,eax
 .endif
 mov terminal.tUnvisibleW,eax
 ;----
 mov eax,newHeight
 mov terminal.tWinHeight,eax
 mov ecx,terminal.tCharHeight
 neg eax
 imul ecx,terminal.numRows
 add eax,ecx ; UnvisibleHeight=numRows*CharHeight-WindowHeight
 .if SIGN?   ; sanity check
  xor eax,eax
 .endif
 mov terminal.tUnvisibleH,eax
 ;----
 mov eax,terminal.tScrollX
 GETMIN eax,terminal.tUnvisibleW
 sub eax,terminal.tScrollX ; eax = scroll amount
 add terminal.tScrollX,eax
 neg eax
 invoke ScrollWindow,hWnd,0,eax,NULL,NULL
 invoke SetScrollPos,hWnd,SB_HORZ,terminal.tScrollX,FALSE
 invoke SetScrollRange,hWnd,SB_HORZ,0,terminal.tUnvisibleW,TRUE
 ;----
 mov eax,terminal.tScrollY
 GETMIN eax,terminal.tUnvisibleH
 sub eax,terminal.tScrollY ; eax = scroll amount
 add terminal.tScrollY,eax
 neg eax
 invoke ScrollWindow,hWnd,0,eax,NULL,NULL
 invoke SetScrollPos,hWnd,SB_VERT,terminal.tScrollY,FALSE
 invoke SetScrollRange,hWnd,SB_VERT,0,terminal.tUnvisibleH,TRUE
 ;----
 invoke InvalidateRect,hWnd,NULL,TRUE
 ret
ResizeTerminalWindow ENDP


ScrollTerminal PROC hWnd:HWND,ScrollDir:DWORD,ScrollCommand:DWORD,ScrollPos:DWORD
LOCAL barPos:DWORD
LOCAL newPos:DWORD
LOCAL pPos:LPVOID
LOCAL ClippedSize:DWORD
LOCAL CharSize:DWORD
LOCAL PageSize:DWORD
LOCAL SB_Cmd:DWORD
 .if ScrollDir==TERM_SCROLLHORZ
   mov eax,OFFSET terminal.tScrollX
   mov pPos,eax
   mov eax,[eax]
   mov barPos,eax
   mov eax,terminal.tUnvisibleW
   mov ClippedSize,eax
   mov eax,terminal.tCharWidth
   mov CharSize,eax
   mov eax,terminal.tWinWidth
   mov PageSize,eax
   mov SB_Cmd,SB_HORZ
 .else
   mov eax,OFFSET terminal.tScrollY
   mov pPos,eax
   mov eax,[eax]
   mov barPos,eax
   mov eax,terminal.tUnvisibleH
   mov ClippedSize,eax
   mov eax,terminal.tCharHeight
   mov CharSize,eax
   mov eax,terminal.tWinHeight
   mov PageSize,eax
   mov SB_Cmd,SB_VERT
 .endif
 ; Calc scroll amount, depending on scrolling command
 mov eax,ScrollCommand
 .if eax==SB_TOP
   mov edx,barPos
   neg edx ; back to home
 .elseif eax==SB_BOTTOM
   mov edx,ClippedSize
   sub edx,barPos
 .elseif eax==SB_LINEUP
   mov edx,CharSize
   neg edx
 .elseif eax==SB_LINEDOWN
   mov edx,CharSize
 .elseif eax==SB_PAGEUP
   mov edx,PageSize
   neg edx
 .elseif eax==SB_PAGEDOWN
   mov edx,PageSize
 .elseif eax==SB_THUMBPOSITION ; ScrollPos=current position
   mov edx,ScrollPos
   sub edx,barPos
 .else
   jmp Quit
 .endif
 mov eax,barPos
 add eax,edx
 .if SIGN?
  mov edx,barPos
  neg edx
 .elseif eax>ClippedSize
  mov edx,ClippedSize
  sub edx,barPos
 .endif
 mov eax,barPos
 add eax,edx
 mov ecx,pPos
 mov newPos,eax
 mov [ecx],eax
 neg edx
 xor ecx,ecx
 .if ScrollDir==TERM_SCROLLHORZ
   xchg ecx,edx ; swap dX,dY
 .endif
 invoke ScrollWindow,hWnd,ecx,edx,NULL,NULL
 invoke SetScrollPos,hWnd,SB_Cmd,newPos,TRUE
Quit:
 ret
ScrollTerminal ENDP

SendCharToTerminal PROC hWnd:HWND,Char:DWORD
 invoke SendBlockToTerminal,hWnd,ADDR Char,1
 ret
SendCharToTerminal ENDP
