.386
locals
jumps
.model flat,STDCALL

include win32.inc
include wsock32.inc

;---------------------------------------------------------------------

L equ <LARGE>

WM_SOCKET   equ WM_USER+100

IDD_EXIT	 EQU 1001
IDD_YOU		 EQU 1002
IDD_REMOTE   EQU 1003
IDD_SEND	 EQU 1004
IDD_CONNECT  EQU 1005
IDD_CANCEL   EQU 1006
IDD_STATUS	 EQU 1007
IDI_ICON1    EQU 100
IDD_IPEDIT   EQU 1103
IDD_ABOUTOK	 EQU 1300

IDM_CONN     EQU 1200
IDM_USERINFO EQU 1201
IDM_ABOUT    EQU 1202
IDM_EXIT     EQU 1203

TRUE        EQU 1
FALSE       EQU 0
NULL        EQU 0

;-----------

.data

szTitleName      db '',0
szClassName      db 'ASMCLASS32',0
msg              MSGSTRUCT   <?>
wc               WNDCLASS    <?>

wsadata 		 WSAdata <?> 
sin 			 sockaddr_in <?>

szNULL   		 db      0
ymenu    		 dd      0

hInst            dd 0
hMenu            dd 0
hDlg             dd 0

dlg_start        db 'DLG_START',0
dlg_about		 db 'DLG_ABOUT',0
dlg_conn		 db 'DLG_CONN',0

sockdes			 dd 0
newsockdes		 dd 0
TheIP			 db 16 dup (0)
PORT			 dd 1024

ServDowntitle	 db 'Connection lost!',0
ServDowntext	 db 'Connection to server lost, exiting!',0
err2title		 db 'No connection!',0
err2text		 db 'Could not establish connection!',0

conntitle		 db 'Connection!',0
conntext		 db 'Connection established!',0

NotConnected     db '          Not Connected',0
Connection		 db '            Connected',0

CrueStr     	 db ' Welcome to CrueChat! ',13,10,13,10,0
SendBuffer   	 db 256 dup (0)
ReadBuffer		 db 256 dup (0)

.code

;---------------------------------------------------------
; This is where control is received from the loader.
;---------------------------------------------------------


start:
        push    0
        call    GetModuleHandle         
        mov     [hInst], eax            

		push	offset wsadata					;Let's start
		push	0101h
		call	WSAStartup
		test	eax,eax
		jne		error

		push	0								;Create socket
		push	SOCK_STREAM
		push	PF_INET
		call	socket
		mov		sockdes,eax

		mov 	sin.sin_family, AF_INET 		;Convert the port
		push	PORT
		call	htons
		mov 	sin.sin_port,ax 		

		jmp		reg_class
error:
        ret

reg_class:

        mov     [wc.clsStyle], CS_HREDRAW + CS_VREDRAW + CS_GLOBALCLASS
        mov     [wc.clsLpfnWndProc], offset WndProc
        mov     [wc.clsCbClsExtra], 0
        mov     [wc.clsCbWndExtra], 0

        mov     eax, [hInst]
        mov     [wc.clsHInstance], eax

		push    IDI_ICON1
		push 	eax
        call    LoadIcon

        mov     [wc.clsHIcon], eax

        push    L IDC_ARROW             
        push    L 0
        call    LoadCursor
        mov     [wc.clsHCursor], eax

        push    0                   
        push    offset Main_DlgProc
        push    0
        push    offset dlg_start
        push    [hInst]
        call    DialogBoxParamA
        jmp     finish

msg_loop:
        push    L 0
        push    L 0
        push    L 0
        push    offset msg
        call    GetMessage

        cmp     ax, 0
        je      end_loop

        push    offset msg
        call    TranslateMessage

        push    offset msg
        call    DispatchMessage

        jmp     msg_loop

end_loop:

        push    [msg.msWPARAM]
        call    ExitProcess             


;----------------------------------------------------------------------------
; WARNING: Win32 requires that EBX, EDI, and ESI be preserved!  

WndProc proc hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
        push    esi
        push    edi
        push    ebx
        jmp     defwndproc

defwndproc:
        push    [lparam]
        push    [wparam]
        push    [wmsg]
        push    [hwnd]
        call    DefWindowProc
        jmp     finish

finish:
        pop     ebx
        pop     edi
        pop     esi
        ret
WndProc endp

public WndProc


;----------------------
;Main Dialog
;----------------------

Main_DlgProc proc hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD

        push    ebx
        push    esi
        push    edi

		cmp		[wmsg],WM_SOCKET
		je		socket_event
		cmp     [wmsg],WM_COMMAND
        je      main_command
		cmp		[wmsg],WM_INITDIALOG
		je		main_init
        cmp     [wmsg], WM_CLOSE
        je      main_dlgdestroy
        mov     eax,FALSE

main_finish:
        pop     edi
        pop     esi
        pop     ebx
        ret

dlgconn:
        push    L 0                     
        push    offset Conn_DlgProc
        push    [hwnd]
        push    offset dlg_conn
        push    [hInst]
        call    DialogBoxParamA
        jmp     main_finish

dlgabout:
        push    L 0         
        push    offset About_DlgProc      
        push    [hwnd]
        push    offset dlg_about
        push    [hInst]
        call    DialogBoxParamA
		jmp		main_finish

socket_event:
		mov		eax,lparam
		cmp		ax,FD_CONNECT					;Do we have a FD_CONNECT msg?
		jne		go_on							;If not, move on

		push	0
		push	offset conntitle
		push	offset conntext
		push	[hwnd]
		call	MessageBoxA

		push	offset Connection
		push	IDD_STATUS
		push	[hwnd]
		call	SetDlgItemTextA
		jmp		go_on

go_on:
		mov		eax,lparam
		cmp		ax,FD_READ						;Do we have a FD_READ msg?
		jne		go_on2							;If not, move on

		push	0
		push	256
		push	offset ReadBuffer
		push	[newsockdes]
		call	recv							;Recieve the text
		cmp     eax,-1							;If error, then move on
		je		go_on2

		mov		ecx,eax							;Our MEGA COOL encryption algorightm :)
		lea		edi,ReadBuffer
XorLoop:							
		xor		byte ptr [edi],19
		inc		edi
		loop	XorLoop

		lea		edi,ReadBuffer
		add		edi,eax
		mov		byte ptr [edi],13				;Add a line feed to the text
		mov		byte ptr [edi+1],10

		push	offset ReadBuffer
		push	0
		push	EM_REPLACESEL
		push	IDD_REMOTE
		push	[hwnd]
		call	SendDlgItemMessageA				;Show the message in the "Chat Window"

		mov		al,0							;Clear the string
		mov		ecx,256
		lea		edi,ReadBuffer
		rep		stosb

	go_on2:

		mov		eax,lparam
		cmp		ax,FD_CLOSE						;Do we have a FD_CLOSE msg?
		jne		go_on4							;If not, move on

		push	0								;Show "Server is down" message
		push	offset ServDowntitle
		push	offset ServDowntext
		push	[hwnd]
		call	MessageBoxA
		jmp		main_dlgdestroy					;Exit the program

	go_on4:

		mov		eax,TRUE
		jmp		main_finish

main_init:

		push	offset CrueStr
		push	0
		push	EM_REPLACESEL
		push	IDD_REMOTE
		push	[hwnd]
		call	SendDlgItemMessageA				;Send the welcome string to the "Chat Window"

		push	FD_CONNECT+FD_CLOSE+FD_READ		;Choose what msg's to respond to
		push	WM_SOCKET
		push	[hwnd]
		push	[sockdes]
		call	WSAAsyncSelect

		push	0
		push	256
		push	EM_LIMITTEXT
		push	IDD_YOU
		push	[hwnd]
		call	SendDlgItemMessageA				;Limit the text in the "you" edit field

		push	offset NotConnected
		push	IDD_STATUS
		push	[hwnd]
		call	SetDlgItemTextA

		mov		eax,TRUE
		jmp		main_finish

main_command:

		cmp		[wparam],IDM_CONN
		je		dlgconn
		cmp		[wparam],IDM_ABOUT
		je		dlgabout
		cmp		[wparam],IDM_EXIT
		je		main_dlgdestroy
       	cmp		[wparam],IDD_SEND
		je		main_send
		cmp     [wparam],IDD_EXIT
        jne     main_nothing

main_dlgdestroy:

		push	[newsockdes]					;We must close all open sockets
		call	closesocket

		push	[sockdes]						;We must close all open sockets
		call	closesocket

		call	WSACleanup						;Let's clean up the mess we created :)

        push    L 0             
        push    [hwnd]
        call    EndDialog
        mov     eax,TRUE        
        jmp     main_finish

main_send:

		push	256
		push	offset SendBuffer
		push	IDD_YOU
		push	[hwnd]
		call	GetDlgItemTextA					;Get the string that we want to send
		test	eax,eax							;Error?
		je		ouch							;If so, exit

		push	eax								;Push away the length of the string (we'll need this later)

		lea		edi,SendBuffer					;Offset of the message in EDI
		add		edi,eax							;Add the length of the string to EDI, thus making it point to the end of the string.
		mov		byte ptr [edi],13				;We must add a LineFeed to it
		mov		byte ptr [edi+1],10
		
		sub		edi,eax							;Now edi points at the begin of the string again-

		push	edi
		push	0
		push	EM_REPLACESEL
		push	IDD_REMOTE
		push	[hwnd]
		call	SendDlgItemMessageA				;Write the text to the "Chat window"

		pop		eax								;Eax = Length of string

		push	0
		push	eax
		push	edi
		push	[newsockdes]
		call	send							;Send the msg to the server
		cmp		eax,-1							;If eax=-1 then we have an error
		jne		MessageSent

		push	-1
		call	MessageBeep						;Apperently we didnt send the message, let's beep!

MessageSent:
		mov		al,0
		mov		ecx,256
		lea		edi,SendBuffer
		rep		stosb							;Clear the SendBuffer string

		push	offset SendBuffer				;Remove what we just wrote from the "You" edit field
		push	IDD_YOU
		push	[hwnd]
		call	SetDlgItemTextA

ouch:

		mov		eax,TRUE
		jmp		main_finish

main_nothing:
        mov     eax,FALSE
        jmp     main_finish

Main_DlgProc    endp
public Main_DlgProc

Conn_DlgProc proc hwnd2:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD

        push    ebx
        push    esi
        push    edi

		cmp     [wmsg],WM_COMMAND
        je      conn_command
        cmp     [wmsg], WM_CLOSE
        je      conn_dlgdestroy
        mov     eax,FALSE

conn_finish:

        pop     edi
        pop     esi
        pop     ebx

        ret

conn_command:
      
		cmp		[wparam],IDD_CONNECT
		je      conn_connect
		cmp		[wparam],IDD_CANCEL
		je		conn_dlgdestroy
		cmp     [wparam],IDD_EXIT
        jne     conn_nothing

conn_dlgdestroy:

        push    L 0             
        push    [hwnd2]
        call    EndDialog
        mov     eax,TRUE        
        jmp     conn_finish

conn_connect:

		push	16								;Get the IP
		push	offset TheIP
		push	IDD_IPEDIT
		push	[hwnd2]
		call	GetDlgItemTextA					

		push	offset TheIP					;Conver the IP
		call	inet_addr
	    mov 	sin.sin_addr,eax 

		push	16								;Try to connect
		push	offset sin
		push	[sockdes]
		call	connect

		mov		eax,[sockdes]					
		mov		newsockdes,eax
		jmp		conn_dlgdestroy

conn_nothing:
        mov     eax,FALSE
        jmp     conn_finish

Conn_DlgProc    endp
public Conn_DlgProc

About_DlgProc proc hwnd3:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD

        push    ebx
        push    esi
        push    edi

		cmp     [wmsg],WM_COMMAND
        je      about_command
        cmp     [wmsg],WM_CLOSE
        je      about_dlgdestroy
        mov     eax,FALSE

about_finish:
        pop     edi
        pop     esi
        pop     ebx
        ret

about_command:
      
		cmp		[wparam],IDD_ABOUTOK
		je      about_dlgdestroy
		cmp     [wparam],IDD_EXIT
        jne     about_nothing

about_dlgdestroy:

        push    L 0             
        push    [hwnd3]
        call    EndDialog
        mov     eax,TRUE        
        jmp     about_finish

about_nothing:
        mov     eax,FALSE
        jmp     about_finish

About_DlgProc    endp
public About_DlgProc
end start
