.386
locals
jumps
.model flat,STDCALL

include win32.inc
include wsock32.inc

;---------------------------------------------------------------------

L equ <LARGE>

WM_LISTSOCKET EQU WM_USER+100

IDD_TOTUSER	  EQU 1000
IDD_EXIT	  EQU 1003
IDI_ICON1     EQU 100

TRUE          EQU 1
FALSE         EQU 0
NULL          EQU 0

;-----------

.data

szTitleName      db 'CrueChat 1.1 - Server version',0
msg              MSGSTRUCT   <?>
wc               WNDCLASS    <?>
wsadata 		 WSAdata <?> 
sin 			 sockaddr_in <?>

szNULL   db      0
ymenu    dd      0

hInst            dd 0
hMenu            dd 0
hDlg             dd 0

dlg_start        db 'DLG_START',0

sockdes			 db 4000 dup (0)				;Can handle 1000 (1000*4 = 4000) connections.
listsock		 dd 0
PORT			 dd 1024

Connections		 dd 0
Connectionsstr	 db '0',5 dup (0)

ReadBuffer		 db 256 dup (0)
Hex2Dec			 db '%-4i',0
temp			 dd 0
LengthOfString	 dd 0

.code

;---------------------------------------------------------
; This is where control is received from the loader.
;---------------------------------------------------------


start:
        push    0
        call    GetModuleHandle         
        mov     [hInst], eax            

		push	offset wsadata					;Set things up
		push	0101h
		call	WSAStartup

		mov 	sin.sin_family, AF_INET 		;Convert the PORT
		push	PORT
		call	htons
		mov 	sin.sin_port,ax 		

        push    offset szTitleName				;We dont want more than one copy of the server program running
		push	0
        call    FindWindow              
        or      eax,eax                 
        jz      reg_class               
        ret

reg_class:

        mov     [wc.clsStyle], CS_HREDRAW + CS_VREDRAW + CS_GLOBALCLASS
        mov     [wc.clsLpfnWndProc], offset WndProc
        mov     [wc.clsCbClsExtra], 0
        mov     [wc.clsCbWndExtra], 0

        mov     eax, [hInst]
        mov     [wc.clsHInstance], eax

		push    IDI_ICON1
		push 	eax
        call    LoadIcon

        mov     [wc.clsHIcon], eax

        push    L IDC_ARROW             
        push    L 0
        call    LoadCursor
        mov     [wc.clsHCursor], eax

        push    0                   
        push    offset Main_DlgProc
        push    0
        push    offset dlg_start
        push    [hInst]
        call    DialogBoxParamA
        jmp     finish

msg_loop:
        push    L 0
        push    L 0
        push    L 0
        push    offset msg
        call    GetMessage

        cmp     ax, 0
        je      end_loop

        push    offset msg
        call    TranslateMessage

        push    offset msg
        call    DispatchMessage

        jmp     msg_loop

end_loop:

        push    [msg.msWPARAM]
        call    ExitProcess             

;----------------------------------------------------------------------------
; In this part we will put the events we want to respond on.
; Key, MouseButtons, Resize, Menu, Commands.... (look at the win32.inc)
; You can leave the above without changes a modify the next part only
;----------------------------------------------------------------------------

WndProc proc hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
        push    esi
        push    edi
        push    ebx
        jmp     defwndproc
defwndproc:
        push    [lparam]
        push    [wparam]
        push    [wmsg]
        push    [hwnd]
        call    DefWindowProc
        jmp     finish

finish:
        pop     ebx
        pop     edi
        pop     esi
        ret
WndProc endp

public WndProc


;----------------------
;Main Dialog
;----------------------

Main_DlgProc proc hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD

        push    ebx
        push    esi
        push    edi

		cmp		[wmsg],WM_LISTSOCKET
		je		socket_event
		cmp     [wmsg],WM_COMMAND
        je      main_command
		cmp		[wmsg],WM_INITDIALOG
		je		main_init
        cmp     [wmsg], WM_CLOSE
        je      main_dlgdestroy
        mov     eax,FALSE

main_finish:
        pop     edi
        pop     esi
        pop     ebx
        ret

socket_event:
		mov		eax,lparam						;FD_ACCEPT?
		cmp		ax,FD_ACCEPT
		jne		go_on
		shr 	eax,16

		xor		ebx,ebx
		call	CheckSocketList					;Find the next empty spot in our SocketHandle array to save away this new SocketHandle
		
		push	0
		push	0
		push	[listsock]
		call	accept							;Accept the connection
		inc		Connections
		mov		[edi],eax

        push 	offset Connections
        push 	offset Hex2Dec
        push 	offset Connectionsstr
        call 	wvsprintfA
	
		push	offset Connectionsstr
		push	IDD_TOTUSER
		push	[hwnd]
		call	SetDlgItemTextA
		jmp		go_on

go_on:

		mov		eax,lparam						;FD_READ?
		cmp		ax,FD_READ
		jne		go_on2

		mov		eax,wparam
		xor		ebx,ebx
		mov		bx,ax

		mov		temp,ebx						;temp holds the SocketHandle of the Client program we're recieving from

		push	0
		push	256
		push	offset ReadBuffer
		push	ebx
		call	recv
		cmp     eax,-1
		je		go_on2

		lea		esi,ReadBuffer
		lea		edi,ReadBuffer

		mov		ecx,eax
XorLoop:										;Our MEGA-COOL encryption algorithm
		xor		byte ptr [edi],19
		inc		edi
		loop	XorLoop

;		lea		edi,ReadBuffer					;Add a linefeed
;		add		edi,eax
;		mov		byte ptr [edi],13
;		mov		byte ptr [edi+1],10

		lea		edi,sockdes						;Edi points to the array of connected SocketHandles.
;		add		eax,2
		mov		LengthOfString,eax

		mov		ebx,temp
		
SendMore:
		cmp		dword ptr [edi],ebx				;Is this the SocketHandle we got the info from?
		jne		PerhapsSend						;If not, continue
		add		edi,4							;Dont send the string to the SocketHandle we got it from
		jmp		SendMore
PerhapsSend:
		cmp		dword ptr [edi],0				;Have we processed all the SocketHandle's`?
		je		Senteverything					;If so, then we're done

		push	0								;Else, send the string to the SocketHandle that EDI points to
		push	LengthOfString
		push	offset ReadBuffer
		push	dword ptr [edi]
		call	send		

		add		edi,4
		jmp		SendMore

Senteverything:

		mov		al,0							;Clear the string
		mov		ecx,256
		lea		edi,ReadBuffer
		rep		stosb

go_on2:

		cmp		ax,FD_CLOSE						;FD_CLOSE msg?
		jne		go_on3

		mov		eax,wparam
		xor		ebx,ebx
		mov		bx,ax

		call	CheckSocketList					;Get where in the SocketHandle array the current Handle is.
		mov		dword ptr [edi],0				;Remove it from the list!

		push	ebx								;Close down the socket
		call	closesocket
		dec		Connections

        push 	offset Connections
        push 	offset Hex2Dec
        push 	offset Connectionsstr
        call 	wvsprintfA
	
		push	offset Connectionsstr
		push	IDD_TOTUSER
		push	[hwnd]
		call	SetDlgItemTextA

go_on3:

		mov		eax,TRUE
		jmp		main_finish

main_init:

		push	0								;Create the socket that will listen for incoming connections
		push	SOCK_STREAM
		push	PF_INET
		call	socket
		mov		listsock,eax

		push	FD_ACCEPT+FD_READ+FD_CLOSE 		;The msg's we want to respond on
		push	WM_LISTSOCKET
		push	[hwnd]
		push	[listsock]
		call	WSAAsyncSelect

		push	16								;We must bind this socket in order to use if for listening purposes
		push	offset sin
		push	[listsock]
		call	bind

		push	2								;Start listening
		push	[listsock]
		call	listen

		push	offset Connectionsstr
		push	IDD_TOTUSER
		push	[hwnd]
		call	SetDlgItemTextA

		mov		eax,TRUE
		jmp		main_finish

main_command:

		cmp		[wparam],IDD_EXIT
        jne     main_nothing

main_dlgdestroy:

		push	[listsock]						;Close the listening socket
		call	closesocket

		lea		edi,sockdes						;Close all the connected sockets as well
CheckOpenSockets:
		cmp		dword ptr [edi],0
		je		ClosedAllSockets

		push	edi
		call	closesocket
		add		edi,4
		jmp		CheckOpenSockets

ClosedAllSockets:

		call	WSACleanup						;Clean up the mess we created

        push    L 0             
        push    [hwnd]
        call    EndDialog
        mov     eax,TRUE        
        jmp     main_finish

main_nothing:
        mov     eax,FALSE
        jmp     main_finish

Main_DlgProc    endp

;*** EXTERNAL PROCEDURES ***

CheckSocketList:
		lea		edi,sockdes-4
CheckMoreSocket:
		add		edi,4
		cmp		[edi],ebx
		jne		CheckMoreSocket
ret

public Main_DlgProc
end start
