; com.inc
; usefull things for dealing with COM

;-------------------------------------------------------------------------------------------------
; pushrtol
; pushes the arguments of the macro onto the stack right to left
; uses recursion...
pushrtol MACRO v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12
	IFNB <v1>
			pushrtol <v2>,<v3>,<v4>,<v5>,<v6>,<v7>,<v8>,<v9>,<v10>,<v11>,<v12>
			push v1	
	ENDIF
ENDM

;-------------------------------------------------------------------------------------------------
; vCall
; used to call the COM Interface methods. 
; Pointer to the object is first, 
; then offset into method table, 
; then the parameters...
; example:		CoCall [lpSomeObject], QueryInterface, IID_SomeInterface, pSomeObject
;vCall MACRO ObjectPtr, MethodName, v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12
; 	pushrtol <v1>,<v2>,<v3>,<v4>,<v5>,<v6>,<v7>,<v8>,<v9>,<v10>,<v11>,<v12>
; 	mov eax, ObjectPtr
; 	push eax
; 	mov eax, [eax]
; 	call DWORD PTR [eax+MethodName]
;ENDM


;--------------------------------------------------------------------------------------------------
;vcall	lpsf, IShellFolder, Release, xxx, xxx, xxx	
;		
;			assume 	esi:ptr IShellFolder
;			mov		esi, lpsf
;			mov		edi, [esi]
;			assume	edi:ptr IShellFolderVtbl
;			invoke	[edi].Release, edi
;			assume	esi:nothing
;			assume	edi:nothing
;			

vcall macro ObjectPtr:req, ObjectType:req, Method:req, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, v11, v12
	assume 	esi:ptr ObjectType
	mov		esi, ObjectPtr
	mov		edi, [esi]
	assume	edi:ptr ObjectType&Vtbl
	IFNB <v12>
		invoke	[edi].Method, esi, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, v11, v12
	ELSEIFNB <v11>		
		invoke	[edi].Method, esi, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, v11
	ELSEIFNB <v10>
		invoke	[edi].Method, esi, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10	
	ELSEIFNB <v9>
		invoke	[edi].Method, esi, v1, v2, v3, v4, v5, v6, v7, v8, v9
	ELSEIFNB <v8>
		invoke	[edi].Method, esi, v1, v2, v3, v4, v5, v6, v7, v8
	ELSEIFNB <v7>
		invoke	[edi].Method, esi, v1, v2, v3, v4, v5, v6, v7
	ELSEIFNB <v6>
		invoke	[edi].Method, esi, v1, v2, v3, v4, v5, v6	
	ELSEIFNB <v5>
		invoke	[edi].Method, esi, v1, v2, v3, v4, v5
	ELSEIFNB <v4>
		invoke	[edi].Method, esi, v1, v2, v3, v4
	ELSEIFNB <v3>
		invoke	[edi].Method, esi, v1, v2, v3
	ELSEIFNB <v2>
		invoke	[edi].Method, esi, v1, v2
	ELSEIFNB <v1>
		invoke	[edi].Method, esi, v1
	ELSE
		invoke	[edi].Method, esi 
	ENDIF
	assume	esi:nothing	
	assume	edi:nothing
endm


;--------------------------------------------------------------------------------------------------
m2m MACRO dest, src
	mov	eax, src
	mov	dest, eax
ENDM

m2mp MACRO dest, src
	push src
	pop  dest
ENDM

;-------------------------------------------------------------------------------------------------

FAILED			equ	10000000h
SUCCEEDED		equ	00000000h

S_OK      		equ	00000000h
S_FALSE         equ	00000001h

;-------------------------------------------------------------------------------------------------





include objbase.inc

OleInitialize PROTO :DWORD
OleUninitialize PROTO