; Debug.inc
; Version 1.0 July 20, 1999
;
;
; (C) 1999 lord lucifer
; lord-lucifer@usa.net
; http://lordlucifer.cjb.net
;
;--------------------------------------------------------------------------------------------------

IFDEF DEBUG

wsprintfA proto C :VARARG
Debug_PrintErrorMsg proto STDCALL :DWORD

.data?
	Debug_szDebugMsg	db	256 dup (?)

;--------------------------------------------------------------------------------------------------
; DebugPrint 		
;	Description:	This macro takes a string parameter and passes it do the debuig window.
; 	Syntax: 		DebugPrint <message>
;	Example:		DebugPrint "Testing"
;	Output:			> Testing			

DebugPrint MACRO message:VARARG
	LOCAL lbl
	pusha						;; save all registers
	pushf						;; save the flags
	jmp		lbl
	szMsg	db	message,0Ah,0
lbl:		
	push offset szMsg
	call OutputDebugString
	popf						;; restore the flags
	popa						;; restore the registers
ENDM		


;--------------------------------------------------------------------------------------------------
; DebugPrintf		
;	Description:	This macro behaves like printf, and handles multiple arguments.  Like DebugPrint,
;					it prints a message to the debug window.
;	Syntax:			DebugPrintf <format_string>, v1, v2...
;	Example:		DebugPrintf "eax = %X (%dd)", eax, eax
;	Output:    		> eax = 12 (18d)

DebugPrintf MACRO format:req, v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12
	LOCAL lbl, szFmt
	jmp		lbl
	szFmt	db format,0Ah,0
lbl:
	pushad
	pushfd	
	IFNB	 <v10>
		invoke	wsprintfA, addr Debug_szDebugMsg, addr szFmt, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10
	ELSEIFNB <v9>
		invoke	wsprintfA, addr Debug_szDebugMsg, addr szFmt, v1, v2, v3, v4, v5, v6, v7, v8, v9
	ELSEIFNB <v8>
		invoke	wsprintfA, addr Debug_szDebugMsg, addr szFmt, v1, v2, v3, v4, v5, v6, v7, v8
	ELSEIFNB <v7>
		invoke	wsprintfA, addr Debug_szDebugMsg, addr szFmt, v1, v2, v3, v4, v5, v6, v7
	ELSEIFNB <v6>
		invoke	wsprintfA, addr Debug_szDebugMsg, addr szFmt, v1, v2, v3, v4, v5, v6
	ELSEIFNB <v5>
		invoke	wsprintfA, addr Debug_szDebugMsg, addr szFmt, v1, v2, v3, v4, v5
	ELSEIFNB <v4>
		invoke	wsprintfA, addr Debug_szDebugMsg, addr szFmt, v1, v2, v3, v4
	ELSEIFNB <v3>
		invoke	wsprintfA, addr Debug_szDebugMsg, addr szFmt, v1, v2, v3
	ELSEIFNB <v2>
		invoke	wsprintfA, addr Debug_szDebugMsg, addr szFmt, v1, v2
	ELSE
		invoke	wsprintfA, addr Debug_szDebugMsg, addr szFmt, v1
	ENDIF	
	invoke	OutputDebugString, addr Debug_szDebugMsg	
	popfd	
	popad
ENDM

;--------------------------------------------------------------------------------------------------
; DebugRegDump		
;	Description:	This macro prints out the values of the registers to the debug window.
;	Syntax:			DebugRegDump
;	Example:		DebugRegDump
;	Output:			> EAX=00000814   EBX=0063FC14   ECX=CD4D5F00   EDX=00000000
;					> ESI=0063FA9C   EDI=00510378   EBP=0063FA84   ESP=0063FA14   EIP=00402F3E
;					> CS=0177   DS=017F   SS=017F   ES=017F   FS=4197   GS=0000   FLAGS=00000246

DebugRegDump MACRO
	LOCAL strt, lbl, lbl2
strt:
	jmp	lbl
	szDump	db	"EAX=%08X   EBX=%08X   ECX=%08X   EDX=%08X",0Ah,0
	szDump2	db	"ESI=%08X   EDI=%08X   EBP=%08X   ESP=%08X   EIP=%08X",0Ah,0
	szDump3	db	"CS=%04X   DS=%04X   SS=%04X   ES=%04X   FS=%04X   GS=%04X   FLAGS=%08X",0Ah, 0
lbl:
	pushad
	pushfd
	mov		ebp, esp	
	
;; Row 1
	push	dword ptr [ebp+24] 	;; edx
	push	dword ptr [ebp+28] 	;; ecx
	push	dword ptr [ebp+20] 	;; ebx
	push	dword ptr [ebp+32] 	;; eax
	push	offset szDump
	push	offset Debug_szDebugMsg
	call	wsprintfA
	add		esp, 24
	
	push	offset Debug_szDebugMsg
	call	OutputDebugString
	
;; Row 2
	call	lbl2				;; used to push eip
lbl2:
	mov		ebx, $-strt
	pop		eax					
	sub		eax, ebx
	push	eax					;; eax = eip
	push	dword ptr [ebp+16] 	;; esp
	push	dword ptr [ebp+12]	;; ebp
	push	dword ptr [ebp+4]	;; edi
	push	dword ptr [ebp+8]	;; esi
	push	offset szDump2
	push	offset Debug_szDebugMsg
	call	wsprintfA
	add		esp, 28

	push	offset Debug_szDebugMsg
	call	OutputDebugString	
	
;; Row 3
	push	dword ptr [ebp]
	xor		eax,eax
	mov		eax,gs	
	push	eax
	mov		eax,fs
	push	eax
	mov		eax,es
	push	eax
	mov		eax,ss
	push	eax
	mov		eax,ds
	push	eax
	mov		eax,cs
	push	eax
	push	offset szDump3
	push	offset Debug_szDebugMsg
	call	wsprintfA
	add		esp, 36
	
	push	offset Debug_szDebugMsg
	call	OutputDebugString

	popfd
	popad
ENDM

;--------------------------------------------------------------------------------------------------
; DebugGetLastError	
;	Description:	This macro will call the windows function GetLastError, and print out the 
;					appropriate error message.  The message is only displayed if the error
;					condition is met.
;	Syntax: 		DebugGetLastError <message>, <error_condition>
;	Example:		DebugGetLastError "Error!!!", eax == 0
;	Output:			> Error!!!
;					> GetLastError: 57h (ERROR_INVALID_PARAMETER - The parameter is incorrect.)

DebugGetLastError MACRO message, cnd
	LOCAL lbl, szMsg1
	pusha						;; save all registers
	pushf						;; save the flags	
	jmp		lbl
	szMsg1	db	message,0Ah,0
lbl:		
.if &cnd
	push 	offset szMsg1
	call 	OutputDebugString

	call	GetLastError
	push	eax
	call	Debug_PrintErrorMsg
.endif
	popf						;; restore the flags
	popa						;; restore the registers
ENDM

;--------------------------------------------------------------------------------------------------

ELSE ;; not DEBUG

DebugPrint MACRO message:VARARG
ENDM

DebugPrintf MACRO format:req, v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12
ENDM

DebugRegDump MACRO
ENDM

DebugGetLastError MACRO message, cnd
ENDM

ENDIF
