; Tree.asm
; Handles the Directories Tree View
.486p
.model flat, stdcall
                      
include fman.inc    

;------------------------------------------------------------------------------------------------------------
.data?                                          	; uninitialized data
align DWORD 
	hWndTree			dd		?               	; Window handle for the Tree View
	hTreeImageList		dd		?
	hitemMyComputer		dd		?

;------------------------------------------------------------------------------------------------------------
.const                                          	; constant data segment
align DWORD   
	szTreeClassName		db		"SysTreeView32",0   
	szRootPath			db		"C:\",0

;------------------------------------------------------------------------------------------------------------
.code       

;--------------------------------------------------------------------------------------------------
; InitTreeView
InitTreeView proc hWndParent:DWORD
	LOCAL	rectClient:RECT
	LOCAL	lpsf:LPSHELLFOLDER
   	LOCAL	sfi:SHFILEINFO

	; get parent window size
	;invoke	GetClientRect, hWndParent, addr rectClient    	
	;mov		eax, rectClient.right
	;shr		eax, 1
	;dec		eax

	; create the tree view window
	invoke	CreateWindowEx, 
			WS_EX_CLIENTEDGE,
			addr szTreeClassName, 
			0,
			WS_CHILD or TVS_HASLINES or TVS_HASBUTTONS or TVS_LINESATROOT,
			0, 0,
			1,1, ;eax, rectClient.bottom, 
			hWndParent,
			ID_TREEVIEW, 
			g_hInstance, 
			NULL
	test	eax,eax     
	jz		ret_error
	mov		hWndTree, eax 
	                   
	; Get the shell image list for the tree view
	invoke	SHGetFileInfo, addr szRootPath, 0, addr sfi, sizeof SHFILEINFO, SHGFI_SYSICONINDEX or SHGFI_SMALLICON
	test	eax,eax
	jz		ret_error
	mov		hTreeImageList, eax	
	invoke	SendMessage, hWndTree, TVM_SETIMAGELIST, 0, eax
	
	; initialize the tree window
    invoke	SHGetDesktopFolder, addr lpsf
    test	eax,eax
    js		ret_error

	; fill the window with the root items    
    invoke	UpdateTreeView, hWndTree, lpsf, 0, TVI_ROOT
    
    ; free the shell folder pointer
    mov		eax, lpsf
    mov		eax,[eax]
    invoke	(IShellFolder ptr [eax]).Release, lpsf

ret_ok:                     
	mov		eax, hWndTree
	ret
ret_error:
	invoke	GetLastError
	xor		eax,eax
	ret
InitTreeView	endp



;--------------------------------------------------------------------------------------------------
; UpdateTreeView
UpdateTreeView proc uses ebx edx hWnd:DWORD, pshfParent:LPSHELLFOLDER, pidlFull:LPITEMIDLIST, htreeParent:DWORD
	LOCAL	peidl:LPENUMIDLIST
	LOCAL	pidl:LPITEMIDLIST
	LOCAL	pidlFullCur:LPITEMIDLIST
	LOCAL	ptvobj:LPTV_OBJDATA
	LOCAL	tvis:TV_INSERTSTRUCT
	LOCAL	dwAttr:DWORD
	LOCAL	strret:STRRET
	LOCAL	bFirstItem:DWORD

	
	mov		edx, pshfParent
	mov		edx, [edx]
	invoke	(IShellFolder PTR [edx]).EnumObjects, pshfParent, hWnd, SHCONTF_FOLDERS or SHCONTF_NONFOLDERS or SHCONTF_INCLUDEHIDDEN, addr peidl
	test	eax,eax
	js		ret_error
	mov		bFirstItem,1
		
ObjectLoop:
	mov		edx, peidl
	mov		edx,[edx]
	invoke	(IEnumIDList PTR [edx]).Next, peidl, 1, addr pidl, NULL
	test	eax,eax
	js		ret_error
	cmp		eax,S_FALSE	;no more items
	jz		End_ObjectLoop

	; check to see if its a folder; if its a folder, add it to the tree
	mov		dwAttr, SFGAO_HASSUBFOLDER or SFGAO_FOLDER
	mov		edx, pshfParent
	mov		edx, [edx]
	invoke	(IShellFolder PTR [edx]).GetAttributesOf, pshfParent, 1, addr pidl, addr dwAttr
	test	eax,eax
	js		ret_error
		
	.IF		dwAttr & (SFGAO_HASSUBFOLDER or SFGAO_FOLDER)
	.IF		dwAttr & SFGAO_FOLDER
			 
			; save TV_OBJDATA
			mov		eax, pShellMalloc
			mov		eax,[eax]
			invoke	(IMalloc ptr [eax]).Alloc, pShellMalloc, sizeof TV_OBJDATA			
			test	eax,eax
			jz		ret_error
			mov		ptvobj,eax					
			mov		ebx, eax			
				
			invoke	IDList_Combine, pidlFull, pidl	
			mov		(TV_OBJDATA PTR [ebx]).pidlFull, eax
			mov		pidlFullCur, eax
			
			invoke	IDList_CopyItem, pidl
			mov		(TV_OBJDATA PTR [ebx]).pidlRel, eax				
			
			mov		eax, pshfParent
			mov		(TV_OBJDATA PTR [ebx]).pshfParent, eax

			mov		tvis.item.lParam, ebx
			
			; save tree item datas
			mov		eax, htreeParent
			mov		tvis.hParent, eax
			mov		tvis.item.hItem, 0	
			mov		tvis.hInsertAfter, TVI_LAST
		
			mov		tvis.item.imask, TVIF_TEXT or TVIF_IMAGE or TVIF_SELECTEDIMAGE or TVIF_PARAM
			.IF		dwAttr & SFGAO_HASSUBFOLDER
					mov		tvis.item.cChildren, TRUE
					or		tvis.item.imask, TVIF_CHILDREN					
			.ENDIF
				
			mov		edx, pshfParent
			mov		edx,[edx]
			invoke	(IShellFolder PTR [edx]).GetDisplayNameOf, pshfParent, pidl, SHGDN_NORMAL, addr strret										
			test	eax,eax
			js		ret_error
			.IF		strret.uType == STRRET_CSTR
					lea		eax, strret.cStr
			.ELSEIF	strret.uType == STRRET_OFFSET
					mov		eax, pidl
					add		eax, strret.uOffset
			.ELSEIF	strret.uType == STRRET_WSTR	
					;int 3
			.ENDIF
			mov		tvis.item.pszText, eax								
			mov		tvis.item.cchTextMax, 255	
			
			invoke	GetIcon, pidlFullCur, SHGFI_ICON
			mov		tvis.item.iImage, eax
			invoke	GetIcon, pidlFullCur, SHGFI_OPENICON	
			mov		tvis.item.iSelectedImage, eax						
						
			; add item to the tree				
			invoke	SendMessage, hWnd, TVM_INSERTITEM, 0, addr tvis 
			test	eax,eax
			jz		ret_error 			
			.IF		bFirstItem == TRUE
					mov		hitemMyComputer, eax
					mov		bFirstItem, 0
			.ENDIF
	.ENDIF	
	.ENDIF
	mov		eax, pShellMalloc
	mov		eax,[eax]
	invoke	(IMalloc PTR [eax]).Free, pShellMalloc, pidl
	
	jmp		ObjectLoop
	
	mov		eax, peidl
	mov		eax,[eax]
	invoke	(IEnumIDList PTR [eax]).Release, peidl


End_ObjectLoop:	

ret_ok:
	ret
ret_error:	
	ret
UpdateTreeView endp


;--------------------------------------------------------------------------------------------------
; TreeViewNotify
TreeViewNotify proc uses ebx edx hWnd:DWORD, pnmtv:DWORD
	LOCAL	pshf:LPSHELLFOLDER
	LOCAL	pidl:LPITEMIDLIST
	LOCAL	ptvobj:LPTV_OBJDATA
	LOCAL	strret:STRRET
		
	LOCAL	point:POINT
	LOCAL	tvhti:TV_HITTESTINFO
	LOCAL	tvi:TV_ITEM

	mov		eax, pnmtv
	mov		ebx,(NM_TREEVIEW ptr [eax]).itemNew.lParam 
	mov		ptvobj, ebx	
	
	mov		eax, (NM_TREEVIEW ptr [eax]).hdr.code
	cmp		eax, TVN_ITEMEXPANDING
	je		item_expanding
	cmp		eax, TVN_SELCHANGEDA
	je		sel_changed
	cmp		eax, NM_RCLICK
	je		right_clicked
	jmp		ret_ok
	
; Item is expanding...	
item_expanding:	
	mov		ebx, pnmtv
	test	(NM_TREEVIEW ptr [ebx]).itemNew.state, TVIS_EXPANDEDONCE	
	jnz		ret_ok

	mov		ebx, ptvobj		
	mov		edx, (TV_OBJDATA ptr [ebx]).pshfParent
	mov		edx, [edx]
	invoke	(IShellFolder PTR [edx]).BindToObject, 
			(TV_OBJDATA ptr [ebx]).pshfParent, 
			(TV_OBJDATA ptr [ebx]).pidlRel, 
			0, 
			addr IID_IShellFolder, 
			addr pshf	
	test	eax,eax
	js		ret_error				
	
	mov		ebx,pnmtv
	mov		edx,ptvobj
	invoke	UpdateTreeView, hWndTree, pshf, (TV_OBJDATA ptr [edx]).pidlFull, (NM_TREEVIEW ptr [ebx]).itemNew.hItem
	
	mov		eax, pshf
	mov		eax, [eax]
	invoke	(IShellFolder ptr [eax]).Release, pshf
	jmp		ret_ok			
	
; tree item selection changed
sel_changed:
	; update list view header to give full path name
	invoke	SHGetDesktopFolder, addr pshf
	test	eax,eax
	js		ret_error
	
	mov		ebx, ptvobj
	mov		edx, pshf
	mov		edx,[edx]
	invoke	(IShellFolder PTR [edx]).GetDisplayNameOf, pshf, (TV_OBJDATA ptr [ebx]).pidlFull, SHGDN_NORMAL, addr strret										
	test	eax,eax
	js		ret_error
	.IF		strret.uType == STRRET_CSTR
			lea		eax, strret.cStr
	.ELSEIF	strret.uType == STRRET_OFFSET
			mov		eax, (TV_OBJDATA ptr [ebx]).pidlFull
			add		eax, strret.uOffset
	.ELSEIF	strret.uType == STRRET_WSTR	
			;int 3
	.ENDIF
;	invoke	SendMessage, hWndHeaderBar, SB_SETTEXT, 1, eax
	
	mov		eax, pshf
	mov		eax, [eax]
	invoke	(IShellFolder ptr [eax]).Release, pshf


	; now bind to that folder
	mov		ebx, pnmtv
	mov		ebx,(NM_TREEVIEW ptr [ebx]).itemNew.lParam 
	mov		ptvobj, ebx		

	mov		edx, (TV_OBJDATA ptr [ebx]).pshfParent
	mov		edx, [edx]
	invoke	(IShellFolder PTR [edx]).BindToObject, 
			(TV_OBJDATA ptr [ebx]).pshfParent, 
			(TV_OBJDATA ptr [ebx]).pidlRel, 
			0, 
			addr IID_IShellFolder, 
			addr pshf	
	test	eax,eax
	js		ret_error	
	
	; fill the list view
	invoke	UpdateListView, hWndList, ptvobj, pshf						
	test	eax,eax
	jz		ret_error
	
	mov		eax, pshf
	mov		eax, [eax]
	invoke	(IShellFolder ptr [eax]).Release, pshf
	jmp		ret_ok			
			
; right click context menu
right_clicked:
	invoke	GetCursorPos, addr point
	invoke	ScreenToClient, hWndTree, addr point
	mov		eax, point.x
	mov		tvhti.pt.x, eax
	mov		eax, point.y
	mov		tvhti.pt.y, eax
	
	invoke	SendMessage, hWndTree, TVM_HITTEST, 0, addr tvhti
	invoke	SendMessage, hWndTree, TVM_SELECTITEM, TVGN_CARET, tvhti.hItem
	.IF		(tvhti.flags & TVHT_ONITEM)
			invoke	ClientToScreen, hWndTree, addr point
			mov		tvi.imask, TVIF_HANDLE or TVIF_PARAM
			mov		eax, tvhti.hItem
			mov		tvi.hItem, eax 
			
			invoke	SendMessage, hWndTree, TVM_GETITEM, 0, addr tvi
			test	eax,eax
			jz		ret_error
					
			mov		ebx, tvi.lParam
			mov		ptvobj, ebx
			invoke	ContextMenu, hWnd, (TV_OBJDATA ptr [ebx]).pshfParent, (TV_OBJDATA ptr [ebx]).pidlRel, addr point
	.ENDIF
	jmp		ret_ok


ret_ok:
	mov		eax,TRUE
	ret		
ret_error:
	xor		eax,eax	
	ret
TreeViewNotify endp





END