; util.asm
;--------------------------------------------------------------------------------------------------

.486p
.model flat, stdcall
                      
include fman.inc

;------------------------------------------------------------------------------------------------------------
.data?                                          	; uninitialized data
align DWORD
	
	
;------------------------------------------------------------------------------------------------------------
.const                                          	; constant data segment
align DWORD   

;------------------------------------------------------------------------------------------------------------
.code



;--------------------------------------------------------------------------------------------------
; IDList_GetSize
IDList_GetSize proc uses ebx pidl:LPITEMIDLIST
	LOCAL	cbTotal:DWORD
	
	mov		cbTotal, 0
	.IF		pidl != 0
			mov		ebx,pidl			
start_loop:
			movsx	eax, (ITEMIDLIST PTR [ebx]).mkid.cb
			test	eax,eax
			jz		end_loop
				
			add		cbTotal, eax
			add		ebx, eax
			jmp		start_loop
end_loop:							
	.ENDIF		
	
	mov		eax,cbTotal	
	ret
IDList_GetSize endp



;--------------------------------------------------------------------------------------------------
; IDList_CopyItem
IDList_CopyItem	proc uses ebx edx ecx edi esi pidl:LPITEMIDLIST
	LOCAL	pidlNew:LPITEMIDLIST
	LOCAL	sz:DWORD
	
	mov		ebx, pidl	
	movsx	edx, (ITEMIDLIST PTR [ebx]).mkid.cb
	add		edx, sizeof WORD
	mov		sz,edx
		
	mov		edx, pShellMalloc
	mov		edx, [edx]
	invoke	(IMalloc PTR [edx]).Alloc, pShellMalloc, sz
	
	test	eax,eax
	jz		ret_null
	mov		pidlNew, eax

	mov		esi, pidl
	mov		edi, pidlNew
	mov		ecx, sz
	.WHILE	ecx != 0
			mov 	al,byte ptr [esi]
			mov		byte ptr [edi], al		
			dec		ecx			
			inc		esi
			inc		edi
	.ENDW
	
ret_ok:	
	mov		eax, pidlNew
	ret
	
ret_null:
	xor		eax,eax
	ret	
IDList_CopyItem	endp



;--------------------------------------------------------------------------------------------------
; IDList_Combine
IDList_Combine proc uses esi edi ecx edx pidl1:LPITEMIDLIST, pidl2:LPITEMIDLIST
	LOCAL	pidlNew:LPITEMIDLIST
	LOCAL	cb1:DWORD
	LOCAL	cb2:DWORD
	
	; Get length of 1st pidl (not including NULL terminating word)
	invoke	IDList_GetSize, pidl1
	mov		cb1, eax
	
	; Get length of 2nd pidl (not including NULL terminating word)
	invoke	IDList_GetSize, pidl2
	mov		cb2, eax
	
	; Get total length of resulting combined pidl (including NULL terminating word)
	mov		eax, sizeof ITEMIDLIST.mkid.cb
	add		eax, cb1
	add		eax, cb2	
		
	; Allocate the memory
	mov		edx, pShellMalloc
	mov		edx,[edx]
	invoke	(IMalloc PTR [edx]).Alloc, pShellMalloc, eax
	
	test	eax,eax
	jz		ret_error
	mov		pidlNew, eax
	
	; Set destination 
	mov		edi, eax
	
	; Write 1st pidl to destination (pidlNew)
	mov		esi, pidl1
	mov		ecx, cb1
	.WHILE	ecx != 0
			mov 	al,byte ptr [esi]
			mov		byte ptr [edi], al		
			dec		ecx			
			inc		esi
			inc		edi
	.ENDW			

	; Write 2nd pidl after 1st
	mov		esi, pidl2
	mov		ecx, cb2
	.WHILE	ecx != 0
			mov 	al,byte ptr [esi]
			mov		byte ptr [edi], al		
			dec		ecx			
			inc		esi
			inc		edi
	.ENDW			
	
	; Add terminating word
	mov		word ptr [edi], 0
		
	mov		eax, pidlNew
	ret
ret_error:
	int 	3
	xor		eax,eax
	ret	
IDList_Combine	endp


;--------------------------------------------------------------------------------------------------
; GetIcons
; dwType = SHGFI_OPENICON or SHGFI_ICON
GetIcon	proc uses edx pidl:LPITEMIDLIST, dwType:DWORD
	LOCAL	shfi:SHFILEINFO
		
	mov		edx, SHGFI_PIDL or SHGFI_SYSICONINDEX or SHGFI_SMALLICON
	or		edx, dwType
		
	invoke	SHGetFileInfo, 		; SHGetfileinfo requires full pidl
			pidl, 
			0,
			addr shfi,
			sizeof SHFILEINFO, 
			edx
	mov		eax, shfi.iIcon
	ret
GetIcon	endp


;--------------------------------------------------------------------------------------------------
ContextMenu proc uses ebx edx hWnd:DWORD, pshfParent:LPSHELLFOLDER, pidl:LPITEMIDLIST, ppoint:DWORD
	LOCAL	pcm:LPCONTEXTMENU
	LOCAL	hMenu:DWORD
	LOCAL	iCmd:DWORD
	LOCAL	cmi:CMINVOKECOMMANDINFO
	
	mov		ebx, pshfParent
	mov		ebx,[ebx]
	invoke	(IShellFolder ptr [ebx]).GetUIObjectOf, pshfParent,
			hWnd,
			1,
			addr pidl,
			addr IID_IContextMenu,
			0,
			addr pcm
	test	eax,eax
	js		ret_error
	
	invoke	CreatePopupMenu
	test	eax,eax
	jz		ret_error
	mov		hMenu, eax
	
	mov		ebx, pcm
	mov		ebx, [ebx]
	invoke	(IContextMenu ptr [ebx]).QueryContextMenu, pcm,
			hMenu,
			0,
			1,
			7FFFh,
			CMF_EXPLORE
	test	eax,eax
	js		ret_error
	
	mov		edx, ppoint
	invoke	TrackPopupMenu,
			hMenu,
			TPM_LEFTALIGN or TPM_RIGHTBUTTON or 0100h, ;TPM_RETURNCMD
			(POINT ptr [edx]).x,
			(POINT ptr [edx]).y,
			0,
			hWnd,
			0
	test	eax,eax
	jz		ret_error
	mov		iCmd, eax	

	mov		cmi.cbSize, sizeof CMINVOKECOMMANDINFO
	mov		cmi.fMask, 0
	mov		eax, hWnd
	mov		cmi.hwnd, eax
	
	mov		eax, iCmd
	dec		eax
	and		eax, 0000FFFFh
	mov		cmi.lpVerb, eax
	
	mov		cmi.lpParameters, 0
	mov		cmi.lpDirectory, 0
	mov		cmi.nShow, SW_SHOWNORMAL
	mov		cmi.dwHotKey, 0
	mov		cmi.hIcon, 0
	
	mov		ebx, pcm
	mov		ebx, [ebx]
	invoke	(IContextMenu ptr [ebx]).InvokeCommand, pcm, addr cmi
	.IF		eax < 0 ; failed
			;int 3
	.ENDIF
	invoke	DestroyMenu, hMenu
	invoke	(IContextMenu ptr [ebx]).Release, pcm
	
ret_ok:
	mov		eax,1
	ret
			
ret_error:
	xor		eax,eax
	ret
ContextMenu endp



END