;//////////////////////////////////////////////////////////////
;//  write your comments to : loadall@hotmail.com
;//  have a look at my homepage : www.multimania.com/loadall
;//  chat with the author (loadall) on IRCNet, channel #coders
;//////////////////////////////////////////////////////////////
include System.inc
.data
MatrixIdentity  dd 1.0, 0.0, 0.0, 0.0
	        dd 0.0, 1.0, 0.0, 0.0
	        dd 0.0, 0.0, 1.0, 0.0
	        dd 0.0, 0.0, 0.0, 1.0
.code
Matrix_Clear proc Matrix
mpush	eax, ecx, edi
mov	edi, [Matrix]
mov	ecx, tMAT44
xor	eax, eax
rep	stosd
mpop	edi, ecx, eax
ret
Matrix_Clear endp
Matrix_Copy proc Dest, Src
mpush	eax, edx, esi, edi
mov	esi, [Src]
mov	edi, [Dest]
VectorCopy edi+M_00, esi+M_00, eax, edx
VectorCopy edi+M_10, esi+M_10, eax, edx
VectorCopy edi+M_20, esi+M_20, eax, edx
VectorCopy edi+M_30, esi+M_30, eax, edx
mpop	edi, esi, edx, eax
ret
Matrix_Copy endp
Matrix_SetIdentity proc Matrix
mcall	Matrix_Copy, [Matrix], offset MatrixIdentity
ret
Matrix_SetIdentity endp
Matrix_ToString proc Matrix
local	Buffer[16*16]:byte
mpush	ecx, edx
mov	edx, [Matrix]
lea	eax, [Buffer]
mov	ecx, 16
@@2000:
mcall	Sys_ftoa, eax, @[edx+(ecx*4)-4]
push	eax
add	eax, 16
dec	ecx
jnz	@@2000
.data
MTRXString db "[%s %s %s %s]", 13, 10
	   db "[%s %s %s %s]", 13, 10
	   db "[%s %s %s %s]", 13, 10
	   db "[%s %s %s %s]", 0
.code
push	offset MTRXString
call	Sys_GetTempString
push	eax
call	Sys_sprintf
add	esp, 64
mpop	edx, ecx
ret
Matrix_ToString endp
Matrix_Transpose proc Dest, Src
local	TmpMatrix[tMAT44]
mpush	eax, edx, esi, edi
mov	esi, [Src]
lea	edi, [TmpMatrix]
mov	eax, [esi+M_00]
mov	edx, [esi+M_01]
mov	[edi+M_00], eax
mov	[edi+M_10], edx
mov	eax, [esi+M_02]
mov	edx, [esi+M_10]
mov	[edi+M_20], eax
mov	[edi+M_01], edx
mov	eax, [esi+M_11]
mov	edx, [esi+M_12]
mov	[edi+M_11], eax
mov	[edi+M_21], edx
mov	eax, [esi+M_20]
mov	edx, [esi+M_21]
mov	[edi+M_02], eax
mov	eax, [esi+M_22]
mov	[edi+M_12], edx
mov	[edi+M_22], eax
lea	eax, [esi+M_30]
lea	edx, [edi+M_30]
mcall	VectorRotate, edx, eax, edi
mcall	VectorNegate, edx, edx
mov	edx, [Dest]
mcall	Matrix_Copy, edx, edi
mpop	edi, esi, edx, eax
ret
Matrix_Transpose endp
Matrix_Multiply proc Dest,
		     SrcA,
		     SrcB
local	TmpMatrix[tMAT44]		     
mpush	eax, ebx, edi
mov	eax, [SrcA]
mov	ebx, [SrcB]
lea	edi, [TmpMatrix]
fld	@[eax+M_00]
fmul	@[ebx+M_00]
fld	@[eax+M_10]
fmul	@[ebx+M_01]
fld	@[eax+M_20]
fmul	@[ebx+M_02]
fxch	st(2)
faddp	st(1), st(0)
faddp	st(1), st(0)
fstp	@[edi+M_00]
fld	@[eax+M_01]
fmul	@[ebx+M_00]
fld	@[eax+M_11]
fmul	@[ebx+M_01]
fld	@[eax+M_21]
fmul	@[ebx+M_02]
fxch	st(2)
faddp	st(1), st(0)
faddp	st(1), st(0)
fstp	@[edi+M_01]
fld	@[eax+M_02]
fmul	@[ebx+M_00]
fld	@[eax+M_12]
fmul	@[ebx+M_01]
fld	@[eax+M_22]
fmul	@[ebx+M_02]
fxch	st(2)
faddp	st(1), st(0)
faddp	st(1), st(0)
fstp	@[edi+M_02]
;///////////////////////////
fld	@[eax+M_00]
fmul	@[ebx+M_10]
fld	@[eax+M_10]
fmul	@[ebx+M_11]
fld	@[eax+M_20]
fmul	@[ebx+M_12]
fxch	st(2)
faddp	st(1), st(0)
faddp	st(1), st(0)
fstp	@[edi+M_10]
fld	@[eax+M_01]
fmul	@[ebx+M_10]
fld	@[eax+M_11]
fmul	@[ebx+M_11]
fld	@[eax+M_21]
fmul	@[ebx+M_12]
fxch	st(2)
faddp	st(1), st(0)
faddp	st(1), st(0)
fstp	@[edi+M_11]
fld	@[eax+M_02]
fmul	@[ebx+M_10]
fld	@[eax+M_12]
fmul	@[ebx+M_11]
fld	@[eax+M_22]
fmul	@[ebx+M_12]
fxch	st(2)
faddp	st(1), st(0)
faddp	st(1), st(0)
fstp	@[edi+M_12]
;///////////////////////////
fld	@[eax+M_00]
fmul	@[ebx+M_20]
fld	@[eax+M_10]
fmul	@[ebx+M_21]
fld	@[eax+M_20]
fmul	@[ebx+M_22]
fxch	st(2)
faddp	st(1), st(0)
faddp	st(1), st(0)
fstp	@[edi+M_20]
fld	@[eax+M_01]
fmul	@[ebx+M_20]
fld	@[eax+M_11]
fmul	@[ebx+M_21]
fld	@[eax+M_21]
fmul	@[ebx+M_22]
fxch	st(2)
faddp	st(1), st(0)
faddp	st(1), st(0)
fstp	@[edi+M_21]
fld	@[eax+M_02]
fmul	@[ebx+M_20]
fld	@[eax+M_12]
fmul	@[ebx+M_21]
fld	@[eax+M_22]
fmul	@[ebx+M_22]
fxch	st(2)
faddp	st(1), st(0)
faddp	st(1), st(0)
fstp	@[edi+M_22]
;///////////////////////////
fld	@[eax+M_00]
fmul	@[ebx+M_30]
fld	@[eax+M_10]
fmul	@[ebx+M_31]
fld	@[eax+M_20]
fmul	@[ebx+M_32]
fadd	@[eax+M_30]
fxch	st(2)
faddp	st(1), st(0)
faddp	st(1), st(0)
fstp	@[edi+M_30]
fld	@[eax+M_01]
fmul	@[ebx+M_30]
fld	@[eax+M_11]
fmul	@[ebx+M_31]
fld	@[eax+M_21]
fmul	@[ebx+M_32]
fadd	@[eax+M_31]
fxch	st(2)
faddp	st(1), st(0)
faddp	st(1), st(0)
fstp	@[edi+M_31]
fld	@[eax+M_02]
fmul	@[ebx+M_30]
fld	@[eax+M_12]
fmul	@[ebx+M_31]
fld	@[eax+M_22]
fmul	@[ebx+M_32]
fadd	@[eax+M_32]
fxch	st(2)
faddp	st(1), st(0)
faddp	st(1), st(0)
fstp	@[edi+M_32]
;///////////////////////////
mov	eax, [Dest]
mcall	Matrix_Copy, eax, edi
mpop	edi, eax, ebx
ret
Matrix_Multiply endp
Matrix_SetRotation proc Matrix,
			Rotation
local	cosA, sinA,
	cosB, sinB,
	cosC, sinC
mpush	esi, edi
mov	esi, [Rotation]
mov	edi, [Matrix]
fld	@[esi+0]
fsincos
fstp	[cosA]
fstp	[sinA]
fld	@[esi+4]
fsincos
fstp	[cosB]
fstp	[sinB]
fld	@[esi+8]
fsincos
fstp	[cosC]
fstp	[sinC]
fld	[cosB]
fmul	[cosC]
fstp	@[edi+M_00]
fld	[sinA]
fmul	[sinB]
fmul	[cosC]
fld	[cosA]
fmul	[sinC]
faddp	st(1), st(0)
fstp	@[edi+M_01]
fld	[cosA]
fmul	[sinB]
fmul	[cosC]
fld	[sinA]
fmul	[sinC]
fsubp	st(1), st(0)
fstp	@[edi+M_02]
fld	[cosB]
fmul	[sinC]
fstp	@[edi+M_10]
fld	[sinA]
fmul	[sinB]
fmul	[sinC]
fld	[cosA]
fmul	[cosC]
faddp	st(1), st(0)
fstp	@[edi+M_11]
fld	[cosA]
fmul	[sinB]
fmul	[sinC]
fld	[sinA]
fmul	[cosC]
fsubp	st(1), st(0)
fstp	@[edi+M_12]
fld	[sinB]
fchs
fstp	@[edi+M_20]
fld	[sinA]
fmul	[cosB]
fstp	@[edi+M_21]
fld	[cosA]
fmul	[cosB]
fstp	@[edi+M_22]
mpop	edi, esi			
ret
Matrix_SetRotation endp
Matrix_OrthoNormalize proc Matrix
mpush	eax, ebx, ecx
mov	eax, [Matrix]
lea	ebx, [eax+M_10]
lea	ecx, [eax+M_20]
mcall	CrossProduct, eax, ebx, ecx
mcall	CrossProduct, ebx, ecx, eax
mcall	VectorNormalize, eax, eax
mcall	VectorNormalize, ebx, ebx
mcall	VectorNormalize, ecx, ecx
mpop	eax, ebx, ecx
ret
Matrix_OrthoNormalize endp
Matrix_Transform proc Dest,
		      Src,
		      DeltaPosition,
		      DeltaRotation,
		      Scaling
local	TmpMatrix[tMAT44]
pushad
lea	edi, [TmpMatrix]
mcall	Matrix_SetIdentity, edi
mov	esi, [DeltaPosition]
cmp	esi, 0
je	@@1000
VectorCopy edi+M_30, esi, eax, edx
@@1000:
mov	esi, [DeltaRotation]
cmp	esi, 0
je	@@2000
mcall	Matrix_SetRotation, edi, esi
@@2000:
mov	ebx, [Src]
mov	eax, [Dest]
mcall	Matrix_Multiply, eax, ebx, edi
mcall	Matrix_OrthoNormalize, eax
popad
ret
Matrix_Transform endp
var f_0_5,0.5
var f_1,1.0
Matrix_SetProjection proc Matrix,
			  FieldOfView,
			  Aspect,
                          NearPlane,
                          FarPlane
pushad
mov	edi, [Matrix]
mcall	Matrix_Clear, edi
fld	[FieldOfView]
fmul	[f_0_5]
fsincos
fdivrp	st(1), st(0)
fst	@[edi+M_11]
fmul	[Aspect]
fstp	@[edi+M_00]
mov	eax, [f_1]
mov	[edi+M_23], eax
fld	[FarPlane]
fld	st(0)
fsub	[NearPlane]
fdivp	st(1), st(0)
fst	@[edi+M_22]
fmul	[NearPlane]
fchs
fstp	@[edi+M_32]
popad
ret
Matrix_SetProjection endp
end 
