;//////////////////////////////////////////////////////////////
;//  write your comments to : loadall@hotmail.com
;//  have a look at my homepage : www.multimania.com/loadall
;//  chat with the author (loadall) on IRCNet, channel #coders
;//////////////////////////////////////////////////////////////
include System.inc
include Pak.inc

FILE_ATTRIBUTE_DIRECTORY = 010h

mstruc WIN32_FIND_DATA
    m dwFileAttributes
    m ftCreationTime,8
    m ftLastAccessTime,8
    m ftLastWriteTime,8
    m nFileSizeHigh
    m nFileSizeLow
    m dwReserved0
    m dwReserved1
    m cFileName,260
    m cAlternateFileName,14
mends

MAX_PAK_FILES = 1000

mstruc PAKSTRUC
	m BaseDir, 256
	m OutputFile, 256
	m OutputFileHandle
	m pCurrentDirectoryName
	m pCurrentDirectory
	m pCurrentFile
	m NumFiles
	m Header, sPAKHEADER
	m Directories, (NUM_PAK_DIRS*sPAKDIR)
	m Files, (MAX_PAK_FILES*sPAKFILE)
mends

.data
PakFileName db "Paysage.dat",0
DIR_NAME_BITMAPS db "Bitmap",0
DIR_NAME_MESHES	db "Mesh",0
DIR_NAME_SOUNDS db "Sound",0
pPak dd 0

.code

Pak_Begin proc
mcall	Sys_MemAlloc, sPAKSTRUC
mov	[pPak], eax
xchg	eax, ebx
pushstr	"d:\"
lea	eax, [ebx+PAKSTRUC_BaseDir]
push	eax	
call	Sys_StrCpy
push 	offset PakFileName
lea	eax, [ebx+PAKSTRUC_BaseDir]
push	eax
pushstr "%s%s"
lea	eax, [ebx+PAKSTRUC_OutputFile]
push	eax
call	Sys_sprintf
add	esp, 8
lea	eax, [ebx+PAKSTRUC_OutputFile]
mcall	Sys_FileCreate, eax
mov	[ebx+PAKSTRUC_OutputFileHandle], eax
lea	eax, [ebx+PAKSTRUC_Header]
mcall	Sys_FileWrite, [@ ebx+PAKSTRUC_OutputFileHandle],eax,sPAKHEADER
mov	@[ebx+PAKSTRUC_Header+PAKHEADER_Signature], SIGNATURE_PAK
mov	@[ebx+PAKSTRUC_Header+PAKHEADER_DirOffset], sPAKHEADER
lea	eax, [ebx+PAKSTRUC_Files]
mov	[ebx+PAKSTRUC_pCurrentFile], eax
ret
Pak_Begin endp

Pak_ParseRecurse proc DirectoryName
local Buffer[128]:byte,
	SearchString[128]:byte,
	FindData[tWIN32_FIND_DATA],
	SearchHandle,
	InputFileData, InputFileSize
push	[DirectoryName]
pushstr "%s*.*"
lea	eax, [SearchString]
push	eax
call	Sys_sprintf
add	esp, 4
lea	eax, [FindData]
push	eax
lea	eax, [SearchString]
push	eax
call	[FindFirstFileA]
mov	[SearchHandle], eax
cmp	eax, -1
je	@@9000
@@1000:
lea	esi, [FindData+WIN32_FIND_DATA_cFileName]
cmp	byte ptr [esi], '.'
je	@@8000
cmp	[FindData+WIN32_FIND_DATA_dwFileAttributes], FILE_ATTRIBUTE_DIRECTORY
jne	@@2000
push	esi
push	[DirectoryName]
pushstr "%s%s\"
lea	eax, [Buffer]
push	eax
call	Sys_sprintf
add	esp, 8
lea	eax, [Buffer]
mcall	Pak_ParseRecurse, eax
jmp	@@8000
@@2000:
mov	ebx, [pPak]
cmp	[@ ebx+PAKSTRUC_pCurrentDirectoryName], offset DIR_NAME_BITMAPS
jne	@@4000
mcall	Sys_StrLen, esi
cmp	byte ptr [esi + eax - 6], '_'
jne	@@3000
cmp	byte ptr [esi + eax - 5], '0'
jb	@@3000
cmp	byte ptr [esi + eax - 5], '9'
jna	@@8000
@@3000:
pushstr "pal"
lea	eax, [esi + eax - 3]
push	eax
call	Sys_StrCmp
test	eax, eax
jnz	@@8000
@@4000:
push	esi
push	[DirectoryName]
pushstr "%s%s"
lea	eax, [Buffer]
push	eax
call	Sys_sprintf
add	esp, 8
lea	eax, [Buffer]
mcall	Sys_LogPrintf, eax
mov	ebx, [pPak]
mov	eax, [ebx+PAKSTRUC_pCurrentDirectory]
inc	@[eax+PAKDIR_NumFiles]
inc	@[ebx+PAKSTRUC_NumFiles]
cmp	@[ebx+PAKSTRUC_NumFiles], MAX_PAK_FILES
ja	@@9999
mov	edi, [ebx+PAKSTRUC_pCurrentFile]
add	@[ebx+PAKSTRUC_pCurrentFile], sPAKFILE
mov	eax, [ebx+PAKSTRUC_Header+PAKHEADER_DirOffset]
mov	[edi+PAKFILE_Offset], eax
lea	eax, [ebx+PAKSTRUC_BaseDir]
mcall	Sys_StrLen, eax
lea	ecx, [Buffer+eax]
lea	eax, [edi+PAKFILE_Name]
mcall	Sys_StrCpy, eax, ecx
lea	eax, [InputFileSize]
push	eax
lea	eax, [Buffer]
push	eax
call	Sys_FileLoad
mov	[InputFileData], eax
push	[InputFileSize]
push	eax
lea	eax, [Buffer]
push	eax
push	[@ ebx+PAKSTRUC_OutputFileHandle]
mov	eax, [ebx+PAKSTRUC_pCurrentDirectoryName]
cmp	eax, offset DIR_NAME_BITMAPS
je	@@5000
cmp	eax, offset DIR_NAME_MESHES
je	@@5100
cmp	eax, offset DIR_NAME_SOUNDS
je	@@5200
jmp	@@9999
@@5000:
call	Pak_AddBitmapFile
jmp	@@6000
@@5100:
call	Pak_AddMeshFile
jmp	@@6000
@@5200:
call	Pak_AddSoundFile
@@6000:
mcall	Sys_MemFree, [InputFileData]
mov	ebx, [pPak]
add	[ebx+PAKSTRUC_Header+PAKHEADER_DirOffset], eax
@@8000:
lea	eax, [FindData]
mcall	[FindNextFileA], [SearchHandle], eax
test	eax, eax
jnz	@@1000
mcall	[FindClose], [SearchHandle]
@@9000:
ret
@@9999:
pushstr "Pak()"
call	Error
Pak_ParseRecurse endp

Pak_Parse proc DirectoryName
local Buffer[256]:byte
mov	ebx, [pPak]
mov	eax, [DirectoryName]
mov	[ebx+PAKSTRUC_pCurrentDirectoryName], eax
mov	eax, [ebx+PAKSTRUC_pCurrentDirectory]
test	eax, eax
jz	@@1000
add	eax, sPAKDIR
jmp	@@2000
@@1000:
lea	eax, [ebx+PAKSTRUC_Directories]
@@2000:
mov	[ebx+PAKSTRUC_pCurrentDirectory], eax
push	[DirectoryName]
lea	eax, [ebx+PAKSTRUC_BaseDir]
push	eax
pushstr "%s%s\"
lea	eax, [Buffer]
push	eax
call	Sys_sprintf
add	esp, 8
lea	eax, [Buffer]
mcall	Pak_ParseRecurse, eax
ret
Pak_Parse endp

Pak_End proc
mov	ebx, [pPak]
mov	edi, [ebx+PAKSTRUC_OutputFileHandle]
mcall	Sys_FileSeekBegin, edi,0
lea	eax, [ebx+PAKSTRUC_Header]
mcall	Sys_FileWrite, edi,eax,sPAKHEADER
mcall	Sys_FileSeekBegin, edi,[@ ebx+PAKSTRUC_Header+PAKHEADER_DirOffset]
lea	eax, [ebx+PAKSTRUC_Directories]
mcall	Sys_FileWrite, edi, eax, (sPAKDIR*NUM_PAK_DIRS)
lea	eax, [ebx+PAKSTRUC_Files]
imul	ecx, [ebx+PAKSTRUC_NumFiles], sPAKFILE
mcall	Sys_FileWrite, edi, eax, ecx
mcall	Sys_FileClose, edi
lea	eax, [ebx+PAKSTRUC_OutputFile]
;call	Pak_LZWEncode, eax, eax
mcall	Sys_MemFree, ebx
ret
Pak_End endp

Pak proc
call	Pak_Begin
mcall	Pak_Parse, offset DIR_NAME_BITMAPS
mcall	Pak_Parse, offset DIR_NAME_MESHES
mcall	Pak_Parse, offset DIR_NAME_SOUNDS
call	Pak_End
ret
Pak endp

end

