;//////////////////////////////////////////////////////////////
;//  write your comments to : loadall@hotmail.com
;//  have a look at my homepage : www.multimania.com/loadall
;//  chat with the author (loadall) on IRCNet, channel #coders
;//////////////////////////////////////////////////////////////
include System.inc
include Pak.inc

mstruc ALPHDECODE
	m Father,4
	m Character,4
mends 

.data
IMAGETYPE_GIF db "gif",0
IMAGETYPE_PCX db "pcx",0

.code

Pak_ValidateTextureSize proc _Width,
			     Height,
			     pWidth, 
			     pHeight,
			     IsFirstLevel
pushad			     
mov	eax, [_Width]
cmp	eax, 256
ja	@@9999
mov	ecx, eax
dec	eax
and	eax, ecx
jnz	@@9999
;********************
mov	eax, [Height]
cmp	eax, 256
ja	@@9999
mov	ecx, eax
dec	eax
and	eax, ecx
jnz	@@9999
;********************
cmp	[IsFirstLevel], 0
jne	@@9000
mov	esi, [pWidth]
lodsd
shr	eax, 1
cmp	eax, [_Width]
jne	@@9999
;********************
mov	esi, [pHeight]
lodsd
shr	eax, 1
cmp	eax, [Height]
jne	@@9999
;********************
@@9000:
mov	eax, [_Width]
mov	edi, [pWidth]
stosd
mov	eax, [Height]
mov	edi, [pHeight]
stosd
popad
mov	eax, 1
ret
;********************
@@9999:
popad
xor	eax, eax
ret
Pak_ValidateTextureSize endp

Pak_GIFdecode proc DestBase,
		   SrcBase
local	Src, 
	Dest,
	Stack,
	CodeSize,
	FreeCode, 
	MaxCode, 
	LastChar, 
	LastCode,
	CurrCode,
	NumSrcBitsLeft,
	SrcDword, 
	NumBlockLeft
CODE_CLEAR     =    256
CODE_EOI       =    257
MAX_CODE_SIZE  =     12
STACK_SIZE     =  65536
pushad
call	@@init
@@1000:
mov	[CodeSize], 9
mov	[MaxCode], 512
mov	[FreeCode], (CODE_EOI + 1)
call	@@getCode
cmp	eax, CODE_EOI
je	@@9000
cmp	eax, CODE_CLEAR
je	@@1000
mov	[LastChar], eax
mov	[LastCode], eax
call	@@setChar
@@2000:
call	@@getCode
cmp	eax, CODE_EOI
je	@@9000
cmp	eax, CODE_CLEAR
je	@@1000
mov	[CurrCode], eax
mov	edx, [Stack]
cmp	eax, [FreeCode]
jnb	@@8000
@@3000:
cmp	eax, CODE_EOI
jb	@@4000
mov	ecx, [ebx+ALPHDECODE_Character + eax * sALPHDECODE]
mov	eax, [ebx+ALPHDECODE_Father + eax * sALPHDECODE]
mov	[edx], cl
inc	edx
jmp	@@3000
@@4000:
dec	edx
mov	ecx, [Stack]
mov	[LastChar], eax
call	@@setChar
cmp	edx, ecx
jb	@@5000
@@4100:
mov	al, [edx]
dec	edx
call	@@setChar
cmp	edx, ecx
jnb	@@4100
@@5000:
mov	edx, [FreeCode]
mov	ecx, [MaxCode]
dec	ecx
cmp	edx, ecx
jnb	@@6000
mov	eax, [LastCode]
mov	ecx, [LastChar]
mov	[ebx+ALPHDECODE_Father + edx * sALPHDECODE], eax
mov	[ebx+ALPHDECODE_Character + edx * sALPHDECODE], ecx
mov	eax, [CurrCode]
inc	edx
mov	[LastCode], eax
mov	[FreeCode], edx
jmp	@@2000
@@6000:
cmp	[CodeSize], MAX_CODE_SIZE
je	@@2000
inc	[CodeSize]
shl	[MaxCode], 1
jmp	@@5000
@@8000:
mov	eax, [LastChar]
mov	[edx], al
inc	edx
mov	eax, [LastCode]
jmp	@@3000
@@9000:
call	@@cleanUp
jmp	@@finish

@@init:
mov	eax, [SrcBase]
mov	[Src], eax
mov	eax, [DestBase]
mov	[Dest], eax
mcall	Sys_MemAlloc, (((1 shl MAX_CODE_SIZE) * sALPHDECODE) + STACK_SIZE)
mov	[Stack], eax
lea	ebx, [eax + STACK_SIZE]
xor	eax, eax
mov	[NumSrcBitsLeft], eax
mov	[NumBlockLeft], eax
retn

@@cleanUp:
mcall	Sys_MemFree, [Stack]
retn

@@getCode:
mpush	ebx, ecx, edx, esi, edi
xor	eax, eax
mov	ebx, [CodeSize]
xor	ecx, ecx
mov	edx, [NumSrcBitsLeft]
mov	esi, [SrcDword]
xor	edi, edi
@@10000:
dec	edx
js	@@11000
mov	[NumSrcBitsLeft], edx
mov	edx, esi
shr	esi, 1
and	edx, 1
shl	edx, cl
inc	ecx
or	eax, edx
mov	edx, [NumSrcBitsLeft]
dec	ebx
jnz	@@10000
mov	[SrcDword], esi
mpop	edi, esi, edx, ecx, ebx
retn
@@11000:
push	eax
push	ecx
mov	esi, [Src]
mov	edx, [NumBlockLeft]
mov	ecx, 4
@@11100:
dec	edx
js	@@12000
mov	al, [esi]
inc	esi
ror	eax, 8
dec	ecx
jnz	@@11100
mov	[NumBlockLeft], edx
mov	[Src], esi
mov	esi, eax
pop	ecx
pop	eax
mov	edx, 020h
jmp	@@10000
@@12000:
movzx	edx, byte ptr [esi]
inc	esi
jmp	@@11100

@@setChar:
push	edx
mov	edx, [Dest]
mov	[edx], al
inc	edx
mov	[Dest], edx
pop	edx
retn
@@finish:
popad
ret	
Pak_GIFdecode endp

Pak_GIFload proc Header,
		 pOutputSize,
		 pWidth,
		 pHeight,
		 OutputFileHandle,
		 InputFileName,
		 InputFileData,
 		 InputFileSize
local pPalette, _Width, Height,
      Src, DestImageData,
      OutputDataSize
pushad
and	[pPalette], 0
cmp	[Header], 0
jne	@@100
lea	eax, [InputFileSize]
mcall	Sys_FileLoad, [InputFileName], eax
mov	[InputFileData], eax
@@100:
;********************
mov	esi, [InputFileData]
push	6
pushstr "GIF87a"
push	esi
call	Sys_StrnCmp
test	eax, eax
jnz	@@200
push	6
pushstr "GIF89a"
push	esi
call	Sys_StrnCmp
test	eax, eax
jz	@@9999
@@200:
add	esi, 10
lodsb
add	esi, 2
test	al, 128
jz	@@300
mov	[pPalette], esi
add	esi, 768
@@300:
xor	eax, eax
lodsb
cmp	al, '!'
jne	@@400
lodsb
lodsb
add	esi, eax
jmp	@@300
@@400:
add	esi, 4
lodsw
mov	[_Width], eax
lodsw
mov	[Height], eax
lodsb
test	al, 128
jz	@@500
mov	[pPalette], esi
add	esi, 768
@@500:
inc	esi
mov	[Src], esi
;********************
mcall	Pak_ValidateTextureSize, [_Width], [Height],\
				 [pWidth], [pHeight],\
				 [Header]
test	eax, eax
jz	@@9999
;********************
mov	ebx, [Header]
cmp	ebx, 0
je	@@700
mov	eax, [_Width]
mov	[ebx+BMPHEADER_Width], eax
mov	eax, [Height]
mov	[ebx+BMPHEADER_Height], eax
lea	edi, [ebx+BMPHEADER_Palette]
mov	esi, [pPalette]
cmp	esi, 0
je	@@9999
mov	ecx, 256
@@600:
movsb
movsb
movsb
inc	edi
dec	ecx
jnz	@@600
mcall	Sys_FileWrite, [OutputFileHandle], ebx, sBMPHEADER
@@700:
;********************
mov	eax, [_Width]
imul	eax, [Height]
mov	[OutputDataSize], eax
mov	edx, [pOutputSize]
add	[edx], eax
mcall	Sys_MemAlloc, eax
mov	[DestImageData], eax
mcall	Pak_GIFdecode, eax, [Src]
mcall	Sys_FileWrite, [OutputFileHandle], [DestImageData], [OutputDataSize]
mcall	Sys_MemFree, [DestImageData]
cmp	[Header], 0
jne	@@2000
mcall	Sys_MemFree, [InputFileData]
@@2000:
popad
ret
@@9999:
push	[InputFileName]
pushstr "Pak_GIFload(%s)"
call	Error
Pak_GIFload endp

Pak_PCXdecode proc Dest,
		   Src,
		   Count
pushad
mov	esi, [Src]
mov	edi, [Dest]
xor	eax, eax
@@1000:
cmp	[Count], 0
jng	@@9000
lodsb
cmp	al, 192
jnb	@@2000
stosb
dec	[Count]
jmp	@@1000
@@2000:
and	al, 63
mov	ecx, eax
sub	[Count], eax
lodsb
@@2100:
stosb
dec	ecx
jnz	@@2100
jmp	@@1000
@@9000:
cmp	[Count], 0
je	@@9100
pushstr "Pak_PCXdecode()"
call	Error
@@9100:
popad
ret
Pak_PCXdecode endp
		   
Pak_PCXload proc Header,
		 pOutputSize,
		 pWidth,
		 pHeight,
		 OutputFileHandle,
		 InputFileName,
		 InputFileData,
		 InputFileSize
local _Width, Height,
	OutputDataSize, Src, DestImageData
pushad
cmp	[Header], 0
jne	@@100
lea	eax, [InputFileSize]
mcall	Sys_FileLoad, [InputFileName], eax
mov	[InputFileData], eax
@@100:
;********************
mov	esi, [InputFileData]
xor	eax, eax
lodsb
cmp	al, 10
jne	@@9999
lodsb
lodsb
test	eax, eax
jz	@@9999
lodsb
cmp	al, 8
jne	@@9999
add	esi, 8
lodsw
mov	[_Width], eax
lodsw
mov	[Height], eax
add	esi, 112
mov	[Src], esi
;********************
mcall	Pak_ValidateTextureSize, [_Width], [Height],\
				 [pWidth], [pHeight],\
				 [Header]
test	eax, eax
jz	@@9999
;********************
mov	ebx, [Header]
cmp	ebx, 0
je	@@700
mov	eax, [_Width]
mov	[ebx+BMPHEADER_Width], eax
mov	eax, [Height]
mov	[ebx+BMPHEADER_Height], eax
lea	edi, [ebx+BMPHEADER_Palette]
mov	esi, [InputFileData]
add	esi, [InputFileSize]
sub	esi, 768
mov	ecx, 256
@@600:
movsb
movsb
movsb
inc	edi
dec	ecx
jnz	@@600
mcall	Sys_FileWrite, [OutputFileHandle], ebx, sBMPHEADER
@@700:
;********************
mov	eax, [_Width]
imul	eax, [Height]
mov	[OutputDataSize], eax
mov	edx, [pOutputSize]
add	[edx], eax
mcall	Sys_MemAlloc, eax
mov	[DestImageData], eax
mcall	Pak_PCXdecode, eax, [Src], [OutputDataSize]
mcall	Sys_FileWrite, [OutputFileHandle], [DestImageData], [OutputDataSize]
mcall	Sys_MemFree, [DestImageData]
cmp	[Header], 0
jne	@@2000
mcall	Sys_MemFree, [InputFileData]
@@2000:
popad		 
ret
@@9999:
push	[InputFileName]
pushstr "Pak_PCXload(%s)"
call	Error
Pak_PCXload endp

;OUT:EAX=OutputDataSize
Pak_AddBitmapFile proc OutputFileHandle,
		       InputFileName,
		       InputFileData,
		       InputFileSize
local _Width, 
      Height,
      Header,
      OutputSize,
      Buffer,
      Tmp0,
      LoadProcedure
mcall	Sys_MemAlloc, 256
mov	[Buffer], eax
xchg	eax, edi
mcall	Sys_StrCpy, edi, [InputFileName]
mcall	Sys_StrLen, edi
add	edi, eax
mov	eax, [edi - 4]
mov	[edi - 2], eax
mov	byte ptr [edi - 4], '_'
mov	byte ptr [edi - 3], '1'
mcall	Sys_MemAlloc, sBMPHEADER
mov	[Header], eax
xchg	eax, ebx
mov	@[ebx+BMPHEADER_Signature], SIGNATURE_BMP
@@100:
mcall	Sys_FileExists, [Buffer]
test	eax, eax
jz	@@200
inc	@[ebx+BMPHEADER_MipMapCount]
inc	byte ptr [edi - 3]
jmp	@@100
@@200:
;*****************************
mov	edi, [Header]
add	edi, BMPHEADER_Palette
mov	eax, -1
mov	ecx, 256
rep	stosd
;*****************************
mov	edi, [Buffer]
mcall	Sys_StrCpy, edi, [InputFileName]
mcall	Sys_StrLen, edi
mov	@[edi + eax - 4], 'lap.'
mcall	Sys_FileExists, edi
test	eax, eax
jz	@@900
mcall	Sys_LogPrintf, edi
lea	eax, [Tmp0]
mcall	Sys_FileLoad, edi, eax
mov	[Tmp0], eax
xchg	eax, esi
lodsd
cmp	eax, 'FFIR'
jne	@@9999
lodsd
lodsd
cmp	eax, ' LAP'
jne	@@9999
lodsd
cmp	eax, 'atad'
jne	@@9999
add	esi, 8
mov	edi, [Header]
add	edi, BMPHEADER_Palette
mov	ecx, 256
@@300:
xor	eax, eax
lodsb
mov	edx, eax
lodsb
add	edx, eax
lodsb
add	edx, eax
inc	esi
xchg	eax, edx
xor	edx, edx
mov	ebx, 3
idiv    ebx
cmp	al, 255
jna	@@310
mov	al, 255
@@310:
add	edi, 3
stosb
dec	ecx
jnz	@@300
mcall	Sys_MemFree, [Tmp0]
@@900:
;*****************************
mov	esi, [InputFileName]
mcall	Sys_StrLen, esi
lea	esi, [esi + eax - 3]
mov	[LoadProcedure], offset Pak_GIFload
mcall	Sys_StrCmp, esi, offset IMAGETYPE_GIF
test	eax, eax
jnz	@@1000
mov	[LoadProcedure], offset Pak_PCXload
mcall	Sys_StrCmp, esi, offset IMAGETYPE_PCX
test	eax, eax
jnz	@@1000
jmp	@@9999
@@1000:
;*****************************
mov	[OutputSize], sBMPHEADER
push	[InputFileSize]
push	[InputFileData]
push	[InputFileName]
push	[OutputFileHandle]
lea	eax, [Height]
push	eax
lea	eax, [_Width]
push	eax
lea	eax, [OutputSize]
push	eax
push	[Header]
call	[LoadProcedure]
mov	eax, [Header]
push	@[eax+BMPHEADER_MipMapCount]
push	@[eax+BMPHEADER_Height]
push	@[eax+BMPHEADER_Width]
pushstr "%i * %i * %i"
call	Sys_LogPrintf
add	esp, 12
;*****************************
mov	edi, [Buffer]
mcall	Sys_StrCpy, edi, [InputFileName]
mcall	Sys_StrLen, edi
add	edi, eax
mov	eax, [edi - 4]
mov	[edi - 2], eax
mov	byte ptr [edi - 4], '_'
mov	byte ptr [edi - 3], '1'
@@1100:
mov	eax, [Header]
dec	@[eax+BMPHEADER_MipMapCount]
js	@@1200
push	0
push	0
push	[Buffer]
push	[OutputFileHandle]
lea	eax, [Height]
push	eax
lea	eax, [_Width]
push	eax
lea	eax, [OutputSize]
push	eax
push	0
call	[LoadProcedure]
inc	byte ptr [edi - 3]
jmp	@@1100
@@1200:
;*****************************
mcall	Sys_MemFree, [Header]
mcall	Sys_MemFree, [Buffer]
mov	eax, [OutputSize]
ret
;*****************************
@@9999:
push	[InputFileName]
pushstr "Pak_AddBitmapFile(%s)"
call	Error
Pak_AddBitmapFile endp
end
