;//////////////////////////////////////////////////////////////
;//  write your comments to : loadall@hotmail.com
;//  have a look at my homepage : www.multimania.com/loadall
;//  chat with the author (loadall) on IRCNet, channel #coders
;//////////////////////////////////////////////////////////////
include System.inc
include Pak.inc
TOKEN_MAX_TRIANGLES = 500
mstruc TOKEN
	m Start
	m End
	m Src
	m Name
	m Vertex,sVEC3
	m Triangles,(24*TOKEN_MAX_TRIANGLES)
	m NumTriangles
	m TextureName, 64
mends
.data
TOKEN_VERTEX db "v",0
TOKEN_TEXVERTEX db "vt",0
TOKEN_FACE db "f",0
TOKEN_TEXTURE db "usemtl",0
.code
;IN:EBX=tTOKEN*
Pak_TokenInit proc
pushad
mov	eax, [ebx+TOKEN_Start]
mov	[ebx+TOKEN_Src], eax
popad
ret
Pak_TokenInit endp

;IN:EBX=tTOKEN*
Pak_GetNextToken proc
local TokenStart, pLastVertexIndexes
pushad
and	@[ebx+TOKEN_Name], 0
@@500:
call	@@parse
mov	esi, [TokenStart]
mcall	Sys_StrCmp, esi, offset TOKEN_VERTEX
test	eax, eax
jnz	@@parseVertex
mcall	Sys_StrCmp, esi, offset TOKEN_TEXVERTEX
test	eax, eax
jnz	@@parseTexVertex
mcall	Sys_StrCmp, esi, offset TOKEN_FACE
test	eax, eax
jnz	@@parseFace
mcall	Sys_StrCmp, esi, offset TOKEN_TEXTURE
test	eax, eax
jnz	@@parseTexture
@@1000:
cmp	esi, [ebx+TOKEN_End]
jnb	@@9000
lodsb
cmp	al, 10
jne	@@1000
mov	[ebx+TOKEN_Src], esi
jmp	@@500
@@9000:
popad
ret
;*****************************
@@parse:
mpush	eax, esi
mov	esi, [ebx+TOKEN_Src]
@@10000:
cmp	esi, [ebx+TOKEN_End]
jnb	@@19000
lodsb
cmp	al, ' '
jna	@@10000
dec	esi
mov	[TokenStart], esi
@@11000:
cmp	esi, [ebx+TOKEN_End]
jnb	@@19000
lodsb
cmp	al, ' '
ja	@@11000
and	byte ptr [esi-1], 0
mov	[ebx+TOKEN_Src], esi
mpop	esi, eax
retn
@@19000:
mpop	esi, eax, eax
jmp	@@9000
;*****************************
@@parseVertex:
mov	@[ebx+TOKEN_Name], offset TOKEN_VERTEX
@@pv500:
mov	ecx, 3
lea	edi, [ebx+TOKEN_Vertex]
@@pv1000:
call	@@parse
mcall	Sys_atof, [TokenStart]
stosd
dec	ecx
jnz	@@pv1000
jmp	@@9000
;*****************************
@@parseTexVertex:
mov	@[ebx+TOKEN_Name], offset TOKEN_TEXVERTEX
jmp	@@pv500
;*****************************
@@parseFace:
mov	@[ebx+TOKEN_Name], offset TOKEN_FACE
xor	ecx, ecx
lea	edi, [ebx+TOKEN_Triangles]
@@pf1000:
call	@@parse
mov	esi, [TokenStart]
mov	al, [esi]
cmp	al, '0'
jb	@@pf9000
cmp	al, '9'
ja	@@pf9000
mcall	Sys_StrChr, esi, '/'
test	eax, eax
jz	@@pf9000
mov	byte ptr [eax], 0
mov	edx, eax
inc	eax
mcall	Sys_atoi, eax
mov	[edi+4], eax
mcall	Sys_atoi, esi
mov	[edi], eax
mov	byte ptr [edx], '/'
add	edi, 8
inc	ecx
cmp	ecx, 3
jb	@@pf1000
ja	@@pf2000
mov	@[ebx+TOKEN_NumTriangles], 1
lea	eax, [ebx+TOKEN_NumTriangles+16]
mov	[pLastVertexIndexes], eax
jmp	@@pf1000
@@pf2000:
lea	esi, [ebx+TOKEN_Triangles]
movsd
movsd
mov	esi, [pLastVertexIndexes]
movsd
movsd
lea	eax, [edi-24]
mov	[pLastVertexIndexes], eax
inc	@[ebx+TOKEN_NumTriangles]
jmp	@@pf1000
@@pf9000:
mov	eax, [TokenStart]
mov	[ebx+TOKEN_Src], eax
jmp	@@9000
;*****************************
@@parseTexture:
mov	@[ebx+TOKEN_Name], offset TOKEN_TEXTURE
call	@@parse
lea	eax, [ebx+TOKEN_TextureName]
mcall	Sys_StrCpy, eax, [TokenStart]
jmp	@@9000
Pak_GetNextToken endp

;OUT:EAX=OutputDataSize
Pak_AddMeshFile proc OutputFileHandle,
		     InputFileName, 
		     InputFileData,
		     InputFileSize
local TrianglesSize,
      Token,
      NumVertices,
      NumTexVertices,
      NumTriangles,
      NumTriGroups,
      Vertices,
      TexVertices,
      Triangles,
      pNumTriGroupVertices,
      Header[tMESHHEADER]
mcall	Sys_MemAlloc, sTOKEN
mov	[Token], eax
xchg	eax, ebx
mov	eax, [InputFileData]
mov	[ebx+TOKEN_Start], eax
add	eax, [InputFileSize]
mov	[ebx+TOKEN_End], eax
;*****************************
and	[NumVertices], 0
and	[NumTexVertices], 0
and	[NumTriangles], 0
mov	[NumTriGroups], 1
call	Pak_TokenInit
@@1000:
call	Pak_GetNextToken
mov	eax, [ebx+TOKEN_Name]
cmp	eax, offset TOKEN_VERTEX
jne	@@1100
inc	[NumVertices]
jmp	@@1000
@@1100:
cmp	eax, offset TOKEN_TEXVERTEX
jne	@@1200
inc	[NumTexVertices]
jmp	@@1000
@@1200:
cmp	eax, offset TOKEN_FACE
jne	@@1300
mov	eax, [ebx+TOKEN_NumTriangles]
add	[NumTriangles], eax
jmp	@@1000
@@1300:
cmp	eax, offset TOKEN_TEXTURE
jne	@@1400
inc	[NumTriGroups]
jmp	@@1000
@@1400:
;*****************************
imul	eax, [NumVertices], sVEC3
mcall	Sys_MemAlloc, eax
mov	[Vertices], eax
xchg	eax, edi
imul	eax, [NumTexVertices], sVEC3
mcall	Sys_MemAlloc, eax
mov	[TexVertices], eax
xchg	eax, esi
call	Pak_TokenInit
@@2000:
call	Pak_GetNextToken
mov	eax, [ebx+TOKEN_Name]
test	eax, eax
jz	@@2900
cmp	eax, offset TOKEN_VERTEX
jne	@@2100
VectorCopy edi, ebx+TOKEN_Vertex, eax, edx
mov	eax, [Vertices]
sub	eax, edi
lea	edx, [Header+MESHHEADER_Mins]
mcall	M_BBoxAddPoint, edx, edi, eax
add	edi, sVEC3
jmp	@@2000
@@2100:
cmp	eax, offset TOKEN_TEXVERTEX
jne	@@2000
VectorCopy esi, ebx+TOKEN_Vertex, eax, edx
add	esi, sVEC3
jmp	@@2000
@@2900:
;*****************************
imul	eax, [NumTriangles], (3*sLVTX)
imul	edx, [NumTriGroups], sTRIGROUP
add	eax, edx
mov	[TrianglesSize], eax
mcall	Sys_MemAlloc, eax
mov	[Triangles], eax
xchg	eax, edi
call	Pak_TokenInit
@@3000:
call	Pak_GetNextToken
mov	eax, [ebx+TOKEN_Name]
test	eax, eax
jz	@@3900
cmp	eax, offset TOKEN_TEXTURE
jne	@@3100
lea	eax, [ebx+TOKEN_TextureName]
lea	edx, [edi+TRIGROUP_TextureName]
mcall	Sys_StrCpy, edx, eax
lea	eax, [edi+TRIGROUP_NumVertices]
mov	[pNumTriGroupVertices], eax
add	edi, sTRIGROUP
jmp	@@3000
@@3100:
cmp	eax, offset TOKEN_FACE
jne	@@3000
imul	ecx, [ebx+TOKEN_NumTriangles], 3
mov	eax, [pNumTriGroupVertices]
add	[eax], ecx
lea	esi, [ebx+TOKEN_Triangles]
@@3110:
lodsd
imul	eax, sVEC3
add	eax, [Vertices]
mov	edx, [eax+0]
mov	[edi+LVTX_x], edx
mov	edx, [eax+4]
mov	[edi+LVTX_y], edx
mov	edx, [eax+8]
mov	[edi+LVTX_z], edx
mov	@[edi+LVTX_color], 0ffffffffh
lodsd
imul	eax, sVEC3
add	eax, [TexVertices]
mov	edx, [eax+0]
mov	[edi+LVTX_tu], edx
mov	edx, [eax+4]
mov	[edi+LVTX_tv], edx
add	esi, 8
add	edi, sLVTX
dec	ecx
jnz	@@3110
jmp	@@3000
@@3900:
;*****************************
lea	eax, [Header]
mov	@[eax+MESHHEADER_Signature], SIGNATURE_MESH
mcall	Sys_FileWrite, [OutputFileHandle], eax, sMESHHEADER
mcall	Sys_FileWrite, [OutputFileHandle], [Triangles], [TrianglesSize]
;*****************************
push	[NumTriGroups]
push	[NumTriangles]
push	[NumTexVertices]
push	[NumVertices]
pushstr "NumVertices = %i, NumTexVertices = %i, NumTriangles = %i, NumTriGroups = %i"
call	Sys_LogPrintf
add	esp, 16
lea	eax, [Header+MESHHEADER_Maxs]
mcall	VectorToString, eax
push	eax
lea	eax, [Header+MESHHEADER_Mins]
mcall	VectorToString, eax
push	eax
pushstr "Mins = %s, Maxs = %s"
call	Sys_LogPrintf
add	esp, 8
;*****************************
mcall	Sys_MemFree, [Triangles]
mcall	Sys_MemFree, [Vertices]
mcall	Sys_MemFree, [TexVertices]
mcall	Sys_MemFree, [Token]
mov	eax, [TrianglesSize]
add	eax, sMESHHEADER
ret
Pak_AddMeshFile endp
end
