;//////////////////////////////////////////////////////////////
;//  write your comments to : loadall@hotmail.com
;//  have a look at my homepage : www.multimania.com/loadall
;//  chat with the author (loadall) on IRCNet, channel #coders
;//////////////////////////////////////////////////////////////
include system.inc
includelib kernel32.lib
LoadLibraryA proto :dword
GetProcAddress proto :dword, :dword

HEAP_SIZE	  = (2 * 1024 * 1024)

PAGE_READWRITE         =     4
MEM_COMMIT             = 01000h
MEM_RESERVE            = 02000h
MEM_RELEASE            = 08000h
GENERIC_READ           = 080000000h
GENERIC_WRITE          = 040000000h
FILE_SHARE_READ        = 1
FILE_SHARE_WRITE       = 2
FILE_FLAG_RANDOM_ACCESS    = 010000000h
CREATE_NEW             = 1
CREATE_ALWAYS          = 2
OPEN_EXISTING          = 3
OPEN_ALWAYS            = 4
FILE_BEGIN   = 0
FILE_CURRENT = 1
FILE_END     = 2
PM_REMOVE      =   1
WM_QUIT        = 010h
MB_ICONERROR   = 010h
mstruc WINMSG
	m hwnd, 4
	m message, 4
	m wParam, 4
	m lParam, 4
	m time, 4
	m pt, 8
mends

.data

hMainWindow dd 0
Heap_Bottom dd 0
Heap_Top dd 0
Malloc_MaxAllocatedMemory dd 0
Malloc_CurrentAllocatedMemory dd 0
Log_FileHandle dd 0
TempStringIndex dd 0
TempStringData dd 0
Keyboard db 256 dup (0)
Sys_RequiredKeyCodes dd VK_ESCAPE
	dd VK_LEFT
	dd VK_RIGHT
	dd VK_UP
	dd VK_DOWN
	dd VK_SHIFT
	dd VK_CONTROL
	dd VK_DELETE
	dd VK_END
	dd VK_PRIOR
	dd VK_NEXT
	dd VK_F1
	dd VK_NUMPAD8
	dd VK_NUMPAD2
	dd '0'
	dd '1'
	dd '2'
	dd '3'
	dd '4'
	dd '5'
	dd '6'
	dd '7'
	dd '8'
	dd '9'
	dd 0
	
Sys_LibKernel32 db "kernel32.dll",0
	db "CloseHandle",0
CloseHandle dd 0
	db "CreateFileA",0
CreateFileA dd 0
	db "ExitProcess",0
ExitProcess dd 0
	db "FindClose",0
FindClose dd 0
	db "FindFirstFileA",0
FindFirstFileA dd 0
	db "FindNextFileA",0
FindNextFileA dd 0
	db "GetFileSize",0
GetFileSize dd 0
	db "GetModuleHandleA",0
GetModuleHandleA dd 0
	db "GetTickCount",0
GetTickCount dd 0
	db "ReadFile",0
ReadFile dd 0
	db "SetFilePointer",0
SetFilePointer dd 0
	db "VirtualAlloc",0
VirtualAlloc dd 0
	db "VirtualFree",0
VirtualFree dd 0
	db "WriteFile",0
WriteFile dd 0
	db 0
		
Sys_LibUser32 db "user32.dll",0
	db "CreateWindowExA",0
CreateWindowExA dd 0
	db "DestroyWindow",0
DestroyWindow dd 0
	db "DispatchMessageA",0
DispatchMessageA dd 0
	db "GetAsyncKeyState",0
GetAsyncKeyState dd 0
	db "MessageBoxA",0
MessageBoxA dd 0
	db "PeekMessageA",0
PeekMessageA dd 0
	db "TranslateMessage",0
TranslateMessage dd 0
	db "wvsprintfA",0
wvsprintfA dd 0
	db 0
	
.code
Sys_GetTickCount proc
call	[GetTickCount]
ret
Sys_GetTickCount endp

Sys_MemClear proc Dest,
		  Count
mpush	eax, ecx, edi
mov	edi, [Dest]
mov	ecx, [Count]
xor	eax, eax
cld
rep	stosb
mpop	edi, ecx, eax
ret
Sys_MemClear endp

Sys_MemCopy proc Dest,
		 Src,
		 Count
mpush	ecx, esi, edi
mov	esi, [Src]
mov	edi, [Dest]
mov	ecx, [Count]
cld
rep	movsb
mpop	edi, esi, ecx
ret
Sys_MemCopy endp

Sys_StrLen proc String
mpush	ecx, esi
mov	esi, [String]
xor	eax, eax
@@1000:
mov	cl, [esi]
inc	eax
inc	esi
cmp	cl, 0
jne	@@1000
dec	eax
mpop	esi, ecx
ret
Sys_StrLen endp

Sys_StrCpy proc Dest,
		Src
mpush	eax, esi, edi
mov	esi, [Src]
mov	edi, [Dest]
@@1000:
mov	al, [esi]
inc	esi
mov	[edi], al
inc	edi
cmp	al, 0
jne	@@1000
mpop	edi, esi, eax
ret
Sys_StrCpy endp

Sys_StrCat proc Dest,
		Src
push	eax
mcall	Sys_StrLen, [Dest]
add	eax, [Dest]
mcall	Sys_StrCpy, eax, [Src]
pop	eax
ret
Sys_StrCat endp

Sys_StrCmp proc String1,
		String2
mpush	ebx, esi, edi
mov	esi, [String1]
mov	edi, [String2]
@@1000:
mov	al, [esi]
inc	esi
mov	bl, [edi]
inc	edi
cmp	al, 0
je	@@2000
cmp	bl, 0
je	@@2000
cmp	al, bl
je	@@1000
@@2000:
cmp	al, bl
je	@@3000
xor	eax, eax
jmp	@@4000
@@3000:
or	eax, 1
@@4000:
mpop	edi, esi, ebx
ret
Sys_StrCmp endp

Sys_StrnCmp proc String1,
		 String2,
		 Count
mpush	ebx, ecx, esi, edi
mov	esi, [String1]
mov	edi, [String2]
mov	ecx, [Count]
@@1000:
mov	al, [esi]
inc	esi
mov	bl, [edi]
inc	edi
cmp	al, bl
jne	@@2000
dec	ecx
jnz	@@1000
@@2000:
cmp	ecx, 0
je	@@3000
xor	eax, eax
jmp	@@4000
@@3000:
or	eax, 1
@@4000:
mpop	edi, esi, ecx, ebx
ret
Sys_StrnCmp endp

Sys_StrChr proc String,
		Chr
mpush	ecx, esi
mov	esi, [String]
mov	ecx, [Chr]
@@1000:
mov	al, [esi]
cmp	al, cl
je	@@2000
inc	esi
cmp	al, 0
jne	@@1000
xor	esi, esi
@@2000:
mov	eax, esi
mpop	esi, ecx
ret
Sys_StrChr endp

Sys_StrToUpper proc String
pushad
mov	esi, [String]
@@1000:
mov	al, [esi]
cmp	al, 'a'
jb	@@2000
cmp	al, 'z'
ja	@@2000
add	al, ('A' - 'a')
mov	[esi], al
@@2000:
inc	esi
cmp	al, 0
jne	@@1000
popad
ret
Sys_StrToUpper endp

Sys_atoi proc String
mpush	edx, esi
mov	esi, [String]
xor	eax, eax
xor	edx, edx
@@100:
lodsb
cmp	al, 0
je	@@900
imul	edx, 10
sub	al, '0'
add	edx, eax
jmp	@@100
@@900:
xchg	eax, edx
mpop	esi, edx
ret
Sys_atoi endp

;OUT:EAX=float
Sys_atof proc String
local ReturnValue,
      Sign,
      Comma,
      DecimalPart,
      Divisor
pushad
and	[Sign], 0
mov	esi, [String]
cmp	byte ptr [esi], '-'
jne	@@1000
inc	esi
or	[Sign], 080000000h
@@1000:
mov	ebx, esi
@@1100:
lodsb
cmp	al, '0'
jb	@@1900
cmp	al, '9'
ja	@@1900
jmp	@@1100
@@1900:
mov	byte ptr [esi - 1], 0
mov	[Comma], eax
mcall	Sys_atoi, ebx
mov	[ReturnValue], eax
fild	[ReturnValue]
fstp	[ReturnValue]
mov	eax, [Comma]
mov	[esi - 1], al
cmp	al, ','
jne	@@3000
mov	ebx, esi
xor	ecx, ecx
@@2000:
lodsb
cmp	al, '0'
jb	@@2900
cmp	al, '9'
ja	@@2900
inc	ecx
jmp	@@2000
@@2900:
mov	byte ptr [esi - 1], 0
push	eax
mcall	Sys_atoi, ebx
mov	[DecimalPart], eax
pop	eax
mov	[esi - 1], al
mov	edx, 1
@@2950:
imul	edx, 10
dec	ecx
jnz	@@2950
mov	[Divisor], edx
fild	[DecimalPart]
fidiv	[Divisor]
fadd	[ReturnValue]
fstp	[ReturnValue]
mov	eax, [Sign]
or	[ReturnValue], eax
@@3000:
popad
mov	eax, [ReturnValue]
ret
Sys_atof endp

Sys_itoa proc Dest, Src
pushad
mov	edi, [Dest]
mov	eax, [Src]
test	eax, 080000000h
jz	@@1000
and	eax, 07fffffffh
mov	byte ptr [edi], '-'
inc	edi
@@1000:
push	0
mov	ecx, 10
@@2000:
xor	edx, edx
idiv	ecx
add	edx, '0'
push	edx
test	eax, eax
jnz	@@2000
@@3000:
pop	eax
stosb
test	eax, eax
jnz	@@3000
popad
ret
Sys_itoa endp

var f_10,10.0
var f_0_5,0.499999
Sys_ftoa proc Dest, Src
local	Buffer[64]:byte,
	Integer
pushad
mov	edi, [Dest]
test	[Src], 080000000h
jz	@@1000
mov	al, '-'
stosb
@@1000:
fld	[Src]
fabs
fsub	[f_0_5]
fistp	[Integer]
mcall	Sys_itoa, edi, [Integer]
mcall	Sys_StrLen, edi
add	edi, eax
mov	al, '.'
stosb
fld	[Src]
fabs
mov	ecx, 4
@@2000:
fisub	[Integer]
fmul	[f_10]
fld	st(0)
fsub	[f_0_5]
fistp	[Integer]
mov	eax, [Integer]
add	eax, '0'
stosb
dec	ecx
jnz	@@2000
fcomp
mov	byte ptr [edi], 0
popad
ret
Sys_ftoa endp

Sys_vsprintf proc Dest,
		  FormatString,
		  pArgumentsList
mpush	ecx, edx
mcall	[wvsprintfA], [Dest], [FormatString], [pArgumentsList]
mpop	edx, ecx
ret
Sys_vsprintf endp

Sys_sprintf proc Dest,
		 FormatString
push	eax
lea	eax, [FormatString + 4]
mcall	Sys_vsprintf, [Dest], [FormatString], eax
pop	eax
ret
Sys_sprintf endp

Sys_LoadLibrary proc Library
pushad
mov	esi, [Library]
mcall	LoadLibraryA, esi
test	eax, eax
jz	@@fail
xchg	eax, ebx
mcall	Sys_StrLen, esi
lea	esi, [esi+eax+1]
@@1000:
mcall	Sys_StrLen, esi
test	eax, eax
jz	@@9000
lea	edi, [esi+eax+1]
mcall	GetProcAddress, ebx, esi
test	eax, eax
jz	@@fail
stosd
mov	esi, edi
jmp	@@1000
@@9000:
popad
ret
@@fail:
push	[Library]
pushstr "Sys_LoadLibrary(%s)"
call	Error
Sys_LoadLibrary endp

Error proc ErrorString 
local Buffer[256]:byte
call	Sys_WindowRelease
lea	eax, [ErrorString+4]
push	eax
push	[ErrorString]
lea	eax, [Buffer]
push	eax
call	Sys_vsprintf
push	MB_ICONERROR
pushstr "y'a 1 erreur"
lea	eax, [Buffer]
push	eax
push	0
call	[MessageBoxA]
call	Sys_Release
Error endp

Sys_MemAlloc proc Count
mpush	ecx, edx
add	[Count], 4
mcall	[VirtualAlloc], 0, [Count], \
		(MEM_COMMIT+MEM_RESERVE), PAGE_READWRITE
mcall	Sys_MemClear, eax, [Count]
mov	ecx, [Count]
add	ecx, 4095
and	ecx, (not 4095)
mov	[eax], ecx
add	eax, 4
add	ecx, [Malloc_CurrentAllocatedMemory]
mov	[Malloc_CurrentAllocatedMemory], ecx
cmp	ecx, [Malloc_MaxAllocatedMemory]
jna	@@1000
mov	[Malloc_MaxAllocatedMemory], ecx
@@1000:
mpop	edx, ecx
ret
Sys_MemAlloc endp

Sys_MemFree proc Data
pushad
mov	eax, [Data]
test	eax, eax
jz	@@1000
sub	eax, 4
mov	ecx, [eax]
sub	[Malloc_CurrentAllocatedMemory], ecx
mcall	[VirtualFree], eax, 0, MEM_RELEASE
@@1000:
popad
ret
Sys_MemFree endp

Sys_HeapCreate proc 
mcall	Sys_MemAlloc, HEAP_SIZE
mov	[Heap_Bottom], eax
add	eax, HEAP_SIZE
mov	[Heap_Top], eax
ret
Sys_HeapCreate endp

Sys_HeapAlloc proc Count 
push	ebx
mov	ebx, [Count]
add	ebx, 3
and	ebx, (not 3)
mov	eax, [Heap_Bottom]
add	ebx, eax
cmp	ebx, [Heap_Top]
jna	@@1000
pushstr "Heap_Alloc()"
call	Error
@@1000:
mov	[Heap_Bottom], ebx
pop	ebx
ret
Sys_HeapAlloc endp

;OUT:EAX=TempString
Sys_GetTempString proc
push	edx
mov	eax, [TempStringIndex]
inc	eax
and	eax, (16-1)
mov	[TempStringIndex], eax
imul	eax, 256
mov	edx, [TempStringData]
cmp	edx, 0
jne	@@1000
mcall	Sys_HeapAlloc, (16 * 256)
mov	[TempStringData], eax
xchg	eax, edx
@@1000:
add	eax, edx
pop	edx
ret
Sys_GetTempString endp

;OUT:EAX=String
Sys_FloatToString proc Number
call	Sys_GetTempString
mcall	Sys_ftoa, eax, [Number]
ret
Sys_FloatToString endp

Sys_WindowCreate proc 
push	0
mcall	[GetModuleHandleA], 0
push	eax
xor	eax, eax
push	eax
push	eax
push	eax
push	eax
push	eax
push	eax
push	eax
pushstr "areuh"
pushstr "static"
push	eax
call	[CreateWindowExA]
mov	[hMainWindow], eax
ret
Sys_WindowCreate endp

Sys_WindowRelease proc
mov	ecx, [hMainWindow]
jecxz	@@1000
mcall	[DestroyWindow], ecx
@@1000:
and	[hMainWindow], 0
ret
Sys_WindowRelease endp

Sys_FileOpen proc FileName 
mpush 	ecx, edx
mcall 	[CreateFileA], [FileName],(GENERIC_READ+GENERIC_WRITE),\
	(FILE_SHARE_READ+FILE_SHARE_WRITE),\
	0,OPEN_EXISTING,\
	FILE_FLAG_RANDOM_ACCESS,0
cmp	eax, -1
jne	@@1000		
push	[FileName]	
pushstr "Sys_FileOpen(%s)"
call	Error
@@1000:	
mpop 	edx, ecx
ret
Sys_FileOpen endp

Sys_FileCreate proc FileName
mpush 	ecx, edx
mcall 	[CreateFileA], [FileName],(GENERIC_READ+GENERIC_WRITE),\
	(FILE_SHARE_READ+FILE_SHARE_WRITE),\
	0,CREATE_ALWAYS,\
	FILE_FLAG_RANDOM_ACCESS,0
cmp	eax, -1
jne	@@1000		
push	[FileName]	
pushstr "Sys_FileCreate(%s)"
call	Error
@@1000:	
mpop 	edx, ecx
ret
Sys_FileCreate endp
	
Sys_FileClose proc FileHandle
pushad
mcall	[CloseHandle], [FileHandle]
popad
ret
Sys_FileClose endp
	
Sys_FileRead proc FileHandle,
		  Dest,
		  Count
local tmp
pushad
lea	eax, [tmp]
mcall	[ReadFile], [FileHandle], [Dest], [Count], eax, 0
test	eax, eax
jnz	@@1000
pushstr "Sys_FileRead()"
call	Error
@@1000:
popad		
ret
Sys_FileRead endp

Sys_FileWrite proc FileHandle,
		   Src,
		   Count
local tmp
pushad
lea	eax, [tmp]
mcall	[WriteFile], [FileHandle], [Src], [Count], eax, 0
test	eax, eax
jnz	@@1000
pushstr "Sys_FileWrite()"
call	Error
@@1000:
popad		
ret
Sys_FileWrite endp

Sys_FileGetSize proc FileHandle
mpush	ecx, edx
mcall	[GetFileSize], [FileHandle], 0
mpop	edx, ecx
ret
Sys_FileGetSize endp

Sys_FileSeekBegin proc FileHandle,
		       Distance
pushad
mcall 	[SetFilePointer], [FileHandle], [Distance], 0, FILE_BEGIN
popad
ret
Sys_FileSeekBegin endp

Sys_FileExists proc FileName
mpush	ecx, edx
mcall	[CreateFileA], [FileName],0,0,0,\
		OPEN_EXISTING,FILE_FLAG_RANDOM_ACCESS,0
cmp	eax, -1
je	@@1000
mcall	Sys_FileClose, eax
xor	eax, eax
@@1000:
inc	eax
mpop	edx, ecx	
ret
Sys_FileExists endp

;OUT:EAX=Data
Sys_FileLoad proc FileName,
		  pFileSize
mpush	ecx, edx
mcall	Sys_FileOpen, [FileName]
xchg	eax, ecx
mcall	Sys_FileGetSize, ecx
mov	edx, [pFileSize]
mov	[edx], eax
xchg	eax, edx
mcall	Sys_MemAlloc, edx
mcall	Sys_FileRead, ecx, eax, edx
mcall	Sys_FileClose, ecx
mpop	edx, ecx
ret
Sys_FileLoad endp

Sys_FileSave proc FileName,
		  Data,
		  Count
pushad		  
mcall	Sys_FileCreate, [FileName]
xchg	eax, edx
mcall	Sys_FileWrite, edx, [Data], [Count]
mcall	Sys_FileClose, edx
popad
ret
Sys_FileSave endp

Sys_LogCreate proc 
pushstr "log.txt"
call	Sys_FileCreate
mov	[Log_FileHandle], eax
ret
Sys_LogCreate endp

Sys_LogPrintf proc LogString
local Buffer[256]:byte
mpush	eax, esi
lea	esi, [Buffer]
lea	eax, [LogString+4]
mcall	Sys_vsprintf, esi, [LogString], eax
mcall	Sys_StrLen, esi
mov	@[esi + eax], ((13 shl 0)+(10 shl 8))
add	eax, 2
mcall	Sys_FileWrite, [Log_FileHandle], esi, eax
mpop	esi, eax
ret
Sys_LogPrintf endp

Sys_LogRelease proc 
mcall	Sys_FileClose, [Log_FileHandle]
and	[Log_FileHandle], 0
ret
Sys_LogRelease endp

Sys_Create proc Flags
mcall	Sys_LoadLibrary, offset Sys_LibKernel32
mcall	Sys_LoadLibrary, offset Sys_LibUser32
call	Sys_WindowCreate
call	Sys_HeapCreate
call	Sys_LogCreate
test	[Flags], SYSF_PAK
jz	@@1000
call	Pak
@@1000:
mov	eax, [Flags]
and	eax, SYSF_Z3D
mcall	Z3D_Create, [hMainWindow], eax
call	Unpak
ret
Sys_Create endp

Sys_InputUpdate proc
mov	esi, offset Sys_RequiredKeyCodes
@@1000:
mov	ebx, [esi]
add	esi, 4
cmp	ebx, 0
je	@@9000
mcall	[GetAsyncKeyState], ebx
mov	[Keyboard+ebx], ah
jmp	@@1000
@@9000:
ret
Sys_InputUpdate endp

;OUT:EAX=Continue
Sys_Update proc 
local msg[tWINMSG]
mpush	ebx, ecx, edx, esi, edi
call	Sys_InputUpdate
lea	edi, [msg]
mcall	[PeekMessageA], edi, 0, 0, 0, PM_REMOVE
test	eax, eax
jz	@@8000
mcall	[TranslateMessage], edi
mcall	[DispatchMessageA], edi
mov	eax, 1
cmp	@[edi+WINMSG_message], WM_QUIT
je	@@9000
@@8000:
xor	eax, eax
@@9000:	
mpop	edi, esi, edx, ecx, ebx
ret
Sys_Update endp

Sys_Release proc 
push	[Malloc_MaxAllocatedMemory]
pushstr "MaxAllocatedMemory=%i"
call	Sys_LogPrintf
add	esp, 4
call	Z3D_Release
call	Sys_WindowRelease
call	Sys_LogRelease
call	[ExitProcess]
Sys_Release endp

end

