;//////////////////////////////////////////////////////////////
;//  write your comments to : loadall@hotmail.com
;//  have a look at my homepage : www.multimania.com/loadall
;//  chat with the author (loadall) on IRCNet, channel #coders
;//////////////////////////////////////////////////////////////
include Main.inc
.data
TerrainWidth	dd 2000.0
ooTerrainSize	dd 0
.code
var	f_2,2.0
Terrain_Create proc
local	i,
	j,
	TerrainSize
mov	edi, [g]
add	edi, G_Terrain
mov	eax, [TerrainWidth]
mov	[edi+TERR_Width], eax
mov	[TerrainSize], (TERRAIN_SIZE-1) 
;/////////////////
fld	@[edi+TERR_Width]
fidiv	[TerrainSize]
fst	@[edi+TERR_CellWidth]
fld1
fdivrp	st(1), st(0)
fstp	@[edi+TERR_ooCellWidth]
;/////////////////
fld	@[edi+TERR_Width]
fdiv	[f_2]
fst	@[edi+TERR_HalfWidth]
mov	eax, [g]
fst	@[eax+G_Player+PLYR_Matrix+M_30]
fstp	@[eax+G_Player+PLYR_Matrix+M_32]
fld	@[edi+TERR_CellWidth]
fdiv	[f_2]
fstp	@[edi+TERR_HalfCellWidth]
;/////////////////
mov	edi, [g]
add	edi, G_Terrain+TERR_Indices
mov	esi, (TERRAIN_SIZE-1)
xor	eax, eax
@@1000:
push	esi
mov	esi, (TERRAIN_SIZE-1)
@@2000:
lea	ebx, [eax+1]
lea	ecx, [eax+TERRAIN_SIZE]
lea	edx, [eax+TERRAIN_SIZE+1]
mov	[edi], dx
mov	[edi+2], bx
mov	[edi+4], ax
mov	[edi+6], cx
mov	[edi+8], dx
mov	[edi+10], ax
inc	eax
add	edi, 12
dec	esi
jnz	@@2000
pop	esi
inc	eax
dec	esi
jnz	@@1000
;/////////////////
mov	ebx, [g]
add	ebx, G_Terrain
lea	edi, [ebx+TERR_Vertices]
mov	[TerrainSize], TERRAIN_SIZE
fld1
fidiv	[TerrainSize]
fstp	[ooTerrainSize]
and	[i], 0
@@3000:
and	[j], 0
@@4000:
fild	[j]
fmul	@[ebx+TERR_CellWidth]
fstp	@[edi+LVTX_x]
fild	[i]
fmul	@[ebx+TERR_CellWidth]
fstp	@[edi+LVTX_z]
fild	[i]
fmul	[ooTerrainSize]
fstp	@[edi+LVTX_tu]
mov	@[edi+LVTX_color], 0ffffffffh
add	edi, sLVTX
inc	[j]
cmp	[j], TERRAIN_SIZE
jb	@@4000
inc	[i]
cmp	[i], TERRAIN_SIZE
jb	@@3000
ret
Terrain_Create endp
Terrain_Update proc
pushad
mov	esi, [g]
lea	edi, [esi+G_Player]
add	esi, G_Terrain
VectorClear esi+TERR_GlobalMove
@@1000:
fld	@[edi+PLYR_Matrix+M_32]
fsub	@[esi+TERR_HalfWidth]
fcomp	@[esi+TERR_HalfCellWidth]
fnstsw	ax
sahf
jb	@@2000
fld	@[edi+PLYR_Matrix+M_32]
mov	eax, [esi+TERR_CellWidth]
fsub	@[esi+TERR_CellWidth]
xor	eax, 080000000h
fstp	@[edi+PLYR_Matrix+M_32]
mov	[esi+TERR_GlobalMove+8], eax
lea	edx, [esi+TERR_Vertices]
mov	ecx, (TERRAIN_NUM_VERTICES-TERRAIN_SIZE)
@@1100:
mov	eax, [edx+(TERRAIN_SIZE*sLVTX)+LVTX_y]
mov	ebx, [edx+(TERRAIN_SIZE*sLVTX)+LVTX_tv]
mov	[edx+LVTX_y], eax
mov	[edx+LVTX_tv], ebx
add	edx, sLVTX
dec	ecx
jnz	@@1100
xor	ecx, ecx
@@1200:
mcall	Terrain_SetNewVertex, edx, (TERRAIN_SIZE-1), ecx
inc	ecx
add	edx, sLVTX
cmp	ecx, TERRAIN_SIZE
jb	@@1200
jmp	@@1000
@@2000:
fld	@[esi+TERR_HalfWidth]
fsub	@[edi+PLYR_Matrix+M_32]
fcomp	@[esi+TERR_HalfCellWidth]
fnstsw	ax
sahf
jb	@@3000
fld	@[edi+PLYR_Matrix+M_32]
mov	eax, [esi+TERR_CellWidth]
fadd	@[esi+TERR_CellWidth]
mov	[esi+TERR_GlobalMove+8], eax
fstp	@[edi+PLYR_Matrix+M_32]
lea	edx, [esi+TERR_Vertices+((TERRAIN_NUM_VERTICES-1)*sLVTX)]
mov	ecx, (TERRAIN_NUM_VERTICES-TERRAIN_SIZE)
@@2100:
mov	eax, [edx-(TERRAIN_SIZE*sLVTX)+LVTX_y]
mov	ebx, [edx-(TERRAIN_SIZE*sLVTX)+LVTX_tv]
mov	[edx+LVTX_y], eax
mov	[edx+LVTX_tv], ebx
sub	edx, sLVTX
dec	ecx
jnz	@@2100
mov	ecx, (TERRAIN_SIZE-1)
@@2200:
mcall	Terrain_SetNewVertex, edx, (TERRAIN_SIZE-1), ecx
sub	edx, sLVTX
dec	ecx
jns	@@2200
jmp	@@2000
@@3000:
fld	@[edi+PLYR_Matrix+M_30]
fsub	@[esi+TERR_HalfWidth]
fcomp	@[esi+TERR_HalfCellWidth]
fnstsw	ax
sahf
jb	@@4000
fld	@[edi+PLYR_Matrix+M_30]
mov	eax, [esi+TERR_CellWidth]
fsub	@[esi+TERR_CellWidth]
xor	eax, 080000000h
fstp	@[edi+PLYR_Matrix+M_30]
mov	[esi+TERR_GlobalMove+0], eax
lea	edx, [esi+TERR_Vertices]
mov	ecx, (TERRAIN_NUM_VERTICES-1)
@@3100:
mov	eax, [edx+sLVTX+LVTX_y]
mov	ebx, [edx+sLVTX+LVTX_tv]
mov	[edx+LVTX_y], eax
mov	[edx+LVTX_tv], ebx
add	edx, sLVTX
dec	ecx
jnz	@@3100
lea	edx, [esi+TERR_Vertices+((TERRAIN_SIZE-1)*sLVTX)]
xor	ecx, ecx
@@3200:
mcall	Terrain_SetNewVertex, edx, ecx, (TERRAIN_SIZE-1)
inc	ecx
add	edx, (TERRAIN_SIZE*sLVTX)
cmp	ecx, TERRAIN_SIZE
jb	@@3200
jmp	@@3000
@@4000:
fld	@[esi+TERR_HalfWidth]
fsub	@[edi+PLYR_Matrix+M_30]
fcomp	@[esi+TERR_HalfCellWidth]
fnstsw	ax
sahf
jb	@@5000
fld	@[edi+PLYR_Matrix+M_30]
mov	eax, [esi+TERR_CellWidth]
fadd	@[esi+TERR_CellWidth]
mov	[esi+TERR_GlobalMove+0], eax
fstp	@[edi+PLYR_Matrix+M_30]
lea	edx, [esi+TERR_Vertices+((TERRAIN_NUM_VERTICES-1)*sLVTX)]
mov	ecx, (TERRAIN_NUM_VERTICES-1)
@@4100:
mov	eax, [edx-sLVTX+LVTX_y]
mov	ebx, [edx-sLVTX+LVTX_tv]
mov	[edx+LVTX_y], eax
mov	[edx+LVTX_tv], ebx
sub	edx, sLVTX
dec	ecx
jnz	@@4100
lea	edx, [esi+TERR_Vertices]
xor	ecx, ecx
@@4200:
mcall	Terrain_SetNewVertex, edx, ecx, (TERRAIN_SIZE-1)
inc	ecx
add	edx, (TERRAIN_SIZE*sLVTX)
cmp	ecx, TERRAIN_SIZE
jb	@@4200
jmp	@@4000
@@5000:
popad
ret
Terrain_Update endp
Terrain_Draw proc
mov	ebx, [g]
add	ebx, G_Terrain
pushstr	"terrain.gif"
call	Z3D_TextureGet
mcall	Z3D_TextureSet, eax
mcall	Z3D_MatrixSetWorld, offset MatrixIdentity
mcall	Z3D_SetTextureStageState, D3DTSS_ADDRESS, D3DTADDRESS_CLAMP
lea	ecx, [ebx+TERR_Indices]
lea	eax, [ebx+TERR_Vertices]
mcall	Z3D_DrawIndexedTriangles, eax, TERRAIN_NUM_VERTICES, ecx, (TERRAIN_NUM_QUADS*6)
mcall	Z3D_SetTextureStageState, D3DTSS_ADDRESS, D3DTADDRESS_WRAP
ret
Terrain_Draw endp
var	Amplitude,200.0
var	f_4,4.0
Terrain_SetNewVertex proc NewVertex,
			  i,
			  j
local	Point[tVEC3]
mpush	eax, ebx
lea	ebx, [Point]

fild	[i]
fmul	[ooTerrainSize]
fstp	@[ebx+0]
mov	eax, [g]
mov	eax, [eax+G_Fps+FPS_GameTime]
mov	[ebx+4], eax
fild	[j]
fmul	[ooTerrainSize]
fstp	@[ebx+8]
var	PointAmplitude,1.570796
;var	PointAmplitude,1.0471975512
mcall	VectorScale, ebx, ebx, [PointAmplitude]
mcall	M_Noise1d, ebx, 6
;push	eax
;fst	@[esp]
;call	Sys_FloatToString
;mcall	Sys_LogPrintf, eax
mov	ebx, [NewVertex]
var	AltitudeOffset,1.2
var	AltitudeScale,0.4
fadd	[AltitudeOffset]
fmul	[AltitudeScale]
ftst
fnstsw	ax
sahf
jnb	@@1000
fsub	st(0), st(0)
@@1000:
fld	st(0)
fmulp	st(1), st(0)
fst	@[ebx+LVTX_tv]
;mcall	Sys_FloatToString, @[ebx+LVTX_tv]
;mcall	Sys_LogPrintf, eax
fmul	[Amplitude]
fstp	@[ebx+LVTX_y]
mpop	ebx, eax
ret
Terrain_SetNewVertex endp
var	f_0_49,0.499999
;OUT:ST(0)=Height(x,z)
Terrain_GetHeight proc x,
		       z
local RelativeX,
      RelativeZ,
      y0,
      y1,
      y2
pushad      
mov	ebx, [g]
add	ebx, G_Terrain
fld	[x]
fmul	@[ebx+TERR_ooCellWidth]
fld	st(0)
fsub	[f_0_49]
fistp	[RelativeX]
mov	eax, [RelativeX]
fisub	[RelativeX]
fstp	[RelativeX]
cmp	eax, (TERRAIN_SIZE-1)
jnb	@@9999
fld	[z]
fmul	@[ebx+TERR_ooCellWidth]
fld	st(0)
fsub	[f_0_49]
fistp	[RelativeZ]
mov	edx, [RelativeZ]
fisub	[RelativeZ]
fstp	[RelativeZ]
cmp	edx, (TERRAIN_SIZE-1)
jnb	@@9999
shl	edx, TERRAIN_SIZE_LOG2
add	eax, edx
lea	eax, [eax*2 + eax]
lea	esi, [ebx + eax*8 +TERR_Vertices]
;/////////////////
mov	eax, [esi+LVTX_y]
mov	edx, [esi+((TERRAIN_SIZE+1)*sLVTX)+LVTX_y]
mov	[y0], eax
mov	[y2], edx
fld	[RelativeX]
fcomp	[RelativeZ]
fnstsw	ax
sahf
ja	@@1000
mov	eax, [esi+(TERRAIN_SIZE*sLVTX)+LVTX_y]
jmp	@@2000
@@1000:
mov	eax, [RelativeX]
mov	edx, [RelativeZ]
mov	[RelativeZ], eax
mov	[RelativeX], edx
mov	eax, [esi+sLVTX+LVTX_y]
@@2000:
mov	[y1], eax
fld	[y2]
fsub	[y1]
fmul	[RelativeX]
fld	[y1]
fsub	[y0]
fmul	[RelativeZ]
faddp	st(1), st(0)
fadd	[y0]
popad
ret
@@9999:
mcall	Sys_FloatToString, [z]
push	eax
mcall	Sys_FloatToString, [x]
push	eax
pushstr "Terrain_GetHeight(%s %s)"
call	Error
Terrain_GetHeight endp
;OUT:eax=bounds
Terrain_CheckBounds proc Position
mpush	ebx, esi, edi
mov	esi, [g]
mov	ebx, [Position]
xor	edi, edi
add	esi, G_Terrain
fld	@[ebx+0]
ftst
fnstsw	ax
sahf
jnb	@@1000
or	edi, TERRAIN_BOUNDS_OFF_XMIN
@@1000:
fcomp	@[esi+TERR_Width]
fnstsw	ax
sahf
jb	@@2000
or	edi, TERRAIN_BOUNDS_OFF_XMAX
@@2000:
fld	@[ebx+8]
ftst
fnstsw	ax
sahf
jnb	@@3000
or	edi, TERRAIN_BOUNDS_OFF_ZMIN
@@3000:
fcomp	@[esi+TERR_Width]
fnstsw	ax
sahf
jb	@@4000
or	edi, TERRAIN_BOUNDS_OFF_ZMAX
@@4000:
xchg	eax, edi
mpop	edi, esi, ebx
ret
Terrain_CheckBounds endp
end
