;//////////////////////////////////////////////////////////////
;//  write your comments to : loadall@hotmail.com
;//  have a look at my homepage : www.multimania.com/loadall
;//  chat with the author (loadall) on IRCNet, channel #coders
;//////////////////////////////////////////////////////////////
include System.inc
.data
VectorNull	dd 0, 0, 0
.code
;OUT:st(0)=a^b
M_iPow proc a, b
fld1
cmp	[b], 0
je	@@2000
@@1000:
fmul	[a]
dec	[b]
jnz	@@1000
@@2000:
ret
M_iPow endp
VectorToString proc Vector
local	Buffer[3*16]:byte
mpush	ecx, edx
mov	edx, [Vector]
lea	eax, [Buffer]
mov	ecx, 3
@@2000:
mcall	Sys_ftoa, eax, @[edx+(ecx*4)-4]
push	eax
add	eax, 16
dec	ecx
jnz	@@2000
pushstr "[%s %s %s]"
call	Sys_GetTempString
push	eax
call	Sys_sprintf
add	esp, 12
mpop	edx, ecx
ret
VectorToString endp
M_BBoxAddPoint proc BBox,
		    Point,
		    IsNotFirstTime
pushad		    
mov	esi, [Point]
mov	edi, [BBox]
cmp	[IsNotFirstTime], 0
je	@@9900
mov	ecx, 3
@@1000:
fld	@[esi]
fcomp	@[edi]
fnstsw  ax
sahf
ja	@@1100
mov	eax, [esi]
mov	[edi], eax
@@1100:
add	esi, 4
add	edi, 4
dec	ecx
jnz	@@1000
mov	esi, [Point]
mov	ecx, 3
@@2000:
fld	@[esi]
fcomp	@[edi]
fnstsw  ax
sahf
jb	@@2100
mov	eax, [esi]
mov	[edi], eax
@@2100:
add	esi, 4
add	edi, 4
dec	ecx
jnz	@@2000
@@9000:
popad
ret
@@9900:
VectorCopy edi, esi, eax, edx
VectorCopy edi+sVEC3, esi, eax, edx
jmp	@@9000
M_BBoxAddPoint endp
var	PiFold2,6.28318530718
;OUT:st(0)=anglemod(angle)
M_AngleMod proc Angle
push	eax
fld	[Angle]
@@1000:
ftst
fnstsw	ax
sahf
jnb	@@2000
fadd	[PiFold2]
jmp	@@1000
@@2000:
fcom	[PiFold2]
fnstsw	ax
sahf
jb	@@3000
fsub	[PiFold2]
jmp	@@2000
@@3000:
pop	eax
ret
M_AngleMod endp
VectorAngleMod proc v
push	eax
mov	eax, [v]
mcall	M_AngleMod, @[eax+0]
fstp	@[eax+0]
mcall	M_AngleMod, @[eax+4]
fstp	@[eax+4]
mcall	M_AngleMod, @[eax+8]
fstp	@[eax+8]
pop	eax
ret
VectorAngleMod endp
;OUT:st(0)=DotProduct
DotProduct proc a,
		b
mpush	eax, ebx
mov	eax, [a]
mov	ebx, [b]
fld	@[eax+0]
fmul	@[ebx+0]
fld	@[eax+4]
fmul	@[ebx+4]
fld	@[eax+8]
fmul	@[ebx+8]
fxch	st(2)
faddp	st(1), st(0)
faddp	st(1), st(0)
mpop	ebx, eax
ret
DotProduct endp
CrossProduct proc Dest,
		  SrcA,
		  SrcB
mpush	eax, ebx, edi
mov	eax, [SrcA]
mov	ebx, [SrcB]
mov	edi, [Dest]
fld	@[eax+4]
fmul	@[ebx+8]
fld	@[eax+8]
fmul	@[ebx+4]
fsubrp	st(1), st(0)
fstp	@[edi+0]
fld	@[eax+8]
fmul	@[ebx+0]
fld	@[eax+0]
fmul	@[ebx+8]
fsubrp	st(1), st(0)
fstp	@[edi+4]
fld	@[eax+0]
fmul	@[ebx+4]
fld	@[eax+4]
fmul	@[ebx+0]
fsubrp	st(1), st(0)
fstp	@[edi+8]
mpop	edi, eax, ebx		  
ret
CrossProduct endp		  
VectorNegate proc Dest, Src
mpush	eax, edx, esi, edi
mov	esi, [Src]
mov	edi, [Dest]
mov	eax, [esi+0]
mov	edx, [esi+4]
xor	eax, 080000000h
xor	edx, 080000000h
mov	[edi+0], eax
mov	eax, [esi+8]
mov	[edi+4], edx
xor	eax, 080000000h
mov	[edi+8], eax
mpop	edi, esi, edx, eax
ret
VectorNegate endp
VectorAdd proc d, a, b
mpush	eax, ebx, edi
mov	eax, [a]
mov	ebx, [b]
mov	edi, [d]
fld	@[eax+0]
fadd	@[ebx+0]
fld	@[eax+4]
fadd	@[ebx+4]
fld	@[eax+8]
fadd	@[ebx+8]
fxch	st(2)
fstp	@[edi+0]
fstp	@[edi+4]
fstp	@[edi+8]
mpop	edi, ebx, eax
ret
VectorAdd endp
VectorSub proc d, a, b
mpush	eax, ebx, edi
mov	eax, [a]
mov	ebx, [b]
mov	edi, [d]
fld	@[eax+0]
fsub	@[ebx+0]
fld	@[eax+4]
fsub	@[ebx+4]
fld	@[eax+8]
fsub	@[ebx+8]
fxch	st(2)
fstp	@[edi+0]
fstp	@[edi+4]
fstp	@[edi+8]
mpop	edi, ebx, eax
ret
VectorSub endp
VectorScale proc d, s, Factor
mpush	esi, edi
mov	esi, [s]
mov	edi, [d]
fld	@[esi+0]
fmul	[Factor]	
fld	@[esi+4]
fmul	[Factor]
fld	@[esi+8]
fmul	[Factor]
fxch	st(2)
fstp	@[edi+0]
fstp	@[edi+4]
fstp	@[edi+8]
mpop	edi, esi
ret
VectorScale endp
VectorNormalize proc Dest,
		     Src
mpush	esi, edi
mov	esi, [Src]
mov	edi, [Dest]
fld	@[esi+0]
fmul	@[esi+0]
fld	@[esi+4]
fmul	@[esi+4]
fld	@[esi+8]
fmul	@[esi+8]
fxch	st(2)
faddp	st(1), st(0)
faddp	st(1), st(0)
fsqrt
ftst
fnstsw	ax
sahf
jz	@@9000
fld1
fdivrp	st(1), st(0)
fld	@[esi+0]
fmul	st(0), st(1)
fld	@[esi+4]
fmul	st(0), st(2)
fld	@[esi+8]
fmul	st(0), st(3)
fxch	st(2)
fstp	@[edi+0]
fstp	@[edi+4]
fstp	@[edi+8]
@@9000:
fcomp
mpop	edi, esi		     
ret		     
VectorNormalize endp		     
VectorRotate proc Dest, Src, Matrix
mpush	ebx, esi, edi
mov	esi, [Src]
mov	edi, [Dest]
mov	ebx, [Matrix]
fld	@[esi+0]
fmul	@[ebx+M_00]
fld	@[esi+0]
fmul	@[ebx+M_01]
fld	@[esi+0]
fmul	@[ebx+M_02]
fld	@[esi+4]
fmul	@[ebx+M_10]
fld	@[esi+4]
fmul	@[ebx+M_11]
fld	@[esi+4]
fmul	@[ebx+M_12]
fxch	st(2)
faddp	st(5), st(0)
faddp	st(3), st(0)
faddp	st(1), st(0)
fld	@[esi+8]
fmul	@[ebx+M_20]
fld	@[esi+8]
fmul	@[ebx+M_21]
fld	@[esi+8]
fmul	@[ebx+M_22]
fxch	st(2)
faddp	st(5), st(0)
faddp	st(3), st(0)
faddp	st(1), st(0)
fxch	st(2)
fstp	@[edi+0]
fstp	@[edi+4]
fstp	@[edi+8]
mpop	edi, esi, ebx	
ret
VectorRotate endp
end 
