;//////////////////////////////////////////////////////////////
;//  write your comments to : loadall@hotmail.com
;//  have a look at my homepage : www.multimania.com/loadall
;//  chat with the author (loadall) on IRCNet, channel #coders
;//////////////////////////////////////////////////////////////
include System.inc
include Pak.inc
SCREEN_WIDTH 	= 800
SCREEN_HEIGHT 	= 600
DD_ROP_SPACE 		= (256/32)
DDCAPS_3D 		= 1
DDCAPS_NOHARDWARE 	= 02000000h
DDSCL_FULLSCREEN	= 1
DDSCL_ALLOWREBOOT	= 2
DDSCL_NOWINDOWCHANGES 	= 4
DDSCL_NORMAL		= 8
DDSCL_EXCLUSIVE         = 16
DDSCL_FPUSETUP          = 0800h
DDSD_CAPS		= 1
DDSD_HEIGHT		= 2
DDSD_WIDTH		= 4
DDSD_PITCH		= 8
DDSD_BACKBUFFERCOUNT	= 020h
DDSD_ZBUFFERBITDEPTH	= 040h
DDSD_ALPHABITDEPTH	= 080h
DDSD_LPSURFACE		= 0800h
DDSD_PIXELFORMAT	= 01000h
DDSD_MIPMAPCOUNT        = 020000h
DDSD_TEXTURESTAGE       = 0100000h
DDSCAPS_RESERVED1	= 000000001h
DDSCAPS_ALPHA		= 000000002h
DDSCAPS_BACKBUFFER	= 000000004h
DDSCAPS_COMPLEX		= 000000008h
DDSCAPS_FLIP		= 000000010h
DDSCAPS_FRONTBUFFER	= 000000020h
DDSCAPS_OFFSCREENPLAIN	= 000000040h
DDSCAPS_OVERLAY		= 000000080h
DDSCAPS_PALETTE		= 000000100h
DDSCAPS_PRIMARYSURFACE	= 000000200h
DDSCAPS_PRIMARYSURFACELEFT	= 000000400h
DDSCAPS_SYSTEMMEMORY	= 000000800h
DDSCAPS_TEXTURE		= 000001000h
DDSCAPS_3DDEVICE        = 000002000h
DDSCAPS_VIDEOMEMORY	= 000004000h
DDSCAPS_VISIBLE		= 000008000h
DDSCAPS_WRITEONLY	= 000010000h
DDSCAPS_ZBUFFER		= 000020000h
DDSCAPS_OWNDC		= 000040000h
DDSCAPS_LIVEVIDEO	= 000080000h
DDSCAPS_HWCODEC		= 000100000h
DDSCAPS_MODEX		= 000200000h
DDSCAPS_MIPMAP          = 000400000h
DDSCAPS_RESERVED2       = 000800000h
DDSCAPS_ALLOCONLOAD     = 004000000h
DDSCAPS_VIDEOPORT	= 008000000h
DDSCAPS_LOCALVIDMEM     = 010000000h
DDSCAPS_NONLOCALVIDMEM  = 020000000h
DDSCAPS_STANDARDVGAMODE = 040000000h
DDSCAPS_OPTIMIZED       = 080000000h
DDPF_ALPHAPIXELS	= 1
DDPF_ALPHA		= 2
DDPF_FOURCC		= 4
DDPF_PALETTEINDEXED4	= 8
DDPF_PALETTEINDEXEDTO8	= 010h
DDPF_PALETTEINDEXED8	= 020h
DDPF_RGB		= 040h
DDPF_COMPRESSED		= 080h
DDPF_RGBTOYUV		= 0100h
DDPF_YUV		= 0200h
DDPF_ZBUFFER		= 0400h
DDPF_PALETTEINDEXED1	= 0800h
DDPF_PALETTEINDEXED2	= 01000h
DDPF_ZPIXELS		= 02000h
DDPF_STENCILBUFFER	= 04000h
DDPF_ALPHAPREMULT 	= 08000h
DDPF_LUMINANCE          = 020000h
DDPF_BUMPLUMINANCE      = 040000h
DDPF_BUMPDUDV           = 080000h
DDPCAPS_4BIT		= 1
DDPCAPS_8BITENTRIES	= 2
DDPCAPS_8BIT		= 4
DDPCAPS_INITIALIZE	= 8
DDPCAPS_PRIMARYSURFACE	= 010h
DDPCAPS_PRIMARYSURFACELEFT = 020h
DDPCAPS_ALLOW256	= 040h
DDPCAPS_VSYNC		= 080h
DDPCAPS_1BIT		= 0100h
DDPCAPS_2BIT		= 0200h
DDPCAPS_ALPHA		= 0400h
DDLOCK_WAIT		= 1
D3DCLEAR_TARGET  	= 1
D3DCLEAR_ZBUFFER 	= 2
DDFLIP_WAIT             = 1
D3DRENDERSTATE_ANTIALIAS          = 2
D3DRENDERSTATE_TEXTUREADDRESS     = 3
D3DRENDERSTATE_TEXTUREPERSPECTIVE = 4
D3DRENDERSTATE_WRAPU          = 5
D3DRENDERSTATE_WRAPV          = 6
D3DRENDERSTATE_ZENABLE            = 7
D3DRENDERSTATE_FILLMODE           = 8
D3DRENDERSTATE_SHADEMODE          = 9
D3DRENDERSTATE_LINEPATTERN        = 10
D3DRENDERSTATE_MONOENABLE         = 11
D3DRENDERSTATE_ROP2               = 12
D3DRENDERSTATE_PLANEMASK          = 13
D3DRENDERSTATE_ALPHATESTENABLE    = 15
D3DRENDERSTATE_LASTPIXEL          = 16
D3DRENDERSTATE_TEXTUREMAG         = 17
D3DRENDERSTATE_TEXTUREMIN         = 18
D3DRENDERSTATE_TEXTUREMAPBLEND    = 21
D3DRENDERSTATE_ALPHAREF           = 24
D3DRENDERSTATE_ALPHAFUNC          = 25
D3DRENDERSTATE_DITHERENABLE       = 26
D3DRENDERSTATE_SPECULARENABLE     = 29
D3DRENDERSTATE_ZVISIBLE           = 30
D3DRENDERSTATE_SUBPIXEL           = 31
D3DRENDERSTATE_SUBPIXELX          = 32
D3DRENDERSTATE_EDGEANTIALIAS      = 40
D3DRENDERSTATE_COLORKEYENABLE     = 41
D3DRENDERSTATE_BORDERCOLOR        = 43
D3DRENDERSTATE_TEXTUREADDRESSU    = 44
D3DRENDERSTATE_TEXTUREADDRESSV    = 45
D3DRENDERSTATE_MIPMAPLODBIAS      = 46
D3DRENDERSTATE_ZBIAS              = 47
D3DPT_TRIANGLELIST  = 4
D3DPT_TRIANGLESTRIP = 5
D3DTRANSFORMSTATE_WORLD           = 1
D3DTRANSFORMSTATE_VIEW            = 2
D3DTRANSFORMSTATE_PROJECTION      = 3
D3DFILTER_NEAREST          = 1
D3DFILTER_LINEAR           = 2
D3DFILTER_MIPNEAREST       = 3
D3DFILTER_MIPLINEAR        = 4
D3DFILTER_LINEARMIPNEAREST = 5
D3DFILTER_LINEARMIPLINEAR  = 6
D3DTSS_COLOROP        =  1
D3DTSS_COLORARG1      =  2
D3DTSS_COLORARG2      =  3
D3DTSS_ALPHAOP        =  4
D3DTSS_ALPHAARG1      =  5
D3DTSS_ALPHAARG2      =  6
D3DTSS_TEXCOORDINDEX  = 11
D3DTSS_ADDRESSU       = 13
D3DTSS_ADDRESSV       = 14
D3DTSS_BORDERCOLOR    = 15
D3DTSS_MAGFILTER      = 16
D3DTSS_MINFILTER      = 17
D3DTSS_MIPFILTER      = 18
D3DTSS_MIPMAPLODBIAS  = 19
D3DTOP_DISABLE    = 1
D3DTOP_SELECTARG1 = 2
D3DTOP_SELECTARG2 = 3
D3DTOP_MODULATE   = 4
D3DTA_DIFFUSE           = 0
D3DTA_CURRENT           = 1
D3DTA_TEXTURE           = 2
D3DTA_TFACTOR           = 3
D3DTA_COMPLEMENT        = 010h
D3DTA_ALPHAREPLICATE    = 020h
D3DTFG_POINT        = 1
D3DTFG_LINEAR       = 2
D3DTFN_POINT        = 1
D3DTFN_LINEAR       = 2
D3DTFP_NONE         = 1
D3DTFP_POINT        = 2
D3DTFP_LINEAR       = 3
D3DSHADE_FLAT        = 1
D3DSHADE_GOURAUD     = 2
D3DSHADE_PHONG       = 3
D3DFVF_XYZ              = 2
D3DFVF_XYZRHW           = 4
D3DFVF_DIFFUSE          = 040h
D3DFVF_TEX1             = 0100h
D3DFVF_LVERTEX		= (D3DFVF_XYZ+D3DFVF_DIFFUSE+D3DFVF_TEX1)
D3DFVF_TLVERTEX		= (D3DFVF_XYZRHW+D3DFVF_DIFFUSE+D3DFVF_TEX1)
mstruc DDSCAPS
m dwCaps
mends	
mstruc DDSCAPS2
m dwCaps
m dwCaps2
m dwCaps3
m dwCaps4
mends
mstruc DDCAPS
m dwSize
m dwCaps
m dwCaps2
m dwCKeyCaps
m dwFXCaps
m dwFXAlphaCaps
m dwPalCaps
m dwSVCaps
m dwAlphaBltConstBitDepths
m dwAlphaBltPixelBitDepths
m dwAlphaBltSurfaceBitDepths
m dwAlphaOverlayConstBitDepths
m dwAlphaOverlayPixelBitDepths
m dwAlphaOverlaySurfaceBitDepths
m dwZBufferBitDepths
m dwVidMemTotal
m dwVidMemFree
m dwMaxVisibleOverlays
m dwCurrVisibleOverlays
m dwNumFourCCCodes
m dwAlignBoundarySrc
m dwAlignSizeSrc
m dwAlignBoundaryDest
m dwAlignSizeDest
m dwAlignStrideAlign
m dwRops,(4*DD_ROP_SPACE)
m ddsOldCaps,sDDSCAPS
m dwMinOverlayStretch
m dwMaxOverlayStretch
m dwMinLiveVideoStretch
m dwMaxLiveVideoStretch
m dwMinHwCodecStretch
m dwMaxHwCodecStretch
m dwReserved1
m dwReserved2
m dwReserved3
m dwSVBCaps
m dwSVBCKeyCaps
m dwSVBFXCaps
m dwSVBRops,(4*DD_ROP_SPACE)
m dwVSBCaps
m dwVSBCKeyCaps
m dwVSBFXCaps
m dwVSBRops,(4*DD_ROP_SPACE)
m dwSSBCaps
m dwSSBCKeyCaps
m dwSSBFXCaps
m dwSSBRops,(4*DD_ROP_SPACE)
m dwMaxVideoPorts
m dwCurrVideoPorts
m dwSVBCaps2
m dwNLVBCaps
m dwNLVBCaps2
m dwNLVBCKeyCaps
m dwNLVBFXCaps
m dwNLVBRops,(4*DD_ROP_SPACE)
m ddsCaps,sDDSCAPS2
mends
mstruc DDCOLORKEY
m dwColorSpaceLowValue
m dwColorSpaceHighValue
mends
mstruc DDPIXELFORMAT
m dwSize
m dwFlags
m dwFourCC
m dwRGBBitCount,0
m dwYUVBitCount,0
m dwZBufferBitDepth,0
m dwAlphaBitDepth,0
m dwLuminanceBitCount,0
m dwBumpBitCount
m dwRBitMask,0
m dwYBitMask,0
m dwStencilBitDepth,0
m dwLuminanceBitMask,0
m dwBumpDuBitMask
m dwGBitMask,0
m dwUBitMask,0
m dwZBitMask,0
m dwBumpDvBitMask
m dwBBitMask,0
m dwVBitMask,0
m dwStencilBitMask,0
m dwBumpLuminanceBitMask
m dwRGBAlphaBitMask,0
m dwYUVAlphaBitMask,0
m dwLuminanceAlphaBitMask,0
m dwRGBZBitMask,0
m dwYUVZBitMask
mends
mstruc DDSURFACEDESC2
m dwSize
m dwFlags
m dwHeight
m dwWidth
m lPitch
m dwBackBufferCount
m dwMipMapCount
m dwAlphaBitDepth
m dwReserved
m lpSurface
m ddckCKDestOverlay,sDDCOLORKEY
m ddckCKDestBlt,sDDCOLORKEY
m ddckCKSrcOverlay,sDDCOLORKEY
m ddckCKSrcBlt,sDDCOLORKEY
m ddpfPixelFormat,sDDPIXELFORMAT
m ddsCaps,sDDSCAPS2
m dwTextureStage
mends
mstruc D3DVIEWPORT2
m dwSize
m dwX
m dwY
m dwWidth
m dwHeight
m dvClipX
m dvClipY
m dvClipWidth
m dvClipHeight
m dvMinZ
m dvMaxZ
mends
mstruc IDirectDraw4
m QueryInterface
m AddRef
m Release
m Compact
m CreateClipper
m CreatePalette
m CreateSurface
m DuplicateSurface
m EnumDisplayModes
m EnumSurfaces
m FlipToGDISurface
m GetCaps
m GetDisplayMode
m GetFourCCCodes
m GetGDISurface
m GetMonitorFrequency
m GetScanLine
m GetVerticalBlankStatus
m Initialize
m RestoreDisplayMode
m SetCooperativeLevel
m SetDisplayMode
m WaitForVerticalBlank
m GetAvailableVidMem
m GetSurfaceFromDC
m RestoreAllSurfaces
m TestCooperativeLevel
m GetDeviceIdentifier
mends
mstruc IDirectDrawSurface4
m QueryInterface
m AddRef
m Release
m AddAttachedSurface
m AddOverlayDirtyRect
m Blt
m BltBatch
m BltFast
m DeleteAttachedSurface
m EnumAttachedSurfaces
m EnumOverlayZOrders
m Flip
m GetAttachedSurface
m GetBltStatus
m GetCaps
m GetClipper
m GetColorKey
m GetDC
m GetFlipStatus
m GetOverlayPosition
m GetPalette
m GetPixelFormat
m GetSurfaceDesc
m Initialize
m IsLost
m Lock
m ReleaseDC
m Restore
m SetClipper
m SetColorKey
m SetOverlayPosition
m SetPalette
m Unlock
m UpdateOverlay
m UpdateOverlayDisplay
m UpdateOverlayZOrder
m GetDDInterface
m PageLock
m PageUnlock
m SetSurfaceDesc
m SetPrivateData
m GetPrivateData
m FreePrivateData
m GetUniquenessValue
m ChangeUniquenessValue
mends
mstruc IDirect3D3
m QueryInterface
m AddRef
m Release
m EnumDevices
m CreateLight
m CreateMaterial
m CreateViewport
m FindDevice
m CreateDevice
m CreateVertexBuffer
m EnumZBufferFormats
m EvictManagedTextures
mends
mstruc IDirect3DDevice3
m QueryInterface
m AddRef
m Release
m GetCaps
m GetStats
m AddViewport
m DeleteViewport
m NextViewport
m EnumTextureFormats
m BeginScene
m EndScene
m GetDirect3D
m SetCurrentViewport
m GetCurrentViewport
m SetRenderTarget
m GetRenderTarget
m Begin
m BeginIndexed
m Vertex
m Index
m End
m GetRenderState
m SetRenderState
m GetLightState
m SetLightState
m SetTransform
m GetTransform
m MultiplyTransform
m DrawPrimitive
m DrawIndexedPrimitive
m SetClipStatus
m GetClipStatus
m DrawPrimitiveStrided
m DrawIndexedPrimitiveStrided
m DrawPrimitiveVB
m DrawIndexedPrimitiveVB
m ComputeSphereVisibility
m GetTexture
m SetTexture
m GetTextureStageState
m SetTextureStageState
m ValidateDevice
mends
mstruc IDirect3DViewport3
m QueryInterface
m AddRef
m Release
m Initialize
m GetViewport
m SetViewport
m TransformVertices
m LightElements
m SetBackground
m GetBackground
m SetBackgroundDepth
m GetBackgroundDepth
m Clear
m AddLight
m DeleteLight
m NextLight
m GetViewport2
m SetViewport2
m SetBackgroundDepth2
m GetBackgroundDepth2
m Clear2
mends
mstruc IDirect3DTexture2
m QueryInterface
m AddRef
m Release
m GetHandle
m PaletteChanged
m Load
mends
mstruc Z3D
m FullScreen
m pDD1
m pDD4
m pPrimary
m pSecondary
m MaxVideoMemoryUsed
m CurrentTexture
m pD3D
m pDevice
m pViewport
m ViewportData,sD3DVIEWPORT2
mends

dxcall macro m0,m1,m2,m3,m4,m5,m6,m7,m8,m9,m10,m11,m12
ifnb <m12>
push	&m12
endif
ifnb <m11>
push	&m11
endif
ifnb <m10>
push	&m10
endif
ifnb <m9>
push	&m9
endif
ifnb <m8>
push	&m8
endif
ifnb <m7>
push	&m7
endif
ifnb <m6>
push	&m6
endif
ifnb <m5>
push	&m5
endif
ifnb <m4>
push	&m4
endif
ifnb <m3>
push	&m3
endif
ifnb <m2>
push	&m2
endif
mov	eax, [&m0]
push	eax
mov	eax, [eax]
call	@[eax+ &m1]
test	eax, eax
jnz	@@9999
endm

.data
Z3D_LibDDraw db "ddraw.dll",0
	db "DirectDrawCreate",0
DirectDrawCreate dd 0	
	db "DirectDrawEnumerateA",0
DirectDrawEnumerate dd 0
	db 0	
IID_IDirectDraw4 dd 09c59509ah
	dw 039bdh,011d1h
	db 08ch,04ah,0,0c0h,04fh,0d9h,030h,0c5h
IID_IDirect3D3 dd 0bb223240h
	dw 0e72bh,011d0h
	db 0a9h,0b4h,0,0aah,0,0c0h,099h,03eh
IID_IDirect3DHALDevice dd 084E63dE0h
	dw 046AAh,011CFh
	db 081h,06Fh,0,0,0C0h,020h,015h,06Eh
IID_IDirect3DTexture2 dd 093281502h
	dw 08cf8h, 011d0h
	db 089h,0abh,0,0a0h,0c9h,5,041h,029h
pZ3D dd 0
pBitmaps dd 0
Z3DViewport dd 0
.code

Z3D_ComRelease proc ppObject
mpush	eax, ecx, edx
mov	edx, [ppObject]
xor	ecx, ecx
xchg	ecx, [edx]
jecxz	@@9000
push	ecx
mov	ecx, [ecx]
call	@[ecx+8]
@@9000:
mpop	edx, ecx, eax
ret
Z3D_ComRelease endp

Z3D_SetViewport proc x0,
		     y0,
		     x1,
		     y1
var ScreenWidth, SCREEN_WIDTH
var ScreenHeight, SCREEN_HEIGHT
var f_m_1,-1.0
var f_2,2.0
pushad		     
mov	ebx, [pZ3D]
lea	edi, [ebx+Z3D_ViewportData]
mov	@[edi+D3DVIEWPORT2_dwSize], sD3DVIEWPORT2
fld	[x0]
fimul	[ScreenWidth]
fistp	@[edi+D3DVIEWPORT2_dwX]
fld	[y0]
fimul	[ScreenHeight]
fistp	@[edi+D3DVIEWPORT2_dwY]
fld	[x1]
fsub	[x0]
fimul	[ScreenWidth]
fistp	@[edi+D3DVIEWPORT2_dwWidth]
fld	[y1]
fsub	[y0]
fimul	[ScreenHeight]
fistp	@[edi+D3DVIEWPORT2_dwHeight]
mov	eax, [f_m_1]
mov	[edi+D3DVIEWPORT2_dvClipX], eax
mov	eax, [f_2]
mov	[edi+D3DVIEWPORT2_dvClipWidth], eax
fild	@[edi+D3DVIEWPORT2_dwHeight]
fidiv	@[edi+D3DVIEWPORT2_dwWidth]
fst	@[edi+D3DVIEWPORT2_dvClipY]
fmul	[f_2]
fstp	@[edi+D3DVIEWPORT2_dvClipHeight]
and	@[edi+D3DVIEWPORT2_dvMinZ], 0
mov	eax, [f_1]
mov	[edi+D3DVIEWPORT2_dvMaxZ], eax
cmp	@[ebx+Z3D_FullScreen], 0
je	@@9000
dxcall	ebx+Z3D_pViewport,\
	IDirect3DViewport3_SetViewport2,\
	edi
@@9000:	
popad
ret
@@9999:
pushstr "Z3D_SetViewport()"
call	Error
Z3D_SetViewport endp

Z3D_MatrixSetProjection proc Matrix
pushad
mov	esi, [Matrix]
mov	ebx, [pZ3D]
cmp	@[ebx+Z3D_FullScreen], 0
je	@@9000
dxcall	ebx+Z3D_pDevice,\
	IDirect3DDevice3_SetTransform,\
	D3DTRANSFORMSTATE_PROJECTION,\
	esi
@@9000:	
popad
ret
@@9999:
pushstr "Z3D_MatrixSetProjection()"
call	Error
Z3D_MatrixSetProjection endp

var f_1,1.0

Z3D_MatrixSetView proc Matrix
local TmpMatrix[tMAT44]
pushad
mov	esi, [Matrix]
lea	edi, [TmpMatrix]
mcall	Matrix_Transpose, edi, esi
xor	eax, eax
mov	edx, [f_1]
mov	@[edi+M_03], eax
mov	@[edi+M_13], eax
mov	@[edi+M_23], eax
mov	@[edi+M_33], edx
mov	ebx, [pZ3D]
cmp	@[ebx+Z3D_FullScreen], 0
je	@@9000
dxcall	ebx+Z3D_pDevice,\
	IDirect3DDevice3_SetTransform,\
	D3DTRANSFORMSTATE_VIEW,\
	edi
@@9000:	
popad
ret
@@9999:
pushstr "Z3D_MatrixSetView()"
call	Error
Z3D_MatrixSetView endp

Z3D_MatrixSetWorld proc Matrix
mpush	eax, ecx, edx
mov	ecx, [Matrix]
xor	eax, eax
mov	edx, [f_1]
mov	@[ecx+M_03], eax
mov	@[ecx+M_13], eax
mov	@[ecx+M_23], eax
mov	@[ecx+M_33], edx
mov	edx, [pZ3D]
cmp	@[edx+Z3D_FullScreen], 0
je	@@9000
dxcall	edx+Z3D_pDevice,\
	IDirect3DDevice3_SetTransform,\
	D3DTRANSFORMSTATE_WORLD,\
	ecx
@@9000:	
mpop	edx, ecx, eax
ret
@@9999:
pushstr "Z3D_MatrixSetWorld()"
call	Error
Z3D_MatrixSetWorld endp

Z3D_SetRenderState proc RenderStateType,
			RenderState
mpush	eax, ecx, edx
mov	ecx, [pZ3D]
cmp	@[ecx+Z3D_FullScreen], 0
je	@@9000
dxcall	ecx+Z3D_pDevice,\
	IDirect3DDevice3_SetRenderState,\
	[RenderStateType],\
	[RenderState]
@@9000:
mpop	edx, ecx, eax
ret
@@9999:
pushstr "Z3D_SetRenderState()"
call	Error	
Z3D_SetRenderState endp


Z3D_SetTextureStageState proc State,
			      Value	
mpush	eax, ecx, edx
mov	ecx, [pZ3D]
cmp	@[ecx+Z3D_FullScreen], 0
je	@@9000
dxcall	ecx+Z3D_pDevice,\
	IDirect3DDevice3_SetTextureStageState,\
	0,\
	[State],\
	[Value]
@@9000:
mpop	edx, ecx, eax
ret
@@9999:
pushstr "Z3D_SetTextureStageState()"
call	Error
Z3D_SetTextureStageState endp

Z3D_FrameBegin proc
mpush	eax, ecx, edx
mov	ecx, [pZ3D]
cmp	@[ecx+Z3D_FullScreen], 0
je	@@9000
lea	edx, [ecx+Z3D_ViewportData+D3DVIEWPORT2_dwX]
dxcall	ecx+Z3D_pViewport,\
	IDirect3DViewport3_Clear2,\
	1,\
	edx,\
	D3DCLEAR_ZBUFFER,\
	0,\
	[f_1],\
	0	
mov	ecx, [pZ3D]
dxcall	ecx+Z3D_pDevice,\
	IDirect3DDevice3_BeginScene
@@9000:
mpop	edx, ecx, eax
ret
@@9999:
pushstr "Z3D_FrameBegin()"
call	Error
Z3D_FrameBegin endp

Z3D_FrameEnd proc
mpush	eax, ecx, edx
mov	ecx, [pZ3D]
cmp	@[ecx+Z3D_FullScreen], 0
je	@@9000
dxcall	ecx+Z3D_pDevice,\
	IDirect3DDevice3_EndScene
mov	ecx, [pZ3D]
dxcall	ecx+Z3D_pPrimary,\
	IDirectDrawSurface4_Flip,\
	0,\
	DDFLIP_WAIT
@@9000:
mpop	edx, ecx, eax
ret
@@9999:
pushstr "Z3D_FrameEnd()"
call	Error
Z3D_FrameEnd endp

Z3D_DDEnumerate proc pGUID,
		     DriverDescription,
 		     DriverName,
		     Context
local	ReturnValue,
	DDCaps[tDDCAPS]
pushad
and	[ReturnValue], 0
mov	ebx, [pZ3D]
lea	eax, [ebx+Z3D_pDD1]
mcall	[DirectDrawCreate], [pGUID], eax, 0
test	eax, eax
jnz	@@9999
lea	edx, [ebx+Z3D_pDD4]
dxcall	ebx+Z3D_pDD1,\
	IDirectDraw4_QueryInterface,\
	offset IID_IDirectDraw4,\
	edx
lea	edi, [DDCaps]
mcall	Sys_MemClear, edi, sDDCAPS
mov	@[edi+DDCAPS_dwSize], sDDCAPS
dxcall	ebx+Z3D_pDD4,\
	IDirectDraw4_GetCaps,\
	edi,\
	0
test	@[edi+DDCAPS_dwCaps], (DDCAPS_3D+DDCAPS_NOHARDWARE)
jz	@@9999
mcall	Sys_LogPrintf, [DriverName]
mcall	Sys_LogPrintf, [DriverDescription]
@@9000:
popad
mov	eax, [ReturnValue]
ret
@@9999:
lea	eax, [ebx+Z3D_pDD4]
mcall	Z3D_ComRelease, eax
lea	eax, [ebx+Z3D_pDD1]
mcall	Z3D_ComRelease, eax
inc	[ReturnValue]
jmp	@@9000
Z3D_DDEnumerate endp

Z3D_EnumZBuffer proc pDDPixFmt,
		     Context
pushad
mov	esi, [pDDPixFmt]
mov	edi, [Context]
test	@[esi+DDPIXELFORMAT_dwFlags], DDPF_ZBUFFER
jz	@@9000
mov	eax, [esi+DDPIXELFORMAT_dwZBufferBitDepth]
cmp	eax, [edi+DDPIXELFORMAT_dwZBufferBitDepth]
jb	@@9000
mcall	Sys_MemCopy, edi, esi, sDDPIXELFORMAT
@@9000:
popad
mov	eax, 1
ret
Z3D_EnumZBuffer endp

Z3D_Create proc WindowHandle,
		FullScreen
local	ddsd[tDDSURFACEDESC2],
	ddsCaps[tDDSCAPS2],
	pZBuffer,
	ProjectionMatrix[tMAT44]
mcall	Sys_LoadLibrary, offset Z3D_LibDDraw
mcall	Sys_HeapAlloc, sZ3D
mov	[pZ3D], eax
xchg	eax, ebx
mov	eax, [FullScreen]
mov	[ebx+Z3D_FullScreen], eax
test	eax, eax
jz	@@9000
mcall	[DirectDrawEnumerate], offset Z3D_DDEnumerate, 0
test	eax, eax
jnz	@@9999
cmp	@[ebx+Z3D_pDD4], 0
je	@@9999
dxcall	ebx+Z3D_pDD4,\
	IDirectDraw4_SetCooperativeLevel,\
	[WindowHandle],\
	(DDSCL_FULLSCREEN+\
	DDSCL_EXCLUSIVE+\
	DDSCL_FPUSETUP+\
	DDSCL_ALLOWREBOOT)
dxcall	ebx+Z3D_pDD4,\
	IDirectDraw4_SetDisplayMode,\
	SCREEN_WIDTH,\
	SCREEN_HEIGHT,\
	16,\
	0,\
	0
;*******************************
lea	edi, [ddsd]
mcall	Sys_MemClear, edi, sDDSURFACEDESC2
mov	@[edi+DDSURFACEDESC2_dwSize], sDDSURFACEDESC2
mov	@[edi+DDSURFACEDESC2_dwFlags],\
	(DDSD_CAPS+DDSD_BACKBUFFERCOUNT)
mov	@[edi+DDSURFACEDESC2_ddsCaps+DDSCAPS_dwCaps],\
(DDSCAPS_PRIMARYSURFACE+DDSCAPS_3DDEVICE+DDSCAPS_FLIP+DDSCAPS_COMPLEX)
mov	@[edi+DDSURFACEDESC2_dwBackBufferCount], 2
lea	edx, [ebx+Z3D_pPrimary]
push	0
push	edx
push	edi
mov	eax, [ebx+Z3D_pDD4]
push	eax
mov	eax, [eax]
call	@[eax+IDirectDraw4_CreateSurface]
test	eax, eax
jz	@@1000
mov	@[edi+DDSURFACEDESC2_dwBackBufferCount], 3
lea	edx, [ebx+Z3D_pPrimary]
dxcall	ebx+Z3D_pDD4,\
	IDirectDraw4_CreateSurface,\
	edi,\
	edx,\
	0
@@1000:
push	@[edi+DDSURFACEDESC2_dwBackBufferCount]
pushstr "BackBufferCount = %i"
call	Sys_LogPrintf
add	esp, 4
lea	edi, [ddsCaps]
mov	@[edi+DDSCAPS2_dwCaps], DDSCAPS_BACKBUFFER
lea	edx, [ebx+Z3D_pSecondary]
dxcall	ebx+Z3D_pPrimary,\
	IDirectDrawSurface4_GetAttachedSurface,\
	edi,\
	edx
;*******************************
lea	edx, [ebx+Z3D_pD3D]
dxcall	ebx+Z3D_pDD4,\
	IDirectDraw4_QueryInterface,\
	offset IID_IDirect3D3,\
	edx
;*******************************
lea	edi, [ddsd]
mcall	Sys_MemClear, edi, sDDSURFACEDESC2
mov	@[edi+DDSURFACEDESC2_dwSize], sDDSURFACEDESC2
mov	@[edi+DDSURFACEDESC2_dwFlags],\
(DDSD_CAPS+DDSD_WIDTH+DDSD_HEIGHT+DDSD_PIXELFORMAT)
mov	@[edi+DDSURFACEDESC2_ddsCaps+DDSCAPS_dwCaps],\
(DDSCAPS_ZBUFFER+DDSCAPS_VIDEOMEMORY) 
mov	@[edi+DDSURFACEDESC2_dwWidth], SCREEN_WIDTH
mov	@[edi+DDSURFACEDESC2_dwHeight], SCREEN_HEIGHT
lea	edx, [edi+DDSURFACEDESC2_ddpfPixelFormat]
dxcall	ebx+Z3D_pD3D,\
	IDirect3D3_EnumZBufferFormats,\
	offset IID_IDirect3DHALDevice,\
	offset Z3D_EnumZBuffer,\
	edx
push	@[edi+DDSURFACEDESC2_ddpfPixelFormat+\
	DDPIXELFORMAT_dwZBufferBitDepth]
pushstr "ZBufferBitDepth = %i"
call	Sys_LogPrintf
add	esp, 4
lea	edx, [pZBuffer]
dxcall	ebx+Z3D_pDD4,\
	IDirectDraw4_CreateSurface,\
	edi,\
	edx,\
	0
dxcall	ebx+Z3D_pSecondary,\
	IDirectDrawSurface4_AddAttachedSurface,\
	[pZBuffer]
;*******************************
lea	edx, [ebx+Z3D_pDevice]
dxcall	ebx+Z3D_pD3D,\
	IDirect3D3_CreateDevice,\
	offset IID_IDirect3DHALDevice,\
	@[ebx+Z3D_pSecondary],\
	edx,\
	0
lea	edx, [ebx+Z3D_pViewport]
dxcall	ebx+Z3D_pD3D,\
	IDirect3D3_CreateViewport,\
	edx,\
	0
dxcall	ebx+Z3D_pDevice,\
	IDirect3DDevice3_AddViewport,\
	[ebx+Z3D_pViewport]
dxcall	ebx+Z3D_pDevice,\
	IDirect3DDevice3_SetCurrentViewport,\
	[ebx+Z3D_pViewport]
@@9000:
lea	eax, [ebx+Z3D_ViewportData+D3DVIEWPORT2_dwX]
mov	[Z3DViewport], eax
mcall	Z3D_SetViewport, 0, 0, [f_1], [f_1]
mcall	Z3D_SetRenderState, D3DRENDERSTATE_SHADEMODE, D3DSHADE_GOURAUD
mcall	Z3D_SetRenderState, D3DRENDERSTATE_DITHERENABLE, 0
mcall	Z3D_SetRenderState, D3DRENDERSTATE_SUBPIXEL, 1
mcall	Z3D_SetRenderState, D3DRENDERSTATE_TEXTUREPERSPECTIVE, 1
mcall	Z3D_SetRenderState, D3DRENDERSTATE_ZFUNC, D3DCMP_LESSEQUAL
mcall	Z3D_SetRenderState, D3DRENDERSTATE_ZENABLE, 1
mcall	Z3D_SetRenderState, D3DRENDERSTATE_ZWRITEENABLE, 1
mcall	Z3D_SetRenderState, D3DRENDERSTATE_CULLMODE, D3DCULL_CCW
mcall	Z3D_SetRenderState, D3DRENDERSTATE_COLORKEYENABLE, 0
mcall	Z3D_SetRenderState, D3DRENDERSTATE_ALPHABLENDENABLE, 0
mcall	Z3D_SetRenderState, D3DRENDERSTATE_ALPHATESTENABLE, 1
mcall	Z3D_SetRenderState, D3DRENDERSTATE_ALPHAREF, 7
mcall	Z3D_SetRenderState, D3DRENDERSTATE_ALPHAFUNC, D3DCMP_GREATER
mcall	Z3D_SetRenderState, D3DRENDERSTATE_SRCBLEND, D3DBLEND_SRCALPHA
mcall	Z3D_SetRenderState, D3DRENDERSTATE_DESTBLEND, D3DBLEND_INVSRCALPHA
mcall	Z3D_SetTextureStageState, D3DTSS_ADDRESS, D3DTADDRESS_WRAP
mcall	Z3D_SetTextureStageState, D3DTSS_MINFILTER, D3DTFN_LINEAR
mcall	Z3D_SetTextureStageState, D3DTSS_MAGFILTER, D3DTFG_LINEAR
mcall	Z3D_SetTextureStageState, D3DTSS_MIPFILTER, D3DTFP_POINT
mcall	Z3D_SetTextureStageState, D3DTSS_ALPHAARG1, D3DTA_TEXTURE
mcall	Z3D_SetTextureStageState, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE
mcall	Z3D_SetTextureStageState, D3DTSS_ALPHAOP, D3DTOP_MODULATE
mcall	Z3D_SetTextureStageState, D3DTSS_COLORARG1, D3DTA_TEXTURE
mcall	Z3D_SetTextureStageState, D3DTSS_COLORARG2, D3DTA_DIFFUSE
mcall	Z3D_SetTextureStageState, D3DTSS_COLOROP, D3DTOP_MODULATE
var	FarPlane,1733.0
var	NearPlane,2.0
var	Aspect,1.0
var	FieldOfView,1.0471
push	[FarPlane]
push	[NearPlane]
push	[Aspect]
push	[FieldOfView]
lea	edi, [ProjectionMatrix]
mcall	Matrix_SetProjection, edi
mcall	Z3D_MatrixSetProjection, edi
ret
@@9999:
pushstr "Z3D_Create()"
call	Error
Z3D_Create endp

Z3D_Release proc
xor	ecx, ecx
xchg	ecx, [pZ3D]
jecxz	@@9000
lea	eax, [ecx+Z3D_pDevice]
mcall	Z3D_ComRelease, eax
lea	eax, [ecx+Z3D_pD3D]
mcall	Z3D_ComRelease, eax
lea	eax, [ecx+Z3D_pDD4]
mcall	Z3D_ComRelease, eax
lea	eax, [ecx+Z3D_pDD1]
mcall	Z3D_ComRelease, eax
push	@[ecx+Z3D_MaxVideoMemoryUsed]
pushstr "MaxVideoMemoryUsed=%i"
call	Sys_LogPrintf
add	esp, 4
@@9000:
ret
Z3D_Release endp

Z3D_CalcTextureMemRequired proc Bitmap
local	MemRequired
pushad
and	[MemRequired], 0
mov	esi, [Bitmap]
mov	ecx, [esi+BMPHEADER_MipMapCount]
mov	ebx, [esi+BMPHEADER_Width]
mov	edx, [esi+BMPHEADER_Height]
@@1000:
mov	eax, ebx
imul	eax, edx
add	[MemRequired], eax
shr	ebx, 1 
shr	edx, 1
dec	ecx
jns	@@1000
popad
mov	eax, [MemRequired]
ret
Z3D_CalcTextureMemRequired endp

Z3D_TextureLoad proc Texture, _Name
local	ddsd[tDDSURFACEDESC2],
	ddsCaps[tDDSCAPS2],
	SystemSurface,
	VideoSurface,
	SystemTexture,
	VideoTexture,
	Palette,
	Level,
	MipMapLevel,
	LevelWidth,
	LevelHeight
pushad
mov	esi, [Texture]
cmp	@[esi+BMPHEADER_Signature], SIGNATURE_BMP
jne	@@9999
mov	eax, [_Name]
mov	[esi+BMPHEADER_Name], eax
mov	eax, [pBitmaps]
mov	[esi+BMPHEADER_Next], eax
mov	[pBitmaps], esi
mov	ebx, [pZ3D]
mcall	Z3D_CalcTextureMemRequired, esi
add	[ebx+Z3D_MaxVideoMemoryUsed], eax
cmp	@[ebx+Z3D_FullScreen], 0
je	@@9000
;*******************************
lea	edi, [ddsd]
mcall	Sys_MemClear, edi, sDDSURFACEDESC2
mov	@[edi+DDSURFACEDESC2_dwSize], sDDSURFACEDESC2
mov	@[edi+DDSURFACEDESC2_dwFlags], (DDSD_CAPS+\
DDSD_WIDTH+DDSD_HEIGHT+DDSD_PIXELFORMAT+DDSD_MIPMAPCOUNT)
mov	@[edi+DDSURFACEDESC2_ddsCaps+DDSCAPS2_dwCaps],\
(DDSCAPS_TEXTURE+DDSCAPS_SYSTEMMEMORY+DDSCAPS_COMPLEX+DDSCAPS_MIPMAP)
mov	eax, [esi+BMPHEADER_Width]
mov	[edi+DDSURFACEDESC2_dwWidth], eax
mov	eax, [esi+BMPHEADER_Height]
mov	[edi+DDSURFACEDESC2_dwHeight], eax
mov	eax, [esi+BMPHEADER_MipMapCount]
inc	eax
mov	[edi+DDSURFACEDESC2_dwMipMapCount], eax
mov	@[edi+DDSURFACEDESC2_ddpfPixelFormat+DDPIXELFORMAT_dwSize],\
	sDDPIXELFORMAT
mov	@[edi+DDSURFACEDESC2_ddpfPixelFormat+DDPIXELFORMAT_dwFlags],\
	(DDPF_PALETTEINDEXED8+DDPF_RGB)	
mov	@[edi+DDSURFACEDESC2_ddpfPixelFormat+DDPIXELFORMAT_dwRGBBitCount],8
lea	edx, [SystemSurface]
dxcall	ebx+Z3D_pDD4,\
	IDirectDraw4_CreateSurface,\
	edi,\
	edx,\
	0
lea	edx, [Palette]
lea	ecx, [esi+BMPHEADER_Palette]
dxcall	ebx+Z3D_pDD4,\
	IDirectDraw4_CreatePalette,\
	(DDPCAPS_ALPHA+DDPCAPS_8BIT+DDPCAPS_ALLOW256+DDPCAPS_INITIALIZE),\
	ecx,\
	edx,\
	0
dxcall	SystemSurface,\
	IDirectDrawSurface4_SetPalette,\
	[Palette]
;*******************************
mov	eax, [SystemSurface]
mov	[Level], eax
mov	eax, [esi+BMPHEADER_MipMapCount]
mov	[MipMapLevel], eax
mov	eax, [esi+BMPHEADER_Width]
mov	[LevelWidth], eax
mov	eax, [esi+BMPHEADER_Height]
mov	[LevelHeight], eax
add	esi, sBMPHEADER
@@1000:
lea	edi, [ddsd]
mcall	Sys_MemClear, edi, sDDSURFACEDESC2
mov	@[edi+DDSURFACEDESC2_dwSize], sDDSURFACEDESC2
dxcall	Level,\
	IDirectDrawSurface4_Lock,\
	0,\
	edi,\
	DDLOCK_WAIT,\
	0
mov	edi, [ddsd+DDSURFACEDESC2_lpSurface]
mov	ecx, [LevelHeight]
@@1100:
push	edi
push	ecx
mov	ecx, [LevelWidth]
rep	movsb
pop	ecx
pop	edi
add	edi, [ddsd+DDSURFACEDESC2_lPitch]
dec	ecx
jnz	@@1100
dxcall	Level,\
	IDirectDrawSurface4_Unlock,\
	0
dec	[MipMapLevel]
js	@@2000
lea	edi, [ddsCaps]
mcall	Sys_MemClear, edi, sDDSCAPS2
mov	@[edi+DDSCAPS2_dwCaps],\
(DDSCAPS_TEXTURE+DDSCAPS_MIPMAP+DDSCAPS_SYSTEMMEMORY)
lea	edx, [Level]
dxcall	Level,\
	IDirectDrawSurface4_GetAttachedSurface,\
	edi,\
	edx
mov	eax, [Level]
push	eax
mov	eax, [eax]	
call	@[eax+IDirectDrawSurface4_Release]
shr	[LevelWidth], 1
shr	[LevelHeight], 1
jmp	@@1000
@@2000:
;*******************************
mov	esi, [Texture]
lea	edi, [ddsd]
mcall	Sys_MemClear, edi, sDDSURFACEDESC2
mov	@[edi+DDSURFACEDESC2_dwSize], sDDSURFACEDESC2
mov	@[edi+DDSURFACEDESC2_dwFlags], (DDSD_CAPS+\
DDSD_WIDTH+DDSD_HEIGHT+DDSD_PIXELFORMAT+DDSD_MIPMAPCOUNT)
mov	@[edi+DDSURFACEDESC2_ddsCaps+DDSCAPS2_dwCaps],\
(DDSCAPS_TEXTURE+DDSCAPS_VIDEOMEMORY+DDSCAPS_ALLOCONLOAD+DDSCAPS_COMPLEX+DDSCAPS_MIPMAP)
mov	eax, [esi+BMPHEADER_Width]
mov	[edi+DDSURFACEDESC2_dwWidth], eax
mov	eax, [esi+BMPHEADER_Height]
mov	[edi+DDSURFACEDESC2_dwHeight], eax
mov	eax, [esi+BMPHEADER_MipMapCount]
inc	eax
mov	[edi+DDSURFACEDESC2_dwMipMapCount], eax
mov	@[edi+DDSURFACEDESC2_ddpfPixelFormat+DDPIXELFORMAT_dwSize],\
	sDDPIXELFORMAT
mov	@[edi+DDSURFACEDESC2_ddpfPixelFormat+DDPIXELFORMAT_dwFlags],\
	(DDPF_PALETTEINDEXED8+DDPF_RGB)	
mov	@[edi+DDSURFACEDESC2_ddpfPixelFormat+DDPIXELFORMAT_dwRGBBitCount],8
lea	edx, [VideoSurface]
dxcall	ebx+Z3D_pDD4,\
	IDirectDraw4_CreateSurface,\
	edi,\
	edx,\
	0
dxcall	VideoSurface,\
	IDirectDrawSurface4_SetPalette,\
	[Palette]
lea	edx, [SystemTexture]	
dxcall	SystemSurface,\
	IDirectDrawSurface4_QueryInterface,\
	offset IID_IDirect3DTexture2,\
	edx
lea	edx, [VideoTexture]	
dxcall	VideoSurface,\
	IDirectDrawSurface4_QueryInterface,\
	offset IID_IDirect3DTexture2,\
	edx
mov	eax, [VideoTexture]
mov	[esi+BMPHEADER_Texture], eax
dxcall	VideoTexture,\
	IDirect3DTexture2_Load,\
	[SystemTexture]
mov	eax, [SystemTexture]
push	eax
mov	eax, [eax]
call	@[eax+IDirect3DTexture2_Release]
dxcall	SystemSurface,\
	IDirectDrawSurface4_Release
;mov	eax, [VideoSurface]
;push	eax
;mov	eax, [eax]
;call	@[eax+IDirectDrawSurface4_Release]
@@9000:
popad
ret
@@9999:
push	eax
push	[_Name]
pushstr "Z3D_TextureLoad(%s):%x"
call	Error
Z3D_TextureLoad endp

Z3D_TextureGet proc _Name
local	Tmp
mpush	ecx, edx
mov	ecx, [pBitmaps]
mov	edx, [_Name]
xor	eax, eax
cmp	edx, 0
je	@@9000
@@1000:
cmp	ecx, 0
je	@@9999
mov	eax, [ecx+BMPHEADER_Name]
mcall	Sys_StrCmp, eax, edx
test	eax, eax
mov	eax, [ecx+BMPHEADER_Texture]
mov	[Tmp], ecx
mov	ecx, [ecx+BMPHEADER_Next]
jz	@@1000
@@9000:
mpop	edx, ecx
ret
@@9999:
push	[_Name]
pushstr "Z3D_TextureGet(%s)"
call	Error
Z3D_TextureGet endp

Z3D_TextureSet proc Texture
mpush	eax, ecx, edx
mov	ecx, [pZ3D]
mov	edx, [Texture]
cmp	@[ecx+Z3D_FullScreen], 0
je	@@9000
cmp	edx, [ecx+Z3D_CurrentTexture]
je	@@9000
mov	[ecx+Z3D_CurrentTexture], edx
dxcall	ecx+Z3D_pDevice,\
	IDirect3DDevice3_SetTexture,\
	0,\
	edx
@@9000:
mpop	edx, ecx, eax
ret
@@9999:
pushstr "Z3D_TextureSet()"
call	Error
Z3D_TextureSet endp

Z3D_DrawTriangleStrip2d proc Vertices,
				 NumVertices
mpush 	eax, ecx, edx
mov	ecx, [pZ3D]
cmp	@[ecx+Z3D_FullScreen], 0
je	@@9000
dxcall	ecx+Z3D_pDevice,\
	IDirect3DDevice3_DrawPrimitive,\
	D3DPT_TRIANGLESTRIP,\
	D3DFVF_TLVERTEX,\
	[Vertices],\
	[NumVertices],\
	0
@@9000:
mpop	edx, ecx, eax
ret
@@9999:
pushstr "Z3D_DrawTriangleStrip2d()"
call	Error
Z3D_DrawTriangleStrip2d endp

Z3D_DrawIndexedTriangles proc Vertices,
			      NumVertices,
			      Indices,
			      NumIndices
mpush 	eax, ecx, edx
mov	ecx, [pZ3D]
cmp	@[ecx+Z3D_FullScreen], 0
je	@@9000
dxcall	ecx+Z3D_pDevice,\
	IDirect3DDevice3_DrawIndexedPrimitive,\
	D3DPT_TRIANGLELIST,\
	D3DFVF_LVERTEX,\
	[Vertices],\
	[NumVertices],\
	[Indices],\
	[NumIndices],\
	0
@@9000:
mpop	edx, ecx, eax
ret
@@9999:
pushstr "Z3D_DrawIndexedTriangle()"
call	Error
Z3D_DrawIndexedTriangles endp

Z3D_DrawTriangleStrip proc Vertices,
			   NumVertices
mpush 	eax, ecx, edx
mov	ecx, [pZ3D]
cmp	@[ecx+Z3D_FullScreen], 0
je	@@9000
dxcall	ecx+Z3D_pDevice,\
	IDirect3DDevice3_DrawPrimitive,\
	D3DPT_TRIANGLESTRIP,\
	D3DFVF_LVERTEX,\
	[Vertices],\
	[NumVertices],\
	0
@@9000:
mpop	edx, ecx, eax
ret
@@9999:
pushstr "Z3D_DrawTriangleStrip()"
call	Error
Z3D_DrawTriangleStrip endp

Z3D_DrawTriangles proc Vertices,
		       NumVertices
ret		       
Z3D_DrawTriangles endp

end
