; PE Labs 1.0 by Latigo
; latigo@ciudad.com.ar
; Most of the code is commented, ill comment more in the next update 
; Tab space = 4
; Best viewed in WinEdit
; there you go 2k lines of pure win32asm :)

.386							   
.MODEL FLAT,STDCALL

include \masm32\include\windows.inc
include \masm32\include\user32.inc
include \masm32\include\kernel32.inc
include \masm32\include\comctl32.inc
include \masm32\include\gdi32.inc
include \masm32\include\comdlg32.inc

includelib user32.lib
includelib kernel32.lib
includelib comctl32.lib
includelib gdi32.lib
includelib comdlg32.lib


EXTRN wsprintfA:PROC

.CONST

IDI_PEICO       EQU 112
ICON_SMALL	    EQU 0
	
IDC_TAB1  			EQU	1003
IDC_TREE1 			EQU 1013
IDB_BITMAP1 		EQU	106
IDC_LIST1       	EQU 1016
IDC_LIST2           EQU 1049
IDC_SPLITFILE   	EQU 1019

;Controls used by PeInfo
IDC_MACHINE			EQU 1104
IDC_NOFSECTIONS 	EQU 1105
IDC_SIZEOPTHEAD 	EQU 1106
IDC_CHARACTERISTICS EQU 1107
IDC_CHARACDESC		EQU 1108
IDC_ENTRYPOINT      EQU 1109
IDC_SECTIONALIGN    EQU 1110
IDC_FILEALIGN       EQU 1111
IDC_IMAGESIZE       EQU 1112
IDC_HEADERSIZE      EQU 1113
IDC_IMAGEBASE       EQU 1114

; Used by Import Table Dlg
IDC_DLLNAME        	EQU 1115
IDC_OFIRSTTHUNK    	EQU 1116
IDC_TDS            	EQU 1117
IDC_FC              EQU 1118
IDC_NAMERVA         EQU 1119
IDC_FT              EQU 1120

; Controls used by the main Dialog
IDC_ORIGINALRVA     EQU 1121
IDC_EQUIVVA         EQU 1122
IDC_FILENAME        EQU 1123
IDC_FILESIZE        EQU 1124


; Menu Shit
IDM_FILE_OPEN		EQU 40001			
IDM_FILE_CLOSE		EQU 40002
IDM_FILE_EXIT   	EQU 40003
IDM_ABOUT       	EQU 40004


cchTextMax			EQU 128
IDC_R2VCHECK        EQU 1045			; CheckBox ID
IDC_POINTERZ        EQU 105			    ; Cursor ID
IDC_OFT             EQU 1048


; Pop up menu identifiers
IDM_DUMP		    EQU 1011

.DATA

HexFormatter		DB "%08X",0
DecFormatter		DB "%d",0
StringFormatter		DB "%s",0

OpenFileErrorMsg	DB "Could not open file!",0	
NotPEFileMsg		DB "Not a valid PE file!",0
DumpOk				DB "File saved to disk Ok :)",0
Titulo				DB "PE Labs 1.0 by Latigo",0
FileIOErrorMsg		DB "File I/O Error!",0

; Dialogs Classes Names
DlgMain				DB "IDD_PELABS",0			; DlgName del main dialogbox
DlgName1			DB "IDD_TABDLG1",0		   	; DlgName del dialogbox dos header
DlgName3			DB "IDD_TABDLG3",0			; DlgName del dialogbox del tercer tab
DlgName4			DB "IDD_TABDLG4",0			; DlgName del dialogbox del cuarto tab (section headers)
DlgName5			DB "IDD_THUNKDLG",0			; 
AboutDlgName		DB "IDD_ABOUTDLG",0

i386				DB "14C-INTEL 80386 or better",0
i486				DB "14D-INTEL 80486 or better",0
Pentium		   		DB "14E-INTEL Pentium or better",0

; Who is going to open a file like these?
; Who is going to use this program anyway! :)

;BR3000				DB "160-R3000 (MIPS) Big Endian",0
;LR3000		   		DB "162-R3000 (MIPS) Little Endian",0
;R4000			   	DB "166-R4000 (MIPS) Little Endian",0
;R10000				DB "168-R10000 (MIPS) Little Endian",0
;DecAlpha			DB "184-DEC Alpha AXP processor",0
;IBMPower			DB "1F0-IBM Power PC, Little Endian",0

; This are used by the List Control (PE sections)
ColumTitle1 		DB "Name",0
ColumTitle2 		DB "Virtual Size",0
ColumTitle3 		DB "Virtual Offset",0
ColumTitle4 		DB "Raw Size",0
ColumTitle5 		DB "Raw Offset",0
ColumTitle6 		DB "Characteristics",0
ColumTitle7			DB "Hint/Name Array",0
ColumTitle8			DB "Hint",0
ColumTitle9			DB "Name",0
ColumTitle10		DB "Import Address Table",0


PeHeaderFileName 	DB ".PE-header",0
DumpSectionName		DB "section0.bin",0
DumpSectionMsg		DB "  files dumped to the same dir as your target file!",0

;RichDll				DB "RICHED32.DLL",0


;*************************************************************************
;					OPENFILENAME structure data
FilterString 		DB "Exe Files (*.exe)",0,"*.exe",0,"Dll Files (*.dll)",0,"*.dll",0,"Dump Files (*.dmp)",0,"*.dmp",0,"All Files (*.*)",0,"*.*",0,0 
FileNameBuffer		DB 260 DUP (0)
OFNTitle			DB "Choose a phile to be analized",0
OFNTitle2			DB "Choose a phile to save your data",0
;*************************************************************************
;					Tab Control data
;
TabTitle1			DB "PE Info",0
TabTitle3			DB "Section Headers",0
TabTitle4			DB "Import Table",0
;*************************************************************************
;					PopUp Menu data
;
;ViewSection		    DB "View Section",0
DumpSection		    DB "Dump Section",0
;KillSection			DB "Kill Section",0
;*************************************************************************
; 
TreeViewClass		DB "SysTreeView32",0		; TreeView Class Name
ParentMember		DB "Import Table",0			; Name of the r00t item in the TreeView ctrl

.DATA?

;	 You will excuse my global variable abuse..someday ill be a better coder :)

Handles LABEL DWORD
DialogHandle1		HANDLE					?			; PeInfo Dlg Handle
DialogHandle3		HANDLE					?		   	; Section Header Dlg Handle
DialogHandle4		HANDLE					?		   	; Import Table Dlg Handle
DialogHandle5		HANDLE					?		   	; 
MainDialogHandle	HANDLE					?			; Main Dlg Handle

hInstance			HINSTANCE				?
FileHandle			HANDLE					?
hwndTab				HANDLE					?			; Tab control handle
hwndTreeView		HANDLE					?			; TreeView handle
hwndRtoACheck		HANDLE					?			; CheckBox handle
hwndParentTree		HANDLE					?			; TreeView ctrl parent member handle
hwndList			HANDLE					?			; List control handle
hwndList2			HANDLE					?			; List control handle in THUNKDATA
hwndMappedFile		HANDLE					?			; Handle used in CreateFileMapping
hPopupMenu	    	HANDLE					?			; Right click pop-up menu handler
MemMapPtr			DWORD		 			?			; Pointer to the Memory Mapped file returned by MapViewOfFile API
OpenPhile			DB						?			; Global flag indicating an open or closed file
Cleaning			DB						?			; (this is cheap) Global flag that tells that the file is closing
VAFlag				DB						?			; Flag used by the RVAtoVA thing..(ok enough lame flags man!!!)
SectionName			DB 8 DUP				(?)			; Buffer for each pe section name
DummyBuffer			DB 25 DUP 				(?)			; I love this one cos i use it a LOT :)
pszText				DB 128 DUP				(?)			; Used by the  TV_ITEM structure
PE_OFFSET			DWORD					?			; yeah you guessed, the VA to the PE doors
WhichTabChosen		DWORD					?			; If you read my TabControl tutorial @ Iczelion's you should know what this is :)
ImpRVA				DWORD					?			; Import Table's RVA

; This variable keeps the subclassed edit boxes OLD procedure
OldProc				HANDLE					?
;*************************************************************************
;			Variables used to represent different values in the File Header
WORDVALUE			WORD					?
DWORDVALUE			DWORD					?
; Averiguar como mierda se transforma esta variable a una local
;*************************************************************************


;****************************************************************************
;					Structures					
ItemStruct  		TC_ITEM 				<?>			; Used by the Tab control
DosHeader			IMAGE_DOS_HEADER		<?>			; Dos header
NTHeader			IMAGE_NT_HEADERS		<?>			; :)
InsertStruct		TV_INSERTSTRUCT			<?>			; Needed for inserting items in a TreeView control
ofn   				OPENFILENAME			<?>			; This one is for GetSaveFileNameA and GetOpenFileNameA
ListCol				LV_COLUMN 				<?>			; Used by the List control
ListItem			LV_ITEM					<?>			; Idem
SectionHeader   	IMAGE_SECTION_HEADER 	<?>			; This structure represents an IMAGE_SECTION_HEADER
ImpDescriptor		IMAGE_IMPORT_DESCRIPTOR <?>			; This one does not :)
TVItem				TV_ITEM					<?>			; Used by the TreeView control

;*************************************************************************
;							Prototypes
WinMain PROTO hInst:HINSTANCE,hPrevInst:HINSTANCE,CmdShow:SDWORD
NewProc	PROTO hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM
;
;*************************************************************************

.CODE

Starts:

	INVOKE GetModuleHandle,0
	MOV hInstance,EAX
	INVOKE WinMain,hInstance,NULL,SW_SHOWDEFAULT
	INVOKE ExitProcess,0
	INVOKE InitCommonControls						; lets justify the use of comctl32.dll							

WinMain PROC hInst:HINSTANCE,hPrevInst:HINSTANCE,CmdShow:SDWORD

	MOV EAX, OFFSET DlgProc
	INVOKE DialogBoxParam, hInst, OFFSET DlgMain,NULL,EAX,NULL    ;Main dialog created
   	RET

WinMain	ENDP

DlgProc	PROC hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM

	LOCAL hwndCursor : HCURSOR
	LOCAL _hIcon	 : HANDLE

	MOV EAX,uMsg

	CMP EAX,WM_CLOSE				; User wanna quit?
	JZ _close

	CMP EAX,WM_INITDIALOG			; App initialization?
	JZ _create

	CMP EAX,WM_NOTIFY	
	JZ _notify
	
	CMP EAX,WM_COMMAND
	JZ _command

	XOR EAX,EAX
	RET

	_close:
	INVOKE ExitProcess,0
	RET

	_command:
	MOV EAX, wParam
	CMP AX, IDM_FILE_OPEN				; Menu parsing
	JZ _file_open

	CMP AX, IDM_FILE_CLOSE
	JZ _file_close

	CMP AX, IDM_FILE_EXIT
	JZ _close

	CMP AX, IDM_ABOUT
	JZ _about


	SHR EAX,16
	CMP EAX,BN_CLICKED 		     		; This message comes in the LO word of the wParam in a WM_COMMAND msg
	JZ _buttonclicked					; and is send when the user clicks a button
	RET

	_buttonclicked:
	MOV EAX,wParam
	CMP EAX,IDC_R2VCHECK				; Was the CheckBox the culprit?
	JZ _rvatovacheck
	RET

	_rvatovacheck:
	CMP OpenPhile,1						; Is any file opened?
	JNZ NoPhileOpened

	INVOKE IsDlgButtonChecked,hWnd,IDC_R2VCHECK		; This API is speaks for itself 
	CMP EAX,BST_CHECKED								; is it checked?
	JZ ItsChecked
	MOV VAFlag,0									; No so modify the flag accordingly
	INVOKE LoadCursor,NULL,IDC_ARROW				; Lets get the normal mouse cursor
	INVOKE SetClassLong,hWnd,GCL_HCURSOR,EAX		; and now we load it
	JMP CheckDone

	ItsChecked:										; All the oposite :)
	MOV VAFlag,1
	INVOKE LoadCursor,hInstance,IDC_POINTERZ
	INVOKE SetClassLong,hWnd,GCL_HCURSOR,EAX	
	CheckDone:
	RET

	NoPhileOpened:									; If no file is being analized then UNcheck the CheckBox
	INVOKE CheckDlgButton,MainDialogHandle,IDC_R2VCHECK,BST_UNCHECKED	
	RET

	_about:
	MOV EAX,OFFSET AboutProc
	INVOKE CreateDialogParam,hInstance,OFFSET AboutDlgName,hWnd,EAX,0
	INVOKE ShowWindow,EAX,SW_SHOWDEFAULT
	RET

	_create:
	PUSH	IDI_PEICO					; Lets put the little icon in the 
	PUSH	hInstance					; upper left corner..stolen from some Rudeboy's asm file.
	CALL	LoadIcon			

    MOV	_hIcon, EAX			
    push	EAX				
    push	ICON_SMALL			
    push	WM_SETICON			
    push	hWnd				
    CALL	SendMessage			

	; Here the Main Dialog is created and we shall do many many things.
	; First we keep the MainDlg's handle for later use
	MOV EAX,hWnd
	MOV MainDialogHandle,EAX

	; The Tab control handle is kept in hwndTab
	INVOKE GetDlgItem,hWnd,IDC_TAB1
	MOV hwndTab,EAX

	; The CheckBox handle is kept in hwndRtoACheck 
	INVOKE GetDlgItem,hWnd,IDC_R2VCHECK
	MOV hwndRtoACheck,EAX

	; The different tabs for the Tab control are created
	; Structure filled and then we call the SendMessage API with the TCM_INSERTITEM msg (check your local API reference for more details)

	MOV ItemStruct.imask,TCIF_TEXT				; Text? image?
	MOV ItemStruct.lpReserved1,0				; Reserved
	MOV ItemStruct.lpReserved2,0 			    ; Reserved
	MOV ItemStruct.pszText,OFFSET TabTitle1 	; pointer to string containing tab text 
	MOV ItemStruct.cchTextMax,sizeof TabTitle1	; size of pszText
  	MOV ItemStruct.iImage,0						; index to tab control's image 
 	MOV ItemStruct.lParam,0						; Extra info
	INVOKE SendMessage,hwndTab,TCM_INSERTITEM,0,OFFSET ItemStruct	; insert!

	; Now some members of the structure are modified

	MOV ItemStruct.imask,TCIF_TEXT
	MOV ItemStruct.pszText,OFFSET TabTitle3
	MOV ItemStruct.cchTextMax,sizeof TabTitle3
  	MOV ItemStruct.iImage,2
	INVOKE SendMessage,hwndTab,TCM_INSERTITEM,1,OFFSET ItemStruct

	MOV ItemStruct.imask,TCIF_TEXT
	MOV ItemStruct.pszText,OFFSET TabTitle4
	MOV ItemStruct.cchTextMax,sizeof TabTitle4
  	MOV ItemStruct.iImage,2
	INVOKE SendMessage,hwndTab,TCM_INSERTITEM,2,OFFSET ItemStruct

	MOV WhichTabChosen,0		; When all this is created, we have the first tab (index 0) chosen

	; Now the Dialogboxes that will be shown in the Tab control are created
	; This is the PE info Dlg

	MOV EAX,OFFSET ChildDlgProc
	INVOKE CreateDialogParam,hInstance,OFFSET DlgName1,hwndTab,EAX,0
	MOV DialogHandle1,EAX

	; Section headers one
	MOV EAX,OFFSET ChildDlgProc3
	INVOKE CreateDialogParam,hInstance,OFFSET DlgName3,hwndTab,EAX,0
	MOV DialogHandle3,EAX

	; TreeView one (import table)
	MOV EAX,OFFSET ChildDlgProc4
	INVOKE CreateDialogParam,hInstance,OFFSET DlgName4,hwndTab,EAX,0
	MOV DialogHandle4,EAX

	; Finally, after the creation, i must SHOW one of all those i created
	; and i decide to show the PEInfo one (which is the first one,with index number 0)

	INVOKE ShowWindow,DialogHandle1,SW_SHOWDEFAULT

	;**********************************************************************	
	; Now we are going to subclass some Edit boxes in order to intercept
	; some messages and then proceed as desired.
	; (Thanks to MrNop for his help here).

	INVOKE GetDlgItem,DialogHandle1,IDC_ENTRYPOINT
	INVOKE SetWindowLong,EAX,GWL_WNDPROC,NewProc
	MOV OldProc,EAX
	
	INVOKE GetDlgItem,DialogHandle4,IDC_OFIRSTTHUNK
	INVOKE SetWindowLong,EAX,GWL_WNDPROC,NewProc

	INVOKE GetDlgItem,DialogHandle4,IDC_NAMERVA
	INVOKE SetWindowLong,EAX,GWL_WNDPROC,NewProc

	INVOKE GetDlgItem,DialogHandle4,IDC_FT
	INVOKE SetWindowLong,EAX,GWL_WNDPROC,NewProc
	RET

	_notify:
	MOV EAX, lParam				   				; Im interested in the .code member of the NMHDR structure
	MOV EAX, (NMHDR PTR [eax]).code			    ; and EAX is a pointer to a NMHDR struct. 
	CMP EAX, TCN_SELCHANGE						; is it 'TCN_SELCHANGE'?
	JZ _change
	RET

	_change:
	MOV EBX,WhichTabChosen
	MOV EAX,[Handles+EBX*4]						; The location of the HANDLES label + the index of the chosen tab (WhichTabChosen) * 4 (each HANDLE is 4 Bytes) gives me the exact location of the HANDLE im interested in
	INVOKE ShowWindow,EAX,SW_HIDE			    ; So i hide the tab wich belongs to the handle we got
	INVOKE SendMessage,hwndTab,TCM_GETCURSEL,0,0	; Which tab does the user want to chose now?
	MOV WhichTabChosen,EAX						; Lets update the flag
	MOV EBX,[Handles+EAX*4]						; Now i repeate the procedure to get the new handle so i can show the Dialog that belongs to it
 	INVOKE ShowWindow,EBX,SW_SHOWDEFAULT		; Lets show it
	RET

	_file_open:
	PUSH hWnd
	CALL Init
	RET

	_file_close:					; User wants to close the current file
	CMP OpenPhile,1					; What? nothing is opened?
	JNZ NothingToClose				; yeah
	CALL WinstonWolf 				; No! you better clean and close everything before the new guest arrives :)
	MOV OpenPhile,0					; Resetting flag

	NothingToClose:
	RET
DlgProc		ENDP

; This is a small Procedure for the about dialog box
AboutProc PROC hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM

	MOV EAX,uMsg
	CMP EAX,WM_CLOSE
	JZ _closeabout
	XOR EAX,EAX
	RET

	_closeabout:
	INVOKE EndDialog,hWnd,0
	RET

AboutProc ENDP

; This procedure is used by the EntryPoint edit box when it is sublcassed
; we filter the Message which indicates that the user has clicked inside
; the edit box. If some flag is initiated is time to intercept that click
; and do some stuff..otherwise we tell windows to handle it as if nothing
; had happened.

ChildDlgProc	PROC hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM

	LOCAL TempBuffer[10]	:BYTE
	LOCAL TempBuffer2[10]	:BYTE

	MOV EAX,uMsg
	CMP EAX,WM_COMMAND
	JZ _command2

	XOR EAX,EAX
	RET
	
	_command2:
	MOV EAX,wParam
	SHR EAX,16

	CMP EAX,EN_SETFOCUS					; Someone clicked inside the box
	JZ GettingFocus
	RET

	GettingFocus:
	CMP VAFlag,1						; Mouse cursor is the aim?
	JZ nADA
	RET
	nADA:
	MOV EAX,wParam
	CMP AX,IDC_ENTRYPOINT
	JNZ NothingToDo

	MOV EBX,lParam
	INVOKE GetWindowText,EBX,OFFSET DummyBuffer,20	; Get the RVA
	CMP EAX,0
	JZ NothingToDo

	INVOKE SetDlgItemText,MainDialogHandle,IDC_ORIGINALRVA,OFFSET DummyBuffer
													; Paste it in some Editbox		
	MOV ECX,8
	LEA EDI,TempBuffer 								; Duh, lame algos
	LEA EBX,TempBuffer2							    ; This atrocity transforms a string	
	LEA ESI,DummyBuffer								; into a number
	CALL StringToNumber
	PUSH [EBX] 										; We got that N in ebx
	CALL RVA2Offset									; Tell me the OFFSET equivalent
	PUSH EAX
	PUSH OFFSET HexFormatter
	PUSH OFFSET DummyBuffer
	CALL wsprintfA
	ADD ESP,0CH
	INVOKE SetDlgItemText,MainDialogHandle,IDC_EQUIVVA,OFFSET DummyBuffer
													; Paste it in some other editbox
	NothingToDo:
	RET

ChildDlgProc	ENDP

StringToNumber	PROC

	; ESI contains a pointer to a buffer that contains the string to be converted to number
	; EDI contains a pointer to a temp buffer..
	; EBX contains a pointer to a buffer that will hold the converted number

	ADD EBX,4
	Jier:
	MOV AL,BYTE PTR [ESI]
	CMP AL,39H
	JG ItsANumbahH
	SUB AL,30H
	JMP d0N3
	ItsANumbahH:
	SUB AL,37H
	d0N3:
	STOSB
	INC ESI
	LOOP Jier
	SUB EDI,8
	MOV ECX,4
	Dear:
	MOV AH,BYTE PTR [EDI]
	MOV AL,BYTE PTR [EDI+1]
	SHL AL,4
	SHR EAX,4
	DEC EBX
	MOV BYTE PTR [EBX],AL
	ADD EDI,2
	LOOP Dear
	RET

StringToNumber	ENDP

; This procedure is for the section headers dialogbox

ChildDlgProc3	PROC hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM

	LOCAL Pt		: POINT

	MOV EAX,uMsg

	CMP EAX,WM_INITDIALOG
	JZ InitList

	CMP EAX,WM_COMMAND
	JZ Command

	CMP EAX,WM_NOTIFY
	JZ Notify

	XOR EAX,EAX
  	RET

	InitList:
	INVOKE GetDlgItem,hWnd,IDC_LIST1
	MOV hwndList,EAX

	INVOKE CreatePopupMenu 		;Se crea el Menu 
	MOV hPopupMenu,EAX 			;Guardo el handle en hPopupMenu en EAX

    INVOKE AppendMenu,hPopupMenu,MF_STRING,IDM_DUMP,OFFSET DumpSection

	; We add the columns to the List control
	MOV ListCol.imask,LVCF_TEXT+LVCF_FMT+LVCF_SUBITEM+LVCF_WIDTH
	MOV ListCol.fmt,LVCFMT_LEFT					; la primer columna debe estar alineada a la izquierda
	MOV ListCol.lx,60									; el ancho en pixeles de la columna
	MOV ListCol.pszText,OFFSET ColumTitle1		; Titulo da columna 	
	MOV ListCol.iSubItem,0
	INVOKE SendMessage,hwndList,LVM_INSERTCOLUMN,0,OFFSET ListCol

	MOV ListCol.lx,70
	MOV ListCol.pszText,OFFSET ColumTitle2
	INVOKE SendMessage,hwndList,LVM_INSERTCOLUMN,1,OFFSET ListCol

	MOV ListCol.lx,80
	MOV ListCol.pszText,OFFSET ColumTitle3
	INVOKE SendMessage,hwndList,LVM_INSERTCOLUMN,2,OFFSET ListCol

	MOV ListCol.lx,65
	MOV ListCol.pszText,OFFSET ColumTitle4
	INVOKE SendMessage,hwndList,LVM_INSERTCOLUMN,3,OFFSET ListCol

	MOV ListCol.lx,70
	MOV ListCol.pszText,OFFSET ColumTitle5
	INVOKE SendMessage,hwndList,LVM_INSERTCOLUMN,4,OFFSET ListCol

	MOV ListCol.lx,85
	MOV ListCol.pszText,OFFSET ColumTitle6
	INVOKE SendMessage,hwndList,LVM_INSERTCOLUMN,5,OFFSET ListCol
	RET

	Notify:
	MOV EAX,lParam
	MOV EAX, (NMHDR PTR [eax]).code
	CMP EAX,NM_RCLICK	
	JZ RightButton
	RET

	RightButton:
 
	; I really dont know what the 1032H message is..i just reversed this from
	; ProcDump. Should you know, you better mail me telling me so :).
	; In short: if you right click on the first cell of any row then this message
	; returns 1 in EAX, otherwise 0.

 	INVOKE SendMessage,hwndList,1032H,0,0
	TEST EAX,EAX
	JNZ ShowMenu
	RET

	ShowMenu:
	INVOKE GetCursorPos,ADDR Pt				; Mouse coordinates
	INVOKE TrackPopupMenu,hPopupMenu,TPM_LEFTALIGN,Pt.x,Pt.y,NULL,DialogHandle3,NULL	
											; Show menu	
	RET

	Command:
	MOV EAX,wParam
	CMP EAX,IDC_SPLITFILE					; Button to split file has been pressed?
	JZ SplitTheDamnFile

	CMP AX,IDM_DUMP							; User wants to dump section?
	JZ DumpOneSection
	RET

	DumpOneSection:
	; Which section has been selected?
	INVOKE SendMessage,hwndList,LVM_GETNEXTITEM,-1,LVNI_SELECTED	

	; EAX contains a 0 based index indicating which row has received the click
	; Why is this usefull? well, if you multiply that index by 28H
	; and then add that to the PE_OFFSET of a given file, you get the offset
	; to the desired section.
	PUSH EAX
	CALL Dump
	RET

	SplitTheDamnFile:

	; I learned this from R!SC's testy.asm
	; The deal is that we must get the 'real' size of the PE header.
	; By 'real' i mean the actual size of the header + the offset to the 
	; first section.

	CMP OpenPhile,1
	JNZ NothingToSplit
	XOR ECX,ECX
	MOV CX,[NTHeader.FileHeader.NumberOfSections]
	PUSH ECX
	MOV ESI,[MemMapPtr]
	ADD ESI,PE_OFFSET
	ADD ESI,0F8H					; Lets move to the section headers
	ADD ESI,14H						; We get to the Raw Offset
	MOV EAX,DWORD PTR [ESI]			; What we are trying to do here in this loop
	MoreRawOffsets:					; is to get the smallest Raw Offset
	CMP EAX,DWORD PTR [ESI]
	JB NextRawOffset
	MOV EAX,DWORD PTR [ESI]
	NextRawOffset:
	DEC ECX
	JZ NoMoreRawOffsets
	ADD ESI,28H 					; Go to next section
	JMP MoreRawOffsets
	NoMoreRawOffsets:
	; EAX contains how many bytes have to be written
	; ESI contains the pointer to data to write to file 
	MOV ESI,[MemMapPtr]
	PUSH EAX
	PUSH ESI
	PUSH OFFSET PeHeaderFileName
	CALL WriteThefile

	; Lets dump all sections
	ADD ESI,PE_OFFSET
	ADD ESI,0F8H
	POP ECX							; Restore NumberOfSections
	DumpNextSection:
	PUSH ESI
	PUSH ECX

	; 'SectionX.bin' incremented
	LEA EDI,DumpSectionName
	ADD EDI,7
	INC BYTE PTR [EDI]

	;EAX contains size of section
	MOV EAX,[ESI+10H]

	;EBX contains raw offset
	MOV EBX,[ESI+14H]
	ADD EBX,[MemMapPtr]

	PUSH EAX
	PUSH EBX
	PUSH OFFSET DumpSectionName
	CALL WriteThefile
	POP ECX
	DEC ECX
	JZ EndDump
	POP ESI
	ADD ESI,28H
	JMP DumpNextSection
	EndDump:

	;SectionX.bin reseted
	LEA EDI,DumpSectionName
	ADD EDI,7
	XOR EAX,EAX
	; AL contains the number of PE sections dumped
	MOV AL,BYTE PTR [EDI]
	; We increment it since we want to add the PE-Header dumping too
	INC AL
	MOV BYTE PTR [EDI],'0'
	LEA EDI,DumpSectionMsg
	MOV BYTE PTR [EDI],AL
	INVOKE MessageBox,0,OFFSET DumpSectionMsg,OFFSET Titulo,MB_OK

	NothingToSplit:
	RET

ChildDlgProc3	ENDP

; This procedure is for the Import Table dialog
ChildDlgProc4	PROC hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM

	LOCAL hwndImageList		: HANDLE		; Handle to the image list
	LOCAL hwndBitMap		: HANDLE		; H to a bitmap
	LOCAL TempBuffer[10]	: BYTE
	LOCAL TempBuffer2[10]	: BYTE
	LOCAL DllIndex			: DWORD
	LOCAL ItemCounter		: DWORD

	MOV EAX,uMsg

	CMP EAX,WM_INITDIALOG
	JZ _create3

	CMP EAX,WM_COMMAND
	JZ _command3

	CMP EAX,WM_NOTIFY
	JZ _notify3

	CMP EAX,WM_DRAWITEM
	JZ _drawitem3

	XOR EAX,EAX
	RET
	
	_drawitem3:
	RET

	_command3:
	MOV EAX,wParam
	CMP EAX,IDC_OFT
	JZ ShowThunk

	SHR EAX,16	  					; Here we process the subclassed Edit boxes
	CMP AX,EN_SETFOCUS
	JZ Focused3
	RET

	ShowThunk:
	INVOKE ShowWindow,DialogHandle5,SW_SHOWDEFAULT	
	RET

	Focused3:
	CMP VAFlag,1
	JZ nADA
	RET

	nADA:
	MOV EAX,wParam
	CMP AX,IDC_DLLNAME				; We do NOT want to process messages coming from these Edit boxes
	JZ NothingToDo
	CMP AX,IDC_TDS
	JZ NothingToDo
	CMP AX,IDC_FC
	JZ NothingToDo
	
	MOV EBX,lParam
	INVOKE GetWindowText,EBX,OFFSET DummyBuffer,20
	CMP EAX,0
	JZ  NothingToDo
	INVOKE SetDlgItemText,MainDialogHandle,IDC_ORIGINALRVA,OFFSET DummyBuffer
	MOV ECX,8
	LEA ESI,DummyBuffer
	LEA EDI,TempBuffer
	LEA EBX,TempBuffer2
	CALL StringToNumber
	PUSH [EBX]
	CALL RVA2Offset
	PUSH EAX
	PUSH OFFSET HexFormatter
	PUSH OFFSET DummyBuffer
	CALL wsprintfA
	ADD ESP,0CH
	INVOKE SetDlgItemText,MainDialogHandle,IDC_EQUIVVA,OFFSET DummyBuffer
	NothingToDo:
	RET

	_notify3:
 	; Message TVN_SELCHANGEDA comes 'inside' a WM_NOTIFY msg. The lParam is a pointer
	; to a NM_TREEVIEW struct, which contains other structures
	; and now in spanish :)
	; El mensaje TVN_SELCHANGEDA viene dentro de un WM_NOTIFY. El lParam es un puntero
	; a una estructura NM_TREEVIEW. Que a su vez contiene otras estructuras:

	; NM_TREEVIEW STRUCT DWORD
  	; hdr       NMHDR      <>
  	; action    DWORD      ?
  	; itemOld   TVITEM      <>
  	; itemNew   TVITEM      <>
  	; ptDrag    POINT      <>
	; NM_TREEVIEW ENDS

	; por eso en el codigo de abajo, yo busco el miembro code de la estructura hdr que
	; a su vez, esta dentro de NM_TREEVIEW. :)

	MOV EAX,lParam
	MOV EBX, (NM_TREEVIEW PTR [EAX]).hdr.code	
	; This translates to:
	; is the .code member inside the hdr structure inside the NM_TREEVIEW
	; structure pointed by EAX a TVN_SELCHANGE? hope you got that.
	CMP EBX,TVN_SELCHANGEDA					
	JZ ItemIsBeingSelected
	RET

	ItemIsBeingSelected:
	CMP Cleaning,1
	JZ NoChildrenHere

	; Now i send a TVM_GETITEM msg to check if the chosen item has any child
	; item.
	; If it has any child item that means:
	; 1) its the root item
	; 2) its some dll name.
	; if 1) then ret cos we dont want to process things coming from r00t.
	; if 2) we go on processing

	; Ahora mando un mensaje TVM_GETITEM para ver si el item elegido tiene algun child..
	; si tiene child,significa que es o bien:
	; 1) el root
	; 2) el nombre de ul dll
	; si es el root, ret
	; sino, sigo :)

	MOV EBX, (NM_TREEVIEW PTR [EAX]).itemNew.hItem
	MOV TVItem.hItem,EBX
	MOV TVItem.pszText,OFFSET pszText
	MOV TVItem.cchTextMax,cchTextMax
	MOV TVItem.imask,TVIF_CHILDREN OR TVIF_HANDLE OR TVIF_TEXT


	INVOKE SendMessage,hwndTreeView,TVM_GETITEM,0,OFFSET TVItem
	MOV EBX,TVItem.cChildren
	; If EBX is 1 then the item has children members.

	; Si EBX es 1 entonces HAY children, sino no

	CMP EBX,0
	JZ NoChildrenHere
	INVOKE SendMessage,hwndTreeView,TVM_GETNEXTITEM,TVGN_ROOT,0
	MOV EBX,TVItem.hItem
	CMP EAX,EBX					; Is the selected one, the root item?
	JZ NoChildrenHere

	; All entries in the List control are deleted
	INVOKE SendMessage,hwndList2,LVM_DELETEALLITEMS,0,0

	INVOKE SetDlgItemText,hWnd,IDC_DLLNAME,OFFSET pszText
	PUSH ImpRVA
	CALL RVA2Offset
	MOV ESI,[MemMapPtr]
	ADD ESI,EAX
	; Here we are in the 'door' of the IMAGE_IMPORT_DESCRIPTOR arrays

	; Aqui estamos en la puerta de los IMAGE_IMPORT_DESCRIPTOR arrays

	MOV DllIndex,-1
	NextDll:
	INC DllIndex
	PUSH ESI
	CMP DWORD PTR [ESI],0000
	JZ NoMoreDlls2
	; Here we fill a IMAGE_IMPORT_DESCRIPTOR structure
	LEA EDI,ImpDescriptor   	
	MOV ECX,size ImpDescriptor
	CLD
	REP MOVSB

	; Lets get the NAME of the dll 
	PUSH [ImpDescriptor.Nombre]
	CALL RVA2Offset
	MOV ESI,[MemMapPtr]
	ADD ESI,EAX
	CLD
	LEA EDI,DummyBuffer
	; We copy byte per byte that name to a variable
	NextChar2:
	CMP BYTE PTR [ESI],00
	JZ EndDllName2
	MOVSB
	JMP NextChar2
	EndDllName2:
	MOVSB			; Null character appended

	; Here we compare the name of the chosen dll and the name of the dll
	; we got from the file, if they are the same we go on..if not
	; then we'll try luck in the next IMAGE_IMPORT_DESCRIPTOR.

	LEA ESI,pszText
	LEA EDI,DummyBuffer
	INVOKE lstrcmp,ESI,EDI
	POP ESI
	ADD ESI,size ImpDescriptor
	CMP EAX,0  							; are they the same?
	JNZ NextDll
	LEA ESI,ImpDescriptor
	MOV EBX,IDC_OFIRSTTHUNK
	MOV ECX,5

	Twins:							; In this loop we set all the members 
	PUSH ECX						; of the IMAGE_IMPORT_DESCRIPTOR
	MOV EAX,[ESI]
	PUSH EAX
	PUSH OFFSET HexFormatter
	PUSH OFFSET DummyBuffer
	CALL wsprintfA
	ADD ESP,0CH
	INVOKE SetDlgItemText,hWnd,EBX,OFFSET DummyBuffer
	POP ECX
	ADD ESI,4
	ADD EBX,1
	LOOP Twins
	
	; Now we fill the List control in the dialogbox that appears when the 
	; user clicks on the OriginalFirstThunk button.

	MOV EAX,ImpRVA
	PUSH EAX
	CALL RVA2Offset
	MOV ESI,[MemMapPtr]
	ADD ESI,EAX
	MOV EBX,DllIndex				; Now we calculate the OFFSET our pointer has to move
	MOV EAX,20						; Multiplying the index of the dll chosen by 20 (size of each IMAGE_IMPORT_DESCRIPTOR struct)
	MUL EBX			
	ADD ESI,EAX	    				; Here we move to chosen IID
	PUSH ESI
	ADD ESI,12						; We add 12 in order to get the Dll's Name RVA
	PUSH [ESI]
	CALL RVA2Offset					
 	MOV ESI,[MemMapPtr]		
	ADD ESI,EAX			    		; We are now going to get the dll name so as to change the window's title
	LEA EDI,DummyBuffer
	nEXTcHAR:
	CMP BYTE PTR [ESI],0
	JZ nOmOREcHARS
	MOVSB
	JMP nEXTcHAR
	MOVSB
	nOmOREcHARS:
	INVOKE SetWindowText,DialogHandle5,OFFSET DummyBuffer
	POP ESI
	PUSH [ESI]
	CALL RVA2Offset					
	MOV ESI,[MemMapPtr]		
	ADD ESI,EAX			    		; We now are facing the array of IMAGE_THUNK_DATA Structures
	MOV ItemCounter,0				; This variable will count all the IMAGE_THUNK_DATA entries in the array

	NextIMAGE_THUNK_DATA:
	CMP DWORD PTR [ESI],0000		; No more RVA's to function names?
	JZ NoMoreITD
	
	MOV EAX,[ESI]					; First we get the RVA to the function name
 	PUSH EAX
	PUSH OFFSET HexFormatter
	PUSH OFFSET DummyBuffer
	CALL wsprintfA					; Turn it into some human readable thing
	ADD ESP,0CH						; Correct the stack :D
	PUSH ESI						; Lets save ESI for later use

    MOV ListItem.iSubItem,0 		; Lets start adding a OriginalFirstThunk				
	MOV ListItem.pszText,OFFSET DummyBuffer
	MOV EAX,ItemCounter
	MOV ListItem.iItem,EAX						; Index to this item
	INVOKE SendMessage,hwndList2,LVM_INSERTITEM,NULL,OFFSET ListItem

	MOV EAX,DWORD PTR [ESI]
	SHR EAX,16
	CMP AX,8000H					; Is it a function imported by its ordinal number?
	JZ ItsAnOrdinal
	PUSH [ESI]						; Lets go for the Hint and the Name
	CALL RVA2Offset
	MOV ESI,[MemMapPtr]		
	ADD ESI,EAX					    ; Now our MemMapPtr is facing a IMAGE_IMPORT_BY_NAME Structure
	XOR EAX,EAX
	MOV AX, WORD PTR [ESI]			; We now get the HINT n
	JMP DickHead
	ItsAnOrdinal:

	MOV EAX,DWORD PTR [ESI]
	JMP ComeHereBaby

	DickHead:
	PUSH EAX
	PUSH OFFSET HexFormatter
	PUSH OFFSET DummyBuffer
	CALL wsprintfA
	ADD ESP,0CH

	MOV EAX,ItemCounter						; Lets add the Hint to the List Control
	MOV ListItem.iItem,EAX
	MOV ListItem.iSubItem,1
	MOV ListItem.pszText,OFFSET DummyBuffer
    INVOKE SendMessage,hwndList2,LVM_SETITEM,NULL,OFFSET ListItem

	ADD ESI,2
	LEA EDI,pszText					; And finally We get the function name
	NextFuncChar:					; Byte per byte we transfer
	CMP BYTE PTR [ESI],0
	JZ NoMoreChars
	MOVSB
	JMP NextFuncChar
	NoMoreChars:
	MOVSB							; Lets append the damn \0 char
	LEA EAX, pszText
	PUSH EAX
	PUSH OFFSET StringFormatter
	PUSH OFFSET DummyBuffer
	CALL wsprintfA
	ADD ESP,0CH
	JMP RightHere

	ComeHereBaby:
	AND EAX,00FFH
	PUSH EAX
	PUSH OFFSET DecFormatter
	PUSH OFFSET DummyBuffer
	CALL wsprintfA
	ADD ESP,0CH

	RightHere:
	MOV ListItem.iSubItem,2			; And finally add it
	MOV ListItem.pszText,OFFSET DummyBuffer
    INVOKE SendMessage,hwndList2,LVM_SETITEM,NULL,OFFSET ListItem

	POP ESI							; Restore ESI going back to the IMAGE_THUNK_DATA array
	ADD ESI,4						; Of course we want the NEXT IMAGE_THUNK_DATA in the array
	INC ItemCounter					
	JMP NextIMAGE_THUNK_DATA
	NoMoreITD:

	; Ok now we got processed all the IMAGE_THUNK_DATA array, well
	; process now the OTHER IMAGE_THUNK_DATA array (the one the M$ Loader
	; will replace with function addresses)

	MOV EAX,ImpRVA
	PUSH EAX
	CALL RVA2Offset
	MOV ESI,[MemMapPtr]
	ADD ESI,EAX
	MOV EBX,DllIndex				; Now we calculate the OFFSET our pointer has to move
	MOV EAX,20						; Multiplying the index of the dll chosen by 20 (size of each IMAGE_IMPORT_DESCRIPTOR struct)
	MUL EBX			
	ADD ESI,EAX	    				; Here we move to chosen IID
	ADD ESI,16						; We add 16 in order to get the Second array's RVA
	PUSH [ESI]
	CALL RVA2Offset
	MOV ESI,[MemMapPtr]		
	ADD ESI,EAX			    		; We now are facing the (second) array of IMAGE_THUNK_DATA Structures	
	MOV ItemCounter,0
	
	NextSecondRva:
	CMP DWORD PTR [ESI],0000
	JZ NoMoreSecondDeal
 	PUSH [ESI]
	PUSH OFFSET HexFormatter
	PUSH OFFSET DummyBuffer
	CALL wsprintfA
	ADD ESP,0CH

	MOV EAX,ItemCounter
	MOV ListItem.iItem,EAX
	MOV ListItem.iSubItem,3			
	MOV ListItem.pszText,OFFSET DummyBuffer
    INVOKE SendMessage,hwndList2,LVM_SETITEM,NULL,OFFSET ListItem

	INC ItemCounter
	ADD ESI,4
	JMP NextSecondRva

	; I know i know, ill improve and optimize this :)
	NoMoreSecondDeal:
	RET

	; AQUI COSCAN
	NoMoreDlls2:
	NoChildrenHere:
	RET

	_create3:
	INVOKE CreateWindowEx,NULL,ADDR TreeViewClass,NULL,\
    WS_CHILD+WS_VISIBLE+TVS_HASLINES+TVS_LINESATROOT+TVS_HASBUTTONS+WS_BORDER,5,\
 	 5,160,210,hWnd,NULL,hInstance,NULL
	MOV hwndTreeView,eax

	; The ImageList that will be used with the TreeView control is created
	INVOKE ImageList_Create,16,16,ILC_COLOR16,2,10
	MOV hwndImageList,EAX

	; Bitmap is loaded
	INVOKE LoadBitmap,hInstance,IDB_BITMAP1
	MOV hwndBitMap,EAX

	; We add the bitmap to the imagelist
	INVOKE ImageList_Add,hwndImageList,hwndBitMap,0
	INVOKE DeleteObject,hwndBitMap

	; Now we must set that imagelist to the Tree,sending a TVM_SETIMAGELIST msg
	INVOKE SendMessage,hwndTreeView,TVM_SETIMAGELIST,TVSIL_NORMAL,hwndImageList

 	; Lets insert an element in the Tree
	MOV InsertStruct.hParent,0
	MOV InsertStruct.hInsertAfter,TVI_ROOT

	; learn spanish :)
	; Llenamos el miembro u del TV_INSERTSTRUCT, que a su vez es otra estructura
	MOV InsertStruct.u.item.imask,TVIF_TEXT+TVIF_IMAGE+TVIF_SELECTEDIMAGE
	MOV InsertStruct.u.item.pszText,OFFSET ParentMember
	MOV InsertStruct.u.item.iImage,0
	MOV InsertStruct.u.item.iSelectedImage,0
	INVOKE SendMessage,hwndTreeView,TVM_INSERTITEM,0,addr InsertStruct
	MOV hwndParentTree,EAX

	; Now we create the THUNK_DATA dialog
	MOV EAX,OFFSET ChildDlgProc5
	INVOKE CreateDialogParam,hInstance,OFFSET DlgName5,hWnd,EAX,0
	MOV DialogHandle5,EAX
	RET

ChildDlgProc4	ENDP

; This procedure is for the 'OriginalFirstThunk' dialogbox
ChildDlgProc5	PROC hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM

	MOV EAX,uMsg
	CMP EAX,WM_INITDIALOG
	JZ _create5
	CMP EAX,WM_CLOSE
	JZ _close5
	XOR EAX,EAX
	RET

	_close5:
	INVOKE ShowWindow,DialogHandle5,SW_HIDE
	RET

	_create5:
	; We get the handle to the List control
	INVOKE GetDlgItem,hWnd,IDC_LIST2	
	MOV hwndList2,EAX

	; Agregamos las columnas al List Control
	MOV ListCol.lx,110								
	MOV ListCol.pszText,OFFSET ColumTitle7		
	MOV ListCol.iSubItem,0
	INVOKE SendMessage,hwndList2,LVM_INSERTCOLUMN,0,OFFSET ListCol

	MOV ListCol.lx,65
	MOV ListCol.pszText,OFFSET ColumTitle8
	INVOKE SendMessage,hwndList2,LVM_INSERTCOLUMN,1,OFFSET ListCol

	MOV ListCol.lx,110
	MOV ListCol.pszText,OFFSET ColumTitle9
	INVOKE SendMessage,hwndList2,LVM_INSERTCOLUMN,2,OFFSET ListCol

	MOV ListCol.lx,120
	MOV ListCol.pszText,OFFSET ColumTitle10
	INVOKE SendMessage,hwndList2,LVM_INSERTCOLUMN,3,OFFSET ListCol
	RET

ChildDlgProc5	ENDP
; This procedure is the one that handles the sub-classed Editboxes
NewProc		PROC hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM

	MOV EAX,uMsg
	CMP EAX,WM_SETCURSOR
	JZ SetCursorz

	; If its not the WM_SETCURSOR then we want the 'original' procedure to 
	; take care of the message,thus we call CallWindowProc with the control's
	; old procedure as a parameter.

	CallWinProc:
	INVOKE CallWindowProc,OldProc,hWnd,uMsg,wParam,lParam
	RET

	SetCursorz:
	MOV EAX,1			; Returning 1 means 'dont change cursor'
	RET

NewProc		ENDP

Init	PROC hWnd:HWND

	MOV ofn.lStructSize,SIZEOF ofn 
	MOV ofn.hWndOwner,NULL
   	PUSH hInstance 
   	POP  ofn.hInstance 
   	MOV ofn.lpstrFilter, OFFSET FilterString 
   	MOV ofn.lpstrFile, OFFSET FileNameBuffer
   	MOV ofn.nMaxFile,260
   	MOV ofn.Flags, OFN_FILEMUSTEXIST or \ 
   	OFN_PATHMUSTEXIST or OFN_LONGNAMES or\ 
   	OFN_EXPLORER or OFN_HIDEREADONLY 
   	MOV  ofn.lpstrTitle, OFFSET OFNTitle
   	INVOKE GetOpenFileName, OFFSET ofn 		 ; Show dialog
	CMP EAX,FALSE
	JZ NadaSeEligio

	CMP OpenPhile,1
	JNZ NoOpenPhile

	CALL WinstonWolf

	NoOpenPhile:
	INVOKE CreateFile,OFFSET FileNameBuffer,GENERIC_READ,0,0,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0
	CMP EAX,-1
	JZ OpenFileError
	MOV FileHandle,EAX
	MOV OpenPhile,1

	INVOKE SetDlgItemText,hWnd,IDC_FILENAME,OFFSET FileNameBuffer
	
	INVOKE GetFileSize,FileHandle,NULL

	PUSH EAX
	PUSH OFFSET HexFormatter
	PUSH OFFSET DummyBuffer
	CALL wsprintfA
	INVOKE SetDlgItemText,hWnd,IDC_FILESIZE,OFFSET DummyBuffer

	;Lets read the Dos header
	INVOKE ReadFile,FileHandle,OFFSET DosHeader,sizeof DosHeader,OFFSET DummyBuffer,0

	MOV EAX,[DosHeader.e_lfanew]
	MOV PE_OFFSET,EAX

	INVOKE SetFilePointer,FileHandle,PE_OFFSET,0,FILE_BEGIN	

	; Lets read the PE header
	INVOKE ReadFile,FileHandle,OFFSET NTHeader,sizeof NTHeader,OFFSET DummyBuffer,0
	CMP [NTHeader.Signature],'EP'
	JNZ NotPEFile

	; Si el archivo es un PE file,lo memory mapeamos
	; Memory mapped!
	INVOKE CreateFileMapping,FileHandle,NULL,PAGE_READONLY,0,0,0	
	MOV hwndMappedFile,EAX

	INVOKE MapViewOfFile,hwndMappedFile,FILE_MAP_READ,0,0,0
	MOV MemMapPtr,EAX

	PUSH hWnd
	CALL SectionNames
	CALL PEInfo
	CALL GetImportTable
	Fin:
	RET

	OpenFileError:
	INVOKE MessageBox,0,OFFSET OpenFileErrorMsg,0,MB_OK
	JMP Fin

	NotPEFile:
	INVOKE MessageBox,0,OFFSET NotPEFileMsg,0,MB_OK
	JMP Fin

	NadaSeEligio:
	JMP Fin
Init ENDP

GetImportTable		PROC

	LOCAL RootHwnd		: DWORD		; Handle for root TreeView Control item
	LOCAL ChldHwnd		: HANDLE	; Handle for child treeview control item 
	LOCAL InitTree		: BYTE		; Flag

	; We get the handle to the root item.
	INVOKE SendMessage,hwndTreeView,TVM_GETNEXTITEM,TVGN_ROOT,0
	MOV RootHwnd,EAX

	LEA EAX,[NTHeader.OptionalHeader.NumberOfRvaAndSizes]
	ADD EAX,12
	MOV EAX,[EAX]		; Here we obtain the RVA to the import table
	MOV ImpRVA,EAX		; and we keep it inside a variable
	PUSH ImpRVA
	CALL RVA2Offset
	
	; Llenemos una estructura de tipo IMPORT_DESCRIPTOR 
	
	MOV ESI,[MemMapPtr]
	ADD ESI,EAX
	XOR EDX,EDX							; Counts entries in the Treeview
	NextDll:
	PUSH ESI
	CMP DWORD PTR [ESI],0000			; No more dll's ????
	JZ NoMoreDlls
	LEA EDI,ImpDescriptor
	MOV ECX,size ImpDescriptor
	CLD
	REP MOVSB							; we fill the ImpDescriptor structure

	; Lets copy the Name of the dll
	PUSH [ImpDescriptor.Nombre]			; PUSH RVA to the Dll Name
	CALL RVA2Offset						; Gimme its OFFSET
	MOV ESI,[MemMapPtr]					; Esi points to memory mapped file
	ADD ESI,EAX							; Esi now points to DLL Name
	CLD
	LEA EDI,DummyBuffer					; DummyBuffer will receive that name
	NextChar:
	CMP BYTE PTR [ESI],00				; No more chars?
	JZ EndDllName				
	MOVSB					    		; Copy it to DummyBuffer
	JMP NextChar
	EndDllName:
	MOVSB								; Null character appended

	MOV EAX,hwndParentTree				; Insert it in the tree
	MOV InsertStruct.hParent,EAX
	MOV InsertStruct.hInsertAfter,TVI_LAST
	MOV InsertStruct.u.item.pszText,OFFSET DummyBuffer
	INVOKE SendMessage,hwndTreeView,TVM_INSERTITEM,0,OFFSET InsertStruct
	
	CMP InitTree,0
	JZ NextCheck

	; Here we get the handle to the 'next item' so we add all the functions
	; to the corresponding DLL.

	INVOKE SendMessage,hwndTreeView,TVM_GETNEXTITEM,TVGN_NEXT,ChldHwnd
	MOV ChldHwnd,EAX

	NextCheck:
	CMP InitTree,1
	JZ YaEsta
	MOV EAX,RootHwnd
	INVOKE SendMessage,hwndTreeView,TVM_GETNEXTITEM,TVGN_CHILD,EAX
	MOV ChldHwnd,EAX
	MOV InitTree,1
	YaEsta:

	; lets read each dll function
	PUSH [ImpDescriptor.OriginalFirstThunk]
	CALL RVA2Offset
	
	MOV ESI,[MemMapPtr]
	ADD ESI,EAX
	
	NextFunction:
	CMP BYTE PTR [ESI],0			; No more DLL functions?
	JZ NoMoreFunctions
	MOV EAX,DWORD PTR [ESI]
	SHR EAX,16
	CMP AX,8000H
	MOV EAX,DWORD PTR [ESI]
	PUSH ESI

	JZ Ordinal
	PUSH EAX
	CALL RVA2Offset

	MOV ESI,[MemMapPtr]
	LEA EDI,DummyBuffer
	ADD ESI,EAX
	ADD ESI,2
	NextChar2:
	CMP BYTE PTR [ESI],00
	JZ AddFunction
	MOVSB
	JMP NextChar2

	Ordinal:
	XOR EBX,EBX
	MOV BX,AX
	PUSH EDX
	PUSH EBX
	PUSH OFFSET DecFormatter
	PUSH OFFSET DummyBuffer
	CALL wsprintfA
	ADD ESP,0CH
	POP EDX
	JMP AddFunction2
	AddFunction:
	MOVSB
	AddFunction2:
	MOV EAX,ChldHwnd
	MOV InsertStruct.hParent,EAX
	MOV InsertStruct.hInsertAfter,TVI_FIRST	
 	MOV InsertStruct.u.item.imask,TVIF_TEXT+TVIF_IMAGE+TVIF_SELECTEDIMAGE
	MOV InsertStruct.u.item.pszText,OFFSET DummyBuffer
   	MOV InsertStruct.u.item.iImage,0
	MOV InsertStruct.u.item.iSelectedImage,0
	INVOKE SendMessage,hwndTreeView,TVM_INSERTITEM,0,OFFSET InsertStruct
		
	EndDllFunction:
	POP ESI
	ADD ESI,4
	JMP NextFunction
	NoMoreFunctions:
	POP ESI
	ADD ESI,SIZE ImpDescriptor
	INC EDX
	JMP NextDll
	NoMoreDlls:
	
	RET

GetImportTable		ENDP

SectionNames	PROC hWnd:HWND

	
	; Lets read the section headers names
	XOR ECX,ECX
	MOV CX,[NTHeader.FileHeader.NumberOfSections]
	MOV EAX,PE_OFFSET
	ADD EAX,0F8H
	XOR EBX,EBX		; EBX es el contador de secciones

	ReadSection:
	PUSH ECX
	PUSH EAX
	INVOKE SetFilePointer,FileHandle,EAX,0,FILE_BEGIN
	INVOKE ReadFile,FileHandle,OFFSET SectionName,8,OFFSET DummyBuffer,0
	INVOKE ReadFile,FileHandle,OFFSET SectionHeader,32,OFFSET DummyBuffer,0

	; Se inserta el nombre de cada Header
	MOV ListItem.imask,LVIF_TEXT					; Solo texto
    MOV ListItem.iSubItem,0 						; no esta claro
	MOV ListItem.pszText,OFFSET SectionName			; el texto que ira			   	
	MOV ListItem.iItem,EBX							; el index del nuevo item
	INVOKE SendMessage,hwndList,LVM_INSERTITEM,NULL,OFFSET ListItem
	PUSH EBX
	; Se inserta el Virtual Size
	PUSH [SectionHeader.VirtualSize]
	PUSH OFFSET HexFormatter
	PUSH OFFSET DummyBuffer
	CALL wsprintfA
	ADD ESP,0CH
	POP EBX
	MOV ListItem.imask,LVIF_TEXT			; Solo texto
	MOV ListItem.iSubItem,1					; no esta claro
	MOV ListItem.pszText,OFFSET DummyBuffer	; el texto que ira			   	
	MOV ListItem.iItem,EBX					; el index del nuevo item
	INVOKE SendMessage,hwndList,LVM_SETITEM,NULL,OFFSET ListItem

	PUSH EBX
	PUSH [SectionHeader.VirtualAddress]
	PUSH OFFSET HexFormatter
	PUSH OFFSET DummyBuffer
	CALL wsprintfA
	ADD ESP,0CH
	POP EBX
	MOV ListItem.imask,LVIF_TEXT			; Solo texto
   	MOV ListItem.iSubItem,2					; no esta claro
	MOV ListItem.pszText,OFFSET DummyBuffer	; el texto que ira			   	
	MOV ListItem.iItem,EBX					; el index del nuevo item
	INVOKE SendMessage,hwndList,LVM_SETITEM,NULL,OFFSET ListItem

	PUSH EBX
	PUSH [SectionHeader.SizeOfRawData]
	PUSH OFFSET HexFormatter
	PUSH OFFSET DummyBuffer
	CALL wsprintfA
	ADD ESP,0CH
	POP EBX
	MOV ListItem.imask,LVIF_TEXT			; Solo texto
   	MOV ListItem.iSubItem,3					; no esta claro
	MOV ListItem.pszText,OFFSET DummyBuffer	; el texto que ira			   	
	MOV ListItem.iItem,EBX					; el index del nuevo item
	INVOKE SendMessage,hwndList,LVM_SETITEM,NULL,OFFSET ListItem

	PUSH EBX
	PUSH [SectionHeader.PointerToRawData]
	PUSH OFFSET HexFormatter
	PUSH OFFSET DummyBuffer
	CALL wsprintfA
	ADD ESP,0CH
	POP EBX
	MOV ListItem.imask,LVIF_TEXT			; Solo texto
   	MOV ListItem.iSubItem,4					; no esta claro
	MOV ListItem.pszText,OFFSET DummyBuffer	; el texto que ira			   	
	MOV ListItem.iItem,EBX					; el index del nuevo item
	INVOKE SendMessage,hwndList,LVM_SETITEM,NULL,OFFSET ListItem

	PUSH EBX
	PUSH [SectionHeader.Characteristics]
	PUSH OFFSET HexFormatter
	PUSH OFFSET DummyBuffer
	CALL wsprintfA
	ADD ESP,0CH
	POP EBX
	MOV ListItem.imask,LVIF_TEXT			
    MOV ListItem.iSubItem,5					
	MOV ListItem.pszText,OFFSET DummyBuffer
	MOV ListItem.iItem,EBX					
	INVOKE SendMessage,hwndList,LVM_SETITEM,NULL,OFFSET ListItem

	INC EBX
	POP EAX
	ADD EAX,40
	POP ECX
	CMP EBX,ECX
	JB ReadSection

	RET

SectionNames	ENDP

PEInfo	PROC


	CALL Machine
	XOR EAX,EAX
	; Se procesan los Numbers of Section
  	MOV AX,[NTHeader.FileHeader.NumberOfSections]
	PUSH EAX
	PUSH OFFSET HexFormatter
	PUSH OFFSET DWORDVALUE
	CALL wsprintfA
	ADD ESP,0CH
	INVOKE SetDlgItemText,DialogHandle1,IDC_NOFSECTIONS,OFFSET DWORDVALUE

	; Se procesa el Size Of Optional Header  
	XOR EAX,EAX
	MOV AX,[NTHeader.FileHeader.SizeOfOptionalHeader]
	PUSH EAX
	PUSH OFFSET HexFormatter
	PUSH OFFSET DWORDVALUE
	CALL wsprintfA
	ADD ESP,0CH
	INVOKE SetDlgItemText,DialogHandle1,IDC_SIZEOPTHEAD,OFFSET DWORDVALUE

	XOR EAX,EAX
	MOV AX,[NTHeader.FileHeader.Characteristics]
	PUSH EAX
	PUSH OFFSET HexFormatter
	PUSH OFFSET DWORDVALUE
	CALL wsprintfA
	ADD ESP,0CH
	INVOKE SetDlgItemText,DialogHandle1,IDC_CHARACTERISTICS,OFFSET DWORDVALUE

	
 	MOV EAX,[NTHeader.OptionalHeader.AddressOfEntryPoint]
	PUSH EAX
	PUSH OFFSET HexFormatter
	PUSH OFFSET DWORDVALUE
	CALL wsprintfA
	ADD ESP,0CH
	INVOKE SetDlgItemText,DialogHandle1,IDC_ENTRYPOINT,ADDR DWORDVALUE

	MOV EAX,[NTHeader.OptionalHeader.SectionAlignment]
	PUSH EAX
	PUSH OFFSET HexFormatter
	PUSH OFFSET DWORDVALUE
	CALL wsprintfA
	ADD ESP,0CH
	INVOKE SetDlgItemText,DialogHandle1,IDC_SECTIONALIGN,ADDR DWORDVALUE

	MOV EAX,[NTHeader.OptionalHeader.FileAlignment]
	PUSH EAX
	PUSH OFFSET HexFormatter
	PUSH OFFSET DWORDVALUE
	CALL wsprintfA
	ADD ESP,0CH
	INVOKE SetDlgItemText,DialogHandle1,IDC_FILEALIGN,ADDR DWORDVALUE

	MOV EAX,[NTHeader.OptionalHeader.SizeOfImage]
	PUSH EAX
	PUSH OFFSET HexFormatter
	PUSH OFFSET DWORDVALUE
	CALL wsprintfA
	ADD ESP,0CH
	INVOKE SetDlgItemText,DialogHandle1,IDC_IMAGESIZE,ADDR DWORDVALUE

	MOV EAX,[NTHeader.OptionalHeader.SizeOfHeaders]
	PUSH EAX
	PUSH OFFSET HexFormatter
	PUSH OFFSET DWORDVALUE
	CALL wsprintfA
	ADD ESP,0CH
	INVOKE SetDlgItemText,DialogHandle1,IDC_HEADERSIZE,ADDR DWORDVALUE

	MOV EAX,[NTHeader.OptionalHeader.ImageBase]
	PUSH EAX
	PUSH OFFSET HexFormatter
	PUSH OFFSET DWORDVALUE
	CALL wsprintfA
	ADD ESP,0CH
	INVOKE SetDlgItemText,DialogHandle1,IDC_IMAGEBASE,ADDR DWORDVALUE


	RET

PEInfo	ENDP

Machine	PROC

	MOV AX,[NTHeader.FileHeader.Machine]

	CMP AX,14CH
	JZ _14C
	CMP AX,14DH
	JZ _14D
	CMP AX,14EH
	JZ _14E
;	CMP AX,160
;	JZ _160
;	CMP AX,162
;	JZ _162
;	CMP AX,166
;	JZ _166
;	CMP AX,168
;	JZ _168
;	CMP AX,184
;	JZ _184
;	CMP AX,1F0H
;	JZ _1F0

	_14C:
	MOV EBX,OFFSET i386
	JMP SetText

	_14D:
	MOV EBX,OFFSET i486
	JMP SetText

	_14E:
	MOV EBX,OFFSET Pentium
	JMP SetText

;	_160:
;	MOV EBX,OFFSET BR3000
;	JMP SetText

;	_162:
;	MOV EBX,OFFSET LR3000
;	JMP SetText

;	_166:
;	MOV EBX,OFFSET R4000
;	JMP SetText

;	_168:
;	MOV EBX,OFFSET R10000
;	JMP SetText

;	_184:
;	MOV EBX,OFFSET DecAlpha
;	JMP SetText

;	_1F0:
;	MOV EBX,OFFSET IBMPower

	SetText:
	INVOKE SetDlgItemText,DialogHandle1,IDC_MACHINE,EBX
	RET
Machine	ENDP

RVA2Offset	PROC RVA:DWORD

	XOR ECX,ECX
	MOV CX,[NTHeader.FileHeader.NumberOfSections]

	MOV EAX,PE_OFFSET
	ADD EAX,100H
	MOV ESI,[MemMapPtr]
	ADD ESI,EAX
	XOR EBX,EBX		; EBX es el contador de secciones

	; va seccion por seccion

	ImpReadSection:
	PUSH ESI
	; toma el Virtual Offset de cada seccion
	ADD ESI,4
	MOV EAX,DWORD PTR [ESI]
	; le suma el Raw size
	ADD ESI,4
	ADD EAX,DWORD PTR [ESI]
	; si el Virtual Offset + Raw Size es MAYOR a lo pasado como parametro, entonces
	CMP RVA,EAX
	; a lo inputeado se le resta el Virtual Offset y se le suma el Raw Offset.
	JAE ProximaSeccion
	MOV EBX,RVA
	SUB ESI,4
	SUB EBX,DWORD PTR [ESI]
	ADD ESI,8
	ADD EBX,DWORD PTR [ESI]
	JMP GotsTheOffset
	ProximaSeccion:
	POP ESI
	ADD ESI,40
	DEC ECX
	JMP ImpReadSection
	GotsTheOffset:
	MOV EAX,EBX
	RET

RVA2Offset	ENDP

WriteThefile PROC PhileName:DWORD,DataBuffer:DWORD,Cantidad:DWORD
 
	LOCAL	FileHwnd	:	HANDLE
	PUSHAD

	INVOKE CreateFile,PhileName,GENERIC_WRITE,0,0,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0	
	CMP EAX,-1
	JZ FileIOError
	MOV FileHwnd,EAX
	
	INVOKE WriteFile,FileHwnd,DataBuffer,Cantidad,OFFSET DummyBuffer,0
	CMP EAX,0
	JZ FileIOError

	INVOKE CloseHandle,FileHwnd
	RET

	FileIOError:
	INVOKE MessageBox,0,OFFSET FileIOErrorMsg,0,MB_OK
	RET

WriteThefile ENDP

WinstonWolf		PROC
   
	; Si a lo que apunta MemMapPtr es -1, significa que ya se llamo a 
	; UnmapViewOfFile y el puntero apunta a nada,por eso no podemos seguir
	; ya que si se llama a Rva2Offset con un puntero null, crashea todo
	MOV Cleaning,1
	INVOKE UnmapViewOfFile,MemMapPtr
	INVOKE CloseHandle, hwndMappedFile
	INVOKE CloseHandle, FileHandle
	MOV OpenPhile,0

   ; Edit boxes are cleaned
   ; Pe info editboxes
	MOV ESI,11
	MOV EBX,IDC_MACHINE
	WipeIt:
	INVOKE SetDlgItemText,DialogHandle1,EBX,0
	INC EBX
	DEC ESI
	JNZ WipeIt

	; Import Table editboxes
	MOV ESI,6
	MOV EBX,IDC_DLLNAME
	WipeIt2:
	INVOKE SetDlgItemText,DialogHandle4,EBX,0
	INC EBX
	DEC ESI
	JNZ WipeIt2

	; Main dialogbox 
	MOV ESI,4
	MOV EBX,IDC_ORIGINALRVA
	WipeIt3:
	INVOKE SetDlgItemText,MainDialogHandle,EBX,0
	INC EBX
	DEC ESI
	JNZ WipeIt3
	
	; RVAtoVA CheckBox cleared and Cursor returns to normal
	INVOKE CheckDlgButton,MainDialogHandle,IDC_R2VCHECK,BST_UNCHECKED	
	INVOKE LoadCursor,NULL,IDC_ARROW
	INVOKE SetClassLong,MainDialogHandle,GCL_HCURSOR,EAX	

	; Import table tree-view Control cleared
 	INVOKE SendMessage,hwndTreeView,TVM_DELETEITEM,0,0

	; Section headers is cleaned
	INVOKE SendMessage,hwndList,LVM_DELETEALLITEMS,0,0

	; THUNK List control deleted
	INVOKE SendMessage,hwndList2,LVM_DELETEALLITEMS,0,0

	MOV InsertStruct.hParent,0
	MOV InsertStruct.hInsertAfter,TVI_ROOT
	MOV InsertStruct.u.item.imask,TVIF_TEXT+TVIF_IMAGE+TVIF_SELECTEDIMAGE
	MOV InsertStruct.u.item.pszText,OFFSET ParentMember
	MOV InsertStruct.u.item.iImage,0
	MOV InsertStruct.u.item.iSelectedImage,0
	INVOKE SendMessage,hwndTreeView,TVM_INSERTITEM,0,addr InsertStruct
	MOV hwndParentTree,EAX
	
	MOV Cleaning,0
	RET

WinstonWolf		ENDP

Dump				PROC SectionIndex:DWORD

	LOCAL PhileHandle:	HANDLE

	MOV ESI,[MemMapPtr]

	;CMP SectionIndex, -1			; If this parameter is -1 we dont want to dump a section but just any part of
	;JZ xxxxxxx				; the program

 	DumpASection:
    MOV ofn.Flags,OFN_PATHMUSTEXIST or OFN_LONGNAMES or OFN_EXPLORER or OFN_HIDEREADONLY 
	MOV BYTE PTR FileNameBuffer,NULL
	MOV ofn.lpstrTitle, OFFSET OFNTitle2

	INVOKE GetSaveFileName, OFFSET ofn 
	CMP EAX,FALSE
	JZ NothingToSave
	CMP ofn.nFileExtension,NULL				; User did not type an extension?
	JNZ TypedAnExtension
	MOV EAX,ofn.nFilterIndex
	CMP EAX,4								; User chose *.* ?
	JZ TypedAnExtension
	XOR EBX,EBX								; Contador
	LEA ESI,FilterString
	MOV ECX,size FilterString				; Cuanto hay que loopear?
	tHERE:
	LODSB
	CMP AL,0								; Null?
	JNZ tHERE
	PossibleEOFString:
	CMP BYTE PTR [ESI],'*'
	JNZ tHERE
	INC EBX
	CMP EBX,ofn.nFilterIndex
	JNZ tHERE
	PUSH ESI
	LEA EDI,FileNameBuffer
	NullSearch:
	MOV AL,BYTE PTR [EDI]
	INC EDI
	CMP AL,0
	JNZ NullSearch
	SUB EDI,1
	POP ESI
	INC ESI
	MOVSD								; The file extension is appended to the FileNameBuffer
	MOV BYTE PTR [EDI],0				; Lets append the NULL byte

	TypedAnExtension:
	INVOKE CreateFile,OFFSET FileNameBuffer,GENERIC_WRITE,0,0,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0	
	CMP EAX,-1
	JZ FileIOError2
	MOV PhileHandle, EAX
	MOV ESI,[MemMapPtr]
	ADD ESI,PE_OFFSET 
	ADD ESI,0F8H 
	MOV EAX,SectionIndex
	MOV EBX,28H
	MUL EBX
	ADD ESI,EAX
	MOV EAX,[ESI+10H]
	MOV EBX,[ESI+14H]
	ADD EBX,[MemMapPtr]
	INVOKE WriteFile,PhileHandle,EBX,EAX,OFFSET DummyBuffer,0
	CMP EAX,0
	JZ FileIOError2
	INVOKE CloseHandle,PhileHandle
	INVOKE MessageBox,0,OFFSET DumpOk,OFFSET Titulo,MB_OK
	NothingToSave:
	RET
  	
	FileIOError2:
	INVOKE MessageBox,0,OFFSET FileIOErrorMsg,0,MB_OK
	RET

Dump				ENDP


end Starts

;Bye! :)
