; Rotating Font Example
;
; This example program show how to create and use a TrueType rotating font
; using 100% assembly languaje, for Windows.
;
; Dolphinz - Spain
; http://personal5.iddeo.es/ret007ow/index.html
;

.386p                                   ; use 80386 instruction set
.model flat, stdcall                    ; memory model to use under windows
include win32.inc                       ; my include file, contains
                                        ; all the win32 equates I'll use.

extrn           GetModuleHandleA: PROC
extrn           LoadIconA       : PROC
extrn           LoadCursorA     : PROC
extrn           RegisterClassA  : PROC
extrn           CreateWindowExA : PROC
extrn           PostQuitMessage : PROC
extrn           GetMessageA     : PROC
extrn           TranslateMessage: PROC
extrn           DispatchMessageA: PROC
extrn           DefWindowProcA  : PROC
extrn           ExitProcess     : PROC
extrn           GetClientRect   : PROC
extrn           SetTimer        : PROC
extrn           KillTimer       : PROC
extrn           CreateFontA     : PROC
extrn           GetDC           : PROC
extrn           ReleaseDC       : PROC
extrn           SelectObject    : PROC
extrn           DeleteObject    : PROC
extrn           SetTextColor    : PROC
extrn           TextOutA        : PROC

ID_TIMER        equ             1
IDI_ICON        equ             100
IDR_MENU        equ             200
IDM_EXIT        equ             300

.DATA                                           ; data segment

;========== Structures
msg         	MSG	    	<?>
wc          	WNDCLASS    	<?>
Rect            RECT            <?>

;========== Handles
hMain           dd      0                       ; Main window handle
hInst           dd      0                       ; Instance handle
hDC             dd      0                       ; Device Context handle
hFont           dd      0                       ; Font handle

;========== Strings
szProgName      db      'Rotating Font Example',0
szMainClass     db      'RFONT',0
szFont          db      'Dolphinz',0            ; Font name
iAngle          dd      0

.CODE                                           ; code segment
;-----------------------------------------------------------------------------
start:
        call    GetModuleHandleA, 0          
        mov     hInst, eax 

        mov     [wc.style], CS_HREDRAW + CS_VREDRAW
        mov     [wc.lpfnWndProc], offset WndProc
        mov     [wc.cbClsExtra], 0
        mov     [wc.cbWndExtra], 0

        mov     eax, [hInst]
        mov     [wc.hInstance], eax

        call    LoadIconA, hInst, IDI_ICON      ; Here we load the icon
        mov     [wc.hIcon], eax

        call    LoadCursorA, 0, IDC_ARROW       ; Load the cursor
        mov     [wc.hCursor], eax
                                                
        mov     [wc.hbrBackground], 5+1
        mov     dword ptr [wc.lpszMenuName], IDR_MENU
        mov     dword ptr [wc.lpszClassName], offset szMainClass
        push    offset wc
        call    RegisterClassA       

        call    CreateWindowExA, 0, offset szMainClass, offset szProgName,\
                                 WS_VISIBLE OR WS_CAPTION OR WS_SYSMENU OR WS_THICKFRAME,\
                                 100,50,250,250,0,0, hInst, 0
	mov	hMain, eax

        ; It's not necessary to use ShowWindow() and UpdateWindow()
        ; since I'm using WS_VISIBLE as a style for the main window.

msg_loop:
        call    GetMessageA, offset msg, 0, 0, 0
        cmp     ax, 0
        je      end_loop
        call    TranslateMessage, offset msg
        call    DispatchMessageA, offset msg
        jmp     msg_loop
end_loop:
        call    ExitProcess, 0

;-----------------------------------------------------------------------------
WndProc         proc    Hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD     
        movzx   eax,    WORD PTR wmsg
        .if     eax == WM_DESTROY
                jmp     wmdestroy
        .elseif eax == WM_CREATE
                jmp     wmcreate
        .elseif eax == WM_TIMER
                jmp     wmtimer
        .elseif eax == WM_COMMAND
                jmp     wmcommand
        .else
                call    DefWindowProcA, Hwnd, wmsg, wparam, lparam
                jmp     @@End
        .endif
                xor     eax, eax
        @@End:
                ret

wmcreate:
        call    SetTimer, Hwnd, ID_TIMER, 100, 0 ; Start a timer
        xor     eax, eax
        ret

wmcommand:
        mov     eax, wparam
        cmp     eax, IDM_EXIT
        je      wmdestroy
        xor     eax, eax
        ret

wmtimer:
        call    GetDC, Hwnd                     ; Get a DC to the window
        mov     hDC, eax
                                                ; Create our font
        call    CreateFontA, 24, 0,iAngle,0,FW_EXTRABOLD,\
                            0,0,0,0,0,0,0,0,offset szFont
        mov     hFont, eax
        call    SelectObject, hDC, hFont        ; Select font
        call    SetTextColor, hDC, 0FFFFFFh     ; White Color

        call    GetClientRect, Hwnd, offset Rect

        mov     eax, Rect.Right                 ; Rect.Right=Rect.Right/2
        xor     edx, edx
        mov     ebx, 2
        div     ebx
        mov     ecx, eax
        mov     Rect.Right, eax

        mov     eax, Rect.Bottom                ; Rect.Bottom=Rect.Bottom/2
        xor     edx, edx
        mov     ebx, 2
        div     ebx
        mov     Rect.Bottom, eax
                                                ; Draw the white text at last angle
        call    TextOutA, hDC, Rect.Right, Rect.Bottom, offset szFont, 8

        add     iAngle, 100                     ; Update new angle value
        .if     iAngle >= 3600
                mov     iAngle, 0               ; Reset angle
        .endif

        call    SelectObject,hDC, hFont         ; Select old font
        call    DeleteObject, eax               ; and delete it
                                                ; Create the font
        call    CreateFontA,24,0,iAngle,0,FW_EXTRABOLD,\
                            0,0,0,0,0,0,0,0,offset szFont
        mov     hFont, eax
        call    SelectObject,hDC,hFont

        call    SetTextColor,hDC, 0FF0000h        ; Text color
                                                ; Draw the black text at last angle                        
        call    TextOutA,hDC,Rect.Right,Rect.Bottom,offset szFont, 8

        call    DeleteObject, hFont             ; Delete font
        call    ReleaseDC, Hwnd, hDC
        xor     eax, eax
        ret

wmdestroy:
        call    KillTimer, Hwnd, ID_TIMER       ; Kill the timer
        call    PostQuitMessage, 0
        xor     eax, eax
        ret
WndProc         endp
public  WndProc

        ends
        end start

