; CP.ASM -- A simple file copy program.
;
; Assembles with Borland Turbo Assembler 4.0
; Use:
;   TASM /m /ml cp
;
; where
;   /m  = multiple passes
;   /ml = case sensitive
;
; Link with:
;   TLINK32 /Tpe /ap /c cp,,,fulldir\import32.lib
;
; where
;   /Tpe  = Win32 (PE) .EXE
;   /aa   = Windows non-console app
;   /c    = case sensitive external and public symbols
;
; Link to VC++ library (assuming environment variables are set) with:
;   LINK cp kernel32.lib /entry:start /subsystem:console
;
	.386
	.model	flat

	; choose the following, if necessary
	include	vclib.inc	; Microsoft VC++ .lib entry names

	include	win32.inc	; constants and structures
;
; Start of program
; Get command line and initialize program
;
	public	_start	; public status ignored by Borland linker

	.code				; simplified segment directive
_start:

	.data
cmd_line_ptr	dd	0

	extrn	GetCommandLine:near

	.code
;	extrn	__imp__GetCommandLineA@0:dword	; must be DWORD !!!
;	call	__imp__GetCommandLineA@0		; indirect CALL

	call	GetCommandLine
	mov	[cmd_line_ptr],eax

	call	parse_cmd_line

	.data
source_filename_ptr	dd 0
dest_filename_ptr		dd 0

source_file_handle	dd 0
dest_file_handle		dd 0
;
; Open up the files
;
	extrn	CreateFile:near

	.code
	push	large 0	; template file
	push	large FILE_ATTRIBUTE_NORMAL
	push	large OPEN_EXISTING
	push	large 0	; security attributes
	push	large 0	; share mode
	push	large GENERIC_READ
	push	[source_filename_ptr]
	call	CreateFile
	cmp	eax,INVALID_HANDLE_VALUE
	je	bad_source
	mov	[source_file_handle],eax

	push	large 0	; template file
	push	large FILE_ATTRIBUTE_NORMAL
	push	large CREATE_ALWAYS
	push	large 0	; security attributes
	push	large 0	; share mode
	push	large GENERIC_WRITE
	push	[dest_filename_ptr]
	call	CreateFile
	cmp	eax,INVALID_HANDLE_VALUE
	je	bad_dest
	mov	[dest_file_handle],eax

BUFFER_SIZE	equ	32768

	.data
bytes_read		dd 0
bytes_written	dd 0

	.data?
temp_buffer		db BUFFER_SIZE dup(?)
;
; The copy loop
;
	extrn	ReadFile:near,WriteFile:near

	.code
copy_loop:
	push	large 0		; ptr to OVERLAPPED structure
	push	offset bytes_read
	push	large BUFFER_SIZE	; maximum bytes to transfer
	push	offset temp_buffer
	push	[source_file_handle]
	call	ReadFile
	cmp	[bytes_read],0
	je	end_copy

	push	large 0		; ptr to OVERLAPPED structure
	push	offset bytes_written
	push	[bytes_read]	; write all bytes that were read
	push	offset temp_buffer
	push	[dest_file_handle]
	call	WriteFile
	jmp	copy_loop
end_copy:
;
; Finish up program
;
	extrn	CloseHandle:near,ExitProcess:near

	.code
	push	[source_file_handle]
	call	CloseHandle

	push	[dest_file_handle]
	call	CloseHandle

	push	large 0    ; exit code
	call	ExitProcess
;
; Extract file names out of the command line
;
	.data?
cmd_line_2	db	1024 dup(?)		; space for extracted arguments

	.code
parse_cmd_line:
	mov	esi,[cmd_line_ptr]	; source
	mov	edi,offset cmd_line_2	; destination
	call	scan_blanks
	call	scan_arg			; skip EXE name

	call	scan_blanks
	mov	[source_filename_ptr],edi
	call	scan_arg

	call	scan_blanks
	mov	[dest_filename_ptr],edi
	call	scan_arg

	ret
;
; Skip blanks and tabs, starting at ESI
; ANSI only
;
tab	equ    9

	.code
scan_blanks_1:
	inc	esi
scan_blanks:		; entry point
	mov	al,[esi]
	cmp	al,' '
	je	scan_blanks_1
	cmp	al,tab
	je	scan_blanks_1
	ret	; ESI points to first nonblank
;
; Scan past quoted strings or unquoted nonblanks, starting at ESI
; Store (with quotes removed) argument starting at EDI
; Set ESI to terminating character, EDI past stored argument string
; ANSI only
;
scan_arg:
	mov	al,[esi]
	cmp	al,0
	je	exit_scan_arg
	cmp	al,'"'
	je	scan_quoted
scan_unquoted:
	mov	[edi],al
	inc	esi
	inc	edi
	mov	al,[esi]
	cmp	al,0
	je	exit_scan_arg
	cmp	al,' '
	je	exit_scan_arg
	cmp	al,tab
	je	exit_scan_arg
	cmp	al,'"'
	je	exit_scan_arg
	jmp	scan_unquoted
scan_quoted:
	inc	esi		; skip quote
	mov	al,[esi]
	cmp	al,0
	je	exit_scan_arg
	cmp	al,'"'
	je	exit_quoted
scan_quoted_1:
	mov	[edi],al
	inc	esi
	inc	edi
	mov	al,[esi]
	cmp	al,0
	je	exit_scan_arg
	cmp	al,'"'
	je	exit_quoted
	jmp	scan_quoted_1
exit_quoted:
	inc	esi		; skip quote
exit_scan_arg:
	mov	byte ptr [edi],0	; terminate destination string
	inc	edi
	ret			; esi points past argument
;
; Error routines
;
	.data
bad_source_msg	db "Can't open source file",13,10
bad_source_msg_len equ $ - bad_source_msg

bad_dest_msg	db "Can't open destination file",13,10
bad_dest_msg_len equ $ - bad_dest_msg

	extrn	GetStdHandle:near

	.code
bad_source:
	mov	esi,offset bad_source_msg
	mov	ecx,bad_source_msg_len
	jmp	error_exit
bad_dest:
	mov	esi,offset bad_dest_msg
	mov	ecx,bad_dest_msg_len
error_exit:
	push	large 0	; ptr to OVERLAPPED structure
	push	offset bytes_written
	push	ecx		; byte count
	push	esi		; byte buffer

	push	large STD_OUTPUT_HANDLE
	call	GetStdHandle

	push	eax
	call	WriteFile

	push	large 0    ; exit code
	call	ExitProcess

	end	_start	; address ignored by MS linker
