; WIN32.INC -- Partial list of Win32 constants and structures
;
; Assembles with Borland Turbo Assembler 4.0
;

;
; Define Win32, Win95 structures
;

	include win32x.inc	; nonstd STRUCTs for long argument lists

;
; Structures used by other structures
;
POINT STRUC
ptX dd ?
ptY dd ?
POINT ENDS

RECT STRUC
rcLeft   dd ?
rcTop    dd ?
rcRight  dd ?
rcBottom dd ?
RECT ENDS
;
; Structures not used elsewhere
;
CREATESTRUCT STRUC
csParm	dd ?	; lpCreateParams
csInstance	dd ?	; hInstance
csMenu	dd ?	; hMenu
csParent	dd ?	; hwndParent
csCy		dd ?	; cy, height
csCx		dd ?	; cx, width
csY		dd ?	; y
csX		dd ?	; x
csStyle	dd ?	; style
csName	dd ?	; lpszName, window name (caption)
csClass	dd ?	; lpszClass, class name
csExstyle	dd ?	; dwExStyle
CREATESTRUCT ENDS

MSG STRUC
msgWnd     dd ?		; hwnd
msgMessage dd ?		; message
msgWparam  dd ?		; wParam
msgLparam  dd ?		; lParam
msgTime    dd ?		; time
msgPt      POINT ?	; pt
MSG ENDS

NMHEADER STRUC
nmhFromWnd    DD ?    ; handle of control that sent WM_NOTIFY
nmhFromID     DD ?    ; ID of control that sent WM_NOTIFY
nmhNotifyCode DD ?    ; NM or user defined code
NMHEADER ENDS

PAINTSTRUCT STRUC
psDC        dd ?			; hdc
psErase     dd ?			; fErase
psRect      dd ?			; rcPaint
; the following reserved by Windows
psRestore   dd ?			; fRestore
psIncUpdate dd ?			; fIncUpdate
psRGB       db 16 dup(?)	; rgbReserved
PAINTSTRUCT ENDS

WNDCLASS STRUC
wcStyle           dd ?    ; style
wcWndProc         dd ?    ; lpfnWndProc
wcClsExtra        dd ?    ; cbClsExtra
wcWndExtra        dd ?    ; cbWndExtra
wcInstance        dd ?    ; hInstance
wcIcon            dd ?    ; hIcon
wcCursor          dd ?    ; hCursor
wcBackgroundBrush dd ?    ; hbrBackground
wcMenuName        dd ?    ; lpszMenuName
wcClassName       dd ?    ; lpszClassName
WNDCLASS ENDS

WNDCLASSEX STRUC
wcxSize		 dd ?	   ; cbSize
wcxStyle           dd ?    ; style
wcxWndProc         dd ?    ; lpfnWndProc
wcxClsExtra        dd ?    ; cbClsExtra
wcxWndExtra        dd ?    ; cbWndExtra
wcxInstance        dd ?    ; hInstance
wcxIcon            dd ?    ; hIcon
wcxCursor          dd ?    ; hCursor
wcxBackgroundBrush dd ?    ; hbrBackground
wcxMenuName        dd ?    ; lpszMenuName
wcxClassName       dd ?    ; lpszClassName
wcxSmallIcon	 dd ?	   ; hIconSm
WNDCLASSEX ENDS

; ***************

;
; Standard access rights
;
DELETE				equ 00010000h
READ_CONTROL			equ 00020000h
WRITE_DAC				equ 00040000h
WRITE_OWNER				equ 00080000h
SYNCHRONIZE				equ 00100000h

STANDARD_RIGHTS_REQUIRED	equ 000F0000h

STANDARD_RIGHTS_READ		equ READ_CONTROL
STANDARD_RIGHTS_WRITE		equ READ_CONTROL
STANDARD_RIGHTS_EXECUTE		equ READ_CONTROL

STANDARD_RIGHTS_ALL		equ 001F0000h

SPECIFIC_RIGHTS_ALL		equ 0000FFFFh
;
; Background Modes
;
TRANSPARENT	equ 1
OPAQUE	equ 2
;
; Button messages
;
BM_GETCHECK		equ 00F0h
BM_SETCHECK		equ 00F1h
BM_GETSTATE		equ 00F2h
BM_SETSTATE		equ 00F3h
BM_SETSTYLE		equ 00F4h
BM_CLICK		equ 00F5h
BM_GETIMAGE		equ 00F6h
BM_SETIMAGE		equ 00F7h
;
; Button notifications
;
BN_CLICKED		equ 0
BN_PAINT		equ 1
BN_HILITE		equ 2
BN_UNHILITE		equ 3
BN_DISABLE		equ 4
BN_DOUBLECLICKED	equ 5
BN_SETFOCUS		equ 6
BN_KILLFOCUS	equ 7

BN_PUSHED		equ BN_HILITE
BN_UNPUSHED		equ BN_UNHILITE
BN_DBLCLK		equ BN_DOUBLECLICKED
;
; Button styles
;
BS_PUSHBUTTON	equ 0000h
BS_DEFPUSHBUTTON	equ 0001h
BS_CHECKBOX		equ 0002h
BS_AUTOCHECKBOX	equ 0003h
BS_RADIOBUTTON	equ 0004h
BS_3STATE		equ 0005h
BS_AUTO3STATE	equ 0006h
BS_GROUPBOX		equ 0007h
BS_USERBUTTON	equ 0008h
BS_AUTORADIOBUTTON equ 0009h
BS_OWNERDRAW	equ 000Bh

BS_TEXT		equ 0000h
BS_LEFTTEXT		equ 0020h
BS_RIGHTBUTTON	equ BS_LEFTTEXT
BS_ICON		equ 0040h
BS_BITMAP		equ 0080h
BS_LEFT		equ 0100h
BS_RIGHT		equ 0200h
BS_CENTER		equ 0300h
BS_TOP		equ 0400h
BS_BOTTOM		equ 0800h
BS_VCENTER		equ 0C00h
BS_PUSHLIKE		equ 1000h
BS_MULTILINE	equ 2000h
BS_NOTIFY		equ 4000h
BS_FLAT		equ 8000h
;
; Button states
;
BST_UNCHECKED	equ 0h
BST_CHECKED		equ 1h
BST_INDETERMINATE	equ 2h
; get/set check state = 3h
BST_PUSHED		equ 4h	; get/set highlight state
BST_FOCUS		equ 8h	; get/set focus state
;
; Combo box messages and error return values
;
CB_OKAY	equ 0
CB_ERR	equ -1
CB_ERRSPACE	equ -2

CB_GETEDITSEL	equ 0140h
CB_LIMITTEXT	equ 0141h
CB_SETEDITSEL	equ 0142h
CB_ADDSTRING	equ 0143h
CB_DELETESTRING	equ 0144h
CB_DIR		equ 0145h
CB_GETCOUNT		equ 0146h
CB_GETCURSEL	equ 0147h
CB_GETLBTEXT	equ 0148h
CB_GETLBTEXTLEN	equ 0149h
CB_INSERTSTRING	equ 014Ah
CB_RESETCONTENT	equ 014Bh
CB_FINDSTRING	equ 014Ch
CB_SELECTSTRING	equ 014Dh
CB_SETCURSEL	equ 014Eh
CB_SHOWDROPDOWN	equ 014Fh
CB_GETITEMDATA	equ 0150h
CB_SETITEMDATA	equ 0151h
CB_GETDROPPEDCONTROLRECT equ 0152h
CB_SETITEMHEIGHT	equ 0153h
CB_GETITEMHEIGHT	equ 0154h
CB_SETEXTENDEDUI	equ 0155h
CB_GETEXTENDEDUI	equ 0156h
CB_GETDROPPEDSTATE equ 0157h
CB_FINDSTRINGEXACT equ 0158h
CB_SETLOCALE	equ 0159h
CB_GETLOCALE	equ 015Ah

CB_GETTOPINDEX	equ 015Bh
CB_SETTOPINDEX	equ 015Ch
CB_GETHORIZONTALEXTENT equ 015Dh
CB_SETHORIZONTALEXTENT equ 015Eh
CB_GETDROPPEDWIDTH equ 015Fh
CB_SETDROPPEDWIDTH equ 0160h
CB_INITSTORAGE	equ 0161h
CB_MSGMAX		equ 0162h	; pre 4.0 = 015Bh
;
; Combo box notifications
;
CBN_ERRSPACE	equ -1
CBN_SELCHANGE	equ 1
CBN_DBLCLK		equ 2
CBN_SETFOCUS	equ 3
CBN_KILLFOCUS	equ 4
CBN_EDITCHANGE	equ 5
CBN_EDITUPDATE	equ 6
CBN_DROPDOWN	equ 7
CBN_CLOSEUP		equ 8
CBN_SELENDOK	equ 9
CBN_SELENDCANCEL	equ 10
;
; Combo box styles
;
CBS_SIMPLE		equ 0001h
CBS_DROPDOWN	equ 0002h
CBS_DROPDOWNLIST	equ 0003h
CBS_OWNERDRAWFIXED    equ 0010h
CBS_OWNERDRAWVARIABLE equ 0020h
CBS_AUTOHSCROLL	equ 0040h
CBS_OEMCONVERT	equ 0080h
CBS_SORT		equ 0100h
CBS_HASSTRINGS	equ 0200h
CBS_NOINTEGRALHEIGHT equ 0400h
CBS_DISABLENOSCROLL  equ 0800h
CBS_UPPERCASE	equ 2000h
CBS_LOWERCASE	equ 4000h
;
; System colors
;
COLOR_SCROLLBAR		equ 0
COLOR_BACKGROUND		equ 1
COLOR_ACTIVECAPTION	equ 2
COLOR_INACTIVECAPTION	equ 3
COLOR_MENU			equ 4
COLOR_WINDOW		equ 5
COLOR_WINDOWFRAME		equ 6
COLOR_MENUTEXT		equ 7
COLOR_WINDOWTEXT		equ 8
COLOR_CAPTIONTEXT		equ 9
COLOR_ACTIVEBORDER	equ 10
COLOR_INACTIVEBORDER	equ 11
COLOR_APPWORKSPACE	equ 12
COLOR_HIGHLIGHT		equ 13
COLOR_HIGHLIGHTTEXT	equ 14
COLOR_BTNFACE		equ 15
COLOR_BTNSHADOW		equ 16
COLOR_GRAYTEXT		equ 17
COLOR_BTNTEXT		equ 18
COLOR_INACTIVECAPTIONTEXT equ 19
COLOR_BTNHIGHLIGHT	equ 20

COLOR_DESKTOP		equ COLOR_BACKGROUND
COLOR_BTNHILIGHT		equ COLOR_BTNHIGHLIGHT
COLOR_3DFACE		equ COLOR_BTNFACE
COLOR_3DSHADOW		equ COLOR_BTNSHADOW
COLOR_3DHIGHLIGHT		equ COLOR_BTNHIGHLIGHT
COLOR_3DHILIGHT		equ COLOR_BTNHIGHLIGHT

COLOR_3DDKSHADOW		equ 21
COLOR_3DLIGHT		equ 22
COLOR_INFOTEXT		equ 23
COLOR_INFOBK		equ 24
;
; Window class styles
;
CS_VREDRAW		equ	0001h
CS_HREDRAW		equ	0002h
CS_KEYCVTWINDOW	equ	0004h
CS_DBLCLKS		equ	0008h
CS_OWNDC		equ	0020h
CS_CLASSDC		equ	0040h
CS_PARENTDC		equ	0080h
CS_NOKEYCVT		equ	0100h
CS_NOCLOSE		equ	0200h
CS_SAVEBITS		equ	0800h
CS_BYTEALIGNCLIENT equ	1000h
CS_BYTEALIGNWINDOW equ	2000h
CS_GLOBALCLASS	equ	4000h

CS_IME		equ	10000h
;
; CreateWindowEx parameter
;
CW_USEDEFAULT	equ 80000000h
;
; Dialog window class
;
WC_DIALOG		equ 8002h
;
; Extra window bytes needed for private dialog class
;
DLGWINDOWEXTRA	equ 30
;
; Dialog extra window bytes field offsets
;
DWL_MSGRESULT	equ 0
DWL_DLGPROC		equ 4
DWL_USER		equ 8
;
; Dialog box styles
;
DS_ABSALIGN		equ 0001h
DS_SYSMODAL		equ 0002h
DS_LOCALEDIT	equ 0020h  ; /* Edit items get Local storage. */
DS_SETFONT		equ 0040h  ; /* User specified font for Dlg controls */
DS_MODALFRAME	equ 0080h  ; /* Can be combined with WS_CAPTION  */
DS_NOIDLEMSG	equ 0100h  ; /* WM_ENTERIDLE message will not be sent */
DS_SETFOREGROUND	equ 0200h  ; /* not in win3.1 */
; Win4.0
DS_3DLOOK		equ 0004h
DS_FIXEDSYS		equ 0008h
DS_NOFAILCREATE	equ 0010h
DS_CONTROL		equ 0400h
DS_CENTER		equ 0800h
DS_CENTERMOUSE	equ 1000h
DS_CONTEXTHELP	equ 2000h
;
; DrawText parameters
;
DT_TOP          equ 0000H
DT_LEFT         equ 0000H
DT_CENTER       equ 0001H
DT_RIGHT        equ 0002H
DT_VCENTER      equ 0004H
DT_BOTTOM       equ 0008H
DT_WORDBREAK    equ 0010H
DT_SINGLELINE   equ 0020H
DT_EXPANDTABS   equ 0040H
DT_TABSTOP      equ 0080H
DT_NOCLIP       equ 0100H
DT_EXTERNALLEADING equ 0200H
DT_CALCRECT     equ 0400H
DT_NOPREFIX     equ 0800H
;DT_INTERNAL     equ 1000H
;
; Edit window EM_SETMARGIN parameters
;
EC_LEFTMARGIN	equ 0001h
EC_RIGHTMARGIN	equ 0002h
EC_USEFONTINFO	equ 0FFFFh
;
; Edit window messages
; Some of these are shared with the Rich Edit window
;
EM_GETSEL		equ 00B0h
EM_SETSEL		equ 00B1h
EM_GETRECT		equ 00B2h
EM_SETRECT		equ 00B3h
EM_SETRECTNP	equ 00B4h
EM_SCROLL		equ 00B5h
EM_LINESCROLL	equ 00B6h
EM_SCROLLCARET	equ 00B7h
EM_GETMODIFY	equ 00B8h
EM_SETMODIFY	equ 00B9h
EM_GETLINECOUNT	equ 00BAh
EM_LINEINDEX	equ 00BBh
EM_SETHANDLE	equ 00BCh
EM_GETHANDLE	equ 00BDh
EM_GETTHUMB		equ 00BEh
EM_LINELENGTH	equ 00C1h
EM_REPLACESEL	equ 00C2h
EM_GETLINE		equ 00C4h
EM_LIMITTEXT	equ 00C5h
EM_CANUNDO		equ 00C6h
EM_UNDO		equ 00C7h
EM_FMTLINES		equ 00C8h
EM_LINEFROMCHAR	equ 00C9h
EM_SETTABSTOPS	equ 00CBh
EM_SETPASSWORDCHAR equ 00CCh
EM_EMPTYUNDOBUFFER equ 00CDh
EM_GETFIRSTVISIBLELINE equ 00CEh
EM_SETREADONLY	equ 00CFh
EM_SETWORDBREAKPROC equ 00D0h
EM_GETWORDBREAKPROC equ 00D1h
EM_GETPASSWORDCHAR  equ 00D2h
EM_SETMARGINS	equ 00D3h
EM_GETMARGINS	equ 00D4h
EM_SETLIMITTEXT	equ EM_LIMITTEXT	; win40 Name change
EM_GETLIMITTEXT	equ 00D5h
EM_POSFROMCHAR	equ 00D6h
EM_CHARFROMPOS	equ 00D7h
;
; Edit window notification codes
;
EN_SETFOCUS		equ 0100h
EN_KILLFOCUS	equ 0200h
EN_CHANGE		equ 0300h
EN_UPDATE		equ 0400h
EN_ERRSPACE		equ 0500h
EN_MAXTEXT		equ 0501h
EN_HSCROLL		equ 0601h
EN_VSCROLL		equ 0602h
;
; Edit window style
;
ES_LEFT		equ 0000h
ES_CENTER		equ 0001h
ES_RIGHT		equ 0002h
ES_MULTILINE	equ 0004h
ES_UPPERCASE	equ 0008h
ES_LOWERCASE	equ 0010h
ES_PASSWORD		equ 0020h
ES_AUTOVSCROLL	equ 0040h
ES_AUTOHSCROLL	equ 0080h
ES_NOHIDESEL	equ 0100h
ES_OEMCONVERT	equ 0400h
ES_READONLY		equ 0800h
ES_WANTRETURN	equ 1000h
ES_NUMBER		equ 2000h
;
; File constants
;
INVALID_HANDLE_VALUE	equ	-1

CREATE_NEW		equ 1
CREATE_ALWAYS	equ 2
OPEN_EXISTING	equ 3
OPEN_ALWAYS		equ 4
TRUNCATE_EXISTING	equ 5

GENERIC_READ	equ 80000000h
GENERIC_WRITE	equ 40000000h
GENERIC_EXECUTE	equ 20000000h
GENERIC_ALL		equ 10000000h

FILE_ATTRIBUTE_READONLY		equ 00000001h
FILE_ATTRIBUTE_HIDDEN		equ 00000002h
FILE_ATTRIBUTE_SYSTEM		equ 00000004h
FILE_ATTRIBUTE_DIRECTORY	equ 00000010h
FILE_ATTRIBUTE_ARCHIVE		equ 00000020h
FILE_ATTRIBUTE_NORMAL		equ 00000080h
FILE_ATTRIBUTE_TEMPORARY	equ 00000100h
FILE_ATTRIBUTE_COMPRESSED	equ 00000800h

FILE_FLAG_WRITE_THROUGH		equ 80000000h
FILE_FLAG_OVERLAPPED		equ 40000000h
FILE_FLAG_NO_BUFFERING		equ 20000000h
FILE_FLAG_RANDOM_ACCESS		equ 10000000h
FILE_FLAG_SEQUENTIAL_SCAN	equ 08000000h
FILE_FLAG_DELETE_ON_CLOSE	equ 04000000h
FILE_FLAG_BACKUP_SEMANTICS	equ 02000000h
FILE_FLAG_POSIX_SEMANTICS	equ 01000000h

FILE_SHARE_READ			equ 00000001h
FILE_SHARE_WRITE			equ 00000002h
;
;
;
FILE_READ_DATA			equ 0001h	; file & pipe
FILE_LIST_DIRECTORY		equ 0001h	; directory

FILE_WRITE_DATA			equ 0002h	; file & pipe
FILE_ADD_FILE			equ 0002h	; directory

FILE_APPEND_DATA			equ 0004h	; file
FILE_ADD_SUBDIRECTORY		equ 0004h	; directory
FILE_CREATE_PIPE_INSTANCE	equ 0004h	; named pipe

FILE_READ_EA			equ 0008h	; file & directory
FILE_READ_PROPERTIES		equ FILE_READ_EA

FILE_WRITE_EA			equ 0010h	; file & directory
FILE_WRITE_PROPERTIES		equ FILE_WRITE_EA

FILE_EXECUTE			equ 0020h	; file
FILE_TRAVERSE			equ 0020h	; directory

FILE_DELETE_CHILD			equ 0040h	; directory

FILE_READ_ATTRIBUTES		equ 0080h	; all

FILE_WRITE_ATTRIBUTES		equ 0100h	; all

FILE_ALL_ACCESS	equ STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or 0x1FFh

FILE_GENERIC_READ		equ STANDARD_RIGHTS_READ or FILE_READ_DATA or \
			FILE_READ_ATTRIBUTES or FILE_READ_EA or SYNCHRONIZE


FILE_GENERIC_WRITE	equ STANDARD_RIGHTS_WRITE or FILE_WRITE_DATA or \
	FILE_WRITE_ATTRIBUTES or FILE_WRITE_EA or FILE_APPEND_DATA or SYNCHRONIZE


FILE_GENERIC_EXECUTE	equ STANDARD_RIGHTS_EXECUTE or FILE_READ_ATTRIBUTES or \
			FILE_EXECUTE or SYNCHRONIZE

FILE_NOTIFY_CHANGE_FILE_NAME	equ 00000001h
FILE_NOTIFY_CHANGE_DIR_NAME	equ 00000002h
FILE_NOTIFY_CHANGE_ATTRIBUTES	equ 00000004h
FILE_NOTIFY_CHANGE_SIZE		equ 00000008h
FILE_NOTIFY_CHANGE_LAST_WRITE	equ 00000010h
FILE_NOTIFY_CHANGE_SECURITY	equ 00000100h
MAILSLOT_NO_MESSAGE		equ -1
MAILSLOT_WAIT_FOREVER		equ -1
FILE_CASE_SENSITIVE_SEARCH	equ 00000001h
FILE_CASE_PRESERVED_NAMES	equ 00000002h
FILE_UNICODE_ON_DISK		equ 00000004h
FILE_PERSISTENT_ACLS		equ 00000008h
FILE_FILE_COMPRESSION		equ 00000010h
FILE_VOLUME_IS_COMPRESSED	equ 00008000h
IO_COMPLETION_MODIFY_STATE	equ 0002h
IO_COMPLETION_ALL_ACCESS	equ STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or 03h
DUPLICATE_CLOSE_SOURCE		equ 00000001h
DUPLICATE_SAME_ACCESS		equ 00000002h
;
; Class field offsets for GetClassLong()
;
GCL_MENUNAME	equ -8
GCL_HBRBACKGROUND	equ -10
GCL_HCURSOR		equ -12
GCL_HICON		equ -14
GCL_HMODULE		equ -16
GCL_CBWNDEXTRA	equ -18
GCL_CBCLSEXTRA	equ -20
GCL_WNDPROC		equ -24
GCL_STYLE		equ -26

GCW_ATOM		equ -32

GCL_HICONSM		equ -34	; Win 4.0
;
; Window field offsets for GetWindowLong()
;
GWL_WNDPROC		equ -4
GWL_HINSTANCE	equ -6
GWL_HWNDPARENT	equ -8
GWL_STYLE		equ -16
GWL_EXSTYLE		equ -20
GWL_USERDATA	equ -21
GWL_ID		equ -12
;
; Stock cursors
;
IDC_ARROW		equ 32512
IDC_IBEAM		equ 32513
IDC_WAIT		equ 32514
IDC_CROSS		equ 32515
IDC_UPARROW		equ 32516
IDC_SIZE		equ 32640
IDC_ICON		equ 32641
IDC_SIZENWSE	equ 32642
IDC_SIZENWSW	equ 32643
IDC_SIZEWE		equ 32644
IDC_SIZENS		equ 32645
IDC_SIZEALL		equ 32646
IDC_NO		equ 32648
IDC_APPSTARTING	equ 32650
IDC_HELP		equ 32651
;
; Stock icons
;
IDI_APPLICATION	equ 32512
IDI_HAND		equ 32513
IDI_QUESTION	equ 32514
IDI_EXCLAMATION	equ 32515
IDI_ASTERISK	equ 32516
IDI_WINLOGO		equ 32517
; new
IDI_ERROR		equ IDI_HAND
IDI_WARNING		equ IDI_EXCLAMATION
IDI_INFORMATION	equ IDI_ASTERISK
;
; List Box dialog code
;
LB_CTLCODE	equ 0
;
; List Box return values
;
LB_OKAY	equ 0
LB_ERR	equ -1
LB_ERRSPACE	equ -2
;
; List Box messages
;
LB_ADDSTRING		equ 0180h
LB_INSERTSTRING		equ 0181h
LB_DELETESTRING		equ 0182h
LB_SELITEMRANGEEX		equ 0183h
LB_RESETCONTENT		equ 0184h
LB_SETSEL			equ 0185h
LB_SETCURSEL		equ 0186h
LB_GETSEL			equ 0187h
LB_GETCURSEL		equ 0188h
LB_GETTEXT			equ 0189h
LB_GETTEXTLEN		equ 018Ah
LB_GETCOUNT			equ 018Bh
LB_SELECTSTRING		equ 018Ch
LB_DIR			equ 018Dh
LB_GETTOPINDEX		equ 018Eh
LB_FINDSTRING		equ 018Fh
LB_GETSELCOUNT		equ 0190h
LB_GETSELITEMS		equ 0191h
LB_SETTABSTOPS		equ 0192h
LB_GETHORIZONTALEXTENT	equ 0193h
LB_SETHORIZONTALEXTENT	equ 0194h
LB_SETCOLUMNWIDTH		equ 0195h
LB_ADDFILE			equ 0196h
LB_SETTOPINDEX		equ 0197h
LB_GETITEMRECT		equ 0198h
LB_GETITEMDATA		equ 0199h
LB_SETITEMDATA		equ 019Ah
LB_SELITEMRANGE		equ 019Bh
LB_SETANCHORINDEX		equ 019Ch
LB_GETANCHORINDEX		equ 019Dh
LB_SETCARETINDEX		equ 019Eh
LB_GETCARETINDEX		equ 019Fh
LB_SETITEMHEIGHT		equ 01A0h
LB_GETITEMHEIGHT		equ 01A1h
LB_FINDSTRINGEXACT	equ 01A2h
LB_SETLOCALE		equ 01A5h
LB_GETLOCALE		equ 01A6h
LB_SETCOUNT			equ 01A7h
LB_INITSTORAGE		equ 01A8h
LB_ITEMFROMPOINT		equ 01A9h
LB_MSGMAX			equ 01B0h	; pre 4.0 = 01A8h
;
; List Box notification codes
;
LBN_ERRSPACE	equ -2
LBN_SELCHANGE	equ 1
LBN_DBLCLK		equ 2
LBN_SELCANCEL	equ 3
LBN_SETFOCUS	equ 4
LBN_KILLFOCUS	equ 5
;
; List Box styles
;
LBS_NOTIFY			equ 0001h
LBS_SORT			equ 0002h
LBS_NOREDRAW		equ 0004h
LBS_MULTIPLESEL		equ 0008h
LBS_OWNERDRAWFIXED	equ 0010h
LBS_OWNERDRAWVARIABLE	equ 0020h
LBS_HASSTRINGS		equ 0040h
LBS_USETABSTOPS		equ 0080h
LBS_NOINTEGRALHEIGHT	equ 0100h
LBS_MULTICOLUMN		equ 0200h
LBS_WANTKEYBOARDINPUT	equ 0400h
LBS_EXTENDEDSEL		equ 0800h
LBS_DISABLENOSCROLL	equ 1000h
LBS_NODATA			equ 2000h
LBS_NOSEL			equ 4000h

LBS_STANDARD	equ LBS_NOTIFY or LBS_SORT or WS_VSCROLL or WS_BORDER
;
; Message Box constants
;
MB_OK				equ 00000000h
MB_OKCANCEL			equ 00000001h
MB_ABORTRETRYIGNORE	equ 00000002h
MB_YESNOCANCEL		equ 00000003h
MB_YESNO			equ 00000004h
MB_RETRYCANCEL		equ 00000005h

MB_ICONHAND			equ 00000010h
MB_ICONQUESTION		equ 00000020h
MB_ICONEXCLAMATION	equ 00000030h
MB_ICONASTERISK		equ 00000040h

MB_ICONWARNING		equ MB_ICONEXCLAMATION	; 4.0
MB_ICONERROR		equ MB_ICONHAND	; 4.0

MB_ICONINFORMATION	equ MB_ICONASTERISK
MB_ICONSTOP			equ MB_ICONHAND

MB_DEFBUTTON1		equ 00000000h
MB_DEFBUTTON2		equ 00000100h
MB_DEFBUTTON3		equ 00000200h
MB_DEFBUTTON4		equ 00000300h	; 4.0

MB_APPLMODAL		equ 00000000h
MB_SYSTEMMODAL		equ 00001000h
MB_TASKMODAL		equ 00002000h
MB_HELP			equ 00004000h	; 4.0 Help Button
MB_RIGHT			equ 00080000h	; 4.0
MB_RTLREADING		equ 00100000h	; 4.0

MB_NOFOCUS			equ 00008000h
MB_SETFOREGROUND		equ 00010000h
MB_DEFAULT_DESKTOP_ONLY	equ 00020000h
MB_SERVICE_NOTIFICATION	equ 00040000h

MB_TYPEMASK			equ 0000000Fh
MB_USERICON			equ 00000080h	; 4.0
MB_ICONMASK			equ 000000F0h
MB_DEFMASK			equ 00000F00h
MB_MODEMASK			equ 00003000h
MB_MISCMASK			equ 0000C000h
;
; Menu flags
; win40  -- A lot of MF_* flags have been renamed as MFT_* and MFS_* flags
;
; Menu flags for Add/Check/EnableMenuItem()
MF_INSERT		equ 0000h
MF_CHANGE		equ 0080h
MF_APPEND		equ 0100h
MF_DELETE		equ 0200h
MF_REMOVE		equ 1000h

MF_BYCOMMAND	equ 0000h
MF_BYPOSITION	equ 0400h

MF_SEPARATOR	equ 0800h

MF_ENABLED		equ 0000h
MF_GRAYED		equ 0001h
MF_DISABLED		equ 0002h

MF_UNCHECKED	equ 0000h
MF_CHECKED		equ 0008h
MF_USECHECKBITMAPS equ 0200h

MF_STRING		equ 0000h
MF_BITMAP		equ 0004h
MF_OWNERDRAW	equ 0100h

MF_POPUP		equ 0010h
MF_MENUBARBREAK	equ 0020h
MF_MENUBREAK	equ 0040h

MF_UNHILITE		equ 0000h
MF_HILITE		equ 0080h

MF_DEFAULT		equ 1000h
MF_SYSMENU		equ 2000h
MF_HELP		equ 4000h
MF_RIGHTJUSTIFY	equ 4000h

MF_MOUSESELECT	equ 8000h
MF_END		equ 0080h  ; Obsolete -- only used by old RES files

MFT_STRING		equ MF_STRING
MFT_BITMAP		equ MF_BITMAP
MFT_MENUBARBREAK	equ MF_MENUBARBREAK
MFT_MENUBREAK	equ MF_MENUBREAK
MFT_OWNERDRAW	equ MF_OWNERDRAW
MFT_RADIOCHECK	equ 0200h
MFT_SEPARATOR	equ MF_SEPARATOR
MFT_RIGHTORDER	equ 2000h
MFT_RIGHTJUSTIFY	equ MF_RIGHTJUSTIFY

; Menu flags for Add/Check/EnableMenuItem()
MFS_GRAYED          equ 0003h
MFS_DISABLED        equ MFS_GRAYED
MFS_CHECKED         equ MF_CHECKED
MFS_HILITE          equ MF_HILITE
MFS_ENABLED         equ MF_ENABLED
MFS_UNCHECKED       equ MF_UNCHECKED
MFS_UNHILITE        equ MF_UNHILITE
MFS_DEFAULT         equ MF_DEFAULT
;
; Predefined WM_NOTIFY codes
;
NM_OUTOFMEMORY	equ -1
NM_CLICK		equ -2
NM_DBLCLICK		equ -3
NM_RETURN		equ -4
NM_RCLICK		equ -5
NM_RDBLCLK		equ -6
NM_SETFOCUS		equ -7
NM_KILLFOCUS	equ -8
;
; RedrawWindow() flags
;
RDW_INVALIDATE		equ 0001h
RDW_INTERNALPAINT		equ 0002h
RDW_ERASE			equ 0004h

RDW_VALIDATE		equ 0008h
RDW_NOINTERNALPAINT	equ 0010h
RDW_NOERASE			equ 0020h

RDW_NOCHILDREN		equ 0040h
RDW_ALLCHILDREN		equ 0080h

RDW_UPDATENOW		equ 0100h
RDW_ERASENOW		equ 0200h

RDW_FRAME			equ 0400h
RDW_NOFRAME			equ 0800h
;
; Scroll Bar constants
;
SB_HORZ	equ 0
SB_VERT	equ 1
SB_CTL	equ 2
SB_BOTH	equ 3
;
; Scroll Bar commands
;
SB_LINEUP		equ 0
SB_LINELEFT		equ 0
SB_LINEDOWN		equ 1
SB_LINERIGHT	equ 1
SB_PAGEUP		equ 2
SB_PAGELEFT		equ 2
SB_PAGEDOWN		equ 3
SB_PAGERIGHT	equ 3
SB_THUMBPOSITION	equ 4
SB_THUMBTRACK	equ 5
SB_TOP		equ 6
SB_LEFT		equ 6
SB_BOTTOM		equ 7
SB_RIGHT		equ 7
SB_ENDSCROLL	equ 8
;
; Scroll Bar messages
;
SBM_SETPOS			equ 00E0h ; not in win3.1
SBM_GETPOS			equ 00E1h ; not in win3.1
SBM_SETRANGE		equ 00E2h ; not in win3.1
SBM_SETRANGEREDRAW	equ 00E6h ; not in win3.1
SBM_GETRANGE		equ 00E3h ; not in win3.1
SBM_ENABLE_ARROWS		equ 00E4h ; not in win3.1
SBM_SETSCROLLINFO		equ 00E9h
SBM_GETSCROLLINFO		equ 00EAh
;
; Scroll Bar styles
;
SBS_HORZ			equ 0000h
SBS_VERT			equ 0001h
SBS_TOPALIGN		equ 0002h
SBS_LEFTALIGN		equ 0002h
SBS_BOTTOMALIGN		equ 0004h
SBS_RIGHTALIGN		equ 0004h
SBS_SIZEBOXTOPLEFTALIGN	equ 0002h
SBS_SIZEBOXBOTTOMRIGHTALIGN equ 0004h
SBS_SIZEBOX			equ 0008h
SBS_SIZEGRIP		equ 0010h
;
; Scroll Bar Info flags
;
SIF_RANGE			equ 0001h
SIF_PAGE			equ 0002h
SIF_POS			equ 0004h
SIF_DISABLENOSCROLL	equ 0008h
SIF_TRACKPOS		equ 0010h
SIF_ALL	equ SIF_RANGE or SIF_PAGE or SIF_POS or SIF_TRACKPOS
;
; Static window styles
;
SS_LEFT		equ 0000h
SS_CENTER		equ 0001h
SS_RIGHT		equ 0002h
SS_ICON		equ 0003h
SS_BLACKRECT	equ 0004h
SS_GRAYRECT		equ 0005h
SS_WHITERECT	equ 0006h
SS_BLACKFRAME	equ 0007h
SS_GRAYFRAME	equ 0008h
SS_WHITEFRAME	equ 0009h
SS_USERITEM		equ 000Ah
SS_SIMPLE		equ 000Bh
SS_LEFTNOWORDWRAP	equ 000Ch
SS_BITMAP		equ 000Eh
SS_OWNERDRAW	equ 000Dh
SS_ENHMETAFILE	equ 000Fh
SS_ETCHEDHORZ	equ 0010h
SS_ETCHEDVERT	equ 0011h
SS_ETCHEDFRAME	equ 0012h
SS_TYPEMASK		equ 001Fh
SS_NOPREFIX		equ 0080h	; Don't do "&" character translation
SS_NOTIFY		equ 0100h
SS_CENTERIMAGE	equ 0200h
SS_RIGHTJUST	equ 0400h
SS_REALSIZEIMAGE	equ 0800h
SS_SUNKEN		equ 1000h
;
; Standard I/O
;
STD_INPUT_HANDLE	equ -10
STD_OUTPUT_HANDLE	equ -11
STD_ERROR_HANDLE	equ -12
;
; Static window messages
;
STM_SETICON		equ 0170h
STM_GETICON		equ 0171h
STM_SETIMAGE	equ 0172h
STM_GETIMAGE	equ 0173h
STM_MSGMAX		equ 0174h
;
; Static window notifications
;
STN_CLICKED		equ 0
STN_DBLCLK		equ 1
STN_ENABLE		equ 2
STN_DISABLE		equ 3
;
; ShowWindow commands
;
SW_HIDE		equ 0
SW_SHOWNORMAL	equ 1	; preferred for 1st show
SW_NORMAL		equ 1
SW_SHOWMINIMIZED	equ 2	; activate minimized window
SW_SHOWMAXIMIZED	equ 3
SW_MAXIMIZE		equ 3
SW_SHOWNOACTIVATE	equ 4	; most recent state
SW_SHOW		equ 5	; current state
SW_MINIMIZE		equ 6	; activate next "top" window
SW_SHOWMINNOACTIVE equ 7
SW_SHOWNA		equ 8	; current state
SW_RESTORE		equ 9	; preferred for restoring from minimize
SW_SHOWDEFAULT	equ 10

SW_MAX		equ 10
;
; Window messages
;
WM_NULL		equ 0000h
WM_CREATE		equ 0001h
WM_DESTROY		equ 0002h
WM_MOVE		equ 0003h
WM_SIZE		equ 0005h
WM_ACTIVATE		equ 0006h
WM_SETFOCUS		equ 0007h
WM_KILLFOCUS	equ 0008h
WM_ENABLE		equ 000Ah
WM_SETREDRAW	equ 000Bh
WM_SETTEXT		equ 000Ch
WM_GETTEXT		equ 000Dh
WM_GETTEXTLENGTH	equ 000Eh
WM_PAINT		equ 000Fh
WM_CLOSE		equ 0010h
WM_QUERYENDSESSION equ 0011h
WM_QUIT		equ 0012h
WM_QUERYOPEN	equ 0013h
WM_ERASEBKGND	equ 0014h
WM_SYSCOLORCHANGE	equ 0015h
WM_ENDSESSION	equ 0016h
WM_SHOWWINDOW	equ 0018h
WM_WININICHANGE	equ 001Ah
WM_SETTINGCHANGE	equ WM_WININICHANGE
WM_DEVMODECHANGE	equ 001Bh
WM_ACTIVATEAPP	equ 001Ch
WM_FONTCHANGE	equ 001Dh
WM_TIMECHANGE	equ 001Eh
WM_CANCELMODE	equ 001Fh
WM_SETCURSOR	equ 0020h
WM_MOUSEACTIVATE	equ 0021h
WM_CHILDACTIVATE	equ 0022h
WM_QUEUESYNC	equ 0023h
WM_GETMINMAXINFO	equ 0024h
WM_PAINTICON	equ 0026h
WM_ICONERASEBKGND	equ 0027h
WM_NEXTDLGCTL	equ 0028h
WM_SPOOLERSTATUS	equ 002Ah
WM_DRAWITEM		equ 002Bh
WM_MEASUREITEM	equ 002Ch
WM_DELETEITEM	equ 002Dh
WM_VKEYTOITEM	equ 002Eh
WM_CHARTOITEM	equ 002Fh
WM_SETFONT		equ 0030h
WM_GETFONT		equ 0031h
WM_SETHOTKEY	equ 0032h
WM_GETHOTKEY	equ 0033h
WM_QUERYDRAGICON	equ 0037h
WM_COMPAREITEM	equ 0039h
WM_COMPACTING	equ 0041h
WM_COMMNOTIFY	equ 0044h	; not supported
WM_WINDOWPOSCHANGING equ 0046h
WM_WINDOWPOSCHANGED  equ 0047h
WM_POWER		equ 0048h
WM_COPYDATA		equ 004Ah
WM_CANCELJOURNAL	equ 004Bh
WM_NOTIFY		equ 004Eh
WM_INPUTLANGCHANGEREQUEST equ 0050h
WM_INPUTLANGCHANGE        equ 0051h
WM_TCARD		equ 0052h
WM_HELP		equ 0053h
WM_USERCHANGED	equ 0054h
WM_NOTIFYFORMAT	equ 0055h
WM_CONTEXTMENU	equ 007Bh
WM_STYLECHANGING	equ 007Ch
WM_STYLECHANGED	equ 007Dh
WM_DISPLAYCHANGE	equ 007Eh
WM_GETICON		equ 007Fh
WM_SETICON		equ 0080h
WM_NCCREATE		equ 0081h
WM_NCDESTROY	equ 0082h
WM_NCCALCSIZE	equ 0083h
WM_NCHITTEST	equ 0084h
WM_NCPAINT		equ 0085h
WM_NCACTIVATE	equ 0086h
WM_GETDLGCODE	equ 0087h
WM_NCMOUSEMOVE	equ 00A0h
WM_NCLBUTTONDOWN	equ 00A1h
WM_NCLBUTTONUP	equ 00A2h
WM_NCLBUTTONDBLCLK equ 00A3h
WM_NCRBUTTONDOWN	equ 00A4h
WM_NCRBUTTONUP	equ 00A5h
WM_NCRBUTTONDBLCLK equ 00A6h
WM_NCMBUTTONDOWN	equ 00A7h
WM_NCMBUTTONUP	equ 00A8h
WM_NCMBUTTONDBLCLK equ 00A9h

WM_KEYFIRST		equ 0100h
WM_KEYDOWN		equ 0100h
WM_KEYUP		equ 0101h
WM_CHAR		equ 0102h
WM_DEADCHAR		equ 0103h
WM_SYSKEYDOWN	equ 0104h
WM_SYSKEYUP		equ 0105h
WM_SYSCHAR		equ 0106h
WM_SYSDEADCHAR	equ 0107h
WM_KEYLAST		equ 0108h
WM_IME_STARTCOMPOSITION equ 010Dh
WM_IME_ENDCOMPOSITION   equ 010Eh
WM_IME_COMPOSITION      equ 010Fh
WM_IME_KEYLAST		equ 010Fh
WM_INITDIALOG	equ 0110h
WM_COMMAND		equ 0111h
WM_SYSCOMMAND	equ 0112h
WM_TIMER		equ 0113h
WM_HSCROLL		equ 0114h
WM_VSCROLL		equ 0115h
WM_INITMENU		equ 0116h
WM_INITMENUPOPUP	equ 0117h
WM_MENUSELECT	equ 011Fh
WM_MENUCHAR		equ 0120h
WM_ENTERIDLE	equ 0121h
WM_CTLCOLORMSGBOX	equ 0132h
WM_CTLCOLOREDIT	equ 0133h
WM_CTLCOLORLISTBOX equ 0134h
WM_CTLCOLORBTN	equ 0135h
WM_CTLCOLORDLG	equ 0136h
WM_CTLCOLORSCROLLBAR equ 0137h
WM_CTLCOLORSTATIC	equ 0138h

WM_MOUSEFIRST	equ 0200h
WM_MOUSEMOVE	equ 0200h
WM_LBUTTONDOWN	equ 0201h
WM_LBUTTONUP	equ 0202h
WM_LBUTTONDBLCLK	equ 0203h
WM_RBUTTONDOWN	equ 0204h
WM_RBUTTONUP	equ 0205h
WM_RBUTTONDBLCLK	equ 0206h
WM_MBUTTONDOWN	equ 0207h
WM_MBUTTONUP	equ 0208h
WM_MBUTTONDBLCLK	equ 0209h
WM_MOUSELAST	equ 0209h
WM_PARENTNOTIFY	equ 0210h
WM_ENTERMENULOOP	equ 0211h
WM_EXITMENULOOP	equ 0212h
WM_NEXTMENU		equ 0213h
WM_SIZING		equ 0214h
WM_CAPTURECHANGED	equ 0215h
WM_MOVING		equ 0216h
WM_POWERBROADCAST	equ 0218h
WM_DEVICECHANGE	equ 0219h
WM_MDICREATE	equ 0220h
WM_MDIDESTROY	equ 0221h
WM_MDIACTIVATE	equ 0222h
WM_MDIRESTORE	equ 0223h
WM_MDINEXT		equ 0224h
WM_MDIMAXIMIZE	equ 0225h
WM_MDITILE		equ 0226h
WM_MDICASCADE	equ 0227h
WM_MDIICONARRANGE	equ 0228h
WM_MDIGETACTIVE	equ 0229h
WM_MDISETMENU	equ 0230h
WM_ENTERSIZEMOVE	equ 0231h
WM_EXITSIZEMOVE	equ 0232h
WM_DROPFILES	equ 0233h
WM_MDIREFRESHMENU	equ 0234h
WM_IME_SETCONTEXT	equ 0281h
WM_IME_NOTIFY	equ 0282h
WM_IME_CONTROL	equ 0283h
WM_IME_COMPOSITIONFULL equ 0284h
WM_IME_SELECT	equ 0285h
WM_IME_CHAR		equ 0286h
WM_IME_KEYDOWN	equ 0290h
WM_IME_KEYUP	equ 0291h

WM_CUT		equ 0300h
WM_COPY		equ 0301h
WM_PASTE		equ 0302h
WM_CLEAR		equ 0303h
WM_UNDO		equ 0304h
WM_RENDERFORMAT	equ 0305h
WM_RENDERALLFORMATS equ 0306h
WM_DESTROYCLIPBOARD equ 0307h
WM_DRAWCLIPBOARD	equ 0308h
WM_PAINTCLIPBOARD	equ 0309h
WM_VSCROLLCLIPBOARD equ 030Ah
WM_SIZECLIPBOARD	equ 030Bh
WM_ASKCBFORMATNAME equ 030Ch
WM_CHANGECBCHAIN	equ 030Dh
WM_HSCROLLCLIPBOARD  equ 030Eh
WM_QUERYNEWPALETTE   equ 030Fh
WM_PALETTEISCHANGING equ 0310h
WM_PALETTECHANGED	equ 0311h
WM_HOTKEY		equ 0312h
WM_PRINT		equ 0317h
WM_PRINTCLIENT	equ 0318h

WM_HANDHELDFIRST	equ 0358h
WM_HANDHELDLAST	equ 035Fh
WM_AFXFIRST		equ 0360h
WM_AFXLAST		equ 037Fh
WM_PENWINFIRST	equ 0380h
WM_PENWINLAST	equ 038Fh

WM_USER		equ 0400h
WM_APP		equ 8000h
;
; Window styles
;
WS_OVERLAPPED	equ (0000h shl 16)
WS_POPUP		equ (8000h shl 16)
WS_CHILD		equ (4000h shl 16)

WS_MINIMIZE		equ (2000h shl 16)
WS_VISIBLE		equ (1000h shl 16)
WS_DISABLED		equ (0800h shl 16)
WS_CLIPSIBLINGS	equ (0400h shl 16)
WS_CLIPCHILDREN	equ (0200h shl 16)
WS_MAXIMIZE		equ (0100h shl 16)

WS_CAPTION		equ (00C0h shl 16)
WS_BORDER		equ (0080h shl 16)
WS_DLGFRAME		equ (0040h shl 16)

WS_VSCROLL		equ (0020h shl 16)
WS_HSCROLL		equ (0010h shl 16)
WS_SYSMENU		equ (0008h shl 16)
WS_THICKFRAME	equ (0004h shl 16)

WS_GROUP		equ (0002h shl 16)
WS_TABSTOP		equ (0001h shl 16)

WS_MINIMIZEBOX	equ (0002h shl 16)
WS_MAXIMIZEBOX	equ (0001h shl 16)

WS_TILED		equ WS_OVERLAPPED
WS_ICONIC		equ WS_MINIMIZE
WS_SIZEBOX		equ WS_THICKFRAME
WS_TILEDWINDOW	equ WS_OVERLAPPEDWINDOW

WS_OVERLAPPEDWINDOW  equ WS_OVERLAPPED or WS_CAPTION or WS_THICKFRAME or \
                         WS_SYSMENU or WS_MINIMIZEBOX or WS_MAXIMIZEBOX
WS_POPUPWINDOW	equ WS_POPUP or WS_BORDER or WS_SYSMENU
WS_CHILDWINDOW	equ WS_CHILD
;
; Extended window styles
;
WS_EX_DLGMODALFRAME	equ 0001h
WS_EX_NOPARENTNOTIFY	equ 0004h
WS_EX_TOPMOST		equ 0008h
WS_EX_ACCEPTFILES		equ 0010h
WS_EX_TRANSPARENT		equ 0020h

WS_EX_MDICHILD		equ 0040h
WS_EX_TOOLWINDOW		equ 0080h
WS_EX_WINDOWEDGE		equ 0100h
WS_EX_CLIENTEDGE		equ 0200h
WS_EX_CONTEXTHELP		equ 0400h

WS_EX_LEFT			equ 0 ; left alignment
WS_EX_RIGHT			equ 1000h
WS_EX_LTRREADING		equ 0 ; left-to-right reading
WS_EX_RTLREADING		equ 2000h
WS_EX_RIGHTSCROLLBAR	equ 0 ; scrollbar on right or bottom
WS_EX_LEFTSCROLLBAR	equ 4000h

WS_EX_CONTROLPARENT	equ 10000h
WS_EX_STATICEDGE		equ 20000h
WS_EX_APPWINDOW		equ 40000h

WS_EX_OVERLAPPEDWINDOW	equ WS_EX_WINDOWEDGE or WS_EX_CLIENTEDGE
WS_EX_PALETTEWINDOW	equ WS_EX_WINDOWEDGE or WS_EX_TOOLWINDOW or \
				    WS_EX_TOPMOST
;
; Stock GDI objects
;
WHITE_BRUSH         equ  0
LTGRAY_BRUSH        equ  1
GRAY_BRUSH          equ  2
DKGRAY_BRUSH        equ  3
BLACK_BRUSH         equ  4
NULL_BRUSH          equ  5
HOLLOW_BRUSH        equ  5
WHITE_PEN           equ  6
BLACK_PEN           equ  7
NULL_PEN            equ  8
DOT_MARKER          equ  9
OEM_FIXED_FONT      equ 10
ANSI_FIXED_FONT     equ 11
ANSI_VAR_FONT       equ 12
SYSTEM_FONT         equ 13
DEVICE_DEFAULT_FONT equ 14
DEFAULT_PALETTE     equ 15
SYSTEM_FIXED_FONT   equ 16
;
; GDI Raster Ops
;
; Ternary
;
SRCCPY   equ 00CC0020h

; Selection of API function names when there are two versions.
;
; For the three core Win95 DLL's 
; KERNEL32, USER32, and GDI32

; Kernel32

ifdef UNICODE

AddAtom	equ AddAtomW
BeginUpdateResource	equ BeginUpdateResourceW
BuildCommDCB	equ BuildCommDCBW
BuildCommDCBAndTimeouts	equ BuildCommDCBAndTimeoutsW
CallNamedPipe	equ CallNamedPipeW
CommConfigDialog	equ CommConfigDialogW
CompareString	equ CompareStringW
CopyFile	equ CopyFileW
CreateDirectory	equ CreateDirectoryW
CreateDirectoryEx	equ CreateDirectoryExW
CreateEvent	equ CreateEventW
CreateFile	equ CreateFileW
CreateFileMapping	equ CreateFileMappingW
CreateMailslot	equ CreateMailslotW
CreateMutex	equ CreateMutexW
CreateNamedPipe	equ CreateNamedPipeW
CreateProcess	equ CreateProcessW
CreateSemaphore	equ CreateSemaphoreW
DefineDosDevice	equ DefineDosDeviceW
DeleteFile	equ DeleteFileW
EndUpdateResource	equ EndUpdateResourceW
EnumCalendarInfo	equ EnumCalendarInfoW
EnumDateFormats	equ EnumDateFormatsW
EnumResourceLanguages	equ EnumResourceLanguagesW
EnumResourceNames	equ EnumResourceNamesW
EnumResourceTypes	equ EnumResourceTypesW
EnumSystemCodePages	equ EnumSystemCodePagesW
EnumSystemLocales	equ EnumSystemLocalesW
EnumTimeFormats	equ EnumTimeFormatsW
ExpandEnvironmentStrings	equ ExpandEnvironmentStringsW
FatalAppExit	equ FatalAppExitW
FillConsoleOutputCharacter	equ FillConsoleOutputCharacterW
FindAtom	equ FindAtomW
FindFirstChangeNotification	equ FindFirstChangeNotificationW
FindFirstFile	equ FindFirstFileW
FindNextFile	equ FindNextFileW
FindResourceEx	equ FindResourceExW
FindResource	equ FindResourceW
FoldString		equ FoldStringW
FormatMessage	equ FormatMessageW
FreeEnvironmentStrings	equ FreeEnvironmentStringsW
GetAtomName	equ GetAtomNameW
GetBinaryType	equ GetBinaryTypeW
GetCommandLine	equ GetCommandLineW
GetCompressedFileSize	equ GetCompressedFileSizeW
GetComputerName	equ GetComputerNameW
GetConsoleTitle	equ GetConsoleTitleW
GetCurrencyFormat	equ GetCurrencyFormatW
GetCurrentDirectory	equ GetCurrentDirectoryW
GetDateFormat	equ GetDateFormatW
GetDefaultCommConfig	equ GetDefaultCommConfigW
GetDiskFreeSpace	equ GetDiskFreeSpaceW
GetDriveType	equ GetDriveTypeW
GetEnvironmentStrings	equ GetEnvironmentStringsW
GetEnvironmentVariable	equ GetEnvironmentVariableW
GetFileAttributes	equ GetFileAttributesW
GetFullPathName	equ GetFullPathNameW
GetLocaleInfo	equ GetLocaleInfoW
GetLogicalDriveStrings	equ GetLogicalDriveStringsW
GetModuleFileName	equ GetModuleFileNameW
GetModuleHandle	equ GetModuleHandleW
GetNamedPipeHandleState	equ GetNamedPipeHandleStateW
GetNumberFormat	equ GetNumberFormatW
GetPrivateProfileInt	equ GetPrivateProfileIntW
GetPrivateProfileSectionNames	equ GetPrivateProfileSectionNamesW
GetPrivateProfileSection	equ GetPrivateProfileSectionW
GetPrivateProfileString	equ GetPrivateProfileStringW
GetPrivateProfileStruct	equ GetPrivateProfileStructW
GetProfileInt	equ GetProfileIntW
GetProfileSection	equ GetProfileSectionW
GetProfileString	equ GetProfileStringW
GetShortPathName	equ GetShortPathNameW
GetStartupInfo	equ GetStartupInfoW
GetStringTypeEx	equ GetStringTypeExW
GetStringType	equ GetStringTypeW
GetSystemDirectory	equ GetSystemDirectoryW
GetTempFileName	equ GetTempFileNameW
GetTempPath	equ GetTempPathW
GetTimeFormat	equ GetTimeFormatW
GetVersionEx	equ GetVersionExW
GetVolumeInformation	equ GetVolumeInformationW
GetWindowsDirectory	equ GetWindowsDirectoryW
GlobalAddAtom	equ GlobalAddAtomW
GlobalFindAtom	equ GlobalFindAtomW
GlobalGetAtomName	equ GlobalGetAtomNameW
IsBadStringPtr	equ IsBadStringPtrW
LCMapString	equ LCMapStringW
LoadLibraryEx	equ LoadLibraryExW
LoadLibrary	equ LoadLibraryW
MoveFileEx	equ MoveFileExW
MoveFile	equ MoveFileW
OpenEvent	equ OpenEventW
OpenFileMapping	equ OpenFileMappingW
OpenMutex	equ OpenMutexW
OpenSemaphore	equ OpenSemaphoreW
OutputDebugString	equ OutputDebugStringW
PeekConsoleInput	equ PeekConsoleInputW
QueryDosDevice	equ QueryDosDeviceW
ReadConsoleInput	equ ReadConsoleInputW
ReadConsoleOutputCharacter	equ ReadConsoleOutputCharacterW
ReadConsoleOutput	equ ReadConsoleOutputW
ReadConsole	equ ReadConsoleW
RemoveDirectory	equ RemoveDirectoryW
ScrollConsoleScreenBuffer	equ ScrollConsoleScreenBufferW
SearchPath	equ SearchPathW
SetComputerName	equ SetComputerNameW
SetConsoleTitle	equ SetConsoleTitleW
SetCurrentDirectory	equ SetCurrentDirectoryW
SetDefaultCommConfig	equ SetDefaultCommConfigW
SetEnvironmentVariable	equ SetEnvironmentVariableW
SetFileAttributes	equ SetFileAttributesW
SetLocaleInfo	equ SetLocaleInfoW
SetVolumeLabel	equ SetVolumeLabelW
UpdateResource	equ UpdateResourceW
VerLanguageName	equ VerLanguageNameW
WaitNamedPipe	equ WaitNamedPipeW
WriteConsoleInput	equ WriteConsoleInputW
WriteConsoleOutputCharacter	equ WriteConsoleOutputCharacterW
WriteConsoleOutput	equ WriteConsoleOutputW
WriteConsole	equ WriteConsoleW
WritePrivateProfileSection	equ WritePrivateProfileSectionW
WritePrivateProfileString	equ WritePrivateProfileStringW
WritePrivateProfileStruct	equ WritePrivateProfileStructW
WriteProfileSection	equ WriteProfileSectionW
WriteProfileString	equ WriteProfileStringW
lstrcat	equ lstrcatW
lstrcmp	equ lstrcmpW
lstrcmpi	equ lstrcmpiW
lstrcpy	equ lstrcpyW
lstrcpyn	equ lstrcpynW
lstrlen	equ lstrlenW

else

AddAtom	equ AddAtomA
BeginUpdateResource	equ BeginUpdateResourceA
BuildCommDCB	equ BuildCommDCBA
BuildCommDCBAndTimeouts	equ BuildCommDCBAndTimeoutsA
CallNamedPipe	equ CallNamedPipeA
CommConfigDialog	equ CommConfigDialogA
CompareString	equ CompareStringA
CopyFile	equ CopyFileA
CreateDirectory	equ CreateDirectoryA
CreateDirectoryEx	equ CreateDirectoryExA
CreateEvent	equ CreateEventA
CreateFile	equ CreateFileA
CreateFileMapping	equ CreateFileMappingA
CreateMailslot	equ CreateMailslotA
CreateMutex	equ CreateMutexA
CreateNamedPipe	equ CreateNamedPipeA
CreateProcess	equ CreateProcessA
CreateSemaphore	equ CreateSemaphoreA
DefineDosDevice	equ DefineDosDeviceA
DeleteFile	equ DeleteFileA
EndUpdateResource	equ EndUpdateResourceA
EnumCalendarInfo	equ EnumCalendarInfoA
EnumDateFormats	equ EnumDateFormatsA
EnumResourceLanguages	equ EnumResourceLanguagesA
EnumResourceNames	equ EnumResourceNamesA
EnumResourceTypes	equ EnumResourceTypesA
EnumSystemCodePages	equ EnumSystemCodePagesA
EnumSystemLocales	equ EnumSystemLocalesA
EnumTimeFormats	equ EnumTimeFormatsA
ExpandEnvironmentStrings	equ ExpandEnvironmentStringsA
FatalAppExit	equ FatalAppExitA
FillConsoleOutputCharacter	equ FillConsoleOutputCharacterA
FindAtom	equ FindAtomA
FindFirstChangeNotification	equ FindFirstChangeNotificationA
FindFirstFile	equ FindFirstFileA
FindNextFile	equ FindNextFileA
FindResource	equ FindResourceA
FindResourceEx	equ FindResourceExA
FoldString	equ FoldStringA
FormatMessage	equ FormatMessageA
FreeEnvironmentStrings	equ FreeEnvironmentStringsA
GetAtomName	equ GetAtomNameA
GetBinaryType	equ GetBinaryTypeA
GetCommandLine	equ GetCommandLineA
GetCompressedFileSize	equ GetCompressedFileSizeA
GetComputerName	equ GetComputerNameA
GetConsoleTitle	equ GetConsoleTitleA
GetCurrencyFormat	equ GetCurrencyFormatA
GetCurrentDirectory	equ GetCurrentDirectoryA
GetDateFormat	equ GetDateFormatA
GetDefaultCommConfig	equ GetDefaultCommConfigA
GetDiskFreeSpace	equ GetDiskFreeSpaceA
GetDriveType	equ GetDriveTypeA
GetEnvironmentStrings	equ GetEnvironmentStringsA
GetEnvironmentVariable	equ GetEnvironmentVariableA
GetFileAttributes	equ GetFileAttributesA
GetFullPathName	equ GetFullPathNameA
GetLocaleInfo	equ GetLocaleInfoA
GetLogicalDriveStrings	equ GetLogicalDriveStringsA
GetModuleFileName	equ GetModuleFileNameA
GetModuleHandle	equ GetModuleHandleA
GetNamedPipeHandleState	equ GetNamedPipeHandleStateA
GetNumberFormat	equ GetNumberFormatA
GetPrivateProfileInt	equ GetPrivateProfileIntA
GetPrivateProfileSection	equ GetPrivateProfileSectionA
GetPrivateProfileSectionNames	equ GetPrivateProfileSectionNamesA
GetPrivateProfileString	equ GetPrivateProfileStringA
GetPrivateProfileStruct	equ GetPrivateProfileStructA
GetProfileInt	equ GetProfileIntA
GetProfileSection	equ GetProfileSectionA
GetProfileString	equ GetProfileStringA
GetShortPathName	equ GetShortPathNameA
GetStartupInfo	equ GetStartupInfoA
GetStringType	equ GetStringTypeA
GetStringTypeEx	equ GetStringTypeExA
GetSystemDirectory	equ GetSystemDirectoryA
GetTempFileName	equ GetTempFileNameA
GetTempPath	equ GetTempPathA
GetTimeFormat	equ GetTimeFormatA
GetVersionEx	equ GetVersionExA
GetVolumeInformation	equ GetVolumeInformationA
GetWindowsDirectory	equ GetWindowsDirectoryA
GlobalAddAtom	equ GlobalAddAtomA
GlobalFindAtom	equ GlobalFindAtomA
GlobalGetAtomName	equ GlobalGetAtomNameA
IsBadStringPtr	equ IsBadStringPtrA
LCMapString	equ LCMapStringA
LoadLibrary	equ LoadLibraryA
LoadLibraryEx	equ LoadLibraryExA
MoveFile	equ MoveFileA
MoveFileEx	equ MoveFileExA
OpenEvent	equ OpenEventA
OpenFileMapping	equ OpenFileMappingA
OpenMutex	equ OpenMutexA
OpenSemaphore	equ OpenSemaphoreA
OutputDebugString	equ OutputDebugStringA
PeekConsoleInput	equ PeekConsoleInputA
QueryDosDevice	equ QueryDosDeviceA
ReadConsole	equ ReadConsoleA
ReadConsoleInput	equ ReadConsoleInputA
ReadConsoleOutput	equ ReadConsoleOutputA
ReadConsoleOutputCharacter	equ ReadConsoleOutputCharacterA
RemoveDirectory	equ RemoveDirectoryA
ScrollConsoleScreenBuffer	equ ScrollConsoleScreenBufferA
SearchPath	equ SearchPathA
SetComputerName	equ SetComputerNameA
SetConsoleTitle	equ SetConsoleTitleA
SetCurrentDirectory	equ SetCurrentDirectoryA
SetDefaultCommConfig	equ SetDefaultCommConfigA
SetEnvironmentVariable	equ SetEnvironmentVariableA
SetFileAttributes	equ SetFileAttributesA
SetLocaleInfo	equ SetLocaleInfoA
SetVolumeLabel	equ SetVolumeLabelA
UpdateResource	equ UpdateResourceA
VerLanguageName	equ VerLanguageNameA
WaitNamedPipe	equ WaitNamedPipeA
WriteConsole	equ WriteConsoleA
WriteConsoleInput	equ WriteConsoleInputA
WriteConsoleOutput	equ WriteConsoleOutputA
WriteConsoleOutputCharacter	equ WriteConsoleOutputCharacterA
WritePrivateProfileSection	equ WritePrivateProfileSectionA
WritePrivateProfileString	equ WritePrivateProfileStringA
WritePrivateProfileStruct	equ WritePrivateProfileStructA
WriteProfileSection	equ WriteProfileSectionA
WriteProfileString	equ WriteProfileStringA
lstrcat	equ lstrcatA
lstrcmp	equ lstrcmpA
lstrcmpi	equ lstrcmpiA
lstrcpy	equ lstrcpyA
lstrcpyn	equ lstrcpynA
lstrlen	equ lstrlenA

endif

; User32

ifdef UNICODE

AppendMenu	equ AppendMenuW
CallMsgFilter	equ CallMsgFilterW
CallWindowProc	equ CallWindowProcW
ChangeDisplaySettings	equ ChangeDisplaySettingsW
ChangeMenu	equ ChangeMenuW
CharLowerBuff	equ CharLowerBuffW
CharLower	equ CharLowerW
CharNextEx	equ CharNextExW
CharNext	equ CharNextW
CharPrevEx	equ CharPrevExW
CharPrev	equ CharPrevW
CharToOemBuff	equ CharToOemBuffW
CharToOem	equ CharToOemW
CharUpperBuff	equ CharUpperBuffW
CharUpper	equ CharUpperW
CopyAcceleratorTable	equ CopyAcceleratorTableW
CreateAcceleratorTable	equ CreateAcceleratorTableW
CreateDesktop	equ CreateDesktopW
CreateDialogIndirectParam	equ CreateDialogIndirectParamW
CreateDialogParam	equ CreateDialogParamW
CreateMDIWindow	equ CreateMDIWindowW
CreateWindowEx	equ CreateWindowExW
CreateWindowStation	equ CreateWindowStationW
DdeCreateStringHandle	equ DdeCreateStringHandleW
DdeInitialize	equ DdeInitializeW
DdeQueryString	equ DdeQueryStringW
DefDlgProc	equ DefDlgProcW
DefFrameProc	equ DefFrameProcW
DefMDIChildProc	equ DefMDIChildProcW
DefWindowProc	equ DefWindowProcW
DialogBoxIndirectParam	equ DialogBoxIndirectParamW
DialogBoxParam	equ DialogBoxParamW
DispatchMessage	equ DispatchMessageW
DlgDirListComboBox	equ DlgDirListComboBoxW
DlgDirList	equ DlgDirListW
DlgDirSelectComboBoxEx	equ DlgDirSelectComboBoxExW
DlgDirSelectEx	equ DlgDirSelectExW
DrawCaptionTemp	equ DrawCaptionTempW
DrawState	equ DrawStateW
DrawTextEx	equ DrawTextExW
DrawText	equ DrawTextW
EnumDesktops	equ EnumDesktopsW
EnumDisplaySettings	equ EnumDisplaySettingsW
EnumPropsEx	equ EnumPropsExW
EnumProps	equ EnumPropsW
EnumWindowStations	equ EnumWindowStationsW
FindWindowEx	equ FindWindowExW
FindWindow	equ FindWindowW
GetClassInfoEx	equ GetClassInfoExW
GetClassIngo	equ GetClassInfoW
GetClassLong	equ GetClassLongW
GetClassName	equ GetClassNameW
GetClipboardFormatName	equ GetClipboardFormatNameW
GetDlgItemText	equ GetDlgItemTextW
GetKeyNameText	equ GetKeyNameTextW
GetKeyboardLayoutName	equ GetKeyboardLayoutNameW
GetMenuItemInfo	equ GetMenuItemInfoW
GetMenuString	equ GetMenuStringW
GetMessage	equ GetMessageW
GetProp	equ GetPropW
GetTabbedTextExtent	equ GetTabbedTextExtentW
GetUserObjectInformation	equ GetUserObjectInformationW
GetWindowLong	equ GetWindowLongW
GetWindowTextLength	equ GetWindowTextLengthW
GetWindowText	equ GetWindowTextW
GrayString	equ GrayStringW
InsertMenuItem	equ InsertMenuItemW
InsertMenu	equ InsertMenuW
IsCharAlphaNumeric	equ IsCharAlphaNumericW
IsCharAlpha	equ IsCharAlphaW
IsCharLower	equ IsCharLowerW
IsCharUpper	equ IsCharUpperW
IsDialogMessage	equ IsDialogMessageW
LoadAccelerators	equ LoadAcceleratorsW
LoadBitmap	equ LoadBitmapW
LoadCursorFromFile	equ LoadCursorFromFileW
LoadCursor	equ LoadCursorW
LoadIcon	equ LoadIconW
LoadImage	equ LoadImageW
LoadKeyboardLayout	equ LoadKeyboardLayoutW
LoadMenuIndirect	equ LoadMenuIndirectW
LoadMenu	equ LoadMenuW
LoadString	equ LoadStringW
MapVirtualKeyEx	equ MapVirtualKeyExW
MapVirtualKey	equ MapVirtualKeyW
MessageBoxEx	equ MessageBoxExW
MessageBoxIndirect	equ MessageBoxIndirectW
MessageBox	equ MessageBoxW
ModifyMenu	equ ModifyMenuW
OemToCharBuff	equ OemToCharBuffW
OemToChar	equ OemToCharW
OpenDesktop	equ OpenDesktopW
OpenWindowStation	equ OpenWindowStationW
PeekMessage	equ PeekMessageW
PostMessage	equ PostMessageW
PostThreadMessage	equ PostThreadMessageW
RegisterClassEx	equ RegisterClassExW
RegisterClass	equ RegisterClassW
RegisterClipboardFormat	equ RegisterClipboardFormatW
RegisterWindowMessage	equ RegisterWindowMessageW
RemoveProp	equ RemovePropW
SendDlgItemMessage	equ SendDlgItemMessageW
SendMessageCallback	equ SendMessageCallbackW
SendMessageTimeout	equ SendMessageTimeoutW
SendMessage	equ SendMessageW
SendNotifyMessage	equ SendNotifyMessageW
SetClassLong	equ SetClassLongW
SetDlgItemText	equ SetDlgItemTextW
SetMenuItemInfo	equ SetMenuItemInfoW
SetProp	equ SetPropW
SetUserObjectInformation	equ SetUserObjectInformationW
SetWindowLong	equ SetWindowLongW
SetWindowText	equ SetWindowTextW
SetWindowsHookEx	equ SetWindowsHookExW
SetWindowsHook	equ SetWindowsHookW
SystemParametersInfo	equ SystemParametersInfoW
TabbedTextOut	equ TabbedTextOutW
TranslateAccelerator	equ TranslateAcceleratorW
UnregisterClass	equ UnregisterClassW
VkKeyScanEx	equ VkKeyScanExW
VkKeyScan	equ VkKeyScanW
WinHelp	equ WinHelpW
wsprintf	equ wsprintfW
wvsprintf	equ wvsprintfW

else

AppendMenu	equ AppendMenuA
CallMsgFilter	equ CallMsgFilterA
CallWindowProc	equ CallWindowProcA
ChangeDisplaySettings	equ ChangeDisplaySettingsA
ChangeMenu	equ ChangeMenuA
CharLower	equ CharLowerA
CharLowerBuff	equ CharLowerBuffA
CharNext	equ CharNextA
CharNextEx	equ CharNextExA
CharPrev	equ CharPrevA
CharPrevEx	equ CharPrevExA
CharToOem	equ CharToOemA
CharToOemBuff	equ CharToOemBuffA
CharUpper	equ CharUpperA
CharUpperBuff	equ CharUpperBuffA
CopyAcceleratorTable	equ CopyAcceleratorTableA
CreateAcceleratorTable	equ CreateAcceleratorTableA
CreateDesktop	equ CreateDesktopA
CreateDialogIndirectParam	equ CreateDialogIndirectParamA
CreateDialogParam	equ CreateDialogParamA
CreateMDIWindow	equ CreateMDIWindowA
CreateWindowEx	equ CreateWindowExA
CreateWindowStation	equ CreateWindowStationA
DdeCreateStringHandle	equ DdeCreateStringHandleA
DdeInitialize	equ DdeInitializeA
DdeQueryString	equ DdeQueryStringA
DefDlgProc	equ DefDlgProcA
DefFrameProc	equ DefFrameProcA
DefMDIChildProc	equ DefMDIChildProcA
DefWindowProc	equ DefWindowProcA
DialogBoxIndirectParam	equ DialogBoxIndirectParamA
DialogBoxParam	equ DialogBoxParamA
DispatchMessage	equ DispatchMessageA
DlgDirList	equ DlgDirListA
DlgDirListComboBox	equ DlgDirListComboBoxA
DlgDirSelectComboBoxEx	equ DlgDirSelectComboBoxExA
DlgDirSelectEx	equ DlgDirSelectExA
DrawCaptionTemp	equ DrawCaptionTempA
DrawState	equ DrawStateA
DrawText	equ DrawTextA
DrawTextEx	equ DrawTextExA
EnumDesktops	equ EnumDesktopsA
EnumDisplaySettings	equ EnumDisplaySettingsA
EnumProps	equ EnumPropsA
EnumPropsEx	equ EnumPropsExA
EnumWindowStations	equ EnumWindowStationsA
FindWindow	equ FindWindowA
FindWindowEx	equ FindWindowExA
GetClassInfo	equ GetClassInfoA
GetClassInfoEx	equ GetClassInfoExA
GetClassLong	equ GetClassLongA
GetClassName	equ GetClassNameA
GetClipboardFormatName	equ GetClipboardFormatNameA
GetDlgItemText	equ GetDlgItemTextA
GetKeyNameText	equ GetKeyNameTextA
GetKeyboardLayoutName	equ GetKeyboardLayoutNameA
GetMenuItemInfo	equ GetMenuItemInfoA
GetMenuString	equ GetMenuStringA
GetMessage	equ GetMessageA
GetProp	equ GetPropA
GetTabbedTextExtent	equ GetTabbedTextExtentA
GetUserObjectInformation	equ GetUserObjectInformationA
GetWindowLong	equ GetWindowLongA
GetWindowText	equ GetWindowTextA
GetWindowTextLength	equ GetWindowTextLengthA
GrayString	equ GrayStringA
InsertMenu	equ InsertMenuA
InsertMenuItem	equ InsertMenuItemA
IsCharAlpha	equ IsCharAlphaA
IsCharAlphaNumeric	equ IsCharAlphaNumericA
IsCharLower	equ IsCharLowerA
IsCharUpper	equ IsCharUpperA
IsDialogMessage	equ IsDialogMessageA
LoadAccelerators	equ LoadAcceleratorsA
LoadBitmap	equ LoadBitmapA
LoadCursor	equ LoadCursorA
LoadCursorFromFile	equ LoadCursorFromFileA
LoadIcon	equ LoadIconA
LoadImage	equ LoadImageA
LoadKeyboardLayout	equ LoadKeyboardLayoutA
LoadMenu	equ LoadMenuA
LoadMenuIndirect	equ LoadMenuIndirectA
LoadString	equ LoadStringA
MapVirtualKey	equ MapVirtualKeyA
MapVirtualKeyEx	equ MapVirtualKeyExA
MessageBox	equ MessageBoxA
MessageBoxEx	equ MessageBoxExA
MessageBoxIndirect	equ MessageBoxIndirectA
ModifyMenu	equ ModifyMenuA
OemToChar	equ OemToCharA
OemToCharBuff	equ OemToCharBuffA
OpenDesktop	equ OpenDesktopA
OpenWindowStation	equ OpenWindowStationA
PeekMessage	equ PeekMessageA
PostMessage	equ PostMessageA
PostThreadMessage	equ PostThreadMessageA
RegisterClass	equ RegisterClassA
RegisterClassEx	equ RegisterClassExA
RegisterClipboardFormat	equ RegisterClipboardFormatA
RegisterWindowMessage	equ RegisterWindowMessageA
RemoveProp	equ RemovePropA
SendDlgItemMessage	equ SendDlgItemMessageA
SendMessage	equ SendMessageA
SendMessageCallback	equ SendMessageCallbackA
SendMessageTimeout	equ SendMessageTimeoutA
SendNotifyMessage	equ SendNotifyMessageA
SetClassLong	equ SetClassLongA
SetDlgItemText	equ SetDlgItemTextA
SetMenuItemInfo	equ SetMenuItemInfoA
SetProp	equ SetPropA
SetUserObjectInformation	equ SetUserObjectInformationA
SetWindowLong	equ SetWindowLongA
SetWindowText	equ SetWindowTextA
SetWindowsHook	equ SetWindowsHookA
SetWindowsHookEx	equ SetWindowsHookExA
SystemParametersInfo	equ SystemParametersInfoA
TabbedTextOut	equ TabbedTextOutA
TranslateAccelerator	equ TranslateAcceleratorA
UnregisterClass	equ UnregisterClassA
VkKeyScan	equ VkKeyScanA
VkKeyScanEx	equ VkKeyScanExA
WinHelp	equ WinHelpA
wsprintf	equ wsprintfA
wvsprintf	equ wvsprintfA

endif

; GDI32

ifdef UNICODE

AddFontResource	equ AddFontResourceW
CopyEnhMetaFile	equ CopyEnhMetaFileW
CopyMetaFile	equ CopyMetaFileW
CreateColorSpace	equ CreateColorSpaceW
CreateDC	equ CreateDCW
CreateEnhMetaFile	equ CreateEnhMetaFileW
CreateFontIndirect	equ CreateFontIndirectW
CreateFont	equ CreateFontW
CreateIC	equ CreateICW
CreateMetaFile	equ CreateMetaFileW
CreateScalableFontResource	equ CreateScalableFontResourceW
DeviceCapabilitiesEx	equ DeviceCapabilitiesExW
EnumFontFamiliesEx	equ EnumFontFamiliesExW
EnumFontFamilies	equ EnumFontFamiliesW
EnumFonts	equ EnumFontsW
EnumICMProfiles	equ EnumICMProfilesW
ExtTextOut	equ ExtTextOutW
GetCharABCWidthsFloat	equ GetCharABCWidthsFloatW
GetCharABCWidths	equ GetCharABCWidthsW
GetCharWidth32	equ GetCharWidth32W
GetCharWidthFloat	equ GetCharWidthFloatW
GetCharWidth	equ GetCharWidthW
GetCharacterPlacement	equ GetCharacterPlacementW
GetEnhMetaFileDescription	equ GetEnhMetaFileDescriptionW
GetEnhMetaFile	equ GetEnhMetaFileW
GetGlyphOutline	equ GetGlyphOutlineW
GetICMProfile	equ GetICMProfileW
GetKerningPairs	equ GetKerningPairsW
GetLogColorSpace	equ GetLogColorSpaceW
GetMetaFile	equ GetMetaFileW
GetObject	equ GetObjectW
GetOutlineTextMetrics	equ GetOutlineTextMetricsW
GetTextExtentExPoint	equ GetTextExtentExPointW
GetTextExtentPoint32	equ GetTextExtentPoint32W
GetTextExtentPoint	equ GetTextExtentPointW
GetTextFace	equ GetTextFaceW
GetTextMetrics	equ GetTextMetricsW
PolyTextOut	equ PolyTextOutW
RemoveFontResource	equ RemoveFontResourceW
ResetDC	equ ResetDCW
SetICMProfile	equ SetICMProfileW
StartDoc	equ StartDocW
TextOut	equ TextOutW
UpdateICMRegKey	equ UpdateICMRegKeyW

else

AddFontResource	equ AddFontResourceA
CopyEnhMetaFile	equ CopyEnhMetaFileA
CopyMetaFile	equ CopyMetaFileA
CreateColorSpace	equ CreateColorSpaceA
CreateDC	equ CreateDCA
CreateEnhMetaFile	equ CreateEnhMetaFileA
CreateFont	equ CreateFontA
CreateFontIndirect	equ CreateFontIndirectA
CreateIC	equ CreateICA
CreateMetaFile	equ CreateMetaFileA
CreateScalableFontResource	equ CreateScalableFontResourceA
DeviceCapabilitiesEx	equ DeviceCapabilitiesExA
EnumFontFamilies	equ EnumFontFamiliesA
EnumFontFamilies	equ EnumFontFamiliesExA
EnumFonts	equ EnumFontsA
EnumICMProfiles	equ EnumICMProfilesA
ExtTextOut	equ ExtTextOutA
GetCharABCWidths	equ GetCharABCWidthsA
GetCharABCWidthsFloat	equ GetCharABCWidthsFloatA
GetCharWidth32	equ GetCharWidth32A
GetCharWidth	equ GetCharWidthA
GetCharWidthFloat	equ GetCharWidthFloatA
GetCharacterPlacement	equ GetCharacterPlacementA
GetEnhMetaFile	equ GetEnhMetaFileA
GetEnhMetaFileDescription	equ GetEnhMetaFileDescriptionA
GetGlyphOutline	equ GetGlyphOutlineA
GetICMProfile	equ GetICMProfileA
GetKerningPairs	equ GetKerningPairsA
GetLogColorSpace	equ GetLogColorSpaceA
GetMetaFile	equ GetMetaFileA
GetObject	equ GetObjectA
GetOutlineTextMetrics	equ GetOutlineTextMetricsA
GetTextExtentExPoint	equ GetTextExtentExPointA
GetTextExtentPoint32	equ GetTextExtentPoint32A
GetTextExtentPoint	equ GetTextExtentPointA
GetTextFace	equ GetTextFaceA
GetTextMetrics	equ GetTextMetricsA
PolyTextOut	equ PolyTextOutA
RemoveFontResource	equ RemoveFontResourceA
ResetDC	equ ResetDCA
SetICMProfile	equ SetICMProfileA
StartDoc	equ StartDocA
TextOut	equ TextOutA
UpdateICMRegKey	equ UpdateICMRegKeyA

endif

; ***** End of include
