; WINCAPTN.ASM -- Play with window caption styles.
;
; Assembles with Borland Turbo Assembler 4.0
; Use:
;
;   TASM /m /ml wincaptn
;
; where
;   /m  = multiple passes
;   /ml = case sensitive
;
; Link with:
;
;   TLINK32 /Tpe /aa /c wincaptn+winmain,,,fulldir\import32.lib
;
; where
;   /Tpe  = Win32 (PE) .EXE
;   /aa   = Windows non-console app
;   /c    = case sensitive external and public symbols
;
; Link to VC++ library (assuming environment variables are set) with:
;
;   LINK wincaptn winmain kernel32.lib user32.lib /entry:start
;
	.386
	.model	flat

	; choose the following, if necessary:
	include	vclib.inc    ; Microsoft VC++ .lib link names

	include	win32.inc    ; constants, structures, and entry names

;
; the main window
;
    .data
mainwnd dd 0

wc WNDCLASSEX <size WNDCLASSEX,CS_HREDRAW+CS_VREDRAW,WndProc,0,0, 0, \
                0,0,COLOR_WINDOW+1, 0,wndclsname,0>
mainbox CREATEARGS <0,wndclsname,caption,WS_OVERLAPPEDWINDOW+WS_VISIBLE,\
                    40,40,300,110,0,0,0,0>
wndclsname  db 'generic',0
caption  db 'Caption (title bar) styles',0
;
; Application initialization subroutine
; Returns:
;	ESI = address of a CREATEARGS structure, the CreateWindowEx argument list
;	EDI = address of a WNDCLASSEX structure, the RegisterClassEx argument
;	WINMAIN will set the hInstance field of the above structures
;
	.code

	public	InitApp,EndApp
	extrn	LoadCursor:near

InitApp:
	mov	edi,offset wc
	mov	esi,offset mainbox

	push	large IDC_ARROW
	push	large 0
	call	LoadCursor
	mov	[wc].wcxCursor,eax
	mov	[wc2].wcxCursor,eax
	ret
;
; Application cleanup subroutine
; Returns:
;	EAX = application exit code
;
EndApp:
	xor	eax,eax	; assume no errors
	ret
;
; the test display window
;
	.data
	align	4

testwnd dd 0

wc2 WNDCLASSEX <size WNDCLASSEX,CS_HREDRAW+CS_VREDRAW,DefWindowProc,0,0, \
             0, 0,0,COLOR_WINDOW+1, 0,wndclsname2,0>
test    CREATEARGS <0,wndclsname2,caption2,WS_OVERLAPPED+WS_CAPTION+\
                    WS_VISIBLE, 160,160,200,200,0,0,0,0>
wndclsname2 db 'testdisplay',0
caption2 db 'Display test',0
;
; this holds the style bits used to change
;   the style options of the test window
;
	align	4

test_style dd 0
;
; control IDs for buttons
;
IDCTL_SYSMENU equ 101
IDCTL_SIZEBOX equ 102
IDCTL_MINBOX  equ 103
IDCTL_MAXBOX  equ 104
;
; the check box "button" windows
;
	align	4

chkbox  CREATEARGS <0,btnclsname,0,WS_CHILD+WS_VISIBLE+BS_CHECKBOX,\
                    0,0,0,0, 0,0,0,0>
btnclsname  db 'button',0	; letter case doesn't matter
;
; option/button table
;
	align 4

sysmenu dd WS_SYSMENU,sysmenu_str,10,10,250,15,IDCTL_SYSMENU
sizebox dd WS_THICKFRAME,sizebox_str,10,25,250,15,IDCTL_SIZEBOX
minbox  dd WS_MINIMIZEBOX,minbox_str,10,40,250,15,IDCTL_MINBOX
maxbox  dd WS_MAXIMIZEBOX,maxbox_str,10,55,250,15,IDCTL_MAXBOX
;
; button texts
;
sysmenu_str db 'WS_SYSMENU',0
sizebox_str db 'WS_THICKFRAME/WM_SIZEBOX',0
minbox_str  db 'WS_MINIMIZEBOX',0
maxbox_str  db 'WS_MAXIMIZEBOX',0
;
; The window procedure...where messages for one class of windows
;   are processed.
;
; Parameters are hWnd, message, wParam, lParam.
;   hWnd is the window receiving this message.
;   message is the message ID.
;   wParam and lParam depend on the message ID.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn	DefWindowProc:near

	.code
WndProc:
	mov	eax,[esp+4+4]		; message ID
	cmp	eax,WM_COMMAND		; controls clicked
	je	execute_command
	cmp	eax,WM_CREATE		; window created
	je	finish_create
	cmp	eax,WM_DESTROY		; about to start window destruction
	je	start_destroy
	jmp	DefWindowProc		; delegate other message processing
;
; Process WM_CREATE.  Sent after nonclient area has been created, but
; before showing the window.
;
; Return -1 to abort window creation.  Abortion will send WM_DESTROY.
; Otherwise return zero.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn	CreateWindowEx:near
	extrn	RegisterClassEx:near

finish_create:
	mov	eax,[esp+4+0]  ; hwnd
	mov	[mainwnd],eax
	mov	eax,[wc].wcxInstance
	mov	[wc2].wcxInstance,eax
	push	offset wc2
	call	RegisterClassEx

	push	esi
	push	edi

	mov	esi,offset test
	mov	eax,[esi].cwargStyle
	mov	[test_style],eax		; save original style
	call	install_subwindow
	mov	[testwnd],eax


	mov	esi,offset chkbox
	mov	edi,offset sysmenu
	call	install_chkbox

	mov	esi,offset chkbox
	mov	edi,offset sizebox
	call	install_chkbox

	mov	esi,offset chkbox
	mov	edi,offset minbox
	call	install_chkbox

	mov	esi,offset chkbox
	mov	edi,offset maxbox
	call	install_chkbox

	pop	edi
	pop	esi

	xor	eax,eax    ; signal a successful CREATE
	ret	16
;
; Create chkbox
;
;	ESI = address of CreateWindowEx arguments
;	EDI = chkbox table entry
;
; Returns:
;
;	EAX = BUTTON handle
;
install_chkbox:
	mov	eax,4[edi]
	mov	[chkbox].cwargName,eax	; set window name = window text
	mov	eax,8[edi]
	mov	[chkbox].cwargX,eax
	mov	eax,12[edi]
	mov	[chkbox].cwargY,eax
	mov	eax,16[edi]
	mov	[chkbox].cwargCx,eax
	mov	eax,20[edi]
	mov	[chkbox].cwargCy,eax
	mov	eax,24[edi]
	mov	[chkbox].cwargMenu,eax	; ctl ID when WS_CHILD
	call	install_subwindow
	ret
;
; Create main window's subwindows
;
;	ESI = address of CreateWindowEx arguments
;
; Returns:
;
;	EAX = handle of subwindow
;
install_subwindow:
	mov	eax,[mainwnd]
	mov	[esi].cwargParent,eax	; make "mainbox" owner or parent
						;   of new window
	mov	eax,[wc].wcxInstance	; get instance
	mov	[esi].cwargInstance,eax	; set instance of window class
	sub	esp,48    ; allocate args
	mov	edi,esp
	mov	ecx,12
	rep movsd
	call	CreateWindowEx
	ret
;
; Process WM_DESTROY.  Sent after window is removed from screen, but
; before any destruction begins.
;
; Return zero if processed.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn PostQuitMessage:near

start_destroy:
	push	large 0
	call	PostQuitMessage

	xor	eax,eax
	ret	16
;
; Process WM_COMMAND.  Sent from controls, menus, and accelerators.
;
;	wParam = notification_code:control_ID
;	lParam = control handle
;
; Return zero if processed.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn	SendMessage:near
	extrn	SetWindowLong:near
	extrn	RedrawWindow:near

execute_command:
	mov	eax,[esp+4+8]	; wParam
	mov	edx,[esp+4+12]	; lParam
	cmp	eax,(BN_CLICKED shl 16)+IDCTL_SYSMENU
	je	select_sysmenu
	cmp	eax,(BN_CLICKED shl 16)+IDCTL_SIZEBOX
	je	select_sizebox
	cmp	eax,(BN_CLICKED shl 16)+IDCTL_MINBOX
	je	select_minbox
	cmp	eax,(BN_CLICKED shl 16)+IDCTL_MAXBOX
	je	select_maxbox
	jmp	exit_execute_command
;
; Get styles
;
select_sysmenu:
	mov	ecx,[sysmenu]
	jmp	toggle
select_sizebox:
	mov	ecx,[sizebox]
	jmp	toggle
select_minbox:
	mov	ecx,[minbox]
	jmp	toggle
select_maxbox:
	mov	ecx,[maxbox]
	jmp	toggle

toggle:
	push	ecx		; save style

	push	edx		; save ctl handle

	push	large 0
	push	large 0
	push	large BM_GETCHECK
	push	edx		; ctl handle from lParam
	call	SendMessage

	pop	edx		; retrieve ctl handle

	xor	eax,1		; toggle check state

	push	large 0
	push	eax		; new check state
	push	large BM_SETCHECK
	push	edx		; ctl handle
	call	SendMessage

	pop	ecx		; retrieve style

	xor	[test_style],ecx	; toggle style bit
	push	[test_style]	; new style
	push	large GWL_STYLE
	push	[testwnd]		; test window
	call	SetWindowLong

	; Force redraw of test window

	push	large (RDW_FRAME+RDW_INVALIDATE+RDW_UPDATENOW)
	push	large 0		; update rectangle
	push	large 0		; update region (overrides rect)
	push	[testwnd]		; test window
	call	RedrawWindow

exit_execute_command:
	xor	eax,eax    ; signal WM_COMMAND was processed
	ret	16

	end
