; WINCLICK.ASM -- Simple message example.
;
; Assembles with Borland Turbo Assembler 4.0
; Use:
;   TASM /m /ml winclick
;
; where
;   /m  = multiple passes
;   /ml = case sensitive
;
; Link with:
;   TLINK32 /Tpe /aa /c winclick+winmain,,,fulldir\import32.lib
;
; where
;   /Tpe  = Win32 (PE) .EXE
;   /aa   = Windows non-console app
;   /c    = case sensitive external and public symbols
;
; Link to VC++ library (assuming environment variables are set) with:
;   LINK winclick winmain kernel32.lib user32.lib /entry:start
;
	.386
	.model	flat

	; choose the following, if necessary:
	include	vclib.inc    ; Microsoft VC++ .lib link names

	include	win32.inc    ; constants, structures, and entry names

;
; Application initialization subroutine
; Returns:
;	ESI = address of a CREATEARGS structure, the CreateWindowEx argument list
;	EDI = address of a WNDCLASSEX structure, the RegisterClassEx argument
;	WINMAIN will set the hInstance field of the above structures
;
	public	InitApp,EndApp

	.code
InitApp:
	mov	edi,offset wc
	mov	esi,offset cwargs

	extrn	LoadIcon:near,LoadCursor:near

DEFAULT_CS_STYLE equ CS_VREDRAW + CS_HREDRAW + CS_DBLCLKS

	.data
wc	WNDCLASSEX <size WNDCLASSEX,DEFAULT_CS_STYLE,WndProc,0,0, 0, 0,0,COLOR_WINDOW+1, 0,wndclsname, 0>
wndclsname db 'winmain',0

	.code
	push	large IDI_WINLOGO
	push	large 0		; hInstance, 0 = stock icon
	call	LoadIcon
	mov	[edi].wcxIcon,eax
	mov	[edi].wcxSmallIcon,eax

	push	large IDC_ARROW
	push	large 0		; hInstance, 0 = stock cursor
	call	LoadCursor
	mov	[edi].wcxCursor,eax

DEFAULT_STYLE	equ WS_VISIBLE + WS_OVERLAPPED + WS_CAPTION + WS_SYSMENU + WS_THICKFRAME + WS_MINIMIZEBOX + WS_MAXIMIZEBOX
DEFAULT_EXSTYLE	equ WS_EX_WINDOWEDGE + WS_EX_CLIENTEDGE
DEFAULT_X		equ 100
DEFAULT_Y		equ 100
DEFAULT_WIDTH	equ 400
DEFAULT_HEIGHT	equ 200

	.data
	align	4
cwargs CREATEARGS <DEFAULT_EXSTYLE,wndclsname,title1,DEFAULT_STYLE, DEFAULT_X,DEFAULT_Y, DEFAULT_WIDTH,DEFAULT_HEIGHT, 0,0, 0, 0>
title1 db 'Left-click to change title',0
title2 db 'Restore title by right-clicking',0

	.code
	ret
;
; Application cleanup subroutine
; Returns:
;	EAX = application exit code
;
EndApp:
	xor	eax,eax	; assume no errors
	ret
;
; The window procedure...where messages for one class of windows
;   are processed.
;
; Parameters are hWnd, message, wParam, lParam.
;   hWnd is the window receiving this message.
;   message is the message ID.
;   wParam and lParam depend on the message ID.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn	DefWindowProc:near

	.code
WndProc:
	mov	eax,[esp+4+4]		; message ID
	cmp	eax,WM_LBUTTONDOWN	; left mouse button pressed
	je	left_mouse_down
	cmp	eax,WM_RBUTTONDOWN	; right mouse button pressed
	je	right_mouse_down
	cmp	eax,WM_DESTROY		; about to start window destruction
	je	start_destroy
	jmp	DefWindowProc		; delegate other message processing
;
; Process WM_LBUTTONDOWN.  Left mouse button has been pressed.
;
; wParam is mouse flags.
; lParam is y:x (client coordinates).
;
; Return zero if processed.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn	SetWindowText:near

	.code
left_mouse_down:
	mov	eax,[esp+4+0]	; get hwnd before changing ESP
	push	offset title2
	push	eax
	call	SetWindowText

	xor	eax,eax
	ret	16
;
; Process WM_RBUTTONDOWN.  Right mouse button has been pressed.
;
; wParam is mouse flags.
; lParam is y:x (client coordinates).
;
; Return zero if processed.
;
; Must preserve EBX, ESI, and EDI.
;
right_mouse_down:
	mov	eax,[esp+4+0]	; get hwnd before changing ESP
	push	offset title1
	push	eax
	call	SetWindowText

	xor	eax,eax
	ret	16
;
; Process WM_DESTROY.  Sent after window is removed from screen, but
; before any destruction begins.
;
; Return zero if processed.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn PostQuitMessage:near

	.code
start_destroy:
	push	large 0
	call	PostQuitMessage

	xor	eax,eax
	ret	16

	end
