; WINDOW01.ASM -- Displays a window from minimal specs that can be terminated (with ALT-F4).
; See HTML documents for explanation of code.
;
; Assembles with Borland Turbo Assembler 4.0
; Use:
;   TASM /m /ml window01
;
; where
;   /m  = multiple passes
;   /ml = case sensitive
;
; Link with:
;   TLINK32 /Tpe /aa /c window01,,,fulldir\import32.lib
;
; where
;   /Tpe  = Win32 (PE) .EXE
;   /aa   = Windows non-console app
;   /c    = case sensitive external and public symbols
;
; Link to VC++ library (assuming environment variables are set) with:
;   LINK window01 kernel32.lib user32.lib /entry:start
;
	.386
	.model	flat

vclib	equ	1	; select VC++ library link names

	if	vclib

CreateWindowEx   equ <_CreateWindowExA@48>
DefWindowProc    equ <_DefWindowProcA@16>
DispatchMessage  equ <_DispatchMessageA@4>
ExitProcess      equ <_ExitProcess@4>
GetMessage       equ <_GetMessageA@16>
GetModuleHandle  equ <_GetModuleHandleA@4>
PostQuitMessage  equ <_PostQuitMessage@4>
RegisterClassEx  equ <_RegisterClassExA@4>

	else

CreateWindowEx   equ <CreateWindowExA>
DefWindowProc    equ <DefWindowProcA>
DispatchMessage  equ <DispatchMessageA>
GetMessage       equ <GetMessageA>
GetModuleHandle  equ <GetModuleHandleA>
RegisterClassEx  equ <RegisterClassExA>

	endif

	public _start

	.code
_start:

WNDCLASSEX struc		; comments show the C/C++ name
wcxSize		dd ?	; cbSize, size of WNDCLASSEX
wcxStyle		dd ?	; style
wcxWndProc		dd ?	; lpfnWndProc
wcxClsExtra		dd ?	; cbClsExtra
wcxWndExtra		dd ?	; cbWndExtra
wcxInstance		dd ?	; hInstance
wcxIcon		dd ?	; hIcon
wcxCursor		dd ?	; hCursor
wcxBkgndBrush	dd ?	; hbrBackground
wcxMenuName		dd ?	; lpszMenuName
wcxClassName	dd ?	; lpszClassName
wcxSmallIcon	dd ?	; hIconSm
WNDCLASSEX ends

	extrn	GetModuleHandle:near,RegisterClassEx:near

	.data
wc	WNDCLASSEX <size WNDCLASSEX,0,WndProc,0,0, 0, 0,0,0, 0,wndclsname, 0>
wndclsname db 'window01',0

	.code
	push	large 0		; NULL string pointer means
	call	GetModuleHandle	; get HINSTANCE/HMODULE of EXE file
	mov	[wc.wcxInstance],eax
	push	offset wc
	call	RegisterClassEx

WS_VISIBLE equ 10000000h

	extrn	CreateWindowEx:near

	.code
	push	large 0			; lpParam
	push	[wc.wcxInstance]		; hInstance
	push	large 0			; menu hmenu
	push	large 0			; parent hwnd
	push	large 200			; height
	push	large 200			; width
	push	large 100			; y
	push	large 100			; x
	push	large WS_VISIBLE		; Style
	push	large 0			; Window text (caption)
	push	offset wndclsname		; Class name
	push	large 0			; extended style
	call	CreateWindowEx

MSG struc		; comments show the C/C++ names
msgHwnd	dd ?	; hwnd
msgMessage	dd ?	; message
msgWparam	dd ?	; wParam
msgLparam	dd ?	; lParam
msgTime	dd ?	; time, message posting time
msgPtX	dd ?	; pt.x, cursor position
msgPtY	dd ?	; pt.y, cursor position
MSG ends

	extrn	GetMessage:near,DispatchMessage:near

	.data
msgbuf MSG	<>

	.code
msg_loop:
	push	large 0		; uMsgFilterMax
	push	large 0		; uMsgFilterMin
	push	large 0		; hWnd (filter), 0 = all windows
	push	offset msgbuf	; lpMsg
	call	GetMessage		; returns FALSE if WM_QUIT
	or	eax,eax
	jz	end_loop

	push	offset msgbuf
	call	DispatchMessage

	jmp	msg_loop

end_loop:

	extrn	ExitProcess:near

	.code
	push	large 0	; (error) return code
	call	ExitProcess

	extrn	DefWindowProc:near,PostQuitMessage:near

WM_DESTROY equ 2

	.code
WndProc:
	cmp	dword ptr [esp+4+4],WM_DESTROY
	jne	DefWindowProc

start_destroy:
	push	large 0
	call	PostQuitMessage

	xor	eax,eax
	ret	16

	end	_start
