; WINDOW02.ASM -- A Basic GUI Program.
; See HTML documents for explanation of code.
;
; Assembles with Borland Turbo Assembler 4.0
; Use:
;   TASM /m /ml window02
;
; where
;   /m  = multiple passes
;   /ml = case sensitive
;
; Link with:
;   TLINK32 /Tpe /aa /c window02+winmain,,,fulldir\import32.lib
;
; where
;   /Tpe  = Win32 (PE) .EXE
;   /aa   = Windows non-console app
;   /c    = case sensitive external and public symbols
;
; Link to VC++ library (assuming environment variables are set) with:
;   LINK window02 winmain kernel32.lib user32.lib /entry:start
;
	.386
	.model	flat

	; choose the following, if necessary:
	include	vclib.inc    ; Microsoft VC++ .lib link names

	include	win32.inc    ; constants, structures, and entry names

	public	InitApp,EndApp
	extrn	GetModuleHandle:near

	.code
InitApp:
	mov	edi,offset wc
	mov	esi,offset cwargs

	push	large 0		; NULL string pointer means
	call	GetModuleHandle	; get HINSTANCE/HMODULE of EXE file
	mov	[edi].wcxInstance,eax
	mov	[esi].cwargInstance,eax

	extrn	LoadIcon:near,LoadCursor:near

DEFAULT_CS_STYLE equ CS_VREDRAW + CS_HREDRAW + CS_DBLCLKS

	.data
wc	WNDCLASSEX <size WNDCLASSEX,DEFAULT_CS_STYLE,WndProc,0,0, 0, 0,0,COLOR_WINDOW+1, 0,wndclsname, 0>
wndclsname db 'winmain',0

	.code
	push	large IDI_WINLOGO
	push	large 0		; hInstance, 0 = stock icon
	call	LoadIcon
	mov	[edi].wcxIcon,eax
	mov	[edi].wcxSmallIcon,eax

	push	large IDC_ARROW
	push	large 0		; hInstance, 0 = stock cursor
	call	LoadCursor
	mov	[edi].wcxCursor,eax

DEFAULT_STYLE	equ WS_VISIBLE + WS_OVERLAPPED + WS_CAPTION + WS_SYSMENU + WS_THICKFRAME + WS_MINIMIZEBOX + WS_MAXIMIZEBOX
DEFAULT_EXSTYLE	equ WS_EX_WINDOWEDGE + WS_EX_CLIENTEDGE
DEFAULT_X		equ 100
DEFAULT_Y		equ 100
DEFAULT_WIDTH	equ 200
DEFAULT_HEIGHT	equ 200

	.data
	align	4
cwargs CREATEARGS <DEFAULT_EXSTYLE,wndclsname,def_title,DEFAULT_STYLE, DEFAULT_X,DEFAULT_Y, DEFAULT_WIDTH,DEFAULT_HEIGHT, 0,0, 0, 0>
def_title db 'Application',0

	.code
	ret

EndApp:
	xor	eax,eax	; assume no errors
	ret

	extrn	DefWindowProc:near,PostQuitMessage:near

	.code
WndProc:
	cmp	dword ptr [esp+4+4],WM_DESTROY
	jne	DefWindowProc

start_destroy:
	push	large 0
	call	PostQuitMessage

	xor	eax,eax
	ret	16

	end
