; WINGDI01.ASM -- Introduction to Graphics
;
; Assembles with Borland Turbo Assembler 4.0
; Use:
;   TASM /m /ml wingdi01
;
; where
;   /m  = multiple passes
;   /ml = case sensitive
;
; Link with:
;   TLINK32 /Tpe /aa /c wingdi01+winmain,,,fulldir\import32.lib
;
; where
;   /Tpe  = Win32 (PE) .EXE
;   /aa   = Windows non-console app
;   /c    = case sensitive external and public symbols
;
; Link to VC++ library (assuming environment variables are set) with:
;   LINK wingdi01 winmain kernel32.lib user32.lib gdi32.lib /entry:start
;
	.386
	.model flat,NOLANGUAGE

; Define the link names we will use, if necessary.

	include vclib.inc	; Link to VC++ import libraries

; Define Windows constants, structures, and API entry names

	include win32.inc

;
; Application initialization subroutine
; Returns:
;	ESI = address of a CREATEARGS structure, the CreateWindowEx argument list
;	EDI = address of a WNDCLASSEX structure, the RegisterClassEx argument
;	WINMAIN will set the hInstance field of the above structures
;
	.data
wc WNDCLASSEX <size WNDCLASSEX,0,MainWndProc,0,0, 0, \
			0,0,COLOR_WINDOW+1, 0,mainwndclsname,0>
wndmain CREATEARGS <0,mainwndclsname,maincaption, \
			WS_OVERLAPPEDWINDOW+WS_VISIBLE,\
			100,100,400,200, 0,0,0,0>

mainwndclsname db 'WindowGDI',0

maincaption db 'GDI Intro -- click in client area',0

	.code

	public	InitApp,EndApp
	extrn LoadCursor:near

InitApp:
	mov	edi,offset wc
	mov	esi,offset wndmain

	push	large IDC_ARROW
	push	large 0
	call	LoadCursor
	mov	[wc].wcxCursor,eax
	ret
;
; Application cleanup subroutine
; Returns:
;	EAX = application exit code
;
EndApp:
	xor	eax,eax	; assume no errors
	ret

;
; The window procedure...where messages for one class of windows
;   are processed.
;
; Parameters are hWnd, message, wParam, lParam.
;   hWnd is the window receiving this message.
;   message is the message ID.
;   wParam and lParam depend on the message ID.
;
; Must preserve EBX, ESI, and EDI.
;
	.code

	extrn DefWindowProc:near
	extrn PostQuitMessage:near

MainWndProc:
	mov	eax,[esp+4+4]	; message ID
	cmp	eax,WM_LBUTTONDOWN
	je	left_mouse_down
	cmp	eax,WM_DESTROY	; about to start window destruction
	je	start_destroy
	jmp	DefWindowProc	; delegate other message processing
;
; Process WM_DESTROY.  Sent after window is removed from screen, but
; before any destruction begins.
;
; Return zero if processed.
;
; Must preserve EBX, ESI, and EDI.
;
start_destroy:
	push	large 0
	call	PostQuitMessage

	xor	eax,eax
	ret	16
;
; Process WM_LBUTTONDOWN.  Left mouse button has been pressed.
;
; wParam is mouse flags.
; lParam is y:x (client coordinates).
;
; Return zero if processed.
;
; Must preserve EBX, ESI, and EDI.
;
; -----
;
; In response to a click of the left mouse button,
; draw a circle centered on the click point.
;
	.data

wndDC		dd 0		; DC handle (hDC) of window client area

	.code

	extrn GetDC:near
	extrn ReleaseDC:near
	extrn Ellipse:near

left_mouse_down:
	push	dword ptr [esp+4+0]	; hWnd
	call	GetDC
	mov	[wndDC],eax			; hDC for window

	mov	dx,[esp+4+12+2]		; HIWORD(lParam) = y
	mov	eax,[esp+4+12]		; LOWORD(lParam) = x
	and	edx,large 0FFFFh
	and	eax,large 0FFFFh
	add	edx,10
	add	eax,10
	push	edx				; y, lower right
	push	eax				; x
	sub	edx,20
	sub	eax,20
	push	edx				; y, upper left
	push	eax				; x
	push	[wndDC]			; hDC
	call	Ellipse

	push	[wndDC]
	push	dword ptr [esp+4+0]	; hWnd
	call	ReleaseDC

	xor	eax,eax
	ret	16

	end
