; WINMENU.ASM -- Menu demo.
; See HTML documents for explanation of code.
;
; Assembles with Borland Turbo Assembler 4.0
; Use:
;   TASM /m /ml winmenu
;
; where
;   /m  = multiple passes
;   /ml = case sensitive
;
; Link with:
;   TLINK32 /Tpe /aa /c winmenu+winmain,,,fulldir\import32.lib
;
; where
;   /Tpe  = Win32 (PE) .EXE
;   /aa   = Windows non-console app
;   /c    = case sensitive external and public symbols
;
; Link to VC++ library (assuming environment variables are set) with:
;   LINK winmenu winmain kernel32.lib user32.lib /entry:start
;
	.386
	.model	flat

%NOINCL	; TASM only...suppress listing of include files

	; choose the following, if necessary:
	include	vclib.inc    ; Microsoft VC++ .lib link names

	include	win32.inc    ; constants, structures, and entry names

	public	InitApp,EndApp
	extrn	GetModuleHandle:near

	.code
InitApp:
	mov	edi,offset wc
	mov	esi,offset cwargs

	push	large 0		; NULL string pointer means
	call	GetModuleHandle	; get HINSTANCE/HMODULE of EXE file
	mov	[edi].wcxInstance,eax
	mov	[esi].cwargInstance,eax

	extrn	LoadIcon:near,LoadCursor:near

DEFAULT_CS_STYLE equ CS_VREDRAW + CS_HREDRAW + CS_DBLCLKS

	.data
wc	WNDCLASSEX <size WNDCLASSEX,DEFAULT_CS_STYLE,WndProc,0,0, 0, 0,0,COLOR_WINDOW+1, 0,wndclsname, 0>
wndclsname db 'winmain',0

	.code
	push	large IDI_WINLOGO
	push	large 0		; hInstance, 0 = stock icon
	call	LoadIcon
	mov	[edi].wcxIcon,eax
	mov	[edi].wcxSmallIcon,eax

	push	large IDC_ARROW
	push	large 0		; hInstance, 0 = stock cursor
	call	LoadCursor
	mov	[edi].wcxCursor,eax

	extrn	LoadMenuIndirect:near

	.code
	push	offset appMenuTemplate
	call	LoadMenuIndirect
	mov	[esi].cwargMenu,eax

	ret

DEFAULT_STYLE	equ WS_VISIBLE + WS_OVERLAPPEDWINDOW
DEFAULT_EXSTYLE	equ WS_EX_WINDOWEDGE + WS_EX_CLIENTEDGE
DEFAULT_X		equ 100
DEFAULT_Y		equ 100
DEFAULT_WIDTH	equ 400
DEFAULT_HEIGHT	equ 200

	.data
	align	4
cwargs CREATEARGS <DEFAULT_EXSTYLE,wndclsname,def_title,DEFAULT_STYLE, DEFAULT_X,DEFAULT_Y, DEFAULT_WIDTH,DEFAULT_HEIGHT, 0,0, 0, 0>
def_title db 'Window with menu',0

	.code
EndApp:
	xor	eax,eax	; assume no errors
	ret

;
; Menu item (command) IDs
;
IDM_EXIT equ 101
IDM_HELP equ 901
IDM_ABOUT equ 902
;
; Menu template
;
MFR_END	equ 80h
MFR_POPUP	equ 01h

	.data
	align	4	; must align on DWORD boundary
appMenuTemplate	dw 1	; menu template version
			dw 4	; offset from end of this word to menu item list
			dd 0	; menu bar help ID

			dd MFT_STRING,MFS_ENABLED,0
			dw MFR_POPUP			; first column
			dw '&','F','i','l','e',0,0	; pad to align 4
			dd 0					; popup help ID

			dd MFT_STRING,MFS_ENABLED,IDM_EXIT
			dw MFR_END				; bottom of column
			dw 'E','&','x','i','t',0,0	; pad to align 4

			dd MFT_STRING,MFS_ENABLED,0
			dw MFR_POPUP or MFR_END		; second column, last one
			dw '&','H','e','l','p',0,0	; pad to align 4
			dd 0					; popup help ID

			dd MFT_STRING,MFS_ENABLED,IDM_HELP
			dw 0
			dw '&','H','e','l','p','.','.','.',0

			dd MFT_SEPARATOR,0,0
			dw 0
			dw 0	; pad to align 4

			dd MFT_STRING,MFS_ENABLED,IDM_ABOUT
			dw MFR_END				; bottom of column
			dw '&','A','b','o','u','t','.','.','.',0,0

	.code
;
; The window procedure...where messages for one class of windows
;   are processed.
;
; Parameters are hWnd, message, wParam, lParam.
;   hWnd is the window receiving this message.
;   message is the message ID.
;   wParam and lParam depend on the message ID.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn	DefWindowProc:near,PostQuitMessage:near

	.code
WndProc:
	mov	eax,[esp+4+4]	; message ID
	cmp	eax,WM_COMMAND	; from menu, accelerator, or control
	je	execute_command
	cmp	eax,WM_DESTROY	; window has been destroyed
	je	start_destroy
	jmp	DefWindowProc	; delegate other message processing
;
; Process WM_DESTROY.  Sent after window is removed from the display
;   but before it is destroyed by the message sender.  This message
;   sent by DestroyWindow.
;
; Return zero if processed.
;
; Must preserve EBX, ESI, and EDI.
;
start_destroy:
	push	large 0
	call	PostQuitMessage

	xor	eax,eax
	ret	16

;
; miscellaneous string data
;
	.data
helpCaption equ def_title
helpText db 'Help not implemented.',0

aboutCaption db 'About Win32 Assembly',0
aboutText db 'Place your copyright here.',0

;
; Process WM_COMMAND.  Sent from menu, accelerator, or control.
;
; Low word of wParam is the command ID associated with the menu,
;   accelerator, or control.
; High word of wParam is a notification code from a control.
; lParam is 0 (menu command), 1 (accelerator command), or a control handle.
;
; Return zero if processed.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn	PostMessage:near
	extrn	MessageBox:near
	extrn	hwndMain:dword	; defined in winmain.asm

	.code
execute_command:
	mov	eax,[esp+4+8]	; wParam
	and	eax,large 0FFFFh	; command ID
	cmp	eax,IDM_EXIT
	je	exit_command
	cmp	eax,IDM_HELP
	je	help_command
	cmp	eax,IDM_ABOUT
	je	about_command
	xor	eax,eax		; ignore other commands
	ret	16

exit_command:
	; trigger the main window close function
	push	large 0		; lParam
	push	large 0		; wParam
	push	large WM_CLOSE	; msgid
	push	[hwndMain]		; hwnd
	call	PostMessage

	xor	eax,eax
	ret	16

help_command:
	mov	eax,[esp+4+0]	; hWnd
	push	large MB_OK
	push	offset helpCaption
	push	offset helpText
	push	eax			; owner window
	call	MessageBox

	xor	eax,eax
	ret	16

about_command:
	mov	eax,[esp+4+0]	; hWnd
	push	large MB_OK
	push	offset aboutCaption
	push	offset aboutText
	push	eax			; owner window
	call	MessageBox

	xor	eax,eax
	ret	16

	end
