; WINPAD.ASM -- A simple scratchpad editor.
;
; Assembles with Borland Turbo Assembler 4.0
; Use:
;   TASM /m /ml winpad
;
; where
;   /m  = multiple passes
;   /ml = case sensitive
;
; Link with:
;   TLINK32 /Tpe /aa /c winpad+winmain,,,fulldir\import32.lib
;
; where
;   /Tpe  = Win32 (PE) .EXE
;   /aa   = Windows non-console app
;   /c    = case sensitive external and public symbols
;
; Link to VC++ library (assuming environment variables are set) with:
;   LINK winpad winmain kernel32.lib user32.lib /entry:start
;
	.386
	.model	flat

	; choose the following, if necessary:
	include	vclib.inc    ; Microsoft VC++ .lib link names

	include	win32.inc    ; constants, structures, and entry names

;
; Application initialization subroutine
; Returns:
;	ESI = address of a CREATEARGS structure, the CreateWindowEx argument list
;	EDI = address of a WNDCLASSEX structure, the RegisterClassEx argument
;	WINMAIN will set the hInstance field of the above structures
;
    .data
wc WNDCLASSEX <size WNDCLASSEX,CS_HREDRAW+CS_VREDRAW,WndProc,0,0, 0, \
			0,0,COLOR_WINDOW+1, 0,wndclsname,0>
wndmain CREATEARGS <0,wndclsname,caption,WS_OVERLAPPEDWINDOW+WS_VISIBLE,\
			100,100,200,200, 0,0,0,0>
wndedit CREATEARGS <0,editclsname,0,WS_CHILD+WS_HSCROLL+WS_VSCROLL+\
			WS_VISIBLE+ES_AUTOHSCROLL+ES_AUTOVSCROLL+ES_MULTILINE,\
			0,0,0,0, 0,0,0,0>
wndclsname  db 'ScratchPad',0
editclsname db 'edit',0
caption db 'Scratch Pad Editor',0

hEdit dd 0

	public	InitApp,EndApp

	extrn	LoadCursor:near

	.code
InitApp:
	mov	edi,offset wc
	mov	esi,offset wndmain

	push	large IDC_ARROW
	push	large 0
	call	LoadCursor
	mov	[wc].wcxCursor,eax
	ret
;
; Application cleanup subroutine
; Returns:
;	EAX = application exit code
;
EndApp:
	xor	eax,eax	; assume no errors
	ret
;
; The main window procedure...where messages for the main window
;   are processed.
;
; Parameters are hWnd, message, wParam, lParam.
;   hWnd is the window receiving this message.
;   message is the message ID.
;   wParam and lParam depend on the message ID.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn	DefWindowProc:near

	.code
WndProc:
	mov	eax,[esp+4+4]		; message ID
	cmp	eax,WM_CREATE		; window created
	je	finish_create
	cmp	eax,WM_SIZE			; about to draw resized window
	je	resizing_window
	cmp	eax,WM_DESTROY		; about to start window destruction
	je	start_destroy
	jmp	DefWindowProc		; delegate other message processing
;
; Process WM_CREATE.  Sent after window has been created, but before
; showing the window.
;
; On entry:
;	lParam = address of a copy of the CreateWindowEx arguments
;
; Return -1 to abort window creation.  Abortion will send WM_DESTROY.
; Otherwise return zero.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn	CreateWindowEx:near

finish_create:
	mov	eax,[esp+4+0]  ; grab hwnd before ESP changes

	push	esi
	push	edi

	mov	esi,offset wndedit
	mov	[esi].cwargParent,eax    ; make "wndmain" a parent of "edit"
	mov	eax,[wc].wcxInstance
	mov	[esi].cwargInstance,eax  ; set edit instance
	sub	esp,48    ; allocate args
	mov	edi,esp
	mov	ecx,12
	rep movsd
	call	CreateWindowEx
	mov	[hEdit],eax		; save edit window handle

	pop	edi
	pop	esi

	xor	eax,eax    ; signal a successful CREATE
	ret	16
;
; Process WM_SIZE.  Sent before redrawing nonclient area.
;
; On entry:
;	lParam = size of client area y:x.  Only 16-bit coordinates.
;			Use GetClientRect to get 32-bit coordinates
;
; Return zero if processed.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn	MoveWindow:near

	.code
resizing_window:
	; grab arguments before ESP changes
	xor	eax,eax
	xor	ecx,ecx
	mov	ax,[esp+4+12+2]	; y, height
	mov	cx,[esp+4+12+0]	; x, width
	push	large 1	; repaint
	push	eax		; height
	push	ecx		; width
	push	large 0	; y = 0, top left corner of client area
	push	large 0	; x = 0
	push	[hEdit]	; resize edit window
	call	MoveWindow

	xor	eax,eax
	ret	16
;
; Process WM_DESTROY.  Sent after window is removed from screen, but
; before any destruction begins.
;
; Return zero if processed.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn PostQuitMessage:near

start_destroy:
	push	large 0
	call	PostQuitMessage

	xor	eax,eax
	ret	16

	end
