; WINTYPES.ASM -- Show the three window types.
;
; Assembles with Borland Turbo Assembler 4.0
; Use:
;   TASM /m /ml wintypes
;
; where
;   /m  = multiple passes
;   /ml = case sensitive
;
; Link with:
;   TLINK32 /Tpe /aa /c wintypes+winmain,,,fulldir\import32.lib
;
; where
;   /Tpe  = Win32 (PE) .EXE
;   /aa   = Windows non-console app
;   /c    = case sensitive external and public symbols
;
; Link to VC++ library (assuming environment variables are set) with:
;   LINK wintypes winmain kernel32.lib user32.lib /entry:start
;
	.386
	.model	flat

	; choose the following, if necessary:
	include	vclib.inc    ; Microsoft VC++ .lib link names

	include	win32.inc    ; constants, structures, and entry names

;
; Application initialization subroutine
; Returns:
;	ESI = address of a CREATEARGS structure, the CreateWindowEx argument list
;	EDI = address of a WNDCLASSEX structure, the RegisterClassEx argument
;	WINMAIN will set the hInstance field of the above structures
;
    .data
wc WNDCLASSEX <size WNDCLASSEX,CS_HREDRAW+CS_VREDRAW,WndProc,0,0, 0, \
                0,0,COLOR_WINDOW+1, 0,wndclsname,0>
overlap CREATEARGS <0,wndclsname,caption,WS_OVERLAPPED+WS_CAPTION+WS_SYSMENU+\
                WS_THICKFRAME+WS_MINIMIZEBOX+WS_VISIBLE,100,100,200,200,0,0,0,0>
popup   CREATEARGS <0,wndclsname,caption,WS_POPUP+WS_CAPTION+WS_SYSMENU+\
                WS_THICKFRAME+WS_MINIMIZEBOX+WS_VISIBLE,150,150,200,200,0,0,0,0>
child   CREATEARGS <0,wndclsname,caption,WS_CHILD+WS_CAPTION+WS_SYSMENU+\
                WS_THICKFRAME+WS_MINIMIZEBOX+WS_VISIBLE,50,50,50,50,0,0,0,0>
wndclsname db 'generic',0
caption db 'Anywhere',0

mainwnd dd 0

	public	InitApp,EndApp

	extrn	LoadCursor:near

	.code
InitApp:
	mov	edi,offset wc
	mov	esi,offset overlap

	push	large IDC_ARROW
	push	large 0
	call	LoadCursor
	mov	[wc].wcxCursor,eax
	ret
;
; Application cleanup subroutine
; Returns:
;	EAX = application exit code
;
EndApp:
	xor	eax,eax	; assume no errors
	ret
;
; The window procedure...where messages for one class of windows
;   are processed.
;
; Parameters are hWnd, message, wParam, lParam.
;   hWnd is the window receiving this message.
;   message is the message ID.
;   wParam and lParam depend on the message ID.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn	DefWindowProc:near

	.code
WndProc:
	mov	eax,[esp+4+4]		; message ID
	cmp	eax,WM_CREATE		; window created
	je	finish_create
	cmp	eax,WM_DESTROY		; about to start window destruction
	je	start_destroy
	jmp	DefWindowProc		; delegate other message processing
;
; Process WM_CREATE.  Sent after window has been created, but before
; showing the window.
;
; Return -1 to abort window creation.  Abortion will send WM_DESTROY.
; Otherwise return zero.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn	CreateWindowEx:near

finish_create:
	cmp	[mainwnd],0
	jne	create_nonmain

	mov	eax,[esp+4+0]  ; hwnd
	mov	[mainwnd],eax  ; set main window handle so we don't recurse indefinitely
	push	esi
	push	edi
	mov	esi,offset popup
	mov	[esi].cwargParent,eax    ; make "overlap" an owner of "popup"
	mov	eax,[wc].wcxInstance
	mov	[esi].cwargInstance,eax  ; set popup instance
	sub	esp,48    ; allocate args
	mov	edi,esp
	mov	ecx,12
	rep movsd
	call	CreateWindowEx

	mov	esi,offset child
	mov	[esi].cwargParent,eax    ; make "popup" a parent of "child"
	mov	eax,[wc].wcxInstance
	mov	[esi].cwargInstance,eax  ; set child instance
	sub	esp,48    ; allocate args
	mov	edi,esp
	mov	ecx,12
	rep movsd
	call	CreateWindowEx
	pop	edi
	pop	esi

create_nonmain:
	xor	eax,eax    ; signal a successful CREATE
	ret	16
;
; Process WM_DESTROY.  Sent after window is removed from screen, but
; before any destruction begins.
;
; Return zero if processed.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn PostQuitMessage:near

start_destroy:
	mov	eax,[esp+4+0]    ; hwnd
	cmp	eax,[mainwnd]
	jne	no_special_destroy

	push	large 0
	call	PostQuitMessage

no_special_destroy:
	xor	eax,eax
	ret	16

	end
