; WINVIEW.ASM -- A simple file viewer.
;
; Assembles with Borland Turbo Assembler 4.0
; Use:
;   TASM /m /ml winview
;
; where
;   /m  = multiple passes
;   /ml = case sensitive
;
; Link with:
;   TLINK32 /Tpe /aa /c winview+winmain,,,fulldir\import32.lib
;
; where
;   /Tpe  = Win32 (PE) .EXE
;   /aa   = Windows non-console app
;   /c    = case sensitive external and public symbols
;
; Link to VC++ library (assuming environment variables are set) with:
;   LINK winview winmain kernel32.lib user32.lib /entry:start
;
	.386
	.model	flat

	; choose the following, if necessary:
	include	vclib.inc    ; Microsoft VC++ .lib link names

	include	win32.inc    ; constants, structures, and entry names

;
ID_mainedit	equ	101
ID_popupedit equ	102
ID_popupbtn	equ	103

CREATEFILEARGS STRUC
cfargFileName	dd 0
cfargDesiredAccess dd 0
cfargShareMode	dd 0
cfargSecurityAttr	dd 0
cfargDistribution	dd 0
cfargFlagsAndAttrs dd 0
cfargTemplateFile	dd 0
CREATEFILEARGS ENDS

	.data
	; "create" file arguments
text_file CREATEFILEARGS <fname,GENERIC_READ,0,0,OPEN_EXISTING,\
					FILE_ATTRIBUTE_NORMAL,0>
bytes_transferred dd 0

	; main window
wc WNDCLASSEX <size WNDCLASSEX,CS_HREDRAW+CS_VREDRAW,WndProc,0,0, 0, \
			0,0,COLOR_WINDOW+1, 0,wndclsname,0>
wndmain CREATEARGS <0,wndclsname,caption,WS_OVERLAPPEDWINDOW,\
			100,50,400,400, 0,0,0,0>
wndedit CREATEARGS <0,editclsname,0,WS_CHILD+WS_HSCROLL+WS_VSCROLL+\
			WS_VISIBLE+ES_AUTOHSCROLL+ES_AUTOVSCROLL+ES_MULTILINE,\
			0,0,0,0, 0,ID_mainedit,0,0>
	; popup window
wc_popup WNDCLASSEX <size WNDCLASSEX,0,PopUpWndProc,0,0, 0,\
			0,0,COLOR_3DFACE+1, 0,popupname,0>
wndpopup CREATEARGS <0,popupname,0,WS_POPUP+WS_BORDER+WS_VISIBLE, \
			100,100,200,50, 0,0,0,0>
wndfname CREATEARGS <0,editclsname,0,WS_CHILD+WS_VISIBLE+ES_AUTOHSCROLL,\
			0,0,200,20, 0,ID_popupedit,0,0>
wndbtn   CREATEARGS <0,btnclsname,btn_text,WS_CHILD+WS_VISIBLE,\
			0,25,40,21, 0,ID_popupbtn,0,0>

hMain dd 0
hEdit dd 0
hFnameEdit dd 0

wndclsname	db 'FileViewer',0
popupname	db 'Popup',0
editclsname	db 'edit',0
btnclsname	db 'button',0

caption	db 'File Viewer',0
btn_text	db 'OK',0

fname		db 256 dup(0)

	.data?
fbuffer	db 33000 dup(?)
MAXBUF	equ 32000		; Win95 EDIT control is 16-bit

	public	InitApp,EndApp

	extrn	LoadCursor:near
	extrn GetModuleHandle:near
	extrn	RegisterClassEx:near
;
; Application initialization subroutine
; Returns:
;	ESI = address of a CREATEARGS structure, the CreateWindowEx argument list
;	EDI = address of a WNDCLASSEX structure, the RegisterClassEx argument
;	WINMAIN will set the hInstance field of the above structures
;
	.code
InitApp:
	mov	esi,offset wc_popup
	mov	edi,offset wc

	push	large 0
	call	GetModuleHandle	; get program instance
	mov	[esi].wcxInstance,eax

	push	large IDC_ARROW
	push	large 0
	call	LoadCursor
	mov	[esi].wcxCursor,eax	; to wc_popup
	mov	[edi].wcxCursor,eax	; to wc (main)

	push	esi
	call	RegisterClassEx

	mov	esi,offset wndmain

	ret
;
; Application cleanup subroutine
; Returns:
;	EAX = application exit code
;
EndApp:
	xor	eax,eax	; assume no errors
	ret
;
; The main window procedure...where messages for the main window
;   are processed.
;
; Parameters are hWnd, message, wParam, lParam.
;   hWnd is the window receiving this message.
;   message is the message ID.
;   wParam and lParam depend on the message ID.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn	DefWindowProc:near

	.code
WndProc:
	mov	eax,[esp+4+4]		; message ID
	cmp	eax,WM_CREATE		; window created
	je	finish_create
	cmp	eax,WM_SIZE			; about to draw resized window
	je	resizing_window
	cmp	eax,WM_DESTROY		; about to start window destruction
	je	start_destroy
	jmp	DefWindowProc		; delegate other message processing
;
; Process WM_CREATE.  Sent after window has been created, but before
; showing the window.
;
; On entry:
;	lParam = address of a copy of the CreateWindowEx arguments
;
; Return -1 to abort window creation.  Abortion will send WM_DESTROY.
; Otherwise return zero.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn	CreateWindowEx:near

finish_create:
	mov	eax,[esp+4+0]	; grab hwnd before ESP changes
	mov	[hMain],eax		; save for popup

	push	esi
	push	edi

	mov	esi,offset wndedit
	mov	[esi].cwargParent,eax    	; make "wndmain" parent of "edit"
	mov	eax,[wc].wcxInstance
	mov	[esi].cwargInstance,eax  ; set edit instance
	sub	esp,48    ; allocate args
	mov	edi,esp
	mov	ecx,12
	rep movsd
	call	CreateWindowEx
	mov	[hEdit],eax		; save edit window handle

	mov	esi,offset wndpopup
	mov	eax,[wc].wcxInstance
	mov	[esi].cwargInstance,eax  ; set popup instance
	sub	esp,48    ; allocate args
	mov	edi,esp
	mov	ecx,12
	rep movsd
	call	CreateWindowEx

	pop	edi
	pop	esi

	xor	eax,eax    ; signal a successful CREATE
	ret	16
;
; Process WM_SIZE.  Sent before redrawing nonclient area.
;
; On entry:
;	lParam = size of client area y:x.  Only 16-bit coordinates.
;			Use GetClientRect to get 32-bit coordinates
;
; Return zero if processed.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn	MoveWindow:near

	.code
resizing_window:
	; grab arguments before ESP changes
	xor	eax,eax
	xor	ecx,ecx
	mov	ax,[esp+4+12+2]	; y, height
	mov	cx,[esp+4+12+0]	; x, width
	push	large 1	; repaint
	push	eax		; height
	push	ecx		; width
	push	large 0	; y = 0, top left corner of client area
	push	large 0	; x = 0
	push	[hEdit]	; resize edit window
	call	MoveWindow

	xor	eax,eax
	ret	16
;
; Process WM_DESTROY.  Sent after window is removed from screen, but
; before any destruction begins.
;
; Return zero if processed.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn PostQuitMessage:near

start_destroy:
	push	large 0
	call	PostQuitMessage

	xor	eax,eax
	ret	16
;
; The popup window procedure...where messages for the popup window
;   are processed.
;
; Parameters are hWnd, message, wParam, lParam.
;   hWnd is the window receiving this message.
;   message is the message ID.
;   wParam and lParam depend on the message ID.
;
; Must preserve EBX, ESI, and EDI.
;
	.code
PopUpWndProc:
	mov	eax,[esp+4+4]		; message ID
	cmp	eax,WM_CREATE		; window created
	je	finish_create_popup
	cmp	eax,WM_COMMAND
	je	do_command_popup
	cmp	eax,WM_DESTROY		; about to start window destruction
	je	start_destroy_popup
	jmp	DefWindowProc		; delegate other message processing
;
; Process WM_CREATE.  Sent after window has been created, but before
; showing the window.
;
; On entry:
;	lParam = address of a copy of the CreateWindowEx arguments
;
; Return -1 to abort window creation.  Abortion will send WM_DESTROY.
; Otherwise return zero.
;
; Must preserve EBX, ESI, and EDI.
;
	.code
finish_create_popup:
	mov	eax,[esp+4+0]  ; grab hwnd before ESP changes

	push	esi
	push	edi

	mov	esi,offset wndfname
	mov	[esi].cwargParent,eax    	; make "popup" parent of "edit"
	mov	eax,[wc].wcxInstance
	mov	[esi].cwargInstance,eax  ; set edit instance
	sub	esp,48    ; allocate args
	mov	edi,esp
	mov	ecx,12
	rep movsd
	call	CreateWindowEx
	mov	[hFnameEdit],eax

	mov	esi,offset wndbtn
	mov	eax,[wndfname].cwargParent
	mov	[esi].cwargParent,eax		; make "popup" parent of "button"
	mov	eax,[wc].wcxInstance
	mov	[esi].cwargInstance,eax  ; set button instance
	sub	esp,48    ; allocate args
	mov	edi,esp
	mov	ecx,12
	rep movsd
	call	CreateWindowEx

	pop	edi
	pop	esi

	xor	eax,eax    ; signal a successful CREATE
	ret	16
;
; Process WM_COMMAND.  Sent by menu, accelerator, or control.
;
; On entry:
;	wParam = notifycode:commandid
;		   notifycode = 0 for menu item, = 1 for accelerator
;	lParam = control handle, 0 for menu item and accelerator
;
; Return zero if processed.
;
; Must preserve EBX, ESI, and EDI.
;
	extrn	ShowWindow:near,GetWindowText:near,DestroyWindow:near
	extrn	CreateFile:near,ReadFile:near,CloseHandle:near
	extrn SetWindowText:near

	.code
do_command_popup:
	mov	eax,[esp+4+8]	; third arg is wParam
	cmp	eax,(BN_CLICKED shl 16)+ID_popupbtn
	je	button_click
	xor	eax,eax
	ret	16

button_click:
	push	esi
	push	edi

	push	large 255
	push	offset fname
	push	[hFnameEdit]
	call	GetWindowText	; get file name from edit window

	mov	esi,offset text_file
	sub	esp,28		; allocate args
	mov	edi,esp
	mov	ecx,7
	rep movsd
	call	CreateFile
	cmp	eax,INVALID_HANDLE_VALUE
	je	no_file

	push	eax		; push file handle for CloseHandle

	push	large 0	; no overlap structure
	push	offset bytes_transferred
	push	large MAXBUF
	push	offset fbuffer
	push	eax		; file handle
	call	ReadFile

	call	CloseHandle

	mov	ecx,bytes_transferred
	mov	fbuffer[ecx],0	; terminate data

	push	offset fbuffer
	push	[hEdit]
	call	SetWindowText

no_file:
	; restore esp (as well as edi and esi)
	pop	edi
	pop	esi

	push	dword ptr [esp+4+0]	; hwnd of this window
	call	DestroyWindow		; this window is no longer needed

	xor	eax,eax
	ret	16
;
; Process WM_DESTROY.  Sent after window is removed from screen, but
; before any destruction begins.
;
; Return zero if processed.
;
; Must preserve EBX, ESI, and EDI.
;
start_destroy_popup:
	push	large SW_RESTORE
	push	[hMain]
	call	ShowWindow

	xor	eax,eax
	ret	16

	end
