#!/bin/bash

#
# Copyright (c) 2002 David Eriksson <david@2good.com>
# 
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to permit
# persons to whom the Software is furnished to do so, subject to the
# following conditions:
# 
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
# NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
# DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
# OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
# USE OR OTHER DEALINGS IN THE SOFTWARE.
# 

if [ -z "$1" ]; then
	echo "2GooD Productions ELF parser (c) David Eriksson <david@2good.com>"
	echo
	echo "Syntax:"
	echo
	echo "  $0 file.o > file.pat"
	echo
	echo "This script is made by David Eriksson <david@2good.com>"
	echo "Latest version of this and other software available at:"
	echo
	echo "  http://www.2good.com/"
	echo

	exit 1
else
	OBJECT="$1"
fi

#
# Convert data of this form to lists of names
# 
#          U __environ
#          U errno
#          U free
#          U malloc
#          U memcpy
# 00000000 T setenv
# 000001e4 T unsetenv
#

UNDEFINED=`nm $OBJECT |grep '^         U ' | sed 's/.* //'`
PUBLIC=`nm -n $OBJECT |grep -E '^........ (W|T) ' | sed 's/.* //'`

#
# Convert data of this form from objdump into a continous 
# stream of hexadecimal digits. (Two digits = one byte data.)
#
# 0000 5589e583 ec185756 5330d28b 7d0888d0  U.....WVS0..}...
# 0010 fcb9ffff fffff2ae f7d189ce 4e8975f8  ............N.u.
# .
# .
# .
# 0230 0483c204 833a0075 d7c70300 0000008d  .....:.u........
# 0240 65f05b5e 5f89ec5d c3                 e.[^_..].       
#

HEX=`objdump -s -j .text $OBJECT | \
sed 's/  .*//' | \
awk 'BEGIN{hex=""} / [0-9,a-f][0-9,a-f][0-9,a-f]0/{hex=hex$2$3$4$5} END{print hex}'`

MODLEN2=`echo -n $HEX | wc -c`
MODLEN=`echo "$MODLEN2/2" | bc`

#
# Use objdump again to get relocation information and call our relocate
# tool to modify the data stream to contain punctuation marks where data is
# relocated.
#

HEX=`objdump -r -j .text $OBJECT |grep '^0' |./relocate $HEX`

#
# If relocate fails it returns nothing
#
if [ -z "$HEX" ]; then
	echo "---"
	exit 0
fi

#
# The first 32 data bytes are our main pattern
# The remaining bytes are added too
# 
PATTERN=`echo $HEX | cut -c '1-64' -`
REMAINING=`echo $HEX | cut -c '65-' -`

#
# We don't use the feature where we CRC a part of the data
#
ASUM=0000
ALEN=0

#
# Start writing to stdout
#
printf "%s %02x %s %04x" $PATTERN $ALEN $ASUM $MODLEN

#
# Write names in this object
#
for NAME in $PUBLIC; do
	OFFSET=`nm $OBJECT |grep " \$NAME$"|sed 's/ .*//' | cut -b '5-'`
	printf " :%s %s" $OFFSET $NAME
done

#
# Write names from other objects
#
for NAME in $UNDEFINED; do
	for OFFSET in `objdump -r -j .text $OBJECT |grep $NAME |grep -v $OBJECT |cut -b '5-8'`; do
		printf " ^%s %s" $OFFSET $NAME
	done
done

#
# Write last part of line
#
printf " %s" $REMAINING
printf "\n"

#
# pattern files end with these
#
echo "---"

